/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementEditBean;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.EditMarkSheet$callable$run;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.EditMarkSheet$callable$run$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EditMarkSheet {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$run$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(MarkSheet markSheet, Teacher teacher, Date date) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new EditMarkSheet$callable$run(markSheet, teacher, date));
    }

    static /* synthetic */ void advised$run(MarkSheet markSheet, Teacher responsibleTeacher, Date evaluationDate) throws FenixServiceException {
        if (markSheet == null) {
            throw new InvalidArgumentsServiceException("error.noMarkSheet");
        }
        markSheet.editNormal(responsibleTeacher, evaluationDate);
    }

    public static void run(MarkSheetManagementEditBean markSheetManagementEditBean) throws FenixServiceException {
        Object object = advice$run$1.perform((Callable)new EditMarkSheet$callable$run$1(markSheetManagementEditBean));
    }

    static /* synthetic */ void advised$run(MarkSheetManagementEditBean markSheetManagementEditBean) throws FenixServiceException {
        MarkSheet markSheet = markSheetManagementEditBean.getMarkSheet();
        if (markSheet == null) {
            throw new InvalidArgumentsServiceException("error.noMarkSheet");
        }
        if (markSheet.getMarkSheetState() == MarkSheetState.NOT_CONFIRMED) {
            EditMarkSheet.editNormalMarkSheet(markSheetManagementEditBean);
        } else if (markSheet.getMarkSheetState() == MarkSheetState.RECTIFICATION_NOT_CONFIRMED) {
            EditMarkSheet.editRectificationMarkSheet(markSheetManagementEditBean);
        } else {
            throw new InvalidArgumentsServiceException("error.markSheet.invalid.state");
        }
    }

    private static void editRectificationMarkSheet(MarkSheetManagementEditBean markSheetManagementEditBean) {
        Collection<MarkSheetEnrolmentEvaluationBean> filteredEnrolmentEvaluationBeansToEditList = EditMarkSheet.getEnrolmentEvaluationsWithValidGrades(markSheetManagementEditBean.getEnrolmentEvaluationBeansToEdit());
        Iterator<MarkSheetEnrolmentEvaluationBean> iterator = filteredEnrolmentEvaluationBeansToEditList.iterator();
        markSheetManagementEditBean.getMarkSheet().editRectification(iterator.hasNext() ? iterator.next() : null);
    }

    private static void editNormalMarkSheet(MarkSheetManagementEditBean markSheetManagementEditBean) {
        Collection<MarkSheetEnrolmentEvaluationBean> filteredEnrolmentEvaluationBeansToEditList = EditMarkSheet.getEnrolmentEvaluationsWithValidGrades(markSheetManagementEditBean.getEnrolmentEvaluationBeansToEdit());
        Collection<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeansToAppendList = EditMarkSheet.getEnrolmentEvaluationsWithValidGrades(markSheetManagementEditBean.getEnrolmentEvaluationBeansToAppend());
        Collection enrolmentEvaluationBeansToRemoveList = CollectionUtils.subtract(markSheetManagementEditBean.getEnrolmentEvaluationBeansToEdit(), filteredEnrolmentEvaluationBeansToEditList);
        markSheetManagementEditBean.getMarkSheet().editNormal(filteredEnrolmentEvaluationBeansToEditList, enrolmentEvaluationBeansToAppendList, enrolmentEvaluationBeansToRemoveList);
    }

    private static Collection<MarkSheetEnrolmentEvaluationBean> getEnrolmentEvaluationsWithValidGrades(Collection<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeans) {
        return CollectionUtils.select(enrolmentEvaluationBeans, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                MarkSheetEnrolmentEvaluationBean markSheetEnrolmentEvaluationBean = (MarkSheetEnrolmentEvaluationBean)arg0;
                return markSheetEnrolmentEvaluationBean.getGradeValue() != null && markSheetEnrolmentEvaluationBean.getGradeValue().length() != 0;
            }
        });
    }
}

