/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.RegistryDiploma;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class PhdRegistryDiploma
extends RegistryDiploma {
    private static final long serialVersionUID = 1L;

    protected PhdRegistryDiploma(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected PhdRegistryDiplomaRequest getDocumentRequest() {
        return (PhdRegistryDiplomaRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        String fifthParagraph;
        super.fillReport();
        PhdRegistryDiplomaRequest request = this.getDocumentRequest();
        Person person = request.getPerson();
        this.setHeader();
        this.addParameter("institution", this.getInstitutionName());
        this.setFirstParagraph(request);
        this.setSecondParagraph(person, request);
        this.addParameter("thirdParagraph", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.phdThirdParagraph", (String[])new String[0]));
        String[] dateWord = this.getDateByWords(request.getConclusionDate());
        String fourthParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.phdfourthParagraph", (String[])new String[0]);
        this.addParameter("fourthParagraph", MessageFormat.format(fourthParagraph, dateWord[0], dateWord[1], dateWord[2]));
        if (this.getUniversity(new DateTime()) != this.getUniversity(this.getDocumentRequest().getConclusionDate().toDateTimeAtCurrentTime())) {
            fifthParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.phdFifthParagraph.UTL", (String[])new String[0]);
            this.addParameter("by", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.by.university", (String[])new String[0]));
        } else {
            fifthParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.phdFifthParagraph", (String[])new String[0]);
            this.addParameter("university", "");
            this.addParameter("by", "");
        }
        this.addParameter("fifthParagraph", MessageFormat.format(fifthParagraph, this.getDocumentRequest().getFinalAverage(this.getLocale())));
        this.setFooter();
    }

    @Override
    protected void setHeader() {
        this.addParameter("thesisTitle", this.getThesisTitleI18N().getContent(this.getLanguage()));
        super.setHeader();
    }

    private MultiLanguageString getThesisTitleI18N() {
        return new MultiLanguageString(MultiLanguageString.pt, this.getDocumentRequest().getPhdIndividualProgramProcess().getThesisTitle()).with(MultiLanguageString.en, this.getDocumentRequest().getPhdIndividualProgramProcess().getThesisTitleEn());
    }

    @Override
    void setSecondParagraph(Person person, IRegistryDiplomaRequest request) {
        String studentGender = person.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.studentHolderMale", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.studentHolderFemale", (String[])new String[0]);
        if (person.getCountry() == null) {
            throw new DomainException("error.personWithoutParishOfBirth", new String[0]);
        }
        String country = person.getCountry().getCountryNationality().getContent(this.getLanguage()).toLowerCase();
        PhdRegistryDiplomaRequest phdRequest = this.getDocumentRequest();
        String secondParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.phdSecondParagraph", (String[])new String[0]);
        this.addParameter("secondParagraph", MessageFormat.format(secondParagraph, studentGender, BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)person.getIdDocumentType().getName(), (String[])new String[0]), person.getDocumentIdNumber(), country, phdRequest.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent(this.getLanguage())));
    }
}

