/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR;
import org.fenixedu.academic.domain.degreeStructure.NoEctsComparabilityTableFound;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementMobilityCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.dto.administrativeOffice.documents.ApprovementMobilityCertificateBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class ApprovementMobilityCertificate
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected ApprovementMobilityCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.addParameter("mobilityProgram", this.getMobilityProgramDescription());
        this.addDataSourceElements(this.createApprovementsBean());
        this.addParameter("printPriceFieldsCert", !this.isMobility());
    }

    protected ApprovementMobilityCertificateRequest getDocumentRequest() {
        return (ApprovementMobilityCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected String getDegreeDescription() {
        return this.getDocumentRequest().getRegistration().getDegreeDescription(this.getDocumentRequest().getExecutionYear(), (ProgramConclusion)null, this.getLocale());
    }

    private boolean isMobility() {
        RegistrationProtocol protocol = this.getDocumentRequest().getRegistration().getRegistrationProtocol();
        return protocol.isMobilityAgreement();
    }

    private String getMobilityProgramDescription() {
        return this.isMobility() ? this.getDocumentRequest().getRegistration().getRegistrationProtocol().getDescription().getContent(this.getLocale()) : "";
    }

    private final void mapCycles(SortedSet<ICurriculumEntry> entries) {
        TreeSet<CycleCurriculumGroup> cycles = new TreeSet<CycleCurriculumGroup>(CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
        cycles.addAll(this.getDocumentRequest().getRegistration().getLastStudentCurricularPlan().getInternalCycleCurriculumGrops());
        for (CycleCurriculumGroup cycle : cycles) {
            if (cycle.isConclusionProcessed() && !this.isDEARegistration()) continue;
            ApprovementMobilityCertificateRequest request = this.getDocumentRequest();
            Curriculum curriculum = cycle.getCurriculum(request.getFilteringDate());
            ApprovementMobilityCertificateRequest.filterEntries(entries, request, curriculum);
        }
    }

    private final SortedSet<ICurriculumEntry> mapEntries() {
        ApprovementMobilityCertificateRequest request = this.getDocumentRequest();
        TreeSet<ICurriculumEntry> entries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.isBolonha()) {
            this.mapCycles(entries);
        } else {
            ICurriculum curriculum = registration.getCurriculum(request.getFilteringDate());
            ApprovementMobilityCertificateRequest.filterEntries(entries, request, curriculum);
        }
        if (registration.getRegistrationProtocol().isMobilityAgreement()) {
            entries.addAll(request.getStandaloneEntriesToReport());
        }
        entries.addAll(request.getExtraCurricularEntriesToReport());
        entries.addAll(request.getPropaedeuticEntriesToReport());
        return entries;
    }

    private final List<ApprovementMobilityCertificateBean> createApprovementsBean() {
        SortedSet<ICurriculumEntry> entries = this.mapEntries();
        ArrayList<ApprovementMobilityCertificateBean> beans = new ArrayList<ApprovementMobilityCertificateBean>();
        HashMap<Unit, String> ids = new HashMap<Unit, String>();
        for (ICurriculumEntry entry : entries) {
            ExecutionYear executionYear = entry.getExecutionYear();
            beans.add(new ApprovementMobilityCertificateBean(this.getCurriculumEntryName(ids, entry), entry.getEctsCreditsForCurriculum().toString(), entry.getGradeValue(), this.getEctsGrade(entry), executionYear.getYear()));
        }
        StringBuilder extraInfo = new StringBuilder();
        if (!ids.isEmpty()) {
            extraInfo.append(this.getAcademicUnitInfo(ids));
        }
        if (extraInfo.length() > 0) {
            this.addParameter("mobilityExtraInfo", extraInfo.toString());
        }
        return beans;
    }

    private final String getAcademicUnitInfo(Map<Unit, String> unitIDs) {
        StringBuilder result = new StringBuilder();
        String description = this.getMobilityProgramDescription();
        for (Map.Entry<Unit, String> academicUnitId : unitIDs.entrySet()) {
            StringBuilder unit = new StringBuilder();
            unit.append(academicUnitId.getValue());
            unit.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.external.curricular.courses.one", (String[])new String[0]));
            unit.append(" ").append(this.getMLSTextContent(academicUnitId.getKey().getPartyName()).toUpperCase());
            if (description.length() > 0) {
                unit.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.external.curricular.courses.two", (String[])new String[0]));
                unit.append(" ").append(description);
            }
            result.append(unit.toString());
            result.append("\n");
        }
        return result.toString();
    }

    private boolean isDEARegistration() {
        return this.getDocumentRequest().getRegistration().getDegreeType().isAdvancedSpecializationDiploma();
    }

    private String getEctsGradeDescription() {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.ects.grade", (String[])new String[0]).concat(":");
    }

    private DateTime computeProcessingDateToLockECTSTableUse() {
        DateTime date = this.documentRequestDomainReference.getProcessingDate();
        return date != null ? date : new DateTime();
    }

    private String getEctsGrade(ICurriculumEntry entry) {
        DateTime processingDate = this.computeProcessingDateToLockECTSTableUse();
        if (entry instanceof IEnrolment) {
            IEnrolment enrolment = (IEnrolment)entry;
            try {
                Grade grade = enrolment.getEctsGrade(this.getDocumentRequest().getRegistration().getLastStudentCurricularPlan(), processingDate);
                return grade.getValue();
            }
            catch (NoEctsComparabilityTableFound nectfe) {
                return "--";
            }
        }
        if (entry instanceof Dismissal && ((Dismissal)entry).getCredits().isEquivalence()) {
            Dismissal dismissal = (Dismissal)entry;
            try {
                Grade grade = dismissal.getEctsGrade(processingDate);
                return grade.getValue();
            }
            catch (NoEctsComparabilityTableFound nectfe) {
                return "--";
            }
        }
        throw new Error("The roof is yet again on fire!");
    }

    @Override
    protected String getCreditsAndGradeInfo(ICurriculumEntry entry, ExecutionYear executionYear) {
        StringBuilder result = new StringBuilder();
        if (this.getDocumentRequest().isToShowCredits()) {
            this.getCreditsInfo(result, entry);
        }
        result.append(entry.getGradeValue());
        result.append(StringUtils.rightPad((String)("(" + BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)entry.getGradeValue(), (String[])new String[0]) + ")"), (int)12, (char)' '));
        result.append(", ");
        result.append(this.getEctsGradeDescription());
        result.append(" ");
        result.append(this.getEctsGrade(entry));
        result.append(" ");
        result.append(", ");
        String in = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.in", (String[])new String[0]);
        if (executionYear == null) {
            result.append(StringUtils.rightPad((String)"", (int)in.length(), (char)' '));
            result.append(" ").append(StringUtils.rightPad((String)"", (int)9, (char)' '));
        } else {
            result.append(in);
            result.append(" ").append(executionYear.getYear());
        }
        return result.toString();
    }

    @Override
    protected void addPriceFields() {
        ApprovementMobilityCertificateRequest certificateRequest = this.getDocumentRequest();
        CertificateRequestPR certificateRequestPR = (CertificateRequestPR)((Object)this.getPostingRule());
        Money amountPerPage = certificateRequestPR.getAmountPerPage();
        Money baseAmountPlusAmountForUnits = certificateRequestPR.getBaseAmount().add(certificateRequestPR.getAmountForUnits(certificateRequest.getNumberOfUnits()));
        Money urgencyAmount = certificateRequest.getUrgentRequest() != false ? certificateRequestPR.getBaseAmount() : Money.ZERO;
        this.addParameter("amountPerPage", amountPerPage);
        this.addParameter("baseAmountPlusAmountForUnits", baseAmountPlusAmountForUnits);
        this.addParameter("urgencyAmount", urgencyAmount);
        this.addParameter("printPriceFields", this.printPriceParameters((CertificateRequest)((Object)certificateRequest)));
    }

    @Override
    protected void setPersonFields() {
        Person person = this.getDocumentRequest().getPerson();
        StringBuilder builder1 = new StringBuilder();
        builder1.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.with", (String[])new String[0]));
        builder1.append(" ").append(person.getIdDocumentType().getLocalizedName(this.getLocale()));
        builder1.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.number.short", (String[])new String[0]));
        builder1.append(" ").append(person.getDocumentIdNumber());
        this.addParameter("name", person.getName().toUpperCase());
        this.addParameter("documentIdNumber", builder1.toString());
        this.setNationality(person);
    }
}

