/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.bennu.core.security.Authenticate;

public class RegistrationPredicates {
    public static final AccessControlPredicate<Registration> TRANSIT_TO_BOLONHA = new AccessControlPredicate<Registration>(){

        @Override
        public boolean evaluate(Registration registration) {
            return RoleType.MANAGER.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<Registration> MANAGE_CONCLUSION_PROCESS = new AccessControlPredicate<Registration>(){

        @Override
        public boolean evaluate(Registration registration) {
            if (RoleType.MANAGER.isMember(AccessControl.getPerson().getUser())) {
                return true;
            }
            return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_CONCLUSION, (AcademicProgram)((Object)registration.getDegree()), Authenticate.getUser());
        }
    };
}

