/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumModuleBean;

public class StudentCurriculumGroupBean
extends StudentCurriculumModuleBean {
    private static final long serialVersionUID = 1L;
    private List<StudentCurriculumEnrolmentBean> enrolledCurriculumCourses;
    private List<StudentCurriculumGroupBean> enrolledCurriculumGroups;
    private List<IDegreeModuleToEvaluate> courseGroupsToEnrol;
    private List<IDegreeModuleToEvaluate> curricularCoursesToEnrol;

    public StudentCurriculumGroupBean(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester, int[] curricularYears) {
        super((CurriculumModule)((Object)curriculumGroup));
        this.setCourseGroupsToEnrol(this.buildCourseGroupsToEnrol(curriculumGroup, executionSemester));
        if (curricularYears != null) {
            this.setCurricularCoursesToEnrol(this.buildCurricularCoursesToEnrol(curriculumGroup, executionSemester, curricularYears));
        } else {
            this.setCurricularCoursesToEnrol(this.buildCurricularCoursesToEnrol(curriculumGroup, executionSemester));
        }
        this.setEnrolledCurriculumGroups(this.buildCurriculumGroupsEnroled(curriculumGroup, executionSemester, curricularYears));
        this.setEnrolledCurriculumCourses(this.buildCurricularCoursesEnroled(curriculumGroup, executionSemester));
    }

    protected List<StudentCurriculumGroupBean> buildCurriculumGroupsEnroled(CurriculumGroup parentGroup, ExecutionSemester executionSemester, int[] curricularYears) {
        ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>();
        for (CurriculumGroup curriculumGroup : parentGroup.getCurriculumGroupsToEnrolmentProcess()) {
            result.add(this.createEnroledCurriculumGroupBean(executionSemester, curricularYears, curriculumGroup));
        }
        return result;
    }

    protected StudentCurriculumGroupBean createEnroledCurriculumGroupBean(ExecutionSemester executionSemester, int[] curricularYears, CurriculumGroup curriculumGroup) {
        return new StudentCurriculumGroupBean(curriculumGroup, executionSemester, curricularYears);
    }

    protected List<IDegreeModuleToEvaluate> buildCourseGroupsToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        List<Context> courseGroupContextsToEnrol = group.getCourseGroupContextsToEnrol(executionSemester);
        for (Context context : courseGroupContextsToEnrol) {
            result.add(new DegreeModuleToEnrol(group, context, executionSemester));
        }
        return result;
    }

    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester, int[] curricularYears) {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        List<Context> curricularCoursesToEnrol = group.getCurricularCourseContextsToEnrol(executionSemester);
        block0: for (Context context : curricularCoursesToEnrol) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            for (int curricularYear : curricularYears) {
                if (!context.containsSemesterAndCurricularYear(executionSemester.getSemester(), curricularYear, curricularCourse.getRegime())) continue;
                result.add(new DegreeModuleToEnrol(group, context, executionSemester));
                continue block0;
            }
        }
        return result;
    }

    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        for (Context context : group.getCurricularCourseContextsToEnrol(executionSemester)) {
            result.add(new DegreeModuleToEnrol(group, context, executionSemester));
        }
        return result;
    }

    protected List<StudentCurriculumEnrolmentBean> buildCurricularCoursesEnroled(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<StudentCurriculumEnrolmentBean> result = new ArrayList<StudentCurriculumEnrolmentBean>();
        for (CurriculumLine curriculumLine : group.getCurriculumLines()) {
            Enrolment enrolment;
            if (!curriculumLine.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumLine)).getExecutionPeriod().equals(executionSemester) || !enrolment.isEnroled()) continue;
            result.add(new StudentCurriculumEnrolmentBean((Enrolment)((Object)curriculumLine)));
        }
        return result;
    }

    public CurriculumGroup getCurriculumModule() {
        return (CurriculumGroup)((Object)super.getCurriculumModule());
    }

    public List<IDegreeModuleToEvaluate> getCourseGroupsToEnrol() {
        return this.courseGroupsToEnrol;
    }

    public List<IDegreeModuleToEvaluate> getCourseGroupsToEnrolSortedByContext() {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.courseGroupsToEnrol);
        Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_CONTEXT);
        return result;
    }

    public void setCourseGroupsToEnrol(List<IDegreeModuleToEvaluate> courseGroupsToEnrol) {
        this.courseGroupsToEnrol = courseGroupsToEnrol;
    }

    public List<IDegreeModuleToEvaluate> getSortedDegreeModulesToEvaluate() {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.curricularCoursesToEnrol);
        Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_CONTEXT);
        return result;
    }

    public List<IDegreeModuleToEvaluate> getCurricularCoursesToEnrol() {
        return this.curricularCoursesToEnrol;
    }

    public void setCurricularCoursesToEnrol(List<IDegreeModuleToEvaluate> curricularCoursesToEnrol) {
        this.curricularCoursesToEnrol = curricularCoursesToEnrol;
    }

    public List<StudentCurriculumGroupBean> getEnrolledCurriculumGroups() {
        return this.enrolledCurriculumGroups;
    }

    public List<StudentCurriculumGroupBean> getEnrolledCurriculumGroupsSortedByOrder(ExecutionSemester executionSemester) {
        ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>(this.enrolledCurriculumGroups);
        Collections.sort(result, new ComparatorByCurriculumGroupOrder(executionSemester));
        return result;
    }

    public boolean isEnrolledInAnyCurriculumGroups() {
        return !this.enrolledCurriculumGroups.isEmpty();
    }

    public void setEnrolledCurriculumGroups(List<StudentCurriculumGroupBean> enrolledCurriculumGroups) {
        this.enrolledCurriculumGroups = enrolledCurriculumGroups;
    }

    public List<StudentCurriculumEnrolmentBean> getEnrolledCurriculumCourses() {
        return this.enrolledCurriculumCourses;
    }

    public boolean isEnrolledInAnyCurriculumCourses() {
        return !this.enrolledCurriculumCourses.isEmpty();
    }

    public void setEnrolledCurriculumCourses(List<StudentCurriculumEnrolmentBean> enrolledCurriculumCourses) {
        this.enrolledCurriculumCourses = enrolledCurriculumCourses;
    }

    public boolean isRoot() {
        return this.getCurriculumModule().isRoot();
    }

    public boolean isNoCourseGroupCurriculumGroup() {
        return this.getCurriculumModule().isNoCourseGroupCurriculumGroup();
    }

    public boolean isToBeDisabled() {
        return this.isRoot() || this.isEnrolledInAnyCurriculumCourses() || this.isEnrolledInAnyCurriculumGroups() || this.isNoCourseGroupCurriculumGroup();
    }

    protected static class ComparatorByCurriculumGroupOrder
    implements Comparator<StudentCurriculumGroupBean> {
        private ExecutionSemester executionSemester;

        public ComparatorByCurriculumGroupOrder(ExecutionSemester executionSemester) {
            this.executionSemester = executionSemester;
        }

        @Override
        public int compare(StudentCurriculumGroupBean o1, StudentCurriculumGroupBean o2) {
            CurriculumGroup c1 = o1.getCurriculumModule();
            CurriculumGroup c2 = o2.getCurriculumModule();
            return c1.getChildOrder(this.executionSemester).compareTo(c2.getChildOrder(this.executionSemester));
        }
    }
}

