/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.serviceRequests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeTypeInstance;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.student.MobilityProgram;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.serviceRequests.IDocumentRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;

public class DocumentRequestCreateBean
extends RegistrationAcademicServiceRequestCreateBean
implements IDocumentRequestBean {
    private static final long serialVersionUID = 1L;
    private DocumentPurposeTypeInstance chosenDocumentPurposeType;
    private String otherPurpose;
    private CurriculumGroup branchCurriculumGroup;
    private ProgramConclusion programConclusion;
    private String branch;
    private Boolean average = Boolean.FALSE;
    private Boolean technicalEngineer = Boolean.FALSE;
    private Boolean internshipAbolished = Boolean.FALSE;
    private Boolean internshipApproved = Boolean.FALSE;
    private Boolean studyPlan = Boolean.FALSE;
    private YearMonthDay exceptionalConclusionDate;
    private Boolean toBeCreated;
    private String schema;
    private Collection<String> warningsToReport;
    private Integer year;
    private String givenNames;
    private String familyNames;
    private MobilityProgram mobilityProgram;
    private boolean ignoreExternalEntries = false;
    private boolean ignoreCurriculumInAdvance = false;
    private boolean toUseAll = false;
    private List<Enrolment> enrolments = new ArrayList<Enrolment>();
    private ExecutionSemester executionSemester;
    private List<Exam> exams = new ArrayList<Exam>();
    private Integer numberOfCourseLoads;
    private Unit institution;
    private Integer numberOfPrograms;
    private Money pastPaymentAmount;
    private LocalDate pastRequestDate = new LocalDate();
    private LocalDate pastPaymentDate;
    private LocalDate pastEmissionDate;
    private LocalDate pastDispatchDate;
    private RegistrationProtocol registrationProtocol;

    public DocumentRequestCreateBean(Registration registration) {
        super(registration);
        this.registrationProtocol = registration.getRegistrationProtocol();
        if (this.registrationProtocol != null && this.registrationProtocol.isMobilityAgreement()) {
            this.setLanguage(MultiLanguageString.en);
        } else {
            this.setLanguage(MultiLanguageString.pt);
        }
    }

    public RegistrationProtocol getRegistrationProtocol() {
        return this.registrationProtocol;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        this.registrationProtocol = registrationProtocol;
    }

    @Override
    public ServiceRequestType getChosenServiceRequestType() {
        return this.chosenServiceRequestType;
    }

    @Override
    public void setChosenServiceRequestType(ServiceRequestType chosenServiceRequestType) {
        this.chosenServiceRequestType = chosenServiceRequestType;
    }

    public DocumentRequestType getChosenDocumentRequestType() {
        return this.getChosenServiceRequestType() != null ? this.getChosenServiceRequestType().getDocumentRequestType() : null;
    }

    public void setChosenDocumentRequestType(DocumentRequestType chosenDocumentRequestType) {
        this.chosenServiceRequestType = ServiceRequestType.findUnique(this.getAcademicServiceRequestType(), chosenDocumentRequestType);
    }

    public DocumentPurposeTypeInstance getChosenDocumentPurposeType() {
        return this.chosenDocumentPurposeType;
    }

    public void setChosenDocumentPurposeType(DocumentPurposeTypeInstance chosenDocumentPurposeType) {
        this.chosenDocumentPurposeType = chosenDocumentPurposeType;
    }

    public String getOtherPurpose() {
        return this.otherPurpose;
    }

    public void setOtherPurpose(String otherPurpose) {
        this.otherPurpose = otherPurpose;
    }

    public Boolean getAverage() {
        return this.average;
    }

    public void setAverage(Boolean average) {
        this.average = average;
    }

    public Boolean getTechnicalEngineer() {
        return this.technicalEngineer;
    }

    public void setTechnicalEngineer(Boolean technicalEngineer) {
        this.technicalEngineer = technicalEngineer;
    }

    public Boolean getInternshipAbolished() {
        return this.internshipAbolished;
    }

    public void setInternshipAbolished(Boolean internshipAbolished) {
        this.internshipAbolished = internshipAbolished;
    }

    public Boolean getInternshipApproved() {
        return this.internshipApproved;
    }

    public void setInternshipApproved(Boolean internshipApproved) {
        this.internshipApproved = internshipApproved;
    }

    public Boolean getStudyPlan() {
        return this.studyPlan;
    }

    public void setStudyPlan(Boolean studyPlan) {
        this.studyPlan = studyPlan;
    }

    public YearMonthDay getExceptionalConclusionDate() {
        return this.exceptionalConclusionDate;
    }

    public void setExceptionalConclusionDate(YearMonthDay exceptionalConclusionDate) {
        this.exceptionalConclusionDate = exceptionalConclusionDate;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Boolean getToBeCreated() {
        return this.toBeCreated;
    }

    public void setToBeCreated(Boolean toBeCreated) {
        this.toBeCreated = toBeCreated;
    }

    public Collection<String> getWarningsToReport() {
        if (this.warningsToReport == null) {
            this.warningsToReport = new HashSet<String>();
            DocumentRequestType documentRequestType = this.chosenServiceRequestType.getDocumentRequestType();
            if (documentRequestType == DocumentRequestType.APPROVEMENT_CERTIFICATE) {
                if (this.chosenDocumentPurposeType.getDocumentPurposeType() == DocumentPurposeType.PROFESSIONAL) {
                    this.warningsToReport.add("aprovementType.professionalPurpose.thirdGrade");
                }
                this.warningsToReport.add("aprovementType.finished.degree");
            }
            if (documentRequestType == DocumentRequestType.DEGREE_FINALIZATION_CERTIFICATE) {
                this.warningsToReport.add("degreeFinalizationType.withoutDegreeCertificate");
            }
        }
        return this.warningsToReport;
    }

    public boolean hasWarningsToReport() {
        if (this.warningsToReport == null) {
            this.getWarningsToReport();
        }
        return !this.warningsToReport.isEmpty();
    }

    public void setPurpose(DocumentPurposeTypeInstance chosenDocumentPurposeType, String otherPurpose) {
        otherPurpose = otherPurpose.trim();
        if (chosenDocumentPurposeType != null && chosenDocumentPurposeType.equals((Object)DocumentPurposeType.OTHER) && (otherPurpose == null || otherPurpose.length() == 0)) {
            throw new DomainException("DocumentRequestCreateBean.error.other.purpose.required", new String[0]);
        }
        this.chosenDocumentPurposeType = chosenDocumentPurposeType;
        this.otherPurpose = otherPurpose;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    protected void setRegistration(Registration registration) {
        super.setRegistration(registration);
        if (registration.getPerson().getGivenNames() == null) {
            String[] parts = registration.getStudent().getPerson().getName().split("\\s+");
            int split = parts.length > 3 ? 2 : 1;
            this.setGivenNames(StringUtils.join((Object[])Arrays.copyOfRange(parts, 0, split), (String)" "));
            this.setFamilyNames(StringUtils.join((Object[])Arrays.copyOfRange(parts, split, parts.length), (String)" "));
        } else {
            this.setGivenNames(registration.getPerson().getGivenNames());
            this.setFamilyNames(registration.getPerson().getFamilyNames());
        }
    }

    public void validateNames() {
        String composedName;
        String fullName = this.getRegistration().getStudent().getPerson().getName();
        String familyName = this.getFamilyNames();
        String string = composedName = familyName == null || familyName.isEmpty() ? this.getGivenNames() : this.getGivenNames() + " " + familyName;
        if (!fullName.equals(composedName)) {
            throw new DomainException("error.serviceRequests.diplomaRequest.name.split.not.matching.fullname", new String[0]);
        }
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public void setGivenNames(String givenNames) {
        this.givenNames = givenNames;
    }

    public String getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(String familyNames) {
        this.familyNames = familyNames;
    }

    public final boolean getHasAdditionalInformation() {
        DocumentRequestType documentRequestType = this.chosenServiceRequestType.getDocumentRequestType();
        return documentRequestType == null ? false : documentRequestType.getHasAdditionalInformation();
    }

    @Override
    public boolean getHasCycleTypeDependency() {
        return !this.getIsForProgramConclusionPurposes() && super.getHasCycleTypeDependency();
    }

    public final boolean getIsForProgramConclusionPurposes() {
        DocumentRequestType documentRequestType = this.chosenServiceRequestType.getDocumentRequestType();
        return Stream.of(DocumentRequestType.DEGREE_FINALIZATION_CERTIFICATE, DocumentRequestType.REGISTRY_DIPLOMA_REQUEST, DocumentRequestType.DIPLOMA_REQUEST, DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST).anyMatch(type -> type.equals((Object)documentRequestType));
    }

    public final boolean getHasMobilityProgramDependency() {
        DocumentRequestType documentRequestType = this.chosenServiceRequestType.getDocumentRequestType();
        return documentRequestType == DocumentRequestType.APPROVEMENT_CERTIFICATE || documentRequestType == DocumentRequestType.DEGREE_FINALIZATION_CERTIFICATE;
    }

    public final MobilityProgram getMobilityProgram() {
        return this.mobilityProgram;
    }

    public final void setMobilityProgram(MobilityProgram mobilityProgram) {
        this.mobilityProgram = mobilityProgram;
    }

    public boolean isIgnoreExternalEntries() {
        return this.ignoreExternalEntries;
    }

    public void setIgnoreExternalEntries(boolean ignoreExternalEntries) {
        this.ignoreExternalEntries = ignoreExternalEntries;
    }

    public boolean isIgnoreCurriculumInAdvance() {
        return this.ignoreCurriculumInAdvance;
    }

    public void setIgnoreCurriculumInAdvance(boolean ignoreCurriculumInAdvance) {
        this.ignoreCurriculumInAdvance = ignoreCurriculumInAdvance;
    }

    public boolean isToUseAll() {
        return this.toUseAll;
    }

    public void setToUseAll(boolean toUseAll) {
        this.toUseAll = toUseAll;
    }

    public List<Enrolment> getEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (Enrolment each : this.enrolments) {
            result.add(each);
        }
        return result;
    }

    public void setEnrolments(List<Enrolment> enrolments) {
        ArrayList<Enrolment> enrolmentsToSet = new ArrayList<Enrolment>();
        for (Enrolment enrolment : enrolments) {
            enrolmentsToSet.add(enrolment);
        }
        this.enrolments = enrolmentsToSet;
    }

    public List<Exam> getExams() {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (Exam each : this.exams) {
            result.add(each);
        }
        return result;
    }

    public void setExams(List<Exam> exams) {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (Exam each : exams) {
            result.add(each);
        }
        this.exams = result;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public Integer getNumberOfCourseLoads() {
        return this.numberOfCourseLoads;
    }

    public void setNumberOfCourseLoads(Integer numberOfCourseLoads) {
        this.numberOfCourseLoads = numberOfCourseLoads;
    }

    public UnitName getInstitutionName() {
        return this.institution != null ? this.institution.getUnitName() : null;
    }

    public void setInstitutionName(UnitName institutionName) {
        this.institution = institutionName != null ? institutionName.getUnit() : null;
    }

    public Unit getInstitution() {
        return this.institution;
    }

    public Integer getNumberOfPrograms() {
        return this.numberOfPrograms;
    }

    public void setNumberOfPrograms(Integer numberOfPrograms) {
        this.numberOfPrograms = numberOfPrograms;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public CurriculumGroup getBranchCurriculumGroup() {
        return this.branchCurriculumGroup;
    }

    public void setBranchCurriculumGroup(CurriculumGroup branchCurriculumGroup) {
        this.branchCurriculumGroup = branchCurriculumGroup;
    }

    public String getBranchName() {
        if (this.getBranchCurriculumGroup() == null) {
            return this.branch;
        }
        return this.getBranchCurriculumGroup().getName().getContent();
    }

    public boolean getHasPurposeNeed() {
        if (!this.chosenServiceRequestType.isLegacy()) {
            return false;
        }
        DocumentRequestType documentRequestType = this.chosenServiceRequestType.getDocumentRequestType();
        return !documentRequestType.isDiploma() && !documentRequestType.isRegistryDiploma() && !documentRequestType.isPastDiploma() && !documentRequestType.isDiplomaSupplement();
    }

    public void setPastPaymentAmount(Money paymentAmount) {
        this.pastPaymentAmount = paymentAmount;
    }

    public Money getPastPaymentAmount() {
        return this.pastPaymentAmount;
    }

    public void setPastPaymentDate(LocalDate paymentDate) {
        this.pastPaymentDate = paymentDate;
    }

    public LocalDate getPastPaymentDate() {
        return this.pastPaymentDate;
    }

    public LocalDate getPastEmissionDate() {
        return this.pastEmissionDate;
    }

    public void setPastEmissionDate(LocalDate emissionDate) {
        this.pastEmissionDate = emissionDate;
    }

    public LocalDate getPastDispatchDate() {
        return this.pastDispatchDate;
    }

    public void setPastDispatchDate(LocalDate dispatchDate) {
        this.pastDispatchDate = dispatchDate;
    }

    public LocalDate getPastRequestDate() {
        return this.pastRequestDate;
    }

    public void setPastRequestDate(LocalDate pastRequestDate) {
        this.pastRequestDate = pastRequestDate;
    }

    @Override
    public boolean hasRegistration() {
        return this.getRegistration() != null;
    }

    public ProgramConclusion getProgramConclusion() {
        return this.programConclusion;
    }

    public void setProgramConclusion(ProgramConclusion programConclusion) {
        this.programConclusion = programConclusion;
    }

    public static class CycleTypeProvider
    implements DataProvider {
        public Converter getConverter() {
            return new EnumConverter();
        }

        public Object provide(Object source, Object currentValue) {
            RegistrationAcademicServiceRequestCreateBean bean = (RegistrationAcademicServiceRequestCreateBean)source;
            return bean.getRegistration().getDegreeType().getCycleTypes();
        }
    }
}

