/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.util.NumberUtils;

public class InfoShiftGroupStatistics
extends InfoObject {
    private List<InfoShift> shiftsInGroup = new ArrayList<InfoShift>();

    public List getShiftsInGroup() {
        return this.shiftsInGroup;
    }

    public Integer getTotalCapacity() {
        Integer totalCapacity = 0;
        for (InfoShift infoShift : this.shiftsInGroup) {
            totalCapacity = totalCapacity + infoShift.getLotacao();
        }
        return totalCapacity;
    }

    public Double getTotalPercentage() {
        Integer totalCapacity = 0;
        Integer students = 0;
        for (InfoShift infoShift : this.shiftsInGroup) {
            students = students + infoShift.getOcupation();
            totalCapacity = totalCapacity + infoShift.getLotacao();
        }
        if (students == 0) {
            return 0.0;
        }
        return NumberUtils.formatNumber(new Double(students.floatValue() * 100.0f / totalCapacity.floatValue()), 1);
    }

    public void setShiftsInGroup(List shiftsInGroup) {
        this.shiftsInGroup = shiftsInGroup;
    }

    public Integer getTotalNumberOfStudents() {
        Integer totalNumberOfStudents = 0;
        for (InfoShift infoShift : this.shiftsInGroup) {
            totalNumberOfStudents = totalNumberOfStudents + infoShift.getOcupation();
        }
        return totalNumberOfStudents;
    }
}

