/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.curricularRules.AssertUniqueApprovalInCurricularCourseContexts;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.PreviousYearsEnrolmentCurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroupFactory;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;

public class StudentCurricularPlanEnrolmentManager
extends StudentCurricularPlanEnrolment {
    public StudentCurricularPlanEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertEnrolmentPreConditions() {
        if (!this.isResponsiblePersonManager() && !this.getRegistration().isRegistered(this.getExecutionSemester())) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.registration.inactive", new String[0]);
        }
        super.assertEnrolmentPreConditions();
    }

    @Override
    protected void unEnrol() {
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (!curriculumModule.isLeaf()) continue;
            curriculumModule.delete();
        }
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (curriculumModule.isLeaf()) continue;
            curriculumModule.delete();
        }
    }

    @Override
    protected void addEnroled() {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.getStudentCurricularPlan().getDegreeModulesToEvaluate(this.getExecutionSemester())) {
            this.enrolmentContext.addDegreeModuleToEvaluate(degreeModuleToEvaluate);
        }
    }

    @Override
    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.canCollectRules()) continue;
            HashSet<ICurricularRule> curricularRules = new HashSet<ICurricularRule>();
            curricularRules.addAll(degreeModuleToEvaluate.getCurricularRulesFromDegreeModule(this.getExecutionSemester()));
            curricularRules.addAll(degreeModuleToEvaluate.getCurricularRulesFromCurriculumGroup(this.getExecutionSemester()));
            if (degreeModuleToEvaluate.isLeaf()) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule());
                this.addRuntimeRules(curricularRules, curricularCourse);
            }
            result.put(degreeModuleToEvaluate, curricularRules);
        }
        return result;
    }

    protected void addRuntimeRules(Set<ICurricularRule> curricularRules, CurricularCourse curricularCourse) {
        curricularRules.add(new AssertUniqueApprovalInCurricularCourseContexts(curricularCourse));
    }

    @Override
    protected void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesEnrolMap) {
        String createdBy = this.getResponsiblePerson().getUsername();
        for (Map.Entry<EnrolmentResultType, List<IDegreeModuleToEvaluate>> entry : degreeModulesEnrolMap.entrySet()) {
            if (entry.getKey() == EnrolmentResultType.NULL) continue;
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : entry.getValue()) {
                if (degreeModuleToEvaluate.isEnroled()) {
                    EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
                    if (!(moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment)) continue;
                    Enrolment enrolment = (Enrolment)((Object)moduleEnroledWrapper.getCurriculumModule());
                    enrolment.setEnrolmentCondition(this.getEnrolmentCondition(enrolment, entry.getKey()));
                    continue;
                }
                DegreeModule degreeModule = degreeModuleToEvaluate.getDegreeModule();
                CurriculumGroup curriculumGroup = degreeModuleToEvaluate.getCurriculumGroup();
                if (degreeModule.isLeaf()) {
                    if (degreeModuleToEvaluate.isOptional()) {
                        this.createOptionalEnrolmentFor(this.getEnrolmentCondition(null, entry.getKey()), degreeModuleToEvaluate, curriculumGroup);
                        continue;
                    }
                    new Enrolment(this.getStudentCurricularPlan(), curriculumGroup, (CurricularCourse)((Object)degreeModule), this.getExecutionSemester(), this.getEnrolmentCondition(null, entry.getKey()), createdBy);
                    continue;
                }
                CurriculumGroupFactory.createGroup(degreeModuleToEvaluate.getCurriculumGroup(), (CourseGroup)((Object)degreeModule), this.getExecutionSemester());
            }
        }
        this.getRegistration().updateEnrolmentDate(this.getExecutionYear());
    }

    protected EnrollmentCondition getEnrolmentCondition(Enrolment enrolment, EnrolmentResultType enrolmentResultType) {
        return enrolmentResultType.getEnrollmentCondition();
    }

    private void createOptionalEnrolmentFor(EnrollmentCondition enrollmentCondition, IDegreeModuleToEvaluate degreeModuleToEvaluate, CurriculumGroup curriculumGroup) {
        OptionalDegreeModuleToEnrol optionalDegreeModuleToEnrol = (OptionalDegreeModuleToEnrol)degreeModuleToEvaluate;
        OptionalCurricularCourse optionalCurricularCourse = (OptionalCurricularCourse)((Object)optionalDegreeModuleToEnrol.getDegreeModule());
        CurricularCourse curricularCourse = optionalDegreeModuleToEnrol.getCurricularCourse();
        this.getStudentCurricularPlan().createOptionalEnrolment(curriculumGroup, this.getExecutionSemester(), optionalCurricularCourse, curricularCourse, enrollmentCondition);
    }

    @Override
    protected RuleResult evaluateExtraRules(RuleResult actualResult) {
        if (actualResult.isFalse() || !this.getDegreeCurricularPlan().isToApplyPreviousYearsEnrolmentRule()) {
            return actualResult;
        }
        RuleResult finalResult = RuleResult.createInitialTrue();
        if (!this.getRoot().hasExternalCycles()) {
            PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = new PreviousYearsEnrolmentCurricularRule((CourseGroup)((Object)this.getRoot().getDegreeModule()));
            finalResult = finalResult.and(previousYearsEnrolmentCurricularRule.evaluate(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)this.getRoot()), this.getExecutionSemester()), this.enrolmentContext));
        } else {
            for (CycleCurriculumGroup cycleCurriculumGroup : this.getRoot().getCycleCurriculumGroups()) {
                PreviousYearsEnrolmentCurricularRule previousYearsEnrolmentCurricularRule = new PreviousYearsEnrolmentCurricularRule((CourseGroup)((Object)cycleCurriculumGroup.getDegreeModule()));
                finalResult = finalResult.and(previousYearsEnrolmentCurricularRule.evaluate(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)cycleCurriculumGroup), this.getExecutionSemester()), this.enrolmentContext));
            }
        }
        return finalResult.and(actualResult);
    }
}

