/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Comparator;
import java.util.Set;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.BranchType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup_Base;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class CycleCurriculumGroup
extends CycleCurriculumGroup_Base {
    private static final Comparator<CycleCurriculumGroup> COMPARATOR_BY_CYCLE_TYPE = new Comparator<CycleCurriculumGroup>(){

        @Override
        public final int compare(CycleCurriculumGroup o1, CycleCurriculumGroup o2) {
            return CycleType.COMPARATOR_BY_LESS_WEIGHT.compare(o1.getCycleType(), o2.getCycleType());
        }
    };
    public static final Comparator<CycleCurriculumGroup> COMPARATOR_BY_CYCLE_TYPE_AND_ID = new Comparator<CycleCurriculumGroup>(){

        @Override
        public final int compare(CycleCurriculumGroup o1, CycleCurriculumGroup o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_CYCLE_TYPE);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };

    protected CycleCurriculumGroup() {
    }

    public CycleCurriculumGroup(RootCurriculumGroup rootCurriculumGroup, CycleCourseGroup cycleCourseGroup, ExecutionSemester executionSemester) {
        this();
        this.init((CurriculumGroup)((Object)rootCurriculumGroup), (CourseGroup)((Object)cycleCourseGroup), executionSemester);
    }

    public CycleCurriculumGroup(RootCurriculumGroup rootCurriculumGroup, CycleCourseGroup cycleCourseGroup) {
        this();
        this.init((CurriculumGroup)((Object)rootCurriculumGroup), (CourseGroup)((Object)cycleCourseGroup));
    }

    protected void init(CurriculumGroup curriculumGroup, CourseGroup courseGroup) {
        this.checkInitConstraints((RootCurriculumGroup)((Object)curriculumGroup), (CycleCourseGroup)((Object)courseGroup));
        super.init(curriculumGroup, courseGroup);
    }

    protected void init(CurriculumGroup curriculumGroup, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        this.checkInitConstraints((RootCurriculumGroup)((Object)curriculumGroup), (CycleCourseGroup)((Object)courseGroup));
        super.init(curriculumGroup, courseGroup, executionSemester);
    }

    private void checkInitConstraints(RootCurriculumGroup rootCurriculumGroup, CycleCourseGroup cycleCourseGroup) {
        if (rootCurriculumGroup.getCycleCurriculumGroup(cycleCourseGroup.getCycleType()) != null) {
            throw new DomainException("error.studentCurriculum.RootCurriculumGroup.cycle.course.group.already.exists.in.curriculum", cycleCourseGroup.getName());
        }
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        if (curriculumGroup != null && !(curriculumGroup instanceof RootCurriculumGroup)) {
            throw new DomainException("error.curriculumGroup.CycleParentCanOnlyBeRootCurriculumGroup", new String[0]);
        }
        super.setCurriculumGroup(curriculumGroup);
    }

    public void setDegreeModule(DegreeModule degreeModule) {
        if (degreeModule != null && !(degreeModule instanceof CycleCourseGroup)) {
            throw new DomainException("error.curriculumGroup.CycleParentDegreeModuleCanOnlyBeCycleCourseGroup", new String[0]);
        }
        super.setDegreeModule(degreeModule);
    }

    public CycleCourseGroup getDegreeModule() {
        return (CycleCourseGroup)((Object)super.getDegreeModule());
    }

    public boolean isCycleCurriculumGroup() {
        return true;
    }

    public boolean isCycle(CycleType cycleType) {
        return this.getCycleType() == cycleType;
    }

    public boolean isFirstCycle() {
        return this.isCycle(CycleType.FIRST_CYCLE);
    }

    public CycleCourseGroup getCycleCourseGroup() {
        return this.getDegreeModule();
    }

    public CycleType getCycleType() {
        return this.getCycleCourseGroup().getCycleType();
    }

    public RootCurriculumGroup getCurriculumGroup() {
        return (RootCurriculumGroup)((Object)super.getCurriculumGroup());
    }

    public void delete() {
        this.checkRulesToDelete();
        super.delete();
    }

    public void deleteRecursive() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        for (CurriculumModule child : this.getCurriculumModulesSet()) {
            child.deleteRecursive();
        }
        super.delete();
    }

    private void checkRulesToDelete() {
        if (this.isFirstCycle() && (this.getRegistration().getIngressionType().isDirectAccessFrom1stCycle() || this.getRegistration().getIngressionType().isInternal2ndCycleAccess())) {
            User userView = Authenticate.getUser();
            if (AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)this.getRegistration().getDegree()), userView.getPerson().getUser()) || RoleType.MANAGER.isMember(userView.getPerson().getUser())) {
                return;
            }
        }
        if (this.getCurriculumGroup().getDegreeType().isIntegratedMasterDegree() && this.getCurriculumGroup().getRootCurriculumGroup().getCycleCurriculumGroups().size() == 1) {
            throw new DomainException("error.studentCurriculum.CycleCurriculumGroup.degree.type.requires.this.cycle.to.exist", this.getName().getContent());
        }
    }

    public boolean isExternal() {
        return false;
    }

    public YearMonthDay calculateConclusionDate() {
        YearMonthDay result = super.calculateConclusionDate();
        if (this.getRegistration().getWasTransition()) {
            ExecutionSemester firstBolonhaTransitionExecutionPeriod = ExecutionSemester.readFirstBolonhaTransitionExecutionPeriod();
            YearMonthDay begin = firstBolonhaTransitionExecutionPeriod.getBeginDateYearMonthDay();
            if (result == null || result.isBefore((ReadablePartial)begin)) {
                result = begin;
            }
        }
        return result;
    }

    public Double getCurrentDefaultEcts() {
        return this.getDegreeModule().getCurrentDefaultEcts();
    }

    public Double getDefaultEcts(ExecutionYear executionYear) {
        return this.getDegreeModule().getDefaultEcts(executionYear);
    }

    public CycleCurriculumGroup getParentCycleCurriculumGroup() {
        return this;
    }

    public BranchCurriculumGroup getBranchCurriculumGroup(BranchType branchType) {
        Set groups = this.getBranchCurriculumGroups(branchType);
        return groups.isEmpty() ? null : (BranchCurriculumGroup)((Object)groups.iterator().next());
    }

    public BranchCurriculumGroup getMajorBranchCurriculumGroup() {
        return this.getBranchCurriculumGroup(BranchType.MAJOR);
    }

    public BranchCurriculumGroup getMinorBranchCurriculumGroup() {
        return this.getBranchCurriculumGroup(BranchType.MINOR);
    }

    public BranchCourseGroup getBranchCourseGroup(BranchType branchType) {
        Set groups = this.getBranchCourseGroups(branchType);
        return groups.isEmpty() ? null : (BranchCourseGroup)((Object)groups.iterator().next());
    }

    public BranchCourseGroup getMajorBranchCourseGroup() {
        return this.getBranchCourseGroup(BranchType.MAJOR);
    }

    public BranchCourseGroup getMinorBranchCourseGroup() {
        return this.getBranchCourseGroup(BranchType.MINOR);
    }
}

