/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurricularPlan.equivalencyPlan;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import pt.ist.fenixframework.DomainObject;

public class EquivalencyPlanEntryCurriculumModuleWrapper {
    private static final Comparator<EquivalencyPlanEntryCurriculumModuleWrapper> COMPARATOR_BY_DEGREE_MODULE_NAME = new Comparator<EquivalencyPlanEntryCurriculumModuleWrapper>(){

        @Override
        public int compare(EquivalencyPlanEntryCurriculumModuleWrapper o1, EquivalencyPlanEntryCurriculumModuleWrapper o2) {
            DegreeModule d1 = o1.getCurriculumModule().getDegreeModule();
            DegreeModule d2 = o2.getCurriculumModule().getDegreeModule();
            int c = Collator.getInstance().compare(d1.getName(), d2.getName());
            return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)d1, (DomainObject)d2) : c;
        }
    };
    private final CurriculumModule curriculumModule;
    private final Set<EquivalencePlanEntry> equivalencePlanEntriesToApply = new HashSet<EquivalencePlanEntry>();
    private final Set<EquivalencePlanEntry> removedEquivalencePlanEntries = new HashSet<EquivalencePlanEntry>();
    private final Set<EquivalencyPlanEntryCurriculumModuleWrapper> children = new TreeSet<EquivalencyPlanEntryCurriculumModuleWrapper>(COMPARATOR_BY_DEGREE_MODULE_NAME);

    public EquivalencyPlanEntryCurriculumModuleWrapper(CurriculumModule curriculumModule) {
        this.curriculumModule = curriculumModule;
    }

    public CurriculumModule getCurriculumModule() {
        return this.curriculumModule;
    }

    public Set<EquivalencePlanEntry> getEquivalencePlanEntriesToApply() {
        return this.equivalencePlanEntriesToApply;
    }

    public Set<EquivalencePlanEntry> getRemovedEquivalencePlanEntries() {
        return this.removedEquivalencePlanEntries;
    }

    public Set<EquivalencyPlanEntryCurriculumModuleWrapper> getChildren() {
        return this.children;
    }

    public void addEquivalencePlanEntriesToApply(EquivalencePlanEntry equivalencePlanEntry) {
        this.equivalencePlanEntriesToApply.add(equivalencePlanEntry);
    }

    public void addRemovedEquivalencePlanEntries(EquivalencePlanEntry equivalencePlanEntry) {
        this.removedEquivalencePlanEntries.add(equivalencePlanEntry);
    }

    public void addChildren(EquivalencyPlanEntryCurriculumModuleWrapper curriculumModule) {
        this.children.add(curriculumModule);
    }
}

