/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.AverageType;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;

public class Curriculum
implements Serializable,
ICurriculum {
    private static final long serialVersionUID = -8365985725904139675L;
    private CurriculumModule curriculumModule;
    private Boolean bolonhaDegree;
    private final ExecutionYear executionYear;
    private final Set<ICurriculumEntry> averageEnrolmentRelatedEntries = new HashSet<ICurriculumEntry>();
    private final Set<ICurriculumEntry> averageDismissalRelatedEntries = new HashSet<ICurriculumEntry>();
    private final Set<ICurriculumEntry> curricularYearEntries = new HashSet<ICurriculumEntry>();
    private BigDecimal sumPiCi;
    private BigDecimal sumPi;
    protected static final int SCALE = 2;
    protected static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;
    private AverageType averageType = AverageType.WEIGHTED;
    private Grade rawGrade;
    private Grade finalGrade;
    private BigDecimal sumEctsCredits;
    private Integer curricularYear;
    private boolean forceCalculus;

    public static Curriculum createEmpty(ExecutionYear executionYear) {
        return Curriculum.createEmpty(null, executionYear);
    }

    public static Curriculum createEmpty(CurriculumModule curriculumModule, ExecutionYear executionYear) {
        return new Curriculum(curriculumModule, executionYear);
    }

    private Curriculum(CurriculumModule curriculumModule, ExecutionYear executionYear) {
        this.curriculumModule = curriculumModule;
        this.bolonhaDegree = curriculumModule == null ? null : Boolean.valueOf(curriculumModule.getStudentCurricularPlan().isBolonhaDegree());
        this.executionYear = executionYear;
    }

    public Curriculum(CurriculumModule curriculumModule, ExecutionYear executionYear, Collection<ICurriculumEntry> averageEnrolmentRelatedEntries, Collection<ICurriculumEntry> averageDismissalRelatedEntries, Collection<ICurriculumEntry> curricularYearEntries) {
        this(curriculumModule, executionYear);
        this.addAverageEntries(this.averageEnrolmentRelatedEntries, averageEnrolmentRelatedEntries);
        this.addAverageEntries(this.averageDismissalRelatedEntries, averageDismissalRelatedEntries);
        this.addCurricularYearEntries(this.curricularYearEntries, curricularYearEntries);
    }

    public void add(Curriculum curriculum) {
        if (!this.hasCurriculumModule()) {
            this.curriculumModule = curriculum.getCurriculumModule();
            this.bolonhaDegree = curriculum.isBolonha();
        }
        this.addAverageEntries(this.averageEnrolmentRelatedEntries, curriculum.getEnrolmentRelatedEntries());
        this.addAverageEntries(this.averageDismissalRelatedEntries, curriculum.getDismissalRelatedEntries());
        this.addCurricularYearEntries(this.curricularYearEntries, curriculum.getCurricularYearEntries());
        this.forceCalculus = true;
    }

    private void addAverageEntries(Set<ICurriculumEntry> entries, Collection<ICurriculumEntry> newEntries) {
        for (ICurriculumEntry newEntry : newEntries) {
            if (this.isAlreadyAverageEntry(newEntry)) continue;
            this.add(entries, newEntry);
        }
    }

    private boolean isAlreadyAverageEntry(ICurriculumEntry newEntry) {
        return this.averageEnrolmentRelatedEntries.contains(newEntry) || this.averageDismissalRelatedEntries.contains(newEntry);
    }

    private void addCurricularYearEntries(Set<ICurriculumEntry> entries, Collection<ICurriculumEntry> newEntries) {
        for (ICurriculumEntry newEntry : newEntries) {
            this.add(entries, newEntry);
        }
    }

    private void add(Set<ICurriculumEntry> entries, ICurriculumEntry newEntry) {
        if (this.isBolonha().booleanValue() || !this.isAlreadyCurricularYearEntry(newEntry)) {
            entries.add(newEntry);
        }
    }

    private boolean isAlreadyCurricularYearEntry(ICurriculumEntry newEntry) {
        if (newEntry instanceof IEnrolment) {
            return this.isCurricularYearEntryAsEnrolmentOrAsSourceEnrolment((IEnrolment)newEntry);
        }
        if (newEntry instanceof Dismissal) {
            return this.isCurricularYearEntryAsSimilarDismissal((Dismissal)newEntry);
        }
        return false;
    }

    private boolean isCurricularYearEntryAsEnrolmentOrAsSourceEnrolment(IEnrolment newIEnrolment) {
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            if (entry instanceof Dismissal && ((Dismissal)entry).hasSourceIEnrolments(newIEnrolment)) {
                return true;
            }
            if (entry != newIEnrolment) continue;
            return true;
        }
        return false;
    }

    private boolean isCurricularYearEntryAsSimilarDismissal(Dismissal newDismissal) {
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            if (!(entry instanceof Dismissal) || newDismissal.isCreditsDismissal() || !newDismissal.isSimilar((Dismissal)entry)) continue;
            return true;
        }
        return false;
    }

    public CurriculumModule getCurriculumModule() {
        return this.curriculumModule;
    }

    public boolean hasCurriculumModule() {
        return this.getCurriculumModule() != null;
    }

    public Boolean isBolonha() {
        return this.bolonhaDegree;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    @Override
    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.hasCurriculumModule() ? this.getCurriculumModule().getStudentCurricularPlan() : null;
    }

    public boolean hasAverageEntry() {
        return this.hasCurriculumModule() && !this.getCurriculumEntries().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasCurriculumModule() || this.getCurriculumEntries().isEmpty() && this.curricularYearEntries.isEmpty();
    }

    @Override
    public Collection<ICurriculumEntry> getCurriculumEntries() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        result.addAll(this.averageEnrolmentRelatedEntries);
        result.addAll(this.averageDismissalRelatedEntries);
        return result;
    }

    @Override
    public boolean hasAnyExternalApprovedEnrolment() {
        for (ICurriculumEntry entry : this.averageDismissalRelatedEntries) {
            if (!(entry instanceof ExternalEnrolment)) continue;
            return true;
        }
        return false;
    }

    public Set<ICurriculumEntry> getEnrolmentRelatedEntries() {
        return this.averageEnrolmentRelatedEntries;
    }

    public Set<ICurriculumEntry> getDismissalRelatedEntries() {
        return this.averageDismissalRelatedEntries;
    }

    @Override
    public Set<ICurriculumEntry> getCurricularYearEntries() {
        return this.curricularYearEntries;
    }

    public BigDecimal getWeigthedGradeSum() {
        if (this.sumPiCi == null || this.forceCalculus) {
            this.doCalculus();
            this.forceCalculus = false;
        }
        return this.sumPiCi;
    }

    @Override
    public Grade getRawGrade() {
        if (this.rawGrade == null || this.forceCalculus) {
            this.doCalculus();
            this.forceCalculus = false;
        }
        return this.rawGrade;
    }

    @Override
    public Grade getFinalGrade() {
        if (this.finalGrade == null || this.forceCalculus) {
            this.doCalculus();
            this.forceCalculus = false;
        }
        return this.finalGrade;
    }

    @Override
    public BigDecimal getSumEctsCredits() {
        if (this.sumEctsCredits == null || this.forceCalculus) {
            this.doCalculus();
            this.forceCalculus = false;
        }
        return this.sumEctsCredits;
    }

    @Override
    public Integer getCurricularYear() {
        if (this.curricularYear == null || this.forceCalculus) {
            this.doCalculus();
            this.forceCalculus = false;
        }
        return this.curricularYear;
    }

    @Override
    public BigDecimal getRemainingCredits() {
        BigDecimal result = BigDecimal.ZERO;
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            Dismissal dismissal;
            if (!(entry instanceof Dismissal) || !(dismissal = (Dismissal)entry).getCredits().isCredits() && !dismissal.getCredits().isEquivalence() && (!dismissal.isCreditsDismissal() || dismissal.getCredits().isSubstitution())) continue;
            result = result.add(entry.getEctsCreditsForCurriculum());
        }
        return result;
    }

    private void doCalculus() {
        this.sumPiCi = BigDecimal.ZERO;
        this.sumPi = BigDecimal.ZERO;
        this.countAverage(this.averageEnrolmentRelatedEntries);
        this.countAverage(this.averageDismissalRelatedEntries);
        BigDecimal avg = this.calculateAverage();
        this.rawGrade = Grade.createGrade(avg.setScale(2, ROUNDING_MODE).toString(), GradeScale.TYPE20);
        this.finalGrade = Grade.createGrade(avg.setScale(0, ROUNDING_MODE).toString(), GradeScale.TYPE20);
        this.sumEctsCredits = BigDecimal.ZERO;
        this.countCurricularYear(this.curricularYearEntries);
        this.accountForDirectIngressions();
        this.curricularYear = this.calculateCurricularYear();
    }

    @Override
    public void setAverageType(AverageType averageType) {
        this.averageType = averageType;
        this.forceCalculus = true;
    }

    private void countAverage(Set<ICurriculumEntry> entries) {
        for (ICurriculumEntry entry : entries) {
            if (!entry.getGrade().isNumeric()) continue;
            BigDecimal weigth = entry.getWeigthForCurriculum();
            if (this.averageType == AverageType.WEIGHTED) {
                this.sumPi = this.sumPi.add(weigth);
                this.sumPiCi = this.sumPiCi.add(entry.getWeigthForCurriculum().multiply(entry.getGrade().getNumericValue()));
                continue;
            }
            if (this.averageType == AverageType.SIMPLE) {
                this.sumPi = this.sumPi.add(BigDecimal.ONE);
                this.sumPiCi = this.sumPiCi.add(entry.getGrade().getNumericValue());
                continue;
            }
            throw new DomainException("Curriculum.average.type.not.supported", new String[0]);
        }
    }

    private BigDecimal calculateAverage() {
        return this.sumPi.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.sumPiCi.divide(this.sumPi, 5, ROUNDING_MODE);
    }

    private void countCurricularYear(Set<ICurriculumEntry> entries) {
        for (ICurriculumEntry entry : entries) {
            this.sumEctsCredits = this.sumEctsCredits.add(entry.getEctsCreditsForCurriculum());
        }
    }

    private void accountForDirectIngressions() {
        if (this.getCycleType() != null) {
            return;
        }
        if (!this.getStudentCurricularPlan().getDegreeCurricularPlan().isBolonhaDegree()) {
            return;
        }
        if (this.getStudentCurricularPlan().getCycleCurriculumGroups().isEmpty()) {
            return;
        }
        CycleCurriculumGroup sgroup = Collections.min(this.getStudentCurricularPlan().getCycleCurriculumGroups(), CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
        for (CycleType cycleIter = sgroup.getCycleType().getPrevious(); cycleIter != null; cycleIter = cycleIter.getPrevious()) {
            if (this.getStudentCurricularPlan().getDegreeCurricularPlan().getCycleCourseGroup(cycleIter) == null) continue;
            this.sumEctsCredits = this.sumEctsCredits.add(new BigDecimal(cycleIter.getEctsCredits()));
        }
    }

    private Integer calculateCurricularYear() {
        if (this.sumEctsCredits.compareTo(BigDecimal.ZERO) == 0) {
            return 1;
        }
        BigDecimal ectsCreditsCurricularYear = this.sumEctsCredits.add(BigDecimal.valueOf(24L)).divide(BigDecimal.valueOf(60L), 5, RoundingMode.HALF_EVEN).add(BigDecimal.valueOf(1L));
        return Math.min(ectsCreditsCurricularYear.intValue(), this.getTotalCurricularYears());
    }

    @Override
    public Integer getTotalCurricularYears() {
        StudentCurricularPlan plan = this.getStudentCurricularPlan();
        if (plan == null) {
            return 0;
        }
        return plan.getDegreeCurricularPlan().getDurationInYears(this.getCycleType());
    }

    private CycleType getCycleType() {
        if (!this.hasCurriculumModule() || !this.isBolonha().booleanValue()) {
            return null;
        }
        CurriculumModule module = this.getCurriculumModule();
        CycleType cycleType = module.isCycleCurriculumGroup() ? ((CycleCurriculumGroup)((Object)module)).getCycleType() : null;
        return cycleType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n[CURRICULUM]");
        if (this.hasCurriculumModule()) {
            result.append("\n[CURRICULUM_MODULE][ID] " + this.getCurriculumModule().getExternalId() + "\t[NAME]" + this.getCurriculumModule().getName().getContent());
            result.append("\n[BOLONHA] " + this.isBolonha().toString());
        } else {
            result.append("\n[NO CURRICULUM_MODULE]");
        }
        result.append("\n[SUM ENTRIES] " + (this.averageEnrolmentRelatedEntries.size() + this.averageDismissalRelatedEntries.size()));
        result.append("\n[RAW GRADE] " + this.getRawGrade().getValue());
        result.append("\n[FINAL GRADE] " + this.getFinalGrade().getValue());
        result.append("\n[SUM ECTS CREDITS] " + this.getSumEctsCredits().toString());
        result.append("\n[CURRICULAR YEAR] " + this.getCurricularYear());
        result.append("\n[REMAINING CREDITS] " + this.getRemainingCredits().toString());
        result.append("\n[TOTAL CURRICULAR YEARS] " + this.getTotalCurricularYears());
        result.append("\n[AVERAGE ENROLMENT ENTRIES]");
        for (ICurriculumEntry entry : this.averageEnrolmentRelatedEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[GRADE] " + entry.getGrade().toString() + "\t[WEIGHT] " + entry.getWeigthForCurriculum() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        result.append("\n[AVERAGE DISMISSAL RELATED ENTRIES]");
        for (ICurriculumEntry entry : this.averageDismissalRelatedEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[GRADE] " + entry.getGrade().toString() + "\t[WEIGHT] " + entry.getWeigthForCurriculum() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        result.append("\n[CURRICULAR YEAR ENTRIES]");
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        return result.toString();
    }

    public void removeFromAllCurriculumEntries(ICurriculumEntry entryToRemove) {
        this.averageEnrolmentRelatedEntries.remove(entryToRemove);
        this.averageDismissalRelatedEntries.remove(entryToRemove);
        this.curricularYearEntries.remove(entryToRemove);
    }
}

