/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import java.util.Set;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.SpaceOccupation_Base;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.spaces.domain.Space;

public abstract class SpaceOccupation
extends SpaceOccupation_Base {
    protected SpaceOccupation() {
    }

    public abstract Group getAccessGroup();

    public void checkPermissionsToManageSpaceOccupations() {
        User user = Authenticate.getUser();
        Space r = this.getSpace();
        if (SpaceUtils.personIsSpacesAdministrator(user.getPerson()) || r.getManagementGroupWithChainOfResponsability() != null && r.getManagementGroupWithChainOfResponsability().isMember(user)) {
            return;
        }
        Group group = this.getAccessGroup();
        if (group != null && group.isMember(user)) {
            return;
        }
        throw new DomainException("error.logged.person.not.authorized.to.make.operation", new String[0]);
    }

    public void checkPermissionsToManageSpaceOccupationsWithoutCheckSpaceManager() {
        User user = Authenticate.getUser();
        if (this.getSpace() == null) {
            return;
        }
        Group group = this.getAccessGroup();
        if (group != null && group.isMember(user)) {
            return;
        }
        throw new DomainException("error.logged.person.not.authorized.to.make.operation", new String[0]);
    }

    public Space getSpace() {
        Set spaces = this.getSpaces();
        return spaces.isEmpty() ? null : (Space)spaces.iterator().next();
    }
}

