/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner$callable$create;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentSigner
extends DocumentSigner_Base {
    public static final Comparator<DocumentSigner> DEFAULT_COMPARATOR;
    public static final Advice advice$edit;
    public static final Advice advice$create;

    protected DocumentSigner() {
        this.setBennu(Bennu.getInstance());
    }

    protected DocumentSigner(AdministrativeOffice administrativeOffice, String responsibleName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        this();
        this.setAdministrativeOffice(administrativeOffice);
        this.setResponsibleName(responsibleName);
        this.setResponsibleFunction(responsibleFunction);
        this.setResponsibleUnit(responsibleUnit);
        this.setResponsibleGender(responsibleGender);
        if (DocumentSigner.findDefaultDocumentSignature() == null) {
            this.setDefaultSignature(true);
        }
    }

    private void checkRules() {
    }

    public void edit(String string, LocalizedString localizedString, LocalizedString localizedString2, Gender gender) {
        Object object = advice$edit.perform((Callable)new DocumentSigner$callable$edit(this, string, localizedString, localizedString2, gender));
    }

    static /* synthetic */ void advised$edit(DocumentSigner this_, String responsibleName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        this_.setResponsibleName(responsibleName);
        this_.setResponsibleFunction(responsibleFunction);
        this_.setResponsibleUnit(responsibleUnit);
        this_.setResponsibleGender(responsibleGender);
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        this.setBennu(null);
        this.setAdministrativeOffice(null);
        this.deleteDomainObject();
    }

    public boolean isDefaultSignature() {
        return this.getDefaultSignature() != null ? this.getDefaultSignature() : false;
    }

    public void setDefaultSignature(Boolean defaultSignature) {
        DocumentSigner defaultDocumentSignature;
        if (defaultSignature.booleanValue() && (defaultDocumentSignature = DocumentSigner.findDefaultDocumentSignature()) != null) {
            defaultDocumentSignature.setDefaultSignature(false);
        }
        super.setDefaultSignature(defaultSignature);
    }

    public static Stream<DocumentSigner> findAll() {
        return Bennu.getInstance().getDocumentSignersSet().stream();
    }

    public static DocumentSigner findDefaultDocumentSignature() {
        return DocumentSigner.findAll().filter(DocumentSigner::isDefaultSignature).findFirst().orElse(null);
    }

    public static DocumentSigner create(AdministrativeOffice administrativeOffice, String string, LocalizedString localizedString, LocalizedString localizedString2, Gender gender) {
        return (DocumentSigner)((Object)advice$create.perform((Callable)new DocumentSigner$callable$create(administrativeOffice, string, localizedString, localizedString2, gender)));
    }

    static /* synthetic */ DocumentSigner advised$create(AdministrativeOffice administrativeOffice, String responsibleName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        return new DocumentSigner(administrativeOffice, responsibleName, responsibleFunction, responsibleUnit, responsibleGender);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        DEFAULT_COMPARATOR = new Comparator<DocumentSigner>(){

            @Override
            public int compare(DocumentSigner ds1, DocumentSigner ds2) {
                if (ds1.isDefaultSignature()) {
                    return -1;
                }
                if (ds2.isDefaultSignature()) {
                    return 1;
                }
                return ds1.getResponsibleName().compareTo(ds2.getResponsibleName());
            }
        };
    }
}

