/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementMobilityCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DegreeFinalizationCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExamDateCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalCourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalProgramCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExtraCurricularCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ProgramCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.SchoolRegistrationCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.StandaloneEnrolmentCertificateRequest;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public abstract class CertificateRequest
extends CertificateRequest_Base {
    protected CertificateRequest() {
        super.setNumberOfPages(Integer.valueOf(0));
    }

    protected final void init(DocumentRequestCreateBean bean) {
        super.init((RegistrationAcademicServiceRequestCreateBean)bean);
        super.checkParameters(bean);
        super.setDocumentPurposeTypeInstance(bean.getChosenDocumentPurposeType());
        super.setDocumentPurposeType(this.getDocumentPurposeTypeInstance() != null ? this.getDocumentPurposeTypeInstance().getDocumentPurposeType() : null);
        super.setOtherDocumentPurposeTypeDescription(bean.getOtherPurpose());
    }

    public static final CertificateRequest create(DocumentRequestCreateBean bean) {
        Object certificateRequest = null;
        DocumentRequestType requestType = bean.getChosenServiceRequestType().getDocumentRequestType();
        switch (requestType) {
            case SCHOOL_REGISTRATION_CERTIFICATE: {
                certificateRequest = new SchoolRegistrationCertificateRequest(bean);
                break;
            }
            case ENROLMENT_CERTIFICATE: {
                certificateRequest = new EnrolmentCertificateRequest(bean);
                break;
            }
            case APPROVEMENT_CERTIFICATE: {
                certificateRequest = new ApprovementCertificateRequest(bean);
                break;
            }
            case APPROVEMENT_MOBILITY_CERTIFICATE: {
                certificateRequest = new ApprovementMobilityCertificateRequest(bean);
                break;
            }
            case DEGREE_FINALIZATION_CERTIFICATE: {
                certificateRequest = new DegreeFinalizationCertificateRequest(bean);
                break;
            }
            case EXAM_DATE_CERTIFICATE: {
                certificateRequest = new ExamDateCertificateRequest(bean);
                break;
            }
            case COURSE_LOAD: {
                certificateRequest = new CourseLoadRequest(bean);
                break;
            }
            case EXTERNAL_COURSE_LOAD: {
                certificateRequest = new ExternalCourseLoadRequest(bean);
                break;
            }
            case PROGRAM_CERTIFICATE: {
                certificateRequest = new ProgramCertificateRequest(bean);
                break;
            }
            case EXTERNAL_PROGRAM_CERTIFICATE: {
                certificateRequest = new ExternalProgramCertificateRequest(bean);
                break;
            }
            case EXTRA_CURRICULAR_CERTIFICATE: {
                certificateRequest = new ExtraCurricularCertificateRequest(bean);
                break;
            }
            case STANDALONE_ENROLMENT_CERTIFICATE: {
                certificateRequest = new StandaloneEnrolmentCertificateRequest(bean);
            }
        }
        if (certificateRequest == null) {
            throw new DomainException("error.CertificateRequest.unexpected.document.type", new String[0]);
        }
        return certificateRequest;
    }

    public final void setDocumentPurposeType(DocumentPurposeType documentPurposeType) {
        throw new DomainException("error.serviceRequests.documentRequests.CertificateRequest.cannot.modify.documentPurposeType", new String[0]);
    }

    public final void setOtherDocumentPurposeTypeDescription(String otherDocumentTypeDescription) {
        throw new DomainException("error.serviceRequests.documentRequests.CertificateRequest.cannot.modify.otherDocumentTypeDescription", new String[0]);
    }

    public final void edit(DocumentRequestBean certificateRequestBean) {
        IAcademicServiceRequestAndAcademicTaxTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest((AcademicServiceRequest)((Object)this));
        if (this.isPayable() && event != null && this.getNumberOfPages() == certificateRequestBean.getNumberOfPages()) {
            throw new DomainException("error.serviceRequests.documentRequests.cannot.change.numberOfPages.on.payed.documents", new String[0]);
        }
        super.edit((AcademicServiceRequestBean)certificateRequestBean);
        super.setNumberOfPages(certificateRequestBean.getNumberOfPages());
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude()) {
            this.tryConcludeServiceRequest(academicServiceRequestBean);
        }
    }

    protected void tryConcludeServiceRequest(AcademicServiceRequestBean academicServiceRequestBean) {
        if (!this.hasNumberOfPages()) {
            throw new DomainException("error.serviceRequests.documentRequests.numberOfPages.must.be.set", new String[0]);
        }
    }

    protected void createCertificateRequestEvent() {
    }

    public boolean isFree() {
        if (this.getDocumentRequestType() == DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE && this.getRegistration().getRegistrationProtocol().isMobilityAgreement()) {
            return true;
        }
        if (this.getDocumentRequestType() == DocumentRequestType.SCHOOL_REGISTRATION_CERTIFICATE || this.getDocumentRequestType() == DocumentRequestType.ENROLMENT_CERTIFICATE) {
            return super.isFree() || !this.isRequestForPreviousExecutionYear() && this.isFirstRequestOfCurrentExecutionYear();
        }
        return super.isFree();
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    private boolean isRequestForPreviousExecutionYear() {
        return this.getExecutionYear() != ExecutionYear.readCurrentExecutionYear();
    }

    private boolean isFirstRequestOfCurrentExecutionYear() {
        return this.getRegistration().getSucessfullyFinishedDocumentRequestsBy(ExecutionYear.readCurrentExecutionYear(), this.getDocumentRequestType(), false).isEmpty();
    }

    public boolean isPagedDocument() {
        return true;
    }

    public boolean isToPrint() {
        return true;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

