/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestCategory;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$associateOption;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$create;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$createLegacy;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$delete;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType$callable$removeOption;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOption;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ServiceRequestType
extends ServiceRequestType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$associateOption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeOption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createLegacy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ServiceRequestType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected ServiceRequestType(String code, LocalizedString name, boolean active, boolean payable, ServiceRequestCategory category) {
        this();
        super.setCode(code);
        super.setName(name);
        this.setActive(active);
        this.setPayable(payable);
        this.setServiceRequestCategory(category);
        this.checkRules();
    }

    protected ServiceRequestType(String code, LocalizedString name, boolean active, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean payable, ServiceRequestCategory category) {
        this(code, name, active, payable, category);
        this.setAcademicServiceRequestType(academicServiceRequestType);
        this.setDocumentRequestType(documentRequestType);
        this.checkRules();
    }

    private void checkRules() {
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isPayable() {
        return this.getPayable();
    }

    public boolean isLegacy() {
        return this.getAcademicServiceRequestType() != null;
    }

    public boolean hasOption(ServiceRequestTypeOption option) {
        return this.getServiceRequestTypeOptionsSet().contains((Object)option);
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, ServiceRequestCategory serviceRequestCategory, LocalizedString localizedString2) {
        Object object = advice$edit.perform((Callable)new ServiceRequestType$callable$edit(this, string, localizedString, bl, bl2, serviceRequestCategory, localizedString2));
    }

    static /* synthetic */ void advised$edit(ServiceRequestType this_, String code, LocalizedString name, boolean active, boolean payable, ServiceRequestCategory category, LocalizedString numberOfUnitsLabel) {
        this_.setCode(code);
        this_.setName(name);
        this_.setActive(active);
        this_.setPayable(payable);
        this_.setServiceRequestCategory(category);
        if (this_.hasOption(ServiceRequestTypeOption.findNumberOfUnitsOption().get())) {
            this_.setNumberOfUnitsLabel(numberOfUnitsLabel);
        } else {
            this_.setNumberOfUnitsLabel(null);
        }
        this_.checkRules();
    }

    public boolean isOptionAssociated(ServiceRequestTypeOption option) {
        return this.getServiceRequestTypeOptionsSet().contains((Object)option);
    }

    public void associateOption(ServiceRequestTypeOption serviceRequestTypeOption) {
        Object object = advice$associateOption.perform((Callable)new ServiceRequestType$callable$associateOption(this, serviceRequestTypeOption));
    }

    static /* synthetic */ void advised$associateOption(ServiceRequestType this_, ServiceRequestTypeOption serviceRequestTypeOption) {
        this_.addServiceRequestTypeOptions(serviceRequestTypeOption);
        this_.checkRules();
    }

    public void removeOption(ServiceRequestTypeOption serviceRequestTypeOption) {
        Object object = advice$removeOption.perform((Callable)new ServiceRequestType$callable$removeOption(this, serviceRequestTypeOption));
    }

    static /* synthetic */ void advised$removeOption(ServiceRequestType this_, ServiceRequestTypeOption option) {
        this_.removeServiceRequestTypeOptions(option);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ServiceRequestType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ServiceRequestType this_) {
        if (!this_.isDeletable()) {
            throw new DomainException("error.ServiceRequestType.delete.not.possible", new String[0]);
        }
        this_.getServiceRequestTypeOptionsSet().clear();
        this_.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Stream<ServiceRequestType> findAll() {
        return Bennu.getInstance().getServiceRequestTypesSet().stream();
    }

    public static ServiceRequestType findUnique(AcademicServiceRequestType academicServiceRequestType) {
        return ServiceRequestType.findAll().filter(x -> x.getAcademicServiceRequestType() != null && x.getAcademicServiceRequestType().equals((Object)academicServiceRequestType)).filter(x -> x.getDocumentRequestType() == null).findFirst().orElse(null);
    }

    public static ServiceRequestType findUnique(AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType) {
        return ServiceRequestType.findAll().filter(s -> s.getAcademicServiceRequestType() == academicServiceRequestType && s.getDocumentRequestType() == documentRequestType).findFirst().orElse(null);
    }

    public static ServiceRequestType findUnique(AcademicServiceRequest academicServiceRequest) {
        if (academicServiceRequest.getServiceRequestType() != null) {
            return academicServiceRequest.getServiceRequestType();
        }
        if (academicServiceRequest.isDocumentRequest()) {
            return ServiceRequestType.findUnique(academicServiceRequest.getAcademicServiceRequestType(), ((DocumentRequest)((Object)academicServiceRequest)).getDocumentRequestType());
        }
        return ServiceRequestType.findUnique(academicServiceRequest.getAcademicServiceRequestType());
    }

    public static Stream<ServiceRequestType> findByCode(String code) {
        return ServiceRequestType.findAll().filter(l -> l.getCode().equalsIgnoreCase(code));
    }

    public static Optional<ServiceRequestType> findUniqueByCode(String code) {
        return ServiceRequestType.findByCode(code).findFirst();
    }

    public static Stream<ServiceRequestType> findActive() {
        return ServiceRequestType.findAll().filter(ServiceRequestType::isActive);
    }

    public static Stream<ServiceRequestType> findDeclarations() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.DECLARATIONS);
    }

    public static Stream<ServiceRequestType> findCertificates() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.CERTIFICATES);
    }

    public static Stream<ServiceRequestType> findServices() {
        return ServiceRequestType.findAll().filter(srt -> srt.getServiceRequestCategory() == ServiceRequestCategory.SERVICES);
    }

    public static ServiceRequestType create(String string, LocalizedString localizedString, boolean bl, boolean bl2, ServiceRequestCategory serviceRequestCategory) {
        return (ServiceRequestType)((Object)advice$create.perform((Callable)new ServiceRequestType$callable$create(string, localizedString, bl, bl2, serviceRequestCategory)));
    }

    static /* synthetic */ ServiceRequestType advised$create(String code, LocalizedString name, boolean active, boolean payable, ServiceRequestCategory category) {
        return new ServiceRequestType(code, name, active, payable, category);
    }

    public static ServiceRequestType createLegacy(String string, LocalizedString localizedString, boolean bl, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean bl2, ServiceRequestCategory serviceRequestCategory) {
        return (ServiceRequestType)((Object)advice$createLegacy.perform((Callable)new ServiceRequestType$callable$createLegacy(string, localizedString, bl, academicServiceRequestType, documentRequestType, bl2, serviceRequestCategory)));
    }

    static /* synthetic */ ServiceRequestType advised$createLegacy(String code, LocalizedString name, boolean active, AcademicServiceRequestType academicServiceRequestType, DocumentRequestType documentRequestType, boolean payable, ServiceRequestCategory category) {
        return new ServiceRequestType(code, name, active, academicServiceRequestType, documentRequestType, payable, category);
    }
}

