/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import java.util.Collections;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.log.PhdLog;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.util.phd.PhdProperties;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;

public abstract class PhdThesisActivity
extends Activity<PhdThesisProcess> {
    @Override
    public final void checkPreConditions(PhdThesisProcess process2, User userView) {
        this.processPreConditions(process2, userView);
        this.activityPreConditions(process2, userView);
    }

    protected void processPreConditions(PhdThesisProcess process2, User userView) {
    }

    protected abstract void activityPreConditions(PhdThesisProcess var1, User var2);

    public static String getAccessInformation(PhdIndividualProgramProcess process2, PhdParticipant participant, String coordinatorMessage, String teacherMessage) {
        if (!participant.isInternal()) {
            return AlertService.AlertMessage.get("message.phd.external.access", PhdProperties.getPhdExternalAccessLink(), participant.getAccessHashCode(), participant.getPassword());
        }
        Person person = ((InternalPhdParticipant)((Object)participant)).getPerson();
        if (process2.isCoordinatorForPhdProgram(person)) {
            return AlertService.AlertMessage.get(coordinatorMessage, new Object[0]);
        }
        if (process2.isGuiderOrAssistentGuider(person) || person.getTeacher() != null) {
            return AlertService.AlertMessage.get(teacherMessage, new Object[0]);
        }
        throw new DomainException("error.PhdThesisProcess.unexpected.participant.type", new String[0]);
    }

    protected void email(String email, String subject, String body) {
        SystemSender sender = Bennu.getInstance().getSystemSender();
        new Message((Sender)((Object)sender), sender.getConcreteReplyTos(), null, null, null, subject, body, Collections.singleton(email));
    }

    @Override
    protected void log(PhdThesisProcess process2, User userView, Object object) {
        PhdLog.logActivity(this, (PhdProgramProcess)((Object)process2), userView, object);
    }
}

