/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.access;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdProcessAccessType {
    CANDIDACY_FEEDBACK_DOCUMENTS_DOWNLOAD("CandidacyFeedbackDocumentsDownload", PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION),
    CANDIDACY_FEEDBACK_UPLOAD("CandidacyFeedbackUpload", PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION),
    JURY_DOCUMENTS_DOWNLOAD("JuryDocumentsDownload", PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK),
    JURY_REPORTER_FEEDBACK_UPLOAD("JuryReporterFeedbackUpload", PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK),
    JURY_REVIEW_DOCUMENTS_DOWNLOAD("JuryReviewDocumentsDownload", PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING);

    private String descriptor;
    private PhdProcessStateType[] acceptedTypes;

    private PhdProcessAccessType(String type, PhdProcessStateType ... acceptedTypes) {
        this.descriptor = type;
        this.acceptedTypes = acceptedTypes;
    }

    public String getName() {
        return this.name();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getQualifiedName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    }

    public boolean hasAcceptedTypes() {
        return this.acceptedTypes != null && this.acceptedTypes.length > 0;
    }

    public List<PhdProcessStateType> getAcceptedTypes() {
        return Arrays.asList(this.acceptedTypes);
    }
}

