/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.PhdProgram$callable$create;
import org.fenixedu.academic.domain.phd.PhdProgram$callable$create$1;
import org.fenixedu.academic.domain.phd.PhdProgram$callable$create$2;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriodBean;
import org.fenixedu.academic.domain.phd.PhdProgramInformation;
import org.fenixedu.academic.domain.phd.PhdProgramServiceAgreementTemplate;
import org.fenixedu.academic.domain.phd.PhdProgramUnit;
import org.fenixedu.academic.domain.phd.PhdProgram_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdProgram
extends PhdProgram_Base {
    public static Comparator<PhdProgram> COMPARATOR_BY_NAME;
    public static final Advice advice$create;
    public static final Advice advice$create$1;
    public static final Advice advice$create$2;

    private PhdProgram() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
        this.setCreator(Authenticate.getUser().getUsername());
        new PhdProgramServiceAgreementTemplate(this);
    }

    private PhdProgram(Degree degree, MultiLanguageString name, String acronym) {
        this();
        this.checkDegree(degree);
        this.checkAcronym(acronym);
        this.setDegree(degree);
        this.setName(name);
        this.setAcronym(acronym);
    }

    private PhdProgram(Degree degree, MultiLanguageString name, String acronym, Unit parentProgramUnit) {
        this(degree, name, acronym);
        PhdProgramUnit.create(this, this.getName(), this.getWhenCreated().toYearMonthDay(), null, parentProgramUnit);
    }

    private void checkDegree(Degree degree) {
        String[] args = new String[]{};
        if (degree == null) {
            throw new DomainException("error.PhdProgram.invalid.degree", args);
        }
        if (!degree.getDegreeType().isAdvancedSpecializationDiploma()) {
            throw new DomainException("error.PhdProgram.invalid.degree", new String[0]);
        }
    }

    private void checkAcronym(String acronym) {
        String[] args = new String[]{};
        if (acronym == null || acronym.isEmpty()) {
            throw new DomainException("error.PhdProgram.invalid.acronym", args);
        }
        PhdProgram program = PhdProgram.readByAcronym(acronym);
        if (program != null && program != this) {
            throw new DomainException("error.PhdProgram.acronym.already.exists", acronym);
        }
    }

    public DegreeType getDegreeType() {
        return null;
    }

    public Collection<CycleType> getCycleTypes() {
        return Collections.singletonList(CycleType.THIRD_CYCLE);
    }

    private boolean hasAcronym(String acronym) {
        return this.getAcronym() != null && this.getAcronym().equalsIgnoreCase(acronym);
    }

    public String getPresentationName() {
        return this.getPresentationName(I18N.getLocale());
    }

    private String getPresentationName(Locale locale) {
        return this.getPrefix(locale) + this.getNameFor(locale);
    }

    private String getNameFor(Locale locale) {
        return this.getName().hasContent(locale) ? this.getName().getContent(locale) : this.getName().getPreferedContent();
    }

    private String getPrefix(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)"label.php.program", (String[])new String[0]) + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.in", (String[])new String[0]) + " ";
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getIndividualProgramProcessesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.PhdProgram.cannot.delete.has.individual.php.program.processes", (String[])new String[0]));
        }
    }

    protected void disconnect() {
        this.getPhdProgramUnit().delete();
        this.setDegree(null);
        this.setServiceAgreementTemplate(null);
        this.setRootDomainObject(null);
        super.disconnect();
    }

    public Set<Person> getCoordinatorsFor(ExecutionYear executionYear) {
        if (this.getDegree() == null) {
            return Collections.emptySet();
        }
        ExecutionDegree executionDegree = this.getDegree().getLastActiveDegreeCurricularPlan().getExecutionDegreeByYear(executionYear);
        HashSet<Person> result = new HashSet<Person>();
        if (executionDegree != null) {
            for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                result.add(coordinator.getPerson());
            }
        }
        return result;
    }

    public Set<Person> getResponsibleCoordinatorsFor(ExecutionYear executionYear) {
        if (this.getDegree() == null) {
            return new HashSet<Person>();
        }
        ExecutionDegree executionDegree = this.getDegree().getLastActiveDegreeCurricularPlan().getExecutionDegreeByYear(executionYear);
        HashSet<Person> result = new HashSet<Person>();
        if (executionDegree != null) {
            for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                if (!coordinator.isResponsible()) continue;
                result.add(coordinator.getPerson());
            }
        }
        return result;
    }

    public boolean isCoordinatorFor(Person person, ExecutionYear executionYear) {
        return this.getCoordinatorsFor(executionYear).contains((Object)person);
    }

    public static PhdProgram create(Degree degree, MultiLanguageString multiLanguageString, String string) {
        return (PhdProgram)((Object)advice$create.perform((Callable)new PhdProgram$callable$create(degree, multiLanguageString, string)));
    }

    static /* synthetic */ PhdProgram advised$create(Degree degree, MultiLanguageString name, String acronym) {
        return new PhdProgram(degree, name, acronym);
    }

    public static PhdProgram create(Degree degree, MultiLanguageString multiLanguageString, String string, Unit unit) {
        return (PhdProgram)((Object)advice$create$1.perform((Callable)new PhdProgram$callable$create$1(degree, multiLanguageString, string, unit)));
    }

    static /* synthetic */ PhdProgram advised$create(Degree degree, MultiLanguageString name, String acronym, Unit parent) {
        return new PhdProgram(degree, name, acronym, parent);
    }

    public static PhdProgram readByAcronym(String acronym) {
        for (PhdProgram program : Bennu.getInstance().getPhdProgramsSet()) {
            if (!program.hasAcronym(acronym)) continue;
            return program;
        }
        return null;
    }

    public PhdProgramContextPeriod getMostRecentPeriod() {
        ArrayList periods = new ArrayList();
        periods.addAll(this.getPhdProgramContextPeriodsSet());
        Collections.sort(periods, Collections.reverseOrder(PhdProgramContextPeriod.COMPARATOR_BY_BEGIN_DATE));
        if (periods.isEmpty()) {
            return null;
        }
        return (PhdProgramContextPeriod)((Object)periods.iterator().next());
    }

    public boolean isActiveNow() {
        return this.isActive(new DateTime());
    }

    public boolean isActive(DateTime date) {
        for (PhdProgramContextPeriod period : this.getPhdProgramContextPeriodsSet()) {
            if (!period.contains(date)) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(ExecutionYear executionYear) {
        PhdProgramContextPeriod mostRecentPeriod = this.getMostRecentPeriod();
        if (mostRecentPeriod.getEndDate() == null) {
            DateTime beginDate = mostRecentPeriod.getBeginDate();
            return beginDate.isBefore((ReadableInstant)executionYear.getBeginDateYearMonthDay().toDateMidnight()) || executionYear.containsDate(beginDate);
        }
        return mostRecentPeriod.getInterval().overlaps((ReadableInterval)executionYear.getAcademicInterval());
    }

    public PhdProgramInformation getMostRecentPhdProgramInformation() {
        return this.getPhdProgramInformationByDate(new LocalDate());
    }

    public PhdProgramInformation getPhdProgramInformationByDate(LocalDate localDate) {
        PhdProgramInformation mostRecent = null;
        for (PhdProgramInformation phdProgramInformation : this.getPhdProgramInformationsSet()) {
            if (phdProgramInformation.getBeginDate().isAfter((ReadablePartial)localDate)) continue;
            if (mostRecent == null) {
                mostRecent = phdProgramInformation;
                continue;
            }
            if (!phdProgramInformation.getBeginDate().isAfter((ReadablePartial)mostRecent.getBeginDate())) continue;
            mostRecent = phdProgramInformation;
        }
        return mostRecent;
    }

    public PhdProgramContextPeriod create(PhdProgramContextPeriodBean phdProgramContextPeriodBean) {
        return (PhdProgramContextPeriod)((Object)advice$create$2.perform((Callable)new PhdProgram$callable$create$2(this, phdProgramContextPeriodBean)));
    }

    static /* synthetic */ PhdProgramContextPeriod advised$create(PhdProgram this_, PhdProgramContextPeriodBean bean) {
        return PhdProgramContextPeriod.create(bean);
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = new Comparator<PhdProgram>(){

            @Override
            public int compare(PhdProgram p1, PhdProgram p2) {
                int res = p1.getName().compareTo(p2.getName());
                return res != 0 ? res : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)p1, (DomainObject)p2);
            }
        };
    }
}

