/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdIndividualProgramCollaborationType {
    CMU,
    UT_AUSTIN,
    MIT,
    FCT,
    EPFL(false, false),
    NONE,
    WITH_SUPERVISION(true),
    ERASMUS_MUNDUS(false),
    OTHER(true);

    private boolean needExtraInformation;
    private boolean generateCandidacyDebt;

    private PhdIndividualProgramCollaborationType(boolean needExtraInformation, boolean generateCandidacyDebt) {
        this.needExtraInformation = needExtraInformation;
        this.generateCandidacyDebt = generateCandidacyDebt;
    }

    private PhdIndividualProgramCollaborationType() {
        this(false, true);
    }

    private PhdIndividualProgramCollaborationType(boolean needExtraInformation) {
        this(needExtraInformation, true);
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return PhdIndividualProgramCollaborationType.class.getSimpleName() + "." + this.name();
    }

    public boolean needExtraInformation() {
        return this.needExtraInformation;
    }

    public boolean generateCandidacyDebt() {
        return this.generateCandidacyDebt;
    }

    public static Collection<PhdIndividualProgramCollaborationType> valuesAsList() {
        return Collections.unmodifiableList(Arrays.asList(PhdIndividualProgramCollaborationType.values()));
    }
}

