/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.StudentGroup;
import org.fenixedu.academic.domain.accessControl.TeacherGroup;
import org.fenixedu.academic.domain.accessControl.UnitGroup;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class DepartmentUnit
extends DepartmentUnit_Base {
    private DepartmentUnit() {
        super.setType(PartyTypeEnum.DEPARTMENT);
    }

    public static DepartmentUnit createNewInternalDepartmentUnit(MultiLanguageString departmentName, String departmentNameCard, Integer costCenterCode, String departmentAcronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, Department department, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        DepartmentUnit departmentUnit = new DepartmentUnit();
        departmentUnit.init(departmentName, departmentNameCard, costCenterCode, departmentAcronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        departmentUnit.setDepartment(department);
        departmentUnit.addParentUnit(parentUnit, accountabilityType);
        DepartmentUnit.checkIfAlreadyExistsOneDepartmentUnitWithSameAcronymAndName(departmentUnit);
        return departmentUnit;
    }

    public static DepartmentUnit createNewOfficialExternalDepartmentUnit(String departmentName, String departmentAcronym, Unit parentUnit) {
        DepartmentUnit departmentUnit = new DepartmentUnit();
        departmentUnit.init(new MultiLanguageString(Locale.getDefault(), departmentName), null, null, departmentAcronym, new YearMonthDay(), null, null, null, null, null, null);
        if (parentUnit.isCountryUnit()) {
            departmentUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.GEOGRAPHIC));
        } else {
            departmentUnit.addParentUnit(parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE));
        }
        DepartmentUnit.checkIfAlreadyExistsOneDepartmentUnitWithSameAcronymAndName(departmentUnit);
        return departmentUnit;
    }

    public void edit(MultiLanguageString name, String acronym) {
        super.edit(name, acronym);
        DepartmentUnit.checkIfAlreadyExistsOneDepartmentUnitWithSameAcronymAndName(this);
    }

    public void edit(MultiLanguageString unitName, String departmentNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, departmentNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        if (this.isInternal()) {
            this.setDepartment(department);
        }
        DepartmentUnit.checkIfAlreadyExistsOneDepartmentUnitWithSameAcronymAndName(this);
    }

    public List<CompetenceCourse> getCompetenceCourses() {
        return this.getCompetenceCourses(null);
    }

    public List<CompetenceCourse> getCompetenceCourses(CurricularStage curricularStage) {
        ArrayList<CompetenceCourse> result = new ArrayList<CompetenceCourse>();
        for (ScientificAreaUnit scientificAreaUnit : this.getScientificAreaUnits()) {
            for (CompetenceCourseGroupUnit competenceCourseGroupUnit : scientificAreaUnit.getCompetenceCourseGroupUnits()) {
                for (CompetenceCourse competenceCourse : competenceCourseGroupUnit.getCompetenceCourses()) {
                    if (curricularStage != null && !competenceCourse.getCurricularStage().equals((Object)curricularStage)) continue;
                    result.add(competenceCourse);
                }
            }
        }
        return result;
    }

    public List<ScientificAreaUnit> getScientificAreaUnits() {
        TreeSet<ScientificAreaUnit> result = new TreeSet<ScientificAreaUnit>(ScientificAreaUnit.COMPARATOR_BY_NAME_AND_ID);
        for (Unit unit : this.getSubUnits()) {
            if (!unit.isScientificAreaUnit()) continue;
            result.add((ScientificAreaUnit)((Object)unit));
        }
        return new ArrayList<ScientificAreaUnit>(result);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (this.getDepartment() == null ? parentUnit != null && (!parentUnit.isOfficialExternal() || !parentUnit.isCountryUnit() && !parentUnit.isSchoolUnit() && !parentUnit.isUniversityUnit()) : parentUnit != null && !parentUnit.isInternal()) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public void setDepartment(Department department) {
        if (department == null) {
            throw new DomainException("error.departmentUnit.empty.department", new String[0]);
        }
        super.setDepartment(department);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public boolean isDepartmentUnit() {
        return true;
    }

    public boolean hasCompetenceCourses(CompetenceCourse competenceCourse) {
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.hasCompetenceCourses(competenceCourse)) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        while (!this.getParticipatingAnyCurricularCourseCurricularRulesSet().isEmpty()) {
            ((AnyCurricularCourse)((Object)this.getParticipatingAnyCurricularCourseCurricularRulesSet().iterator().next())).delete();
        }
        super.setDepartment(null);
        super.delete();
    }

    private static void checkIfAlreadyExistsOneDepartmentUnitWithSameAcronymAndName(DepartmentUnit departmentUnit) {
        if (departmentUnit.getDepartment() == null) {
            for (Unit parentUnit : departmentUnit.getParentUnits()) {
                for (Unit subUnit : parentUnit.getAllSubUnits()) {
                    if (subUnit.equals((Object)departmentUnit) || !subUnit.isDepartmentUnit() || !departmentUnit.getName().equalsIgnoreCase(subUnit.getName()) && !departmentUnit.getAcronym().equalsIgnoreCase(subUnit.getAcronym())) continue;
                    throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
                }
            }
        } else {
            for (Unit unit : UnitUtils.readInstitutionUnit().getAllSubUnits()) {
                if (unit.equals((Object)departmentUnit) || !unit.isDepartmentUnit() || !departmentUnit.getAcronym().equalsIgnoreCase(unit.getAcronym()) && !departmentUnit.getName().equalsIgnoreCase(unit.getName())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
            }
        }
    }

    public List<Group> getDefaultGroups() {
        List groups = super.getDefaultGroups();
        ExecutionYear currentYear = ExecutionYear.readCurrentExecutionYear();
        Department department = this.getDepartment();
        if (department != null) {
            groups.add(TeacherGroup.get(department, currentYear));
            groups.add(UnitGroup.recursiveWorkers((Unit)((Object)department.getDepartmentUnit())));
            TreeSet<Degree> degrees = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
            degrees.addAll(department.getDegreesSet());
            for (Degree degree : degrees) {
                groups.add(StudentGroup.get(degree, null));
            }
        }
        return groups;
    }

    public static List<DepartmentUnit> readAllDepartmentUnits() {
        List units = DepartmentUnit.readAllUnits();
        ArrayList<DepartmentUnit> departments = new ArrayList<DepartmentUnit>();
        for (Unit unit : units) {
            if (!(unit instanceof DepartmentUnit) || !unit.getType().equals((Object)PartyTypeEnum.DEPARTMENT)) continue;
            departments.add((DepartmentUnit)((Object)unit));
        }
        return departments;
    }

    public UnitBasedSender getOneUnitBasedSender() {
        if (!this.getUnitBasedSenderSet().isEmpty()) {
            return (UnitBasedSender)((Object)this.getUnitBasedSenderSet().iterator().next());
        }
        return UnitBasedSender.newInstance((Unit)((Object)this));
    }

    public boolean hasDepartment() {
        return this.getDepartment() != null;
    }

    public Set<ExecutionCourse> getAllExecutionCoursesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<ExecutionCourse> executionCourses = new HashSet<ExecutionCourse>();
        for (CompetenceCourse competenceCourse : this.getCompetenceCourses()) {
            competenceCourse.getExecutionCoursesByExecutionPeriod(executionSemester, executionCourses);
        }
        return executionCourses;
    }
}

