/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.messaging;

import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.ConversationThread;
import org.fenixedu.academic.domain.messaging.ForumSubscription;
import org.fenixedu.academic.domain.messaging.Forum_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.commons.StringNormalizer;
import org.joda.time.DateTime;

public abstract class Forum
extends Forum_Base {
    protected Forum() {
    }

    public Forum(MultiLanguageString name, MultiLanguageString description) {
        this.init(name, description);
    }

    public void init(MultiLanguageString name, MultiLanguageString description) {
        this.setCreationDate(new DateTime());
        this.setName(name);
        this.setDescription(description);
    }

    public boolean hasConversationThreadWithSubject(MultiLanguageString subject) {
        ConversationThread conversationThread = this.getConversationThreadBySubject(subject);
        return conversationThread != null;
    }

    public ConversationThread getConversationThreadBySubject(MultiLanguageString subject) {
        for (ConversationThread conversationThread : this.getConversationThreadSet()) {
            MultiLanguageString title = conversationThread.getTitle();
            if (title == null || !title.equalInAnyLanguage(subject)) continue;
            return conversationThread;
        }
        return null;
    }

    public int getConversationMessagesCount() {
        int total = 0;
        for (ConversationThread conversationThread : this.getConversationThreadSet()) {
            total += conversationThread.getMessageSet().size();
        }
        return total;
    }

    public void checkIfPersonCanWrite(Person person) {
        if (!this.getWritersGroup().isMember(person.getUser())) {
            throw new DomainException("forum.person.cannot.write", new String[0]);
        }
    }

    public void checkIfCanAddConversationThreadWithSubject(MultiLanguageString subject) {
        if (this.hasConversationThreadWithSubject(subject)) {
            throw new DomainException("forum.already.existing.conversation.thread", new String[0]);
        }
    }

    public void addEmailSubscriber(Person person) {
        if (!this.getReadersGroup().isMember(person.getUser())) {
            throw new DomainException("forum.cannot.subscribe.person.because.does.not.belong.to.readers", new String[0]);
        }
        ForumSubscription subscription = this.getPersonSubscription(person);
        if (subscription == null) {
            subscription = new ForumSubscription(person, this);
        }
        subscription.setReceivePostsByEmail(true);
    }

    public void removeEmailSubscriber(Person person) {
        ForumSubscription subscription = this.getPersonSubscription(person);
        if (subscription != null) {
            if (!subscription.getFavorite().booleanValue()) {
                this.removeForumSubscriptions(subscription);
                subscription.delete();
            } else {
                subscription.setReceivePostsByEmail(false);
            }
        }
    }

    public ForumSubscription getPersonSubscription(Person person) {
        for (ForumSubscription subscription : this.getForumSubscriptionsSet()) {
            if (subscription.getPerson() != person) continue;
            return subscription;
        }
        return null;
    }

    public boolean isPersonReceivingMessagesByEmail(Person person) {
        ForumSubscription subscription = this.getPersonSubscription(person);
        return subscription != null ? subscription.getReceivePostsByEmail() : false;
    }

    public ConversationThread createConversationThread(Person creator, MultiLanguageString subject) {
        this.checkIfPersonCanWrite(creator);
        this.checkIfCanAddConversationThreadWithSubject(subject);
        return new ConversationThread(this, creator, subject);
    }

    public abstract Group getReadersGroup();

    public abstract Group getWritersGroup();

    public abstract Group getAdminGroup();

    public MultiLanguageString getNormalizedName() {
        return Forum.normalize(this.getName());
    }

    public static MultiLanguageString normalize(MultiLanguageString multiLanguageString) {
        if (multiLanguageString == null) {
            return null;
        }
        MultiLanguageString result = new MultiLanguageString();
        for (Locale language : multiLanguageString.getAllLocales()) {
            result = result.with(language, Forum.normalize(multiLanguageString.getContent(language)));
        }
        return result;
    }

    public static String normalize(String string) {
        return string == null ? null : StringNormalizer.normalize((String)string).replace(' ', '-');
    }

    public void delete() {
        for (ForumSubscription forumSubscription : this.getForumSubscriptionsSet()) {
            forumSubscription.delete();
        }
        for (ConversationThread thread : this.getConversationThreadSet()) {
            thread.delete();
        }
        this.setCreator(null);
        this.deleteDomainObject();
    }
}

