/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.ExternalCurricularCourseToEnrol;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.NoCourseGroupEnrolmentBean;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public class EnrolmentContext {
    private StudentCurricularPlan studentCurricularPlan;
    private ExecutionSemester executionSemester;
    private final Set<IDegreeModuleToEvaluate> degreeModulesToEvaluate;
    private final List<CurriculumModule> curriculumModulesToRemove;
    private CurricularRuleLevel curricularRuleLevel;
    private final User userView = Authenticate.getUser();

    public EnrolmentContext(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Set<IDegreeModuleToEvaluate> degreeModulesToEnrol, List<CurriculumModule> curriculumModulesToRemove, CurricularRuleLevel curricularRuleLevel) {
        this.studentCurricularPlan = studentCurricularPlan;
        this.degreeModulesToEvaluate = new HashSet<IDegreeModuleToEvaluate>();
        for (IDegreeModuleToEvaluate moduleToEnrol : degreeModulesToEnrol) {
            if (curriculumModulesToRemove.contains((Object)moduleToEnrol.getCurriculumGroup())) {
                throw new DomainException("error.StudentCurricularPlan.cannot.remove.enrollment.on.curriculum.group.because.other.enrollments.depend.on.it", moduleToEnrol.getCurriculumGroup().getName().getContent());
            }
            this.addDegreeModuleToEvaluate(moduleToEnrol);
        }
        this.executionSemester = executionSemester;
        this.curriculumModulesToRemove = curriculumModulesToRemove;
        this.curricularRuleLevel = curricularRuleLevel;
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate() {
        return this.degreeModulesToEvaluate;
    }

    public Set<IDegreeModuleToEvaluate> getAllChildDegreeModulesToEvaluateFor(DegreeModule degreeModule) {
        HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.degreeModulesToEvaluate) {
            if (!degreeModule.hasDegreeModule(degreeModuleToEvaluate.getDegreeModule())) continue;
            result.add(degreeModuleToEvaluate);
        }
        return result;
    }

    public void addDegreeModuleToEvaluate(IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        this.getDegreeModulesToEvaluate().add(degreeModuleToEvaluate);
    }

    public boolean hasDegreeModulesToEvaluate() {
        return this.degreeModulesToEvaluate != null && !this.degreeModulesToEvaluate.isEmpty();
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public Registration getRegistration() {
        return this.studentCurricularPlan.getRegistration();
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public List<CurriculumModule> getToRemove() {
        return this.curriculumModulesToRemove;
    }

    public CurricularRuleLevel getCurricularRuleLevel() {
        return this.curricularRuleLevel;
    }

    public void setCurricularRuleLevel(CurricularRuleLevel curricularRuleLevel) {
        this.curricularRuleLevel = curricularRuleLevel;
    }

    public Person getResponsiblePerson() {
        return this.userView.getPerson();
    }

    public boolean hasResponsiblePerson() {
        return this.getResponsiblePerson() != null;
    }

    public boolean isResponsiblePersonStudent() {
        return RoleType.STUDENT.isMember(this.userView.getPerson().getUser());
    }

    public boolean isRegistrationFromResponsiblePerson() {
        return this.getResponsiblePerson() == this.getRegistration().getPerson();
    }

    public boolean isNormal() {
        return this.getCurricularRuleLevel().isNormal();
    }

    public boolean isImprovement() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.IMPROVEMENT_ENROLMENT;
    }

    public boolean isSpecialSeason() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.SPECIAL_SEASON_ENROLMENT;
    }

    public boolean isExtra() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.EXTRA_ENROLMENT;
    }

    public boolean isPropaeudeutics() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.PROPAEUDEUTICS_ENROLMENT;
    }

    public boolean isStandalone() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.STANDALONE_ENROLMENT || this.getCurricularRuleLevel() == CurricularRuleLevel.STANDALONE_ENROLMENT_NO_RULES;
    }

    public boolean isEnrolmentWithoutRules() {
        return this.getCurricularRuleLevel() == CurricularRuleLevel.ENROLMENT_NO_RULES;
    }

    public boolean isPhdDegree() {
        return this.studentCurricularPlan.getDegreeType().isAdvancedSpecializationDiploma();
    }

    public static EnrolmentContext createForVerifyWithRules(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        return EnrolmentContext.createForVerifyWithRules(studentCurricularPlan, executionSemester, Collections.EMPTY_SET);
    }

    public static EnrolmentContext createForVerifyWithRules(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Set<IDegreeModuleToEvaluate> degreeModulesToEvaluate) {
        return new EnrolmentContext(studentCurricularPlan, executionSemester, degreeModulesToEvaluate, Collections.EMPTY_LIST, CurricularRuleLevel.ENROLMENT_WITH_RULES);
    }

    public static EnrolmentContext createForNoCourseGroupCurriculumGroupEnrolment(StudentCurricularPlan studentCurricularPlan, NoCourseGroupEnrolmentBean bean) {
        ExternalCurricularCourseToEnrol moduleToEvaluate = new ExternalCurricularCourseToEnrol((CurriculumGroup)((Object)EnrolmentContext.readOrCreateNoCourseGroupCurriculumGroup(studentCurricularPlan, bean.getGroupType())), bean.getSelectedCurricularCourse(), bean.getExecutionPeriod());
        return new EnrolmentContext(studentCurricularPlan, bean.getExecutionPeriod(), Collections.singleton(moduleToEvaluate), Collections.EMPTY_LIST, bean.getCurricularRuleLevel());
    }

    private static NoCourseGroupCurriculumGroup readOrCreateNoCourseGroupCurriculumGroup(StudentCurricularPlan studentCurricularPlan, NoCourseGroupCurriculumGroupType groupType) {
        NoCourseGroupCurriculumGroup group = studentCurricularPlan.getNoCourseGroupCurriculumGroup(groupType);
        if (group == null) {
            group = studentCurricularPlan.createNoCourseGroupCurriculumGroup(groupType);
        }
        return group;
    }
}

