/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.MinimumNumberOfCreditsToEnrol;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;

public class MinimumNumberOfCreditsToEnrolExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        MinimumNumberOfCreditsToEnrol rule = (MinimumNumberOfCreditsToEnrol)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        Double totalEctsCredits = this.getTotalEctsCredits(enrolmentContext.getStudentCurricularPlan().getRoot(), enrolmentContext.getExecutionPeriod().getExecutionYear());
        if (rule.allowCredits(totalEctsCredits)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
            return this.createImpossibleRuleResult(rule, totalEctsCredits, sourceDegreeModuleToEvaluate);
        }
        return this.createFalseRuleResult(rule, totalEctsCredits, sourceDegreeModuleToEvaluate);
    }

    private Double getTotalEctsCredits(RootCurriculumGroup root, ExecutionYear executionYear) {
        Double res = 0.0;
        for (CycleType cycleType : root.getDegreeType().getOrderedCycleTypes()) {
            CycleCurriculumGroup cycleCurriculumGroup = root.getCycleCurriculumGroup(cycleType);
            if (cycleCurriculumGroup == null) {
                res = res + root.getCycleCourseGroup(cycleType).getDefaultEcts(executionYear);
                continue;
            }
            res = res + root.getCreditsConcluded(executionYear);
            break;
        }
        return res;
    }

    private RuleResult createFalseRuleResult(MinimumNumberOfCreditsToEnrol rule, Double ectsCredits, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.MinimumNumberOfCreditsToEnrolExecutor.student.has.not.minimum.number.of.credits", ectsCredits.toString(), rule.getMinimumCredits().toString(), rule.getDegreeModuleToApplyRule().getName());
    }

    private RuleResult createImpossibleRuleResult(MinimumNumberOfCreditsToEnrol rule, Double ectsCredits, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.MinimumNumberOfCreditsToEnrolExecutor.student.has.not.minimum.number.of.credits", ectsCredits.toString(), rule.getMinimumCredits().toString(), rule.getDegreeModuleToApplyRule().getName());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        MinimumNumberOfCreditsToEnrol rule = (MinimumNumberOfCreditsToEnrol)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        RootCurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().getRoot();
        Double totalEctsCredits = ((CurriculumGroup)((Object)curriculumGroup)).getAprovedEctsCredits();
        if (rule.allowCredits(totalEctsCredits)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        ExecutionSemester previousExecutionPeriod = enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod();
        if (rule.allowCredits(totalEctsCredits = Double.valueOf(totalEctsCredits + ((CurriculumGroup)((Object)curriculumGroup)).getEnroledEctsCredits(previousExecutionPeriod)))) {
            return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
            return this.createImpossibleRuleResult(rule, totalEctsCredits, sourceDegreeModuleToEvaluate);
        }
        return this.createFalseRuleResult(rule, totalEctsCredits, sourceDegreeModuleToEvaluate);
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

