/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CompositeRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.dto.GenericPair;

public interface ICurricularRule {
    public static final Comparator<ICurricularRule> COMPARATOR_BY_BEGIN = new Comparator<ICurricularRule>(){

        @Override
        public int compare(ICurricularRule o1, ICurricularRule o2) {
            return o1.getBegin().compareTo(o2.getBegin());
        }
    };

    public List<GenericPair<Object, Boolean>> getLabel();

    public DegreeModule getDegreeModuleToApplyRule();

    public CourseGroup getContextCourseGroup();

    public CompositeRule getParentCompositeRule();

    public CurricularRuleType getCurricularRuleType();

    public ExecutionSemester getBegin();

    public ExecutionSemester getEnd();

    public boolean appliesToContext(Context var1);

    public boolean appliesToCourseGroup(CourseGroup var1);

    public boolean hasContextCourseGroup();

    public boolean hasCurricularRuleType(CurricularRuleType var1);

    public boolean isCompositeRule();

    public boolean isValid(ExecutionSemester var1);

    public boolean isValid(ExecutionYear var1);

    public boolean isVisible();

    public boolean isActive();

    public RuleResult evaluate(IDegreeModuleToEvaluate var1, EnrolmentContext var2);

    public RuleResult verify(VerifyRuleLevel var1, EnrolmentContext var2, DegreeModule var3, CourseGroup var4);

    public VerifyRuleExecutor createVerifyRuleExecutor();
}

