/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.EnrolmentToBeApprovedByCoordinator;
import org.fenixedu.academic.domain.curricularRules.EvenOddRule;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.MinimumNumberOfCreditsToEnrol;
import org.fenixedu.academic.domain.curricularRules.RestrictionBetweenDegreeModules;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule;
import org.fenixedu.academic.domain.curricularRules.RestrictionEnroledDegreeModule;
import org.fenixedu.academic.domain.curricularRules.RestrictionNotEnroledDegreeModule;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.bolonhaManager.CurricularRuleParametersDTO;
import pt.ist.fenixframework.FenixFramework;

public class CurricularRulesManager {
    public static CurricularRule createCurricularRule(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleType curricularRuleType, CurricularRuleParametersDTO parametersDTO) {
        switch (curricularRuleType) {
            case PRECEDENCY_APPROVED_DEGREE_MODULE: {
                return CurricularRulesManager.createRestrictionDoneDegreeModule(toApplyRule, begin, end, parametersDTO);
            }
            case PRECEDENCY_ENROLED_DEGREE_MODULE: {
                return CurricularRulesManager.createRestrictionEnroledDegreeModule(toApplyRule, begin, end, parametersDTO);
            }
            case RESTRICTION_NOT_ENROLED_DEGREE_MODULE: {
                return CurricularRulesManager.createRestrictionNotEnroledDegreeModule(toApplyRule, begin, end, parametersDTO);
            }
            case CREDITS_LIMIT: {
                return CurricularRulesManager.createCreditsLimit(toApplyRule, begin, end, parametersDTO);
            }
            case DEGREE_MODULES_SELECTION_LIMIT: {
                return CurricularRulesManager.createDegreeModulesSelectionLimit(toApplyRule, begin, end, parametersDTO);
            }
            case ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR: {
                return CurricularRulesManager.createEnrolmentToBeApprovedByCoordinator(toApplyRule, begin, end, parametersDTO);
            }
            case PRECEDENCY_BETWEEN_DEGREE_MODULES: {
                return CurricularRulesManager.createRestrictionBetweenDegreeModules(toApplyRule, begin, end, parametersDTO);
            }
            case EXCLUSIVENESS: {
                return CurricularRulesManager.createExclusiveness(toApplyRule, begin, end, parametersDTO);
            }
            case ANY_CURRICULAR_COURSE: {
                return CurricularRulesManager.createAnyCurricularCourse(toApplyRule, begin, end, parametersDTO);
            }
            case MINIMUM_NUMBER_OF_CREDITS_TO_ENROL: {
                return CurricularRulesManager.createMinimumNumberOfCreditsToEnrol(toApplyRule, begin, end, parametersDTO);
            }
            case EVEN_ODD: {
                return CurricularRulesManager.createEvenOdd(toApplyRule, begin, end, parametersDTO);
            }
        }
        return null;
    }

    public static CurricularRule createCompositeRule(LogicOperator logicOperator, CurricularRule ... curricularRules) {
        return CurricularRule.createCurricularRule(logicOperator, curricularRules);
    }

    public static void editCurricularRule(CurricularRule curricularRule, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        curricularRule.edit(beginExecutionPeriod, endExecutionPeriod);
    }

    private static CurricularRule createMinimumNumberOfCreditsToEnrol(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new MinimumNumberOfCreditsToEnrol(toApplyRule, contextCourseGroup, begin, end, parametersDTO.getMinimumCredits());
    }

    private static CurricularRule createEvenOdd(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new EvenOddRule(toApplyRule, contextCourseGroup, parametersDTO.getCurricularPeriodInfoDTO().getOrder(), parametersDTO.getCurricularPeriodInfoDTO().getPeriodType(), parametersDTO.getEven(), begin, end);
    }

    private static CurricularRule createAnyCurricularCourse(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        Degree degree = (Degree)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeID());
        DepartmentUnit departmentUnit = (DepartmentUnit)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDepartmentUnitID());
        return new AnyCurricularCourse((OptionalCurricularCourse)((Object)toApplyRule), contextCourseGroup, begin, end, parametersDTO.getMinimumCredits(), parametersDTO.getMaximumCredits(), parametersDTO.getCurricularPeriodInfoDTO().getOrder(), parametersDTO.getMinimumYear(), parametersDTO.getMaximumYear(), parametersDTO.getDegreeType(), degree, departmentUnit);
    }

    private static CurricularRule createExclusiveness(DegreeModule firstExclusiveDegreeModule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        DegreeModule secondExclusiveDegreeModule = (DegreeModule)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeModuleID());
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        Exclusiveness firstRule = new Exclusiveness(firstExclusiveDegreeModule, secondExclusiveDegreeModule, contextCourseGroup, begin, end);
        new Exclusiveness(secondExclusiveDegreeModule, firstExclusiveDegreeModule, contextCourseGroup, begin, end);
        return firstRule;
    }

    private static CurricularRule createRestrictionBetweenDegreeModules(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        DegreeModule precedenceDegreeModule = (DegreeModule)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeModuleID());
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new RestrictionBetweenDegreeModules(toApplyRule, precedenceDegreeModule, parametersDTO.getMinimumCredits(), contextCourseGroup, begin, end);
    }

    private static CurricularRule createEnrolmentToBeApprovedByCoordinator(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new EnrolmentToBeApprovedByCoordinator((CurricularCourse)((Object)toApplyRule), contextCourseGroup, begin, end);
    }

    private static CurricularRule createCreditsLimit(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new CreditsLimit(toApplyRule, contextCourseGroup, begin, end, parametersDTO.getMinimumCredits(), parametersDTO.getMaximumCredits());
    }

    private static CurricularRule createDegreeModulesSelectionLimit(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new DegreeModulesSelectionLimit((CourseGroup)((Object)toApplyRule), contextCourseGroup, begin, end, parametersDTO.getMinimumLimit(), parametersDTO.getMaximumLimit());
    }

    private static CurricularRule createRestrictionEnroledDegreeModule(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        DegreeModule enroledDegreeModule = (DegreeModule)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeModuleID());
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new RestrictionEnroledDegreeModule((CurricularCourse)((Object)toApplyRule), (CurricularCourse)((Object)enroledDegreeModule), contextCourseGroup, parametersDTO.getCurricularPeriodInfoDTO(), begin, end);
    }

    private static CurricularRule createRestrictionNotEnroledDegreeModule(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        DegreeModule notEnroledDegreeModule = (DegreeModule)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeModuleID());
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new RestrictionNotEnroledDegreeModule((CurricularCourse)((Object)toApplyRule), (CurricularCourse)((Object)notEnroledDegreeModule), contextCourseGroup, parametersDTO.getCurricularPeriodInfoDTO(), begin, end);
    }

    private static CurricularRule createRestrictionDoneDegreeModule(DegreeModule toApplyRule, ExecutionSemester begin, ExecutionSemester end, CurricularRuleParametersDTO parametersDTO) {
        DegreeModule done = (DegreeModule)FenixFramework.getDomainObject((String)parametersDTO.getSelectedDegreeModuleID());
        CourseGroup contextCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)parametersDTO.getContextCourseGroupID());
        return new RestrictionDoneDegreeModule((CurricularCourse)((Object)toApplyRule), (CurricularCourse)((Object)done), contextCourseGroup, parametersDTO.getCurricularPeriodInfoDTO(), begin, end);
    }
}

