/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhoneValidation;
import org.fenixedu.academic.domain.contacts.Phone_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.joda.time.DateTime;

public class Phone
extends Phone_Base {
    public static Comparator<Phone> COMPARATOR_BY_NUMBER = new Comparator<Phone>(){

        @Override
        public int compare(Phone contact, Phone otherContact) {
            String number = contact.getNumber();
            String otherNumber = otherContact.getNumber();
            int result = 0;
            if (number != null && otherNumber != null) {
                result = number.compareTo(otherNumber);
            } else if (number != null) {
                result = 1;
            } else if (otherNumber != null) {
                result = -1;
            }
            return result == 0 ? PartyContact.COMPARATOR_BY_TYPE.compare((PartyContact)((Object)contact), (PartyContact)((Object)otherContact)) : result;
        }
    };

    public static Phone createPhone(Party party, String number, PartyContactType type, Boolean isDefault, Boolean visibleToPublic, Boolean visibleToStudents, Boolean visibleToStaff) {
        Phone result = null;
        if (!StringUtils.isEmpty((String)number)) {
            result = new Phone(party, type, visibleToPublic, visibleToStudents, visibleToStaff, isDefault, number);
        }
        return result;
    }

    public static Phone createPhone(Party party, String number, PartyContactType type, boolean isDefault) {
        return !StringUtils.isEmpty((String)number) ? new Phone(party, type, isDefault, number) : null;
    }

    protected Phone() {
        new PhoneValidation((PartyContact)((Object)this));
    }

    protected Phone(Party party, PartyContactType type, boolean defaultContact, String number) {
        this();
        super.init(party, type, defaultContact);
        this.checkParameters(number);
        super.setNumber(number);
    }

    protected Phone(Party party, PartyContactType type, boolean visibleToPublic, boolean visibleToStudents, boolean visibleToStaff, boolean defaultContact, String number) {
        this();
        super.init(party, type, visibleToPublic, visibleToStudents, visibleToStaff, defaultContact);
        this.checkParameters(number);
        super.setNumber(number);
    }

    private void checkParameters(String number) {
        if (StringUtils.isEmpty((String)number)) {
            throw new DomainException("error.contacts.Phone.invalid.number", new String[0]);
        }
    }

    public boolean isPhone() {
        return true;
    }

    public void edit(String number) {
        if (!StringUtils.equals((String)this.getNumber(), (String)number)) {
            super.setNumber(number);
            if (!this.waitsValidation()) {
                new PhoneValidation((PartyContact)((Object)this));
            }
            this.setLastModifiedDate(new DateTime());
        }
    }

    protected void checkRulesToDelete() {
        if (this.getParty().getPartyContacts(((Object)((Object)this)).getClass()).size() == 1) {
            throw new DomainException("error.domain.contacts.Phone.cannot.remove.last.phone", new String[0]);
        }
    }

    public String getPresentationValue() {
        return this.getNumber();
    }

    public boolean hasNumber() {
        return this.getNumber() != null && !this.getNumber().isEmpty();
    }

    public boolean hasValue(String value) {
        return this.hasNumber() && this.getNumber().equals(value);
    }

    public void logCreate(Person person) {
        this.logCreateAux(person, "label.partyContacts.Phone");
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        this.logEditAux(person, propertiesChanged, valueChanged, createdNewContact, newValue, "label.partyContacts.Phone");
    }

    public void logDelete(Person person) {
        this.logDeleteAux(person, "label.partyContacts.Phone");
    }

    public void logValid(Person person) {
        this.logValidAux(person, "label.partyContacts.Phone");
    }

    public void logRefuse(Person person) {
        this.logRefuseAux(person, "label.partyContacts.Phone");
    }
}

