/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.contacts.ContactRoot;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactValidation$callable$processValidation;
import org.fenixedu.academic.domain.contacts.PartyContactValidation$callable$setState;
import org.fenixedu.academic.domain.contacts.PartyContactValidationState;
import org.fenixedu.academic.domain.contacts.PartyContactValidation_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PartyContactValidation
extends PartyContactValidation_Base {
    private static final int MAX_TRIES = 3;
    public static final PartyContactValidationPredicate PREDICATE_INVALID;
    public static final PartyContactValidationPredicate PREDICATE_VALID;
    public static final PartyContactValidationPredicate PREDICATE_REFUSED;
    public static final Advice advice$processValidation;
    public static final Advice advice$setState;

    public PartyContactValidation() {
        this.reset();
    }

    public void reset() {
        this.setInvalid();
        this.setRequestDate(new DateTime());
        this.setTries(3);
        this.setToken(null);
    }

    public void init(PartyContact contact) {
        this.setPartyContact(contact);
        if (contact.isDefault()) {
            this.setToBeDefault(Boolean.TRUE);
        }
    }

    public PartyContactValidation(PartyContact contact) {
        this();
        this.init(contact);
    }

    private boolean validate(boolean result) {
        if (this.isInvalid()) {
            if (result) {
                this.setValid();
            } else {
                this.setInvalid();
            }
        }
        return this.isValid();
    }

    public Boolean processValidation(String string) {
        return (Boolean)advice$processValidation.perform((Callable)new PartyContactValidation$callable$processValidation(this, string));
    }

    static /* synthetic */ Boolean advised$processValidation(PartyContactValidation this_, String token) {
        if (this_.isRefused()) {
            return false;
        }
        if (!StringUtils.isEmpty((String)this_.getToken()) && !StringUtils.isEmpty((String)token)) {
            this_.validate(this_.getToken().equals(token));
            if (this_.isInvalid()) {
                this_.setTries(this_.getTries() - 1);
                if (this_.getTries() <= 0) {
                    this_.setRefused();
                }
            }
        }
        return this_.isValid();
    }

    protected void setValid() {
        Boolean toBeDefault;
        if (!this.isInvalid()) {
            return;
        }
        if (this.getContactRoot() != null) {
            this.setContactRoot(null);
        }
        super.setState(PartyContactValidationState.VALID);
        this.setLastChangeDate(new DateTime());
        PartyContact partyContact = this.getPartyContact();
        partyContact.getParty().logValidContact(partyContact);
        if (partyContact.getPrevPartyContact() != null) {
            partyContact.getPrevPartyContact().deleteWithoutCheckRules();
        }
        if ((toBeDefault = this.getToBeDefault()) != null) {
            partyContact.setDefaultContactInformation(toBeDefault);
        }
    }

    private void setNotValidState(PartyContactValidationState state) {
        if (this.getContactRoot() == null) {
            this.setContactRoot(ContactRoot.getInstance());
        }
        super.setState(state);
        this.setLastChangeDate(new DateTime());
    }

    public Integer getAvailableTries() {
        return this.getTries() > 0 ? this.getTries() : 0;
    }

    protected void setInvalid() {
        this.setNotValidState(PartyContactValidationState.INVALID);
    }

    protected void setRefused() {
        if (!this.isRefused()) {
            this.getPartyContact().getParty().logRefuseContact(this.getPartyContact());
            this.setNotValidState(PartyContactValidationState.REFUSED);
            this.getPartyContact().deleteWithoutCheckRules();
        }
    }

    private boolean isState(PartyContactValidationState state) {
        return state.equals((Object)this.getState());
    }

    public boolean isValid() {
        return this.isState(PartyContactValidationState.VALID);
    }

    public boolean isInvalid() {
        return this.isState(PartyContactValidationState.INVALID);
    }

    public boolean isRefused() {
        return this.isState(PartyContactValidationState.REFUSED);
    }

    public void setState(PartyContactValidationState partyContactValidationState) {
        Object object = advice$setState.perform((Callable)new PartyContactValidation$callable$setState(this, partyContactValidationState));
    }

    static /* synthetic */ void advised$setState(PartyContactValidation this_, PartyContactValidationState state) {
        switch (state) {
            case INVALID: {
                this_.setInvalid();
                break;
            }
            case REFUSED: {
                this_.setRefused();
                break;
            }
            case VALID: {
                this_.setValid();
            }
        }
    }

    public void triggerValidationProcess() {
    }

    public void triggerValidationProcessIfNeeded() {
        if (this.getToken() == null) {
            this.triggerValidationProcess();
        }
    }

    static {
        advice$processValidation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        PREDICATE_INVALID = new PartyContactValidationPredicate(PartyContactValidationState.INVALID);
        PREDICATE_VALID = new PartyContactValidationPredicate(PartyContactValidationState.VALID);
        PREDICATE_REFUSED = new PartyContactValidationPredicate(PartyContactValidationState.REFUSED);
    }

    public static class PartyContactValidationPredicate
    implements Predicate<PartyContactValidation> {
        private final PartyContactValidationState state;

        public PartyContactValidationPredicate(PartyContactValidationState state) {
            this.state = state;
        }

        @Override
        public boolean test(PartyContactValidation t) {
            return t.getState().equals((Object)this.state);
        }
    }
}

