/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public abstract class IndividualCandidacyProcessWithPrecedentDegreeInformationBean
extends IndividualCandidacyProcessBean {
    private PrecedentDegreeType precedentDegreeType;
    private PrecedentDegreeInformationBean precedentDegreeInformation;
    private StudentCurricularPlan precedentStudentCurricularPlan;

    public PrecedentDegreeType getPrecedentDegreeType() {
        return this.precedentDegreeType;
    }

    public void setPrecedentDegreeType(PrecedentDegreeType precedentDegreeType) {
        this.precedentDegreeType = precedentDegreeType;
    }

    public boolean hasPrecedentDegreeType() {
        return this.precedentDegreeType != null;
    }

    public boolean isExternalPrecedentDegreeType() {
        return this.precedentDegreeType == PrecedentDegreeType.EXTERNAL_DEGREE;
    }

    public PrecedentDegreeInformationBean getPrecedentDegreeInformation() {
        return this.precedentDegreeInformation;
    }

    public void setPrecedentDegreeInformation(PrecedentDegreeInformationBean precedentDegreeInformation) {
        this.precedentDegreeInformation = precedentDegreeInformation;
    }

    public List<StudentCurricularPlan> getPrecedentStudentCurricularPlans() {
        Student student = this.getStudent();
        if (student == null) {
            return Collections.emptyList();
        }
        ArrayList<StudentCurricularPlan> studentCurricularPlans = new ArrayList<StudentCurricularPlan>();
        block0: for (Registration registration : student.getRegistrationsSet()) {
            if (registration.isBolonha()) {
                StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
                for (CycleType cycleType : this.getValidPrecedentCycleTypes()) {
                    CycleCurriculumGroup cycle;
                    if (!studentCurricularPlan.hasCycleCurriculumGroup(cycleType) || !(cycle = studentCurricularPlan.getCycle(cycleType)).isConclusionProcessed() && !cycle.isConcluded() && !(cycle.getCreditsConcluded() >= this.getMinimumEcts(cycleType))) continue;
                    studentCurricularPlans.add(registration.getLastStudentCurricularPlan());
                    continue block0;
                }
                continue;
            }
            if (!this.isPreBolonhaPrecedentDegreeAllowed() || !registration.isRegistrationConclusionProcessed()) continue;
            studentCurricularPlans.add(registration.getLastStudentCurricularPlan());
        }
        return studentCurricularPlans;
    }

    public StudentCurricularPlan getLastPrecedentStudentCurricularPlan() {
        List<StudentCurricularPlan> studentCurricularPlanList = this.getPrecedentStudentCurricularPlans();
        return studentCurricularPlanList.isEmpty() ? null : Collections.max(studentCurricularPlanList, StudentCurricularPlan.DATE_COMPARATOR);
    }

    protected double getMinimumEcts(CycleType cycleType) {
        return 180.0;
    }

    protected abstract List<CycleType> getValidPrecedentCycleTypes();

    protected abstract boolean isPreBolonhaPrecedentDegreeAllowed();

    protected Student getStudent() {
        return this.getPersonBean().hasStudent() ? this.getPersonBean().getPerson().getStudent() : null;
    }

    public boolean isValidPrecedentDegreeInformation() {
        return this.hasPrecedentDegreeType() && (this.isExternalPrecedentDegreeType() || this.hasPrecedentStudentCurricularPlan());
    }

    public StudentCurricularPlan getPrecedentStudentCurricularPlan() {
        return this.precedentStudentCurricularPlan;
    }

    public boolean hasPrecedentStudentCurricularPlan() {
        return this.getPrecedentStudentCurricularPlan() != null;
    }

    public void setPrecedentStudentCurricularPlan(StudentCurricularPlan precedentStudentCurricularPlan) {
        this.precedentStudentCurricularPlan = precedentStudentCurricularPlan;
    }

    public static enum PrecedentDegreeType {
        INSTITUTION_DEGREE,
        EXTERNAL_DEGREE;


        public String getName() {
            return this.name();
        }

        public static PrecedentDegreeType valueOf(PrecedentDegreeInformation precedentDegreeInformation) {
            return precedentDegreeInformation.isCandidacyExternal() ? EXTERNAL_DEGREE : INSTITUTION_DEGREE;
        }

        public String getLocalizedName() {
            return this.getLocalizedName(I18N.getLocale());
        }

        public String getLocalizedName(Locale locale) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)(((Object)((Object)this)).getClass().getSimpleName() + "." + this.name()), (String[])new String[0]);
        }
    }
}

