/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes.rectorate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.rectorate.RectoratePaymentCode_Base;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class RectoratePaymentCode
extends RectoratePaymentCode_Base {
    protected RectoratePaymentCode(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        this.init(PaymentCodeType.RECTORATE, startDate, endDate, minAmount, maxAmount, null);
    }

    protected void internalProcess(Person person, Money amount, DateTime whenRegistered, String sibsTransactionId, String comments) {
    }

    public boolean isForRectorate() {
        return true;
    }

    public static RectoratePaymentCode create(LocalDate startDate, LocalDate endDate, Money minAmount, Money maxAmount) {
        return new RectoratePaymentCode(startDate.toDateTimeAtStartOfDay().toYearMonthDay(), endDate.toDateTimeAtStartOfDay().toYearMonthDay(), minAmount, maxAmount);
    }

    public static List<RectoratePaymentCode> getAllRectoratePaymentCodes() {
        ArrayList<RectoratePaymentCode> result = new ArrayList<RectoratePaymentCode>();
        Set paymentCodes = Bennu.getInstance().getPaymentCodesSet();
        for (PaymentCode paymentCode : paymentCodes) {
            if (!paymentCode.isForRectorate() || StringUtils.isEmpty((String)paymentCode.getCode())) continue;
            result.add((RectoratePaymentCode)((Object)paymentCode));
        }
        return result;
    }
}

