/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentStudentsConcludedInExecutionYearGroup;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

@GroupOperator(value="studentsConcluded")
public class StudentsConcludedInExecutionYearGroup
extends FenixGroup {
    private static final long serialVersionUID = 5303530923037645419L;
    @GroupArgument
    private Degree degree;
    @GroupArgument
    private ExecutionYear conclusionYear;

    private StudentsConcludedInExecutionYearGroup() {
    }

    private StudentsConcludedInExecutionYearGroup(Degree degree, ExecutionYear conclusionYear) {
        this();
        this.degree = degree;
        this.conclusionYear = conclusionYear;
    }

    public static StudentsConcludedInExecutionYearGroup get(Degree degree, ExecutionYear conclusionYear) {
        return new StudentsConcludedInExecutionYearGroup(degree, conclusionYear);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.degree.getPresentationName(), this.conclusionYear.getName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (Registration registration : this.degree.getRegistrationsSet()) {
            User user;
            LocalDate conclusionDate;
            if (!registration.hasConcluded() || (conclusionDate = this.getConclusionDate(this.degree, registration)) == null || conclusionDate.getYear() != this.conclusionYear.getEndCivilYear() && conclusionDate.getYear() != this.conclusionYear.getBeginCivilYear() || (user = registration.getPerson().getUser()) == null) continue;
            users.add(user);
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null || user.getPerson().getStudent() == null) {
            return false;
        }
        for (Registration registration : user.getPerson().getStudent().getRegistrationsSet()) {
            if (!registration.isConcluded() || !registration.getDegree().equals(this.degree)) continue;
            LocalDate conclusionDate = this.getConclusionDate(registration.getDegree(), registration);
            return conclusionDate != null && (conclusionDate.getYear() == this.conclusionYear.getEndCivilYear() || conclusionDate.getYear() == this.conclusionYear.getBeginCivilYear());
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    private LocalDate getConclusionDate(Degree degree, Registration registration) {
        Iterator<StudentCurricularPlan> iterator = registration.getStudentCurricularPlansByDegree(degree).iterator();
        if (iterator.hasNext()) {
            StudentCurricularPlan scp = iterator.next();
            if (registration.isBolonha()) {
                YearMonthDay conclusionDate;
                if (scp.getLastConcludedCycleCurriculumGroup() != null && (conclusionDate = registration.getConclusionDate(scp.getLastConcludedCycleCurriculumGroup().getCycleType())) != null) {
                    return conclusionDate.toLocalDate();
                }
                return null;
            }
            return registration.getConclusionDate() != null ? registration.getConclusionDate().toLocalDate() : null;
        }
        return null;
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentStudentsConcludedInExecutionYearGroup.getInstance(this.degree, this.conclusionYear);
    }

    public boolean equals(Object object) {
        if (object instanceof StudentsConcludedInExecutionYearGroup) {
            StudentsConcludedInExecutionYearGroup other = (StudentsConcludedInExecutionYearGroup)((Object)object);
            return Objects.equal((Object)this.degree, (Object)other.degree) && Objects.equal((Object)this.conclusionYear, (Object)other.conclusionYear);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degree, this.conclusionYear});
    }
}

