/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AdHocEvaluation;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.BibliographicReference;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularManagementLog;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationMethod;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse$callable$associateCurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse$callable$changeProjectTutorialCourse;
import org.fenixedu.academic.domain.ExecutionCourse$callable$dissociateCurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourseLog;
import org.fenixedu.academic.domain.ExecutionCourse_Base;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.ExportGrouping;
import org.fenixedu.academic.domain.FinalEvaluation;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.LessonPlanning;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Professorship_Base;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.executionCourse.SummariesSearchBean;
import org.fenixedu.academic.domain.messaging.ExecutionCourseForum;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.WeeklyWorkLoad;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.dto.teacher.executionCourse.SearchExecutionCourseAttendsBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ExecutionCoursePredicates;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.GroupEnrolmentStrategyFactory;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategy;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class ExecutionCourse
extends ExecutionCourse_Base {
    public static final String CREATED_SIGNAL = "academic.executionCourse.create";
    public static final Comparator<ExecutionCourse> EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR;
    public static final Comparator<ExecutionCourse> EXECUTION_COURSE_NAME_COMPARATOR;
    public static final Comparator<ExecutionCourse> EXECUTION_COURSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME;
    public static final Comparator<Evaluation> EVALUATION_COMPARATOR;
    public static final Advice advice$changeProjectTutorialCourse;
    public static final Advice advice$associateCurricularCourse;
    public static final Advice advice$dissociateCurricularCourse;

    public static List<ExecutionCourse> readNotEmptyExecutionCourses() {
        return new ArrayList<ExecutionCourse>(Bennu.getInstance().getExecutionCoursesSet());
    }

    public ExecutionCourse(String nome, String sigla, ExecutionSemester executionSemester, EntryPhase entryPhase) {
        this.setRootDomainObject(Bennu.getInstance());
        this.addAssociatedEvaluations((Evaluation)((Object)new FinalEvaluation()));
        this.setAvailableGradeSubmission(Boolean.TRUE);
        this.setNome(nome);
        this.setExecutionPeriod(executionSemester);
        this.setSigla(sigla);
        this.setComment("");
        if (entryPhase == null) {
            entryPhase = EntryPhase.FIRST_PHASE;
        }
        this.setEntryPhase(entryPhase);
        this.setProjectTutorialCourse(Boolean.FALSE);
        this.setUnitCreditValue(null);
        Signal.emit((String)CREATED_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public void editInformation(String nome, String sigla, String comment, Boolean availableGradeSubmission, EntryPhase entryPhase) {
        this.setNome(nome);
        this.setSigla(sigla);
        this.setComment(comment);
        this.setAvailableGradeSubmission(availableGradeSubmission);
        if (entryPhase != null) {
            this.setEntryPhase(entryPhase);
        }
    }

    public void editCourseLoad(ShiftType type, BigDecimal unitQuantity, BigDecimal totalQuantity) {
        CourseLoad courseLoad = this.getCourseLoadByShiftType(type);
        if (courseLoad == null) {
            new CourseLoad(this, type, unitQuantity, totalQuantity);
        } else {
            courseLoad.edit(unitQuantity, totalQuantity);
        }
    }

    public List<Grouping> getGroupings() {
        ArrayList<Grouping> result = new ArrayList<Grouping>();
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (exportGrouping.getProposalState().getState() != 2 && exportGrouping.getProposalState().getState() != 1) continue;
            result.add(exportGrouping.getGrouping());
        }
        return result;
    }

    public Grouping getGroupingByName(String groupingName) {
        for (Grouping grouping : this.getGroupings()) {
            if (!grouping.getName().equals(groupingName)) continue;
            return grouping;
        }
        return null;
    }

    public boolean existsGroupingExecutionCourse(ExportGrouping groupPropertiesExecutionCourse) {
        return this.getExportGroupingsSet().contains((Object)groupPropertiesExecutionCourse);
    }

    public boolean existsGroupingExecutionCourse() {
        return this.getExportGroupingsSet().isEmpty();
    }

    public boolean hasProposals() {
        boolean result = false;
        boolean found = false;
        Set groupPropertiesExecutionCourseList = this.getExportGroupingsSet();
        Iterator iter = groupPropertiesExecutionCourseList.iterator();
        while (iter.hasNext() && !found) {
            ExportGrouping groupPropertiesExecutionCourseAux = (ExportGrouping)((Object)iter.next());
            if (groupPropertiesExecutionCourseAux.getProposalState().getState() != 3) continue;
            result = true;
            found = true;
        }
        return result;
    }

    public boolean isMasterDegreeDFAOrDEAOnly() {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            DegreeType degreeType = curricularCourse.getDegreeCurricularPlan().getDegree().getDegreeType();
            if (degreeType.isPreBolonhaMasterDegree() || degreeType.isAdvancedFormationDiploma() || degreeType.isSpecializationDegree() || degreeType.isAdvancedSpecializationDiploma()) continue;
            return false;
        }
        return true;
    }

    public void createEvaluationMethod(MultiLanguageString evaluationElements) {
        if (evaluationElements == null) {
            throw new NullPointerException();
        }
        EvaluationMethod evaluationMethod = new EvaluationMethod();
        evaluationMethod.setExecutionCourse(this);
        evaluationMethod.setEvaluationElements(evaluationElements);
    }

    public void copyEvaluationMethodFrom(ExecutionCourse executionCourseFrom) {
        if (executionCourseFrom.getEvaluationMethod() != null) {
            EvaluationMethod evaluationMethodFrom = executionCourseFrom.getEvaluationMethod();
            EvaluationMethod evaluationMethodTo = this.getEvaluationMethod();
            if (evaluationMethodTo == null) {
                this.createEvaluationMethod(evaluationMethodFrom.getEvaluationElements());
            } else {
                evaluationMethodTo.edit(evaluationMethodFrom.getEvaluationElements());
            }
        }
    }

    public void createBibliographicReference(String title, String authors, String reference, String year, Boolean optional) {
        if (title == null || authors == null || reference == null || year == null || optional == null) {
            throw new NullPointerException();
        }
        BibliographicReference bibliographicReference = new BibliographicReference();
        bibliographicReference.setTitle(title);
        bibliographicReference.setAuthors(authors);
        bibliographicReference.setReference(reference);
        bibliographicReference.setYear(year);
        bibliographicReference.setOptional(optional);
        bibliographicReference.setExecutionCourse(this);
        String type = optional != false ? BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.optional", (String[])new String[0]) : BundleUtil.getString((String)"resources.ApplicationResources", (String)"option.bibliographicReference.recommended", (String[])new String[0]);
        CurricularManagementLog.createLog(this, "resources.MessagingResources", "log.executionCourse.curricular.bibliographic.created", type, title, this.getName(), this.getDegreePresentationString());
    }

    public List<BibliographicReference> copyBibliographicReferencesFrom(ExecutionCourse executionCourseFrom) {
        ArrayList<BibliographicReference> notCopiedBibliographicReferences = new ArrayList<BibliographicReference>();
        for (BibliographicReference bibliographicReference : executionCourseFrom.getAssociatedBibliographicReferencesSet()) {
            if (this.canAddBibliographicReference(bibliographicReference)) {
                this.createBibliographicReference(bibliographicReference.getTitle(), bibliographicReference.getAuthors(), bibliographicReference.getReference(), bibliographicReference.getYear(), bibliographicReference.getOptional());
                continue;
            }
            notCopiedBibliographicReferences.add(bibliographicReference);
        }
        return notCopiedBibliographicReferences;
    }

    private boolean canAddBibliographicReference(BibliographicReference bibliographicReferenceToAdd) {
        for (BibliographicReference bibliographicReference : this.getAssociatedBibliographicReferencesSet()) {
            if (!bibliographicReference.getTitle().equals(bibliographicReferenceToAdd.getTitle())) continue;
            return false;
        }
        return true;
    }

    public List<Professorship> responsibleFors() {
        return this.getProfessorshipsSet().stream().filter(Professorship_Base::getResponsibleFor).collect(Collectors.toList());
    }

    public Attends getAttendsByStudent(Registration registration) {
        for (Attends attends : this.getAttendsSet()) {
            if (attends.getRegistration() != registration) continue;
            return attends;
        }
        return null;
    }

    public Attends getAttendsByStudent(Student student) {
        for (Attends attends : this.getAttendsSet()) {
            if (!attends.isFor(student)) continue;
            return attends;
        }
        return null;
    }

    public boolean hasAttendsFor(Student student) {
        return this.getAttendsByStudent(student) != null;
    }

    public List<Exam> getAssociatedExams() {
        ArrayList<Exam> associatedExams = new ArrayList<Exam>();
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof Exam)) continue;
            associatedExams.add((Exam)((Object)evaluation));
        }
        return associatedExams;
    }

    public List<WrittenEvaluation> getAssociatedWrittenEvaluations() {
        HashSet<Object> writtenEvaluations = new HashSet<Object>();
        writtenEvaluations.addAll(this.getAssociatedExams());
        writtenEvaluations.addAll(this.getAssociatedWrittenTests());
        return new ArrayList<WrittenEvaluation>(writtenEvaluations);
    }

    public List<WrittenTest> getAssociatedWrittenTests() {
        ArrayList<WrittenTest> associatedWrittenTests = new ArrayList<WrittenTest>();
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof WrittenTest)) continue;
            associatedWrittenTests.add((WrittenTest)((Object)evaluation));
        }
        return associatedWrittenTests;
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (this.getSender() != null) {
            this.getSender().getRecipientsSet().clear();
            this.setSender(null);
        }
        while (!this.getExportGroupingsSet().isEmpty()) {
            ((ExportGrouping)((Object)this.getExportGroupingsSet().iterator().next())).delete();
        }
        while (!this.getGroupingSenderExecutionCourseSet().isEmpty()) {
            ((ExportGrouping)((Object)this.getGroupingSenderExecutionCourseSet().iterator().next())).delete();
        }
        while (!this.getCourseLoadsSet().isEmpty()) {
            ((CourseLoad)((Object)this.getCourseLoadsSet().iterator().next())).delete();
        }
        while (!this.getProfessorshipsSet().isEmpty()) {
            ((Professorship)((Object)this.getProfessorshipsSet().iterator().next())).delete();
        }
        while (!this.getLessonPlanningsSet().isEmpty()) {
            ((LessonPlanning)((Object)this.getLessonPlanningsSet().iterator().next())).delete();
        }
        while (!this.getAttendsSet().isEmpty()) {
            ((Attends)((Object)this.getAttendsSet().iterator().next())).delete();
        }
        while (!this.getForuns().isEmpty()) {
            this.getForuns().iterator().next().delete();
        }
        while (!this.getExecutionCourseLogsSet().isEmpty()) {
            ((ExecutionCourseLog)((Object)this.getExecutionCourseLogsSet().iterator().next())).delete();
        }
        this.removeFinalEvaluations();
        this.getAssociatedCurricularCoursesSet().clear();
        this.getNonAffiliatedTeachersSet().clear();
        this.setExecutionPeriod(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAssociatedSummariesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.getGroupings().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.getAssociatedBibliographicReferencesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.hasOnlyFinalEvaluations()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (this.getEvaluationMethod() != null) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.getAssociatedShifts().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.getAttendsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (professorship.isDeletable()) continue;
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        for (ExecutionCourseForum forum : this.getForuns()) {
            if (forum.getConversationThreadSet().size() == 0) continue;
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.execution.course.cant.delete", (String[])new String[0]));
        }
        if (!this.getStudentGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.executionCourse.cannotDeleteExecutionCourseUsedInAccessControl", (String[])new String[0]));
        }
        if (!this.getSpecialCriteriaOverExecutionCourseGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.executionCourse.cannotDeleteExecutionCourseUsedInAccessControl", (String[])new String[0]));
        }
        if (!this.getTeacherGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.executionCourse.cannotDeleteExecutionCourseUsedInAccessControl", (String[])new String[0]));
        }
    }

    private void removeFinalEvaluations() {
        Iterator iterator = this.getAssociatedEvaluationsSet().iterator();
        while (iterator.hasNext()) {
            Evaluation evaluation = (Evaluation)((Object)iterator.next());
            if (evaluation.isFinal()) {
                iterator.remove();
                evaluation.delete();
                continue;
            }
            throw new DomainException("error.ExecutionCourse.cannot.remove.non.final.evaluation", new String[0]);
        }
    }

    private boolean hasOnlyFinalEvaluations() {
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (evaluation.isFinal()) continue;
            return false;
        }
        return true;
    }

    public boolean teacherLecturesExecutionCourse(Teacher teacher) {
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (professorship.getTeacher() != teacher) continue;
            return true;
        }
        return false;
    }

    public List<Project> getAssociatedProjects() {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof Project)) continue;
            result.add((Project)((Object)evaluation));
        }
        return result;
    }

    private int countAssociatedStudentsByEnrolmentNumber(int enrolmentNumber) {
        int executionCourseAssociatedStudents = 0;
        ExecutionSemester courseExecutionPeriod = this.getExecutionPeriod();
        for (CurricularCourse curricularCourseFromExecutionCourseEntry : this.getAssociatedCurricularCoursesSet()) {
            for (Enrolment enrolment : curricularCourseFromExecutionCourseEntry.getEnrolments()) {
                if (enrolment.getExecutionPeriod() != courseExecutionPeriod) continue;
                StudentCurricularPlan studentCurricularPlanEntry = enrolment.getStudentCurricularPlan();
                int numberOfEnrolmentsForThatExecutionCourse = 0;
                for (Enrolment enrolmentsFromStudentCPEntry : studentCurricularPlanEntry.getEnrolmentsSet()) {
                    if (enrolmentsFromStudentCPEntry.getCurricularCourse() == curricularCourseFromExecutionCourseEntry && enrolmentsFromStudentCPEntry.getExecutionPeriod().compareTo(courseExecutionPeriod) <= 0 && ++numberOfEnrolmentsForThatExecutionCourse > enrolmentNumber) break;
                }
                if (numberOfEnrolmentsForThatExecutionCourse != enrolmentNumber) continue;
                ++executionCourseAssociatedStudents;
            }
        }
        return executionCourseAssociatedStudents;
    }

    public Integer getTotalEnrolmentStudentNumber() {
        int executionCourseStudentNumber = 0;
        for (CurricularCourse curricularCourseFromExecutionCourseEntry : this.getAssociatedCurricularCoursesSet()) {
            for (Enrolment enrolment : curricularCourseFromExecutionCourseEntry.getEnrolments()) {
                if (enrolment.getExecutionPeriod() != this.getExecutionPeriod()) continue;
                ++executionCourseStudentNumber;
            }
        }
        return executionCourseStudentNumber;
    }

    public Integer getFirstTimeEnrolmentStudentNumber() {
        return this.countAssociatedStudentsByEnrolmentNumber(1);
    }

    public Integer getSecondOrMoreTimeEnrolmentStudentNumber() {
        return this.getTotalEnrolmentStudentNumber() - this.getFirstTimeEnrolmentStudentNumber();
    }

    public Duration getTotalShiftsDuration() {
        Duration totalDuration = Duration.ZERO;
        for (Shift shift : this.getAssociatedShifts()) {
            totalDuration = totalDuration.plus((ReadableDuration)shift.getTotalDuration());
        }
        return totalDuration;
    }

    public BigDecimal getAllShiftUnitHours(ShiftType shiftType) {
        BigDecimal totalTime = BigDecimal.ZERO;
        for (Shift shift : this.getAssociatedShifts()) {
            if (!shift.containsType(shiftType)) continue;
            totalTime = totalTime.add(shift.getUnitHours());
        }
        return totalTime;
    }

    public BigDecimal getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType type) {
        CourseLoad courseLoad = this.getCourseLoadByShiftType(type);
        return courseLoad != null ? courseLoad.getWeeklyHours() : BigDecimal.ZERO;
    }

    public Set<Shift> getAssociatedShifts() {
        HashSet<Shift> result = new HashSet<Shift>();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            result.addAll(courseLoad.getShiftsSet());
        }
        return result;
    }

    public Set<LessonInstance> getAssociatedLessonInstances() {
        HashSet<LessonInstance> result = new HashSet<LessonInstance>();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            result.addAll(courseLoad.getLessonInstancesSet());
        }
        return result;
    }

    public Double getStudentsNumberByShift(ShiftType shiftType) {
        int numShifts = this.getNumberOfShifts(shiftType);
        if (numShifts == 0) {
            return 0.0;
        }
        return (double)this.getTotalEnrolmentStudentNumber().intValue() / (double)numShifts;
    }

    public List<Enrolment> getActiveEnrollments() {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            List<Enrolment> enrollments = curricularCourse.getActiveEnrollments(this.getExecutionPeriod());
            results.addAll(enrollments);
        }
        return results;
    }

    public List<Dismissal> getDismissals() {
        ArrayList<Dismissal> results = new ArrayList<Dismissal>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            List<Dismissal> dismissals = curricularCourse.getDismissals(this.getExecutionPeriod());
            results.addAll(dismissals);
        }
        return results;
    }

    public boolean areAllOptionalCurricularCoursesWithLessTenEnrolments() {
        int enrolments = 0;
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.getType() != null && curricularCourse.getType().equals((Object)CurricularCourseType.OPTIONAL_COURSE)) {
                if ((enrolments += curricularCourse.getEnrolmentsByExecutionPeriod(this.getExecutionPeriod()).size()) < 10) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public List<Evaluation> getOrderedAssociatedEvaluations() {
        ArrayList<Evaluation> orderedEvaluations = new ArrayList<Evaluation>(this.getAssociatedEvaluationsSet());
        Collections.sort(orderedEvaluations, EVALUATION_COMPARATOR);
        return orderedEvaluations;
    }

    public Set<Attends> getOrderedAttends() {
        TreeSet<Attends> orderedAttends = new TreeSet<Attends>(Attends.COMPARATOR_BY_STUDENT_NUMBER);
        orderedAttends.addAll(this.getAttendsSet());
        return orderedAttends;
    }

    public Interval getInterval() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        DateTime beginningOfSemester = new DateTime((Object)executionSemester.getBeginDateYearMonthDay());
        DateTime firstMonday = beginningOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateTime endOfSemester = new DateTime((Object)executionSemester.getEndDateYearMonthDay());
        DateTime nextLastMonday = endOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1).plusWeeks(1);
        return new Interval((ReadableInstant)firstMonday, (ReadableInstant)nextLastMonday);
    }

    public WeeklyWorkLoadView getWeeklyWorkLoadView() {
        Attends attends = this.findAttendsWithEnrolment();
        if (attends != null) {
            Interval interval = attends.getWeeklyWorkLoadInterval();
            WeeklyWorkLoadView weeklyWorkLoadView = new WeeklyWorkLoadView(interval);
            for (Attends attend : this.getAttendsSet()) {
                weeklyWorkLoadView.add(attend);
            }
            return weeklyWorkLoadView;
        }
        return null;
    }

    private Attends findAttendsWithEnrolment() {
        for (Attends attends : this.getAttendsSet()) {
            if (attends.getEnrolment() == null) continue;
            return attends;
        }
        return null;
    }

    public boolean hasGrouping(Grouping grouping) {
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (grouping != exportGrouping.getGrouping()) continue;
            return true;
        }
        return false;
    }

    public Shift findShiftByName(String shiftName) {
        for (Shift shift : this.getAssociatedShifts()) {
            if (!shift.getNome().equals(shiftName)) continue;
            return shift;
        }
        return null;
    }

    public Set<Shift> findShiftByType(ShiftType shiftType) {
        HashSet<Shift> shifts = new HashSet<Shift>();
        for (Shift shift : this.getAssociatedShifts()) {
            if (!shift.containsType(shiftType)) continue;
            shifts.add(shift);
        }
        return shifts;
    }

    public Set<SchoolClass> findSchoolClasses() {
        HashSet<SchoolClass> schoolClasses = new HashSet<SchoolClass>();
        for (Shift shift : this.getAssociatedShifts()) {
            schoolClasses.addAll(shift.getAssociatedClassesSet());
        }
        return schoolClasses;
    }

    public List<Summary> readSummariesOfTeachersWithoutProfessorship() {
        ArrayList<Summary> summaries = new ArrayList<Summary>();
        for (Summary summary : this.getAssociatedSummariesSet()) {
            if (summary.getProfessorship() != null || summary.getTeacher() == null && (summary.getTeacherName() == null || summary.getTeacherName().equals(""))) continue;
            summaries.add(summary);
        }
        return summaries;
    }

    public ExportGrouping getExportGrouping(Grouping grouping) {
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (exportGrouping.getGrouping() != grouping) continue;
            return exportGrouping;
        }
        return null;
    }

    public boolean hasExportGrouping(Grouping grouping) {
        return this.getExportGrouping(grouping) != null;
    }

    public boolean hasScopeInGivenSemesterAndCurricularYearInDCP(CurricularYear curricularYear, DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(curricularYear, degreeCurricularPlan, this.getExecutionPeriod())) continue;
            return true;
        }
        return false;
    }

    public void createForum(MultiLanguageString name, MultiLanguageString description) {
        if (this.hasForumWithName(name)) {
            throw new DomainException("executionCourse.already.existing.forum", new String[0]);
        }
        this.addForum(new ExecutionCourseForum(name, description));
    }

    public void addForum(ExecutionCourseForum executionCourseForum) {
        this.checkIfCanAddForum(executionCourseForum.getNormalizedName());
        super.addForum(executionCourseForum);
    }

    public void checkIfCanAddForum(MultiLanguageString name) {
        if (this.hasForumWithName(name)) {
            throw new DomainException("executionCourse.already.existing.forum", new String[0]);
        }
    }

    public boolean hasForumWithName(MultiLanguageString name) {
        return this.getForumByName(name) != null;
    }

    public ExecutionCourseForum getForumByName(MultiLanguageString name) {
        for (ExecutionCourseForum executionCourseForum : this.getForuns()) {
            if (!executionCourseForum.getNormalizedName().equalInAnyLanguage(name)) continue;
            return executionCourseForum;
        }
        return null;
    }

    public SortedSet<Degree> getDegreesSortedByDegreeName() {
        TreeSet<Degree> degrees = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            degrees.add(degreeCurricularPlan.getDegree());
        }
        return degrees;
    }

    public SortedSet<CurricularCourse> getCurricularCoursesSortedByDegreeAndCurricularCourseName() {
        TreeSet<CurricularCourse> curricularCourses = new TreeSet<CurricularCourse>(CurricularCourse.CURRICULAR_COURSE_COMPARATOR_BY_DEGREE_AND_NAME);
        curricularCourses.addAll(this.getAssociatedCurricularCoursesSet());
        return curricularCourses;
    }

    public Set<CompetenceCourse> getCompetenceCourses() {
        HashSet<CompetenceCourse> competenceCourses = new HashSet<CompetenceCourse>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null) continue;
            competenceCourses.add(competenceCourse);
        }
        return competenceCourses;
    }

    public Set<CompetenceCourseInformation> getCompetenceCoursesInformations() {
        HashSet<CompetenceCourseInformation> competenceCourseInformations = new HashSet<CompetenceCourseInformation>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            CompetenceCourseInformation competenceCourseInformation;
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null || (competenceCourseInformation = competenceCourse.findCompetenceCourseInformationForExecutionPeriod(this.getExecutionPeriod())) == null) continue;
            competenceCourseInformations.add(competenceCourseInformation);
        }
        return competenceCourseInformations;
    }

    public boolean hasAnyDegreeGradeToSubmit(ExecutionSemester period, DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (degreeCurricularPlan != null && !degreeCurricularPlan.equals((Object)curricularCourse.getDegreeCurricularPlan()) || !curricularCourse.hasAnyDegreeGradeToSubmit(period)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyDegreeMarkSheetToConfirm(ExecutionSemester period, DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (degreeCurricularPlan != null && !degreeCurricularPlan.equals((Object)curricularCourse.getDegreeCurricularPlan()) || !curricularCourse.hasAnyDegreeMarkSheetToConfirm(period)) continue;
            return true;
        }
        return false;
    }

    public String constructShiftName(Shift shift, int n) {
        String number = n < 10 ? "0" + n : Integer.toString(n);
        StringBuilder typesName = new StringBuilder();
        for (ShiftType shiftType : shift.getSortedTypes()) {
            typesName.append(shiftType.getSiglaTipoAula());
        }
        return this.getSigla() + typesName.toString() + number;
    }

    public SortedSet<Shift> getShiftsByTypeOrderedByShiftName(ShiftType shiftType) {
        TreeSet<Shift> shifts = new TreeSet<Shift>(Shift.SHIFT_COMPARATOR_BY_NAME);
        for (Shift shift : this.getAssociatedShifts()) {
            if (!shift.containsType(shiftType)) continue;
            shifts.add(shift);
        }
        return shifts;
    }

    public void setShiftNames() {
        SortedSet<Shift> shifts = ExecutionCourse.constructSortedSet(this.getAssociatedShifts(), Shift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        int counter = 0;
        for (Shift shift : shifts) {
            String name = this.constructShiftName(shift, ++counter);
            shift.setNome(name);
        }
    }

    private static <T> SortedSet<T> constructSortedSet(Collection<T> collection, Comparator<? super T> c) {
        TreeSet<T> sortedSet = new TreeSet<T>(c);
        sortedSet.addAll(collection);
        return sortedSet;
    }

    public boolean hasProjectsWithOnlineSubmission() {
        for (Project project : this.getAssociatedProjects()) {
            if (!project.getOnlineSubmissionsAllowed().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<Project> getProjectsWithOnlineSubmission() {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project project : this.getAssociatedProjects()) {
            if (!project.getOnlineSubmissionsAllowed().booleanValue()) continue;
            result.add(project);
        }
        return result;
    }

    private Set<SchoolClass> getAllSchoolClassesOrBy(DegreeCurricularPlan degreeCurricularPlan) {
        HashSet<SchoolClass> result = new HashSet<SchoolClass>();
        for (Shift shift : this.getAssociatedShifts()) {
            for (SchoolClass schoolClass : shift.getAssociatedClassesSet()) {
                if (degreeCurricularPlan != null && schoolClass.getExecutionDegree().getDegreeCurricularPlan() != degreeCurricularPlan) continue;
                result.add(schoolClass);
            }
        }
        return result;
    }

    public Set<SchoolClass> getSchoolClassesBy(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getAllSchoolClassesOrBy(degreeCurricularPlan);
    }

    public Set<SchoolClass> getSchoolClasses() {
        return this.getAllSchoolClassesOrBy(null);
    }

    public boolean isLecturedIn(ExecutionYear executionYear) {
        return this.getExecutionPeriod().getExecutionYear() == executionYear;
    }

    public boolean isLecturedIn(ExecutionSemester executionSemester) {
        return this.getExecutionPeriod() == executionSemester;
    }

    public SortedSet<Professorship> getProfessorshipsSortedAlphabetically() {
        TreeSet<Professorship> professorhips = new TreeSet<Professorship>(Professorship.COMPARATOR_BY_PERSON_NAME);
        professorhips.addAll(this.getProfessorshipsSet());
        return professorhips;
    }

    public SummariesSearchBean getSummariesSearchBean() {
        return new SummariesSearchBean(this);
    }

    public Set<Lesson> getLessons() {
        HashSet<Lesson> lessons = new HashSet<Lesson>();
        for (Shift shift : this.getAssociatedShifts()) {
            lessons.addAll(shift.getAssociatedLessonsSet());
        }
        return lessons;
    }

    public boolean hasAnyLesson() {
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            for (Shift shift : courseLoad.getShiftsSet()) {
                if (shift.getAssociatedLessonsSet().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public SortedSet<WrittenEvaluation> getWrittenEvaluations() {
        TreeSet<WrittenEvaluation> writtenEvaluations = new TreeSet<WrittenEvaluation>(WrittenEvaluation.COMPARATOR_BY_BEGIN_DATE);
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof WrittenEvaluation)) continue;
            writtenEvaluations.add((WrittenEvaluation)((Object)evaluation));
        }
        return writtenEvaluations;
    }

    public SortedSet<Shift> getShiftsOrderedByLessons() {
        TreeSet<Shift> shifts = new TreeSet<Shift>(Shift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        shifts.addAll(this.getAssociatedShifts());
        return shifts;
    }

    public Map<CompetenceCourse, Set<CurricularCourse>> getCurricularCoursesIndexedByCompetenceCourse() {
        HashMap<CompetenceCourse, Set<CurricularCourse>> curricularCourseMap = new HashMap<CompetenceCourse, Set<CurricularCourse>>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            TreeSet<CurricularCourse> curricularCourses;
            CompetenceCourse competenceCourse;
            if (!curricularCourse.isBolonhaDegree() || (competenceCourse = curricularCourse.getCompetenceCourse()) == null) continue;
            if (curricularCourseMap.containsKey((Object)competenceCourse)) {
                curricularCourses = (TreeSet<CurricularCourse>)curricularCourseMap.get((Object)competenceCourse);
            } else {
                curricularCourses = new TreeSet<CurricularCourse>(CurricularCourse.CURRICULAR_COURSE_COMPARATOR_BY_DEGREE_AND_NAME);
                curricularCourseMap.put(competenceCourse, curricularCourses);
            }
            curricularCourses.add(curricularCourse);
        }
        return curricularCourseMap;
    }

    public boolean getHasAnySecondaryBibliographicReference() {
        return this.hasAnyBibliographicReferenceByBibliographicReferenceType(BibliographicReferences.BibliographicReferenceType.SECONDARY);
    }

    public boolean getHasAnyMainBibliographicReference() {
        return this.hasAnyBibliographicReferenceByBibliographicReferenceType(BibliographicReferences.BibliographicReferenceType.MAIN);
    }

    private boolean hasAnyBibliographicReferenceByBibliographicReferenceType(BibliographicReferences.BibliographicReferenceType referenceType) {
        for (BibliographicReference bibliographicReference : this.getAssociatedBibliographicReferencesSet()) {
            if ((!referenceType.equals((Object)BibliographicReferences.BibliographicReferenceType.SECONDARY) || !bibliographicReference.getOptional().booleanValue()) && (!referenceType.equals((Object)BibliographicReferences.BibliographicReferenceType.MAIN) || bibliographicReference.getOptional().booleanValue())) continue;
            return true;
        }
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            BibliographicReferences bibliographicReferences;
            CompetenceCourseInformation competenceCourseInformation;
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null || (competenceCourseInformation = competenceCourse.findCompetenceCourseInformationForExecutionPeriod(this.getExecutionPeriod())) == null || (bibliographicReferences = competenceCourseInformation.getBibliographicReferences()) == null) continue;
            for (BibliographicReferences.BibliographicReference bibliographicReference : bibliographicReferences.getBibliographicReferencesList()) {
                if (bibliographicReference.getType() != referenceType) continue;
                return true;
            }
        }
        return false;
    }

    public List<LessonPlanning> getLessonPlanningsOrderedByOrder(ShiftType lessonType) {
        ArrayList<LessonPlanning> lessonPlannings = new ArrayList<LessonPlanning>();
        for (LessonPlanning planning : this.getLessonPlanningsSet()) {
            if (!planning.getLessonType().equals((Object)lessonType)) continue;
            lessonPlannings.add(planning);
        }
        Collections.sort(lessonPlannings, LessonPlanning.COMPARATOR_BY_ORDER);
        return lessonPlannings;
    }

    public LessonPlanning getLessonPlanning(ShiftType lessonType, Integer order) {
        for (LessonPlanning planning : this.getLessonPlanningsSet()) {
            if (!planning.getLessonType().equals((Object)lessonType) || !planning.getOrderOfPlanning().equals(order)) continue;
            return planning;
        }
        return null;
    }

    public Set<ShiftType> getShiftTypes() {
        TreeSet<ShiftType> shiftTypes = new TreeSet<ShiftType>();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            shiftTypes.add(courseLoad.getType());
        }
        return shiftTypes;
    }

    public void copyLessonPlanningsFrom(ExecutionCourse executionCourseFrom) {
        Set<ShiftType> shiftTypes = this.getShiftTypes();
        for (ShiftType shiftType : executionCourseFrom.getShiftTypes()) {
            List<LessonPlanning> lessonPlanningsFrom;
            if (!shiftTypes.contains((Object)shiftType) || (lessonPlanningsFrom = executionCourseFrom.getLessonPlanningsOrderedByOrder(shiftType)).isEmpty()) continue;
            for (LessonPlanning planning : lessonPlanningsFrom) {
                new LessonPlanning(planning.getTitle(), planning.getPlanning(), planning.getLessonType(), this);
            }
        }
    }

    public void createLessonPlanningsUsingSummariesFrom(Shift shift) {
        ArrayList summaries = new ArrayList();
        summaries.addAll(shift.getAssociatedSummariesSet());
        Collections.sort(summaries, new ReverseComparator(Summary.COMPARATOR_BY_DATE_AND_HOUR));
        for (Summary summary : summaries) {
            for (ShiftType shiftType : shift.getTypes()) {
                new LessonPlanning(summary.getTitle(), summary.getSummaryText(), shiftType, this);
            }
        }
    }

    public void deleteLessonPlanningsByLessonType(ShiftType shiftType) {
        List<LessonPlanning> lessonPlanningsOrderedByOrder = this.getLessonPlanningsOrderedByOrder(shiftType);
        for (LessonPlanning planning : lessonPlanningsOrderedByOrder) {
            planning.deleteWithoutReOrder();
        }
    }

    public Integer getNumberOfShifts(ShiftType shiftType) {
        int numShifts = 0;
        for (Shift shiftEntry : this.getAssociatedShifts()) {
            if (!shiftEntry.containsType(shiftType)) continue;
            ++numShifts;
        }
        return numShifts;
    }

    public Double getCurricularCourseEnrolmentsWeight(CurricularCourse curricularCourse) {
        Double totalEnrolmentStudentNumber = new Double(this.getTotalEnrolmentStudentNumber().intValue());
        if (totalEnrolmentStudentNumber > 0.0) {
            return (double)curricularCourse.getTotalEnrolmentStudentNumber(this.getExecutionPeriod()).intValue() / totalEnrolmentStudentNumber;
        }
        return 0.0;
    }

    public Set<ShiftType> getOldShiftTypesToEnrol() {
        List<ShiftType> validShiftTypes = Arrays.asList(ShiftType.TEORICA, ShiftType.PRATICA, ShiftType.LABORATORIAL, ShiftType.TEORICO_PRATICA);
        HashSet<ShiftType> result = new HashSet<ShiftType>(4);
        block0: for (Shift shift : this.getAssociatedShifts()) {
            for (ShiftType shiftType : shift.getTypes()) {
                if (!validShiftTypes.contains((Object)shiftType)) continue;
                result.add(shiftType);
                continue block0;
            }
        }
        return result;
    }

    public String getEqualLoad() {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            for (ShiftType type : ShiftType.values()) {
                if (this.getEqualLoad(type, curricularCourse)) continue;
                return Boolean.FALSE.toString();
            }
        }
        return Boolean.TRUE.toString();
    }

    public boolean getEqualLoad(ShiftType type, CurricularCourse curricularCourse) {
        if (type != null) {
            if (type.equals((Object)ShiftType.DUVIDAS) || type.equals((Object)ShiftType.RESERVA)) {
                return true;
            }
            BigDecimal ccTotalHours = curricularCourse.getTotalHoursByShiftType(type, this.getExecutionPeriod());
            CourseLoad courseLoad = this.getCourseLoadByShiftType(type);
            if (courseLoad == null && ccTotalHours == null || courseLoad == null && ccTotalHours != null && ccTotalHours.compareTo(BigDecimal.ZERO) == 0 || courseLoad != null && ccTotalHours != null && courseLoad.getTotalQuantity().compareTo(ccTotalHours) == 0) {
                return true;
            }
        }
        return false;
    }

    public List<Summary> getSummariesByShiftType(ShiftType shiftType) {
        ArrayList<Summary> summaries = new ArrayList<Summary>();
        for (Summary summary : this.getAssociatedSummariesSet()) {
            if (summary.getSummaryType() == null || !summary.getSummaryType().equals((Object)shiftType)) continue;
            summaries.add(summary);
        }
        return summaries;
    }

    public List<Summary> getSummariesWithoutProfessorshipButWithTeacher(Teacher teacher) {
        ArrayList<Summary> summaries = new ArrayList<Summary>();
        if (teacher != null) {
            for (Summary summary : this.getAssociatedSummariesSet()) {
                if (summary.getTeacher() == null || !summary.getTeacher().equals((Object)teacher)) continue;
                summaries.add(summary);
            }
        }
        return summaries;
    }

    public void moveSummariesFromTeacherToProfessorship(Teacher teacher, Professorship professorship) {
        List<Summary> summaries = this.getSummariesWithoutProfessorshipButWithTeacher(teacher);
        for (Summary summary : summaries) {
            summary.moveFromTeacherToProfessorship(professorship);
        }
    }

    public String getNome() {
        if (I18N.getLocale().getLanguage().equals("en") && !this.getAssociatedCurricularCoursesSet().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            HashSet<String> names = new HashSet<String>();
            for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
                String name;
                if (curricularCourse.getActiveDegreeModuleScopesInExecutionPeriod(this.getExecutionPeriod()).isEmpty() || names.contains(name = curricularCourse.getNameEn())) continue;
                names.add(name);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" / ");
                }
                stringBuilder.append(name);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            boolean unique = true;
            String nameEn = ((CurricularCourse)((Object)this.getAssociatedCurricularCoursesSet().iterator().next())).getNameEn();
            for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
                if (curricularCourse.getNameEn() != null && curricularCourse.getNameEn().equals(nameEn)) continue;
                unique = false;
                break;
            }
            if (unique) {
                return nameEn;
            }
            return super.getNome();
        }
        return super.getNome();
    }

    public String getName() {
        return this.getNome();
    }

    public String getPrettyAcronym() {
        return this.getSigla().replaceAll("[0-9]", "");
    }

    public String getDegreePresentationString() {
        SortedSet<Degree> degrees = this.getDegreesSortedByDegreeName();
        String result = "";
        int i = 0;
        for (Degree degree : degrees) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + degree.getSigla();
            ++i;
        }
        return result;
    }

    public Registration getRegistration(Person person) {
        for (Registration registration : person.getStudents()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                    for (ExecutionCourse course : enrolment.getExecutionCourses()) {
                        if (!course.equals((Object)this)) continue;
                        return registration;
                    }
                }
            }
        }
        return null;
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }

    public CurricularCourse getCurricularCourseFor(DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return curricularCourse;
        }
        return null;
    }

    public SortedSet<BibliographicReference> getOrderedBibliographicReferences() {
        TreeSet<BibliographicReference> references = new TreeSet<BibliographicReference>(BibliographicReference.COMPARATOR_BY_ORDER);
        references.addAll(this.getAssociatedBibliographicReferencesSet());
        return references;
    }

    public void setBibliographicReferencesOrder(List<BibliographicReference> references) {
    }

    public List<BibliographicReference> getMainBibliographicReferences() {
        ArrayList<BibliographicReference> references = new ArrayList<BibliographicReference>();
        for (BibliographicReference reference : this.getAssociatedBibliographicReferencesSet()) {
            if (reference.isOptional()) continue;
            references.add(reference);
        }
        return references;
    }

    public List<BibliographicReference> getSecondaryBibliographicReferences() {
        ArrayList<BibliographicReference> references = new ArrayList<BibliographicReference>();
        for (BibliographicReference reference : this.getAssociatedBibliographicReferencesSet()) {
            if (!reference.isOptional()) continue;
            references.add(reference);
        }
        return references;
    }

    public boolean isCompentenceCourseMainBibliographyAvailable() {
        for (CompetenceCourseInformation information : this.getCompetenceCoursesInformations()) {
            BibliographicReferences bibliographicReferences = information.getBibliographicReferences();
            if (bibliographicReferences == null || bibliographicReferences.getMainBibliographicReferences().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompentenceCourseSecondaryBibliographyAvailable() {
        for (CompetenceCourseInformation information : this.getCompetenceCoursesInformations()) {
            BibliographicReferences bibliographicReferences = information.getBibliographicReferences();
            if (bibliographicReferences == null || bibliographicReferences.getSecondaryBibliographicReferences().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<Curriculum> getCurriculums(ExecutionYear executionYear) {
        HashSet<Curriculum> result = new HashSet<Curriculum>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            Curriculum curriculum = executionYear == null ? curricularCourse.findLatestCurriculum() : curricularCourse.findLatestCurriculumModifiedBefore(executionYear.getEndDate());
            if (curriculum == null) continue;
            result.add(curriculum);
        }
        return result;
    }

    public boolean isInExamPeriod() {
        YearMonthDay yearMonthDay = new YearMonthDay();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        ExecutionYear executionYear = this.getExecutionPeriod().getExecutionYear();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            YearMonthDay startExamsPeriod;
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionSemester.getSemester() == 1) {
                startExamsPeriod = executionDegree.getPeriodExamsFirstSemester().getStartYearMonthDay();
            } else if (executionSemester.getSemester() == 2) {
                startExamsPeriod = executionDegree.getPeriodExamsSecondSemester().getStartYearMonthDay();
            } else {
                throw new DomainException("unsupported.execution.period.semester", new String[0]);
            }
            if (startExamsPeriod.minusDays(2).isAfter((ReadablePartial)yearMonthDay)) continue;
            return true;
        }
        return false;
    }

    public List<Grouping> getGroupingsToEnrol() {
        ArrayList<Grouping> result = new ArrayList<Grouping>();
        for (Grouping grouping : this.getGroupings()) {
            if (!this.checkPeriodEnrollmentFor(grouping)) continue;
            result.add(grouping);
        }
        return result;
    }

    private boolean checkPeriodEnrollmentFor(Grouping grouping) {
        GroupEnrolmentStrategyFactory enrolmentGroupPolicyStrategyFactory = GroupEnrolmentStrategyFactory.getInstance();
        IGroupEnrolmentStrategy strategy = enrolmentGroupPolicyStrategyFactory.getGroupEnrolmentStrategyInstance(grouping);
        return strategy.checkEnrolmentDate(grouping, Calendar.getInstance());
    }

    public SortedSet<ExecutionDegree> getFirsExecutionDegreesByYearWithExecutionIn(ExecutionYear executionYear) {
        TreeSet<ExecutionDegree> result = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            ExecutionDegree executionDegree = curricularCourse.getDegreeCurricularPlan().getExecutionDegreeByYear(executionYear);
            if (executionDegree == null) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public Set<ExecutionDegree> getExecutionDegrees() {
        HashSet<ExecutionDegree> result = new HashSet<ExecutionDegree>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            ExecutionDegree executionDegree = curricularCourse.getDegreeCurricularPlan().getExecutionDegreeByYear(this.getExecutionYear());
            if (executionDegree == null) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public Boolean getAvailableGradeSubmission() {
        if (super.getAvailableGradeSubmission() != null) {
            return super.getAvailableGradeSubmission();
        }
        return Boolean.TRUE;
    }

    public void setUnitCreditValue(BigDecimal unitCreditValue) {
        this.setUnitCreditValue(unitCreditValue, this.getUnitCreditValueNotes());
    }

    public void setUnitCreditValue(BigDecimal unitCreditValue, String justification) {
        if (unitCreditValue != null && (unitCreditValue.compareTo(BigDecimal.ZERO) < 0 || unitCreditValue.compareTo(BigDecimal.ONE) > 0)) {
            throw new DomainException("error.executionCourse.unitCreditValue.range", new String[0]);
        }
        if (unitCreditValue != null && unitCreditValue.compareTo(BigDecimal.ZERO) != 0 && this.getEffortRate() == null) {
            throw new DomainException("error.executionCourse.unitCreditValue.noEffortRate", new String[0]);
        }
        if (this.getEffortRate() != null && unitCreditValue != null && unitCreditValue.compareTo(BigDecimal.valueOf(Math.min(this.getEffortRate().doubleValue(), 1.0))) < 0 && StringUtils.isBlank((String)justification)) {
            throw new DomainException("error.executionCourse.unitCreditValue.lower.effortRate.withoutJustification", new String[0]);
        }
        super.setUnitCreditValueNotes(justification);
        super.setUnitCreditValue(unitCreditValue);
    }

    public Set<Department> getDepartments() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        TreeSet<Department> departments = new TreeSet<Department>(Department.COMPARATOR_BY_NAME);
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            Department department;
            DepartmentUnit departmentUnit;
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null || (departmentUnit = competenceCourse.getDepartmentUnit(executionSemester)) == null || (department = departmentUnit.getDepartment()) == null) continue;
            departments.add(department);
        }
        return departments;
    }

    public String getDepartmentNames() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        TreeSet<String> departments = new TreeSet<String>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            Department department;
            DepartmentUnit departmentUnit;
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse == null || (departmentUnit = competenceCourse.getDepartmentUnit(executionSemester)) == null || (department = departmentUnit.getDepartment()) == null) continue;
            departments.add(department.getName());
        }
        return StringUtils.join(departments, (String)", ");
    }

    public boolean isFromDepartment(Department departmentToCheck) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (departmentToCheck != curricularCourse.getCompetenceCourse().getDepartmentUnit().getDepartment()) continue;
            return true;
        }
        return false;
    }

    public GenericPair<YearMonthDay, YearMonthDay> getMaxLessonsPeriod() {
        YearMonthDay minBeginDate = null;
        YearMonthDay maxEndDate = null;
        Integer semester = this.getExecutionPeriod().getSemester();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            ExecutionDegree executionDegree = curricularCourse.getExecutionDegreeFor(this.getExecutionYear());
            if (semester == 1) {
                OccupationPeriod periodLessonsFirstSemester = executionDegree.getPeriodLessonsFirstSemester();
                if (periodLessonsFirstSemester == null) continue;
                if (minBeginDate == null || minBeginDate.isAfter((ReadablePartial)periodLessonsFirstSemester.getStartYearMonthDay())) {
                    minBeginDate = periodLessonsFirstSemester.getStartYearMonthDay();
                }
                if (maxEndDate != null && !maxEndDate.isBefore((ReadablePartial)periodLessonsFirstSemester.getEndYearMonthDayWithNextPeriods())) continue;
                maxEndDate = periodLessonsFirstSemester.getEndYearMonthDayWithNextPeriods();
                continue;
            }
            OccupationPeriod periodLessonsSecondSemester = executionDegree.getPeriodLessonsSecondSemester();
            if (periodLessonsSecondSemester == null) continue;
            if (minBeginDate == null || minBeginDate.isAfter((ReadablePartial)periodLessonsSecondSemester.getStartYearMonthDay())) {
                minBeginDate = periodLessonsSecondSemester.getStartYearMonthDay();
            }
            if (maxEndDate != null && !maxEndDate.isBefore((ReadablePartial)periodLessonsSecondSemester.getEndYearMonthDayWithNextPeriods())) continue;
            maxEndDate = periodLessonsSecondSemester.getEndYearMonthDayWithNextPeriods();
        }
        if (minBeginDate != null && maxEndDate != null) {
            return new GenericPair<Object, Object>(minBeginDate, maxEndDate);
        }
        return null;
    }

    public Map<ShiftType, CourseLoad> getCourseLoadsMap() {
        HashMap<ShiftType, CourseLoad> result = new HashMap<ShiftType, CourseLoad>();
        Set courseLoads = this.getCourseLoadsSet();
        for (CourseLoad courseLoad : courseLoads) {
            result.put(courseLoad.getType(), courseLoad);
        }
        return result;
    }

    public CourseLoad getCourseLoadByShiftType(ShiftType type) {
        if (type != null) {
            for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
                if (!courseLoad.getType().equals((Object)type)) continue;
                return courseLoad;
            }
        }
        return null;
    }

    public boolean hasCourseLoadForType(ShiftType type) {
        CourseLoad courseLoad = this.getCourseLoadByShiftType(type);
        return courseLoad != null && !courseLoad.isEmpty();
    }

    public boolean verifyNameEquality(String[] nameWords) {
        String courseName;
        if (nameWords != null && (courseName = this.getNome() + " " + this.getSigla()) != null) {
            int i;
            String[] courseNameWords = StringNormalizer.normalize((String)courseName).trim().split(" ");
            for (i = 0; i < nameWords.length; ++i) {
                int j;
                if (nameWords[i].equals("")) continue;
                for (j = 0; j < courseNameWords.length && !courseNameWords[j].equals(nameWords[i]); ++j) {
                }
                if (j != courseNameWords.length) continue;
                return false;
            }
            if (i == nameWords.length) {
                return true;
            }
        }
        return false;
    }

    public Set<Space> getAllRooms() {
        HashSet<Space> result = new HashSet<Space>();
        Set<Lesson> lessons = this.getLessons();
        for (Lesson lesson : lessons) {
            Space room = lesson.getSala();
            if (room == null) continue;
            result.add(room);
        }
        return result;
    }

    public String getLocalizedEvaluationMethodText() {
        EvaluationMethod evaluationMethod = this.getEvaluationMethod();
        if (evaluationMethod != null) {
            MultiLanguageString evaluationElements = evaluationMethod.getEvaluationElements();
            return evaluationElements.getContent();
        }
        for (CompetenceCourse competenceCourse : this.getCompetenceCourses()) {
            LocalizedString lstring = competenceCourse.getLocalizedEvaluationMethod(this.getExecutionPeriod());
            if (lstring == null) continue;
            return lstring.getContent();
        }
        return "";
    }

    public String getEvaluationMethodText() {
        if (this.getEvaluationMethod() != null) {
            MultiLanguageString evaluationElements = this.getEvaluationMethod().getEvaluationElements();
            return evaluationElements != null && evaluationElements.hasContent(MultiLanguageString.pt) ? evaluationElements.getContent(MultiLanguageString.pt) : (!this.getCompetenceCourses().isEmpty() ? this.getCompetenceCourses().iterator().next().getEvaluationMethod() : "");
        }
        return !this.getCompetenceCourses().isEmpty() ? this.getCompetenceCourses().iterator().next().getEvaluationMethod() : "";
    }

    public String getEvaluationMethodTextEn() {
        if (this.getEvaluationMethod() != null) {
            MultiLanguageString evaluationElements = this.getEvaluationMethod().getEvaluationElements();
            return evaluationElements != null && evaluationElements.hasContent(MultiLanguageString.en) ? evaluationElements.getContent(MultiLanguageString.en) : (!this.getCompetenceCourses().isEmpty() ? this.getCompetenceCourses().iterator().next().getEvaluationMethod() : "");
        }
        return !this.getCompetenceCourses().isEmpty() ? this.getCompetenceCourses().iterator().next().getEvaluationMethod() : "";
    }

    public Set<ExecutionCourseForum> getForuns() {
        return this.getForumSet();
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionPeriod().getAcademicInterval();
    }

    public static ExecutionCourse readBySiglaAndExecutionPeriod(String sigla, ExecutionSemester executionSemester) {
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            if (!sigla.equalsIgnoreCase(executionCourse.getSigla())) continue;
            return executionCourse;
        }
        return null;
    }

    public static ExecutionCourse readLastByExecutionYearAndSigla(String sigla, ExecutionYear executionYear) {
        TreeSet<ExecutionCourse> result = new TreeSet<ExecutionCourse>(EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR);
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
                if (!sigla.equalsIgnoreCase(executionCourse.getSigla())) continue;
                result.add(executionCourse);
            }
        }
        return result.isEmpty() ? null : (ExecutionCourse)((Object)result.last());
    }

    public static ExecutionCourse readLastBySigla(String sigla) {
        TreeSet<ExecutionCourse> result = new TreeSet<ExecutionCourse>(EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR);
        for (ExecutionCourse executionCourse : Bennu.getInstance().getExecutionCoursesSet()) {
            if (!sigla.equalsIgnoreCase(executionCourse.getSigla())) continue;
            result.add(executionCourse);
        }
        return result.isEmpty() ? null : (ExecutionCourse)((Object)result.last());
    }

    public static ExecutionCourse readLastByExecutionIntervalAndSigla(String sigla, ExecutionInterval executionInterval) {
        return executionInterval instanceof ExecutionSemester ? ExecutionCourse.readBySiglaAndExecutionPeriod(sigla, (ExecutionSemester)((Object)executionInterval)) : ExecutionCourse.readLastByExecutionYearAndSigla(sigla, (ExecutionYear)((Object)executionInterval));
    }

    public void setSigla(String sigla) {
        String code = sigla.replace(' ', '_').replace('/', '-');
        String uniqueCode = this.findUniqueCode(code);
        super.setSigla(uniqueCode);
    }

    private String findUniqueCode(String code) {
        if (!this.existsMatchingCode(code)) {
            return code;
        }
        int c = 0;
        while (this.existsMatchingCode(code + "-" + c)) {
            ++c;
        }
        return code + "-" + c;
    }

    private boolean existsMatchingCode(String code) {
        for (ExecutionCourse executionCourse : this.getExecutionPeriod().getAssociatedExecutionCoursesSet()) {
            if (executionCourse == this || !executionCourse.getSigla().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }

    public Collection<MarkSheet> getAssociatedMarkSheets() {
        HashSet<MarkSheet> markSheets = new HashSet<MarkSheet>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            markSheets.addAll(curricularCourse.getMarkSheetsByPeriod(this.getExecutionPeriod()));
        }
        return markSheets;
    }

    public Set<Exam> getPublishedExamsFor(CurricularCourse curricularCourse) {
        HashSet<Exam> result = new HashSet<Exam>();
        for (WrittenEvaluation eachEvaluation : this.getWrittenEvaluations()) {
            Exam exam;
            if (!eachEvaluation.isExam() || !(exam = (Exam)((Object)eachEvaluation)).isExamsMapPublished() || !exam.contains(curricularCourse)) continue;
            result.add(exam);
        }
        return result;
    }

    public List<AdHocEvaluation> getAssociatedAdHocEvaluations() {
        ArrayList<AdHocEvaluation> result = new ArrayList<AdHocEvaluation>();
        for (Evaluation evaluation : this.getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof AdHocEvaluation)) continue;
            result.add((AdHocEvaluation)((Object)evaluation));
        }
        return result;
    }

    public List<AdHocEvaluation> getOrderedAssociatedAdHocEvaluations() {
        List<AdHocEvaluation> associatedAdHocEvaluations = this.getAssociatedAdHocEvaluations();
        Collections.sort(associatedAdHocEvaluations, AdHocEvaluation.AD_HOC_EVALUATION_CREATION_DATE_COMPARATOR);
        return associatedAdHocEvaluations;
    }

    public boolean functionsAt(Space campus) {
        ExecutionYear executionYear = this.getExecutionYear();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getCampus() != campus || executionDegree.getExecutionYear() != executionYear) continue;
                return true;
            }
        }
        return false;
    }

    public Set<DegreeCurricularPlan> getAttendsDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> dcps = new HashSet<DegreeCurricularPlan>();
        for (Attends attends : this.getAttendsSet()) {
            dcps.add(attends.getStudentCurricularPlanFromAttends().getDegreeCurricularPlan());
        }
        return dcps;
    }

    public void searchAttends(SearchExecutionCourseAttendsBean attendsBean) {
        AccessControl.check(this, ExecutionCoursePredicates.executionCourseLecturingTeacherOrDegreeCoordinator);
        Predicate<Attends> filter = attendsBean.getFilters();
        HashSet<Attends> validAttends = new HashSet<Attends>();
        HashMap<Integer, Integer> enrolmentNumberMap = new HashMap<Integer, Integer>();
        for (Attends attends : this.getAttendsSet()) {
            if (!filter.test(attends)) continue;
            validAttends.add(attends);
            this.addAttendsToEnrolmentNumberMap(attends, enrolmentNumberMap);
        }
        attendsBean.setAttendsResult(validAttends);
        attendsBean.setEnrolmentsNumberMap(enrolmentNumberMap);
    }

    public void addAttendsToEnrolmentNumberMap(Attends attends, Map<Integer, Integer> enrolmentNumberMap) {
        Integer enrolmentsNumber = attends.getEnrolment() == null ? Integer.valueOf(0) : Integer.valueOf(attends.getEnrolment().getNumberOfTotalEnrolmentsInThisCourse(attends.getEnrolment().getExecutionPeriod()));
        Integer mapValue = enrolmentNumberMap.get(enrolmentsNumber);
        mapValue = mapValue == null ? Integer.valueOf(1) : Integer.valueOf(mapValue + 1);
        enrolmentNumberMap.put(enrolmentsNumber, mapValue);
    }

    public Collection<DegreeCurricularPlan> getAssociatedDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            result.add(curricularCourse.getDegreeCurricularPlan());
        }
        return result;
    }

    public List<WrittenEvaluation> getAssociatedWrittenEvaluationsForScopeAndContext(List<Integer> curricularYears, DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<WrittenEvaluation> result = new ArrayList<WrittenEvaluation>();
        for (WrittenEvaluation writtenEvaluation : this.getWrittenEvaluations()) {
            if (!writtenEvaluation.hasScopeOrContextFor(curricularYears, degreeCurricularPlan)) continue;
            result.add(writtenEvaluation);
        }
        return result;
    }

    public static List<ExecutionCourse> filterByAcademicIntervalAndDegreeCurricularPlanAndCurricularYearAndName(AcademicInterval academicInterval, DegreeCurricularPlan degreeCurricularPlan, CurricularYear curricularYear, String name) {
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        return executionSemester == null ? Collections.EMPTY_LIST : executionSemester.getExecutionCoursesByDegreeCurricularPlanAndSemesterAndCurricularYearAndName(degreeCurricularPlan, curricularYear, name);
    }

    public static Collection<ExecutionCourse> filterByAcademicInterval(AcademicInterval academicInterval) {
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        return executionSemester == null ? Collections.emptyList() : executionSemester.getAssociatedExecutionCoursesSet();
    }

    public static ExecutionCourse getExecutionCourseByInitials(AcademicInterval academicInterval, String courseInitials) {
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        return executionSemester.getExecutionCourseByInitials(courseInitials);
    }

    public static List<ExecutionCourse> searchByAcademicIntervalAndExecutionDegreeYearAndName(AcademicInterval academicInterval, ExecutionDegree executionDegree, CurricularYear curricularYear, String name) {
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        return executionSemester.getExecutionCoursesByDegreeCurricularPlanAndSemesterAndCurricularYearAndName(executionDegree.getDegreeCurricularPlan(), curricularYear, name);
    }

    public boolean isSplittable() {
        return this.getAssociatedCurricularCoursesSet().size() >= 2;
    }

    public boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    public Professorship getProfessorship(Person person) {
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (professorship.getPerson() != person) continue;
            return professorship;
        }
        return null;
    }

    public boolean isHasSender() {
        return this.getSender() != null;
    }

    public MultiLanguageString getNameI18N() {
        MultiLanguageString nameI18N = new MultiLanguageString();
        nameI18N = nameI18N.with(MultiLanguageString.pt, super.getNome());
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> names = new HashSet<String>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            String name;
            if (curricularCourse.getActiveDegreeModuleScopesInExecutionPeriod(this.getExecutionPeriod()).isEmpty() || names.contains(name = curricularCourse.getNameEn())) continue;
            names.add(name);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(name);
        }
        if (stringBuilder.length() > 0) {
            nameI18N = nameI18N.with(MultiLanguageString.en, stringBuilder.toString());
            return nameI18N;
        }
        boolean unique = true;
        String nameEn = this.getAssociatedCurricularCoursesSet().isEmpty() ? null : ((CurricularCourse)((Object)this.getAssociatedCurricularCoursesSet().iterator().next())).getNameEn();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.getNameEn() != null && curricularCourse.getNameEn().equals(nameEn)) continue;
            unique = false;
            break;
        }
        if (unique && nameEn != null) {
            nameI18N = nameI18N.with(MultiLanguageString.en, nameEn);
            return nameI18N;
        }
        nameI18N = nameI18N.with(MultiLanguageString.en, super.getNome());
        return nameI18N;
    }

    public Professorship getProfessorshipForCurrentUser() {
        return this.getProfessorship(AccessControl.getPerson());
    }

    public boolean hasAnyEnrolment(ExecutionDegree executionDegree) {
        for (Attends attend : this.getAttendsSet()) {
            ExecutionDegree studentExecutionDegree;
            StudentCurricularPlan scp;
            if (attend.getEnrolment() == null || (scp = attend.getRegistration().getStudentCurricularPlan(this.getExecutionPeriod())) == null || (studentExecutionDegree = scp.getDegreeCurricularPlan().getExecutionDegreeByYearAndCampus(this.getExecutionYear(), scp.getCampus(this.getExecutionYear()))) != executionDegree) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnrolmentsInAnyCurricularCourse() {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.hasEnrolmentForPeriod(this.getExecutionPeriod())) {
                return true;
            }
            if (!curricularCourse.isAnual() || this.getExecutionPeriod().getPreviousExecutionPeriod().getExecutionYear() != this.getExecutionYear() || !curricularCourse.hasEnrolmentForPeriod(this.getExecutionPeriod().getPreviousExecutionPeriod())) continue;
            return true;
        }
        return false;
    }

    public int getEnrolmentCount() {
        int result = 0;
        for (Attends attends : this.getAttendsSet()) {
            if (attends.getEnrolment() == null) continue;
            ++result;
        }
        return result;
    }

    public boolean isDissertation() {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.isDissertation()) continue;
            return true;
        }
        return false;
    }

    public void changeProjectTutorialCourse() {
        Object object = advice$changeProjectTutorialCourse.perform((Callable)new ExecutionCourse$callable$changeProjectTutorialCourse(this));
    }

    static /* synthetic */ void advised$changeProjectTutorialCourse(ExecutionCourse this_) {
        this_.setProjectTutorialCourse(this_.getProjectTutorialCourse() == false);
    }

    public void addAssociatedCurricularCourses(CurricularCourse curricularCourse) {
        Set executionCourses = curricularCourse.getAssociatedExecutionCoursesSet();
        for (ExecutionCourse executionCourse : executionCourses) {
            if (this == executionCourse || executionCourse.getExecutionPeriod() != this.getExecutionPeriod()) continue;
            throw new DomainException("error.executionCourse.curricularCourse.already.associated", new String[0]);
        }
        super.addAssociatedCurricularCourses(curricularCourse);
    }

    public void associateCurricularCourse(CurricularCourse curricularCourse) {
        Object object = advice$associateCurricularCourse.perform((Callable)new ExecutionCourse$callable$associateCurricularCourse(this, curricularCourse));
    }

    static /* synthetic */ void advised$associateCurricularCourse(ExecutionCourse this_, CurricularCourse curricularCourse) {
        this_.addAssociatedCurricularCourses(curricularCourse);
    }

    public void dissociateCurricularCourse(CurricularCourse curricularCourse) {
        Object object = advice$dissociateCurricularCourse.perform((Callable)new ExecutionCourse$callable$dissociateCurricularCourse(this, curricularCourse));
    }

    static /* synthetic */ void advised$dissociateCurricularCourse(ExecutionCourse this_, CurricularCourse curricularCourse) {
        super.removeAssociatedCurricularCourses(curricularCourse);
    }

    public Double getEctsCredits() {
        Double ects = null;
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.isActive(this.getExecutionPeriod())) continue;
            if (ects == null) {
                ects = curricularCourse.getEctsCredits();
                continue;
            }
            if (ects.equals(curricularCourse.getEctsCredits())) continue;
            throw new DomainException("error.invalid.ectsCredits", new String[0]);
        }
        return ects;
    }

    public Set<OccupationPeriod> getLessonPeriods() {
        TreeSet<OccupationPeriod> result = new TreeSet<OccupationPeriod>(new Comparator<OccupationPeriod>(){

            @Override
            public int compare(OccupationPeriod op1, OccupationPeriod op2) {
                int i = op1.getPeriodInterval().getStart().compareTo((ReadableInstant)op2.getPeriodInterval().getStart());
                return i == 0 ? op1.getExternalId().compareTo(op2.getExternalId()) : i;
            }
        });
        for (ExecutionDegree executionDegree : this.getExecutionDegrees()) {
            result.add(executionDegree.getPeriodLessons(this.getExecutionPeriod()));
        }
        return result;
    }

    static {
        advice$changeProjectTutorialCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$associateCurricularCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$dissociateCurricularCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR = new Comparator<ExecutionCourse>(){

            @Override
            public int compare(ExecutionCourse o1, ExecutionCourse o2) {
                return o1.getExecutionPeriod().compareTo(o2.getExecutionPeriod());
            }
        };
        EXECUTION_COURSE_NAME_COMPARATOR = new Comparator<ExecutionCourse>(){

            @Override
            public int compare(ExecutionCourse o1, ExecutionCourse o2) {
                int c = Collator.getInstance().compare(o1.getNome(), o2.getNome());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
            }
        };
        EXECUTION_COURSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME = new Comparator<ExecutionCourse>(){

            @Override
            public int compare(ExecutionCourse o1, ExecutionCourse o2) {
                int cep = o1.getExecutionPeriod().compareTo(o2.getExecutionPeriod());
                if (cep != 0) {
                    return cep;
                }
                int c = Collator.getInstance().compare(o1.getNome(), o2.getNome());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
            }
        };
        ExecutionCourse.getRelationCurricularCourseExecutionCourse().addListener((RelationListener)new CurricularCourseExecutionCourseListener());
        ExecutionCourse.getRelationCurricularCourseExecutionCourse().addListener((RelationListener)new RelationAdapter<ExecutionCourse, CurricularCourse>(){

            public void beforeAdd(ExecutionCourse executionCourse, CurricularCourse curricularCourse) {
                if (executionCourse != null && curricularCourse != null && executionCourse.getAssociatedCurricularCoursesSet().size() == 0) {
                    ExecutionCourse previous = null;
                    for (ExecutionCourse otherExecutionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        if (previous != null && !otherExecutionCourse.getExecutionPeriod().isAfter(previous.getExecutionPeriod())) continue;
                        previous = otherExecutionCourse;
                    }
                    if (previous != null) {
                        executionCourse.setProjectTutorialCourse(previous.getProjectTutorialCourse());
                    }
                }
            }
        });
        EVALUATION_COMPARATOR = new Comparator<Evaluation>(){

            @Override
            public int compare(Evaluation evaluation1, Evaluation evaluation2) {
                String evaluation1ComparisonString = this.evaluationComparisonString(evaluation1);
                String evaluation2ComparisonString = this.evaluationComparisonString(evaluation2);
                return evaluation1ComparisonString.compareTo(evaluation2ComparisonString);
            }

            private String evaluationComparisonString(Evaluation evaluation) {
                String evaluationTypeDistinguisher = evaluation instanceof AdHocEvaluation ? "0" : (evaluation instanceof Project ? "1" : (evaluation instanceof WrittenEvaluation ? "2" : (evaluation instanceof FinalEvaluation ? "Z" : "3")));
                return DateFormatUtil.format(evaluationTypeDistinguisher + "_yyyy/MM/dd", evaluation.getEvaluationDate()) + evaluation.getExternalId();
            }
        };
    }

    public class WeeklyWorkLoadView {
        final Interval executionPeriodInterval;
        final int numberOfWeeks;
        final Interval[] intervals;
        final int[] numberResponses;
        final int[] contactSum;
        final int[] autonomousStudySum;
        final int[] otherSum;
        final int[] totalSum;

        public WeeklyWorkLoadView(Interval executionPeriodInterval) {
            this.executionPeriodInterval = executionPeriodInterval;
            Period period = executionPeriodInterval.toPeriod();
            int extraWeek = period.getDays() > 0 ? 1 : 0;
            this.numberOfWeeks = (period.getYears() * 12 + period.getMonths()) * 4 + period.getWeeks() + extraWeek + 1;
            this.intervals = new Interval[this.numberOfWeeks];
            this.numberResponses = new int[this.numberOfWeeks];
            this.contactSum = new int[this.numberOfWeeks];
            this.autonomousStudySum = new int[this.numberOfWeeks];
            this.otherSum = new int[this.numberOfWeeks];
            this.totalSum = new int[this.numberOfWeeks];
            for (int i = 0; i < this.numberOfWeeks; ++i) {
                DateTime start = executionPeriodInterval.getStart().plusWeeks(i);
                DateTime end = start.plusWeeks(1);
                this.intervals[i] = new Interval((ReadableInstant)start, (ReadableInstant)end);
            }
        }

        public void add(Attends attends) {
            for (WeeklyWorkLoad weeklyWorkLoad : attends.getWeeklyWorkLoadsSet()) {
                int weekIndex = weeklyWorkLoad.getWeekOffset();
                if (!this.consistentAnswers(attends, weekIndex)) continue;
                int n = weekIndex;
                this.numberResponses[n] = this.numberResponses[n] + 1;
                Integer contact = weeklyWorkLoad.getContact();
                int n2 = weekIndex;
                this.contactSum[n2] = this.contactSum[n2] + (contact != null ? contact : 0);
                Integer autounomousStudy = weeklyWorkLoad.getAutonomousStudy();
                int n3 = weekIndex;
                this.autonomousStudySum[n3] = this.autonomousStudySum[n3] + (autounomousStudy != null ? autounomousStudy : 0);
                Integer other = weeklyWorkLoad.getOther();
                int n4 = weekIndex;
                this.otherSum[n4] = this.otherSum[n4] + (other != null ? other : 0);
                this.totalSum[weekIndex] = this.contactSum[weekIndex] + this.autonomousStudySum[weekIndex] + this.otherSum[weekIndex];
            }
        }

        private boolean consistentAnswers(Attends attends, int weekIndex) {
            int weeklyTotal = 0;
            for (Attends someAttends : attends.getRegistration().getAssociatedAttendsSet()) {
                for (WeeklyWorkLoad weeklyWorkLoad : someAttends.getWeeklyWorkLoadsSet()) {
                    if (weeklyWorkLoad.getWeekOffset() != weekIndex) continue;
                    weeklyTotal += weeklyWorkLoad.getTotal();
                }
            }
            return weeklyTotal <= 140;
        }

        public Interval[] getIntervals() {
            return this.intervals;
        }

        public Interval getExecutionPeriodInterval() {
            return this.executionPeriodInterval;
        }

        public int[] getContactSum() {
            return this.contactSum;
        }

        public int[] getAutonomousStudySum() {
            return this.autonomousStudySum;
        }

        public int[] getOtherSum() {
            return this.otherSum;
        }

        public int[] getNumberResponses() {
            return this.numberResponses;
        }

        public double[] getContactAverage() {
            return this.average(this.getContactSum(), this.getNumberResponses());
        }

        public double[] getAutonomousStudyAverage() {
            return this.average(this.getAutonomousStudySum(), this.getNumberResponses());
        }

        public double[] getOtherAverage() {
            return this.average(this.getOtherSum(), this.getNumberResponses());
        }

        public double[] getTotalAverage() {
            double[] valuesAverage = new double[this.numberOfWeeks];
            for (int i = 0; i < this.numberOfWeeks; ++i) {
                valuesAverage[i] = Math.round((0.0 + (double)this.getContactSum()[i] + (double)this.getAutonomousStudySum()[i] + (double)this.getOtherSum()[i]) / (double)this.getNumberResponses()[i]);
            }
            return valuesAverage;
        }

        private double[] average(int[] values, int[] divisor) {
            double[] valuesAverage = new double[this.numberOfWeeks];
            for (int i = 0; i < this.numberOfWeeks; ++i) {
                valuesAverage[i] = Math.round((0.0 + (double)values[i]) / (double)divisor[i]);
            }
            return valuesAverage;
        }

        private double add(double[] values) {
            double total = 0.0;
            for (double value : values) {
                total += value;
            }
            return total;
        }

        public double getContactAverageTotal() {
            return this.add(this.getContactAverage());
        }

        public double getAutonomousStudyAverageTotal() {
            return this.add(this.getAutonomousStudyAverage());
        }

        public double getOtherAverageTotal() {
            return this.add(this.getOtherAverage());
        }

        public double getTotalAverageTotal() {
            return this.add(this.getTotalAverage());
        }

        public int getNumberResponsesTotal() {
            int total = 0;
            for (int i = 0; i < this.getNumberResponses().length; ++i) {
                total += this.getNumberResponses()[i];
            }
            return total;
        }

        private int getNumberWeeksForAverageCalculation() {
            int currentWeekOffset;
            Attends attends;
            if (!ExecutionCourse.this.getAttendsSet().isEmpty() && (attends = ExecutionCourse.this.findAttendsWithEnrolment()) != null && (currentWeekOffset = attends.calculateCurrentWeekOffset()) > 0 && currentWeekOffset < this.numberOfWeeks) {
                return currentWeekOffset;
            }
            return this.numberOfWeeks;
        }

        public double getContactAverageTotalAverage() {
            int numberOfWeeks = this.getNumberWeeksForAverageCalculation();
            return numberOfWeeks > 0 ? (double)Math.round(this.getContactAverageTotal() / (double)numberOfWeeks) : 0.0;
        }

        public double getAutonomousStudyAverageTotalAverage() {
            int numberOfWeeks = this.getNumberWeeksForAverageCalculation();
            return numberOfWeeks > 0 ? (double)Math.round(this.getAutonomousStudyAverageTotal() / (double)this.getNumberWeeksForAverageCalculation()) : 0.0;
        }

        public double getOtherAverageTotalAverage() {
            int numberOfWeeks = this.getNumberWeeksForAverageCalculation();
            return numberOfWeeks > 0 ? (double)Math.round(this.getOtherAverageTotal() / (double)this.getNumberWeeksForAverageCalculation()) : 0.0;
        }

        public double getTotalAverageTotalAverage() {
            int numberOfWeeks = this.getNumberWeeksForAverageCalculation();
            return numberOfWeeks > 0 ? (double)Math.round(this.getTotalAverageTotal() / (double)this.getNumberWeeksForAverageCalculation()) : 0.0;
        }

        public double getNumberResponsesTotalAverage() {
            int numberOfWeeks = this.getNumberWeeksForAverageCalculation();
            return numberOfWeeks > 0 ? (double)Math.round((0.0 + (double)this.getNumberResponsesTotal()) / (double)this.getNumberWeeksForAverageCalculation()) : 0.0;
        }
    }

    private static class CurricularCourseExecutionCourseListener
    extends RelationAdapter<ExecutionCourse, CurricularCourse> {
        private CurricularCourseExecutionCourseListener() {
        }

        public void afterAdd(ExecutionCourse execution, CurricularCourse curricular) {
            for (Enrolment enrolment : curricular.getEnrolments()) {
                if (!enrolment.getExecutionPeriod().equals(execution.getExecutionPeriod())) continue;
                CurricularCourseExecutionCourseListener.associateAttend(enrolment, execution);
            }
            this.fillCourseLoads(execution, curricular);
        }

        public void afterRemove(ExecutionCourse execution, CurricularCourse curricular) {
            if (execution != null) {
                for (Attends attends : execution.getAttendsSet()) {
                    if (attends.getEnrolment() == null || !attends.getEnrolment().getCurricularCourse().equals((Object)curricular)) continue;
                    attends.setEnrolment(null);
                }
            }
        }

        private static void associateAttend(Enrolment enrolment, ExecutionCourse executionCourse) {
            if (!CurricularCourseExecutionCourseListener.alreadyHasAttend(enrolment, executionCourse.getExecutionPeriod())) {
                Attends attends = executionCourse.getAttendsByStudent(enrolment.getStudentCurricularPlan().getRegistration());
                if (attends == null) {
                    attends = new Attends(enrolment.getStudentCurricularPlan().getRegistration(), executionCourse);
                }
                enrolment.addAttends(attends);
            }
        }

        private static boolean alreadyHasAttend(Enrolment enrolment, ExecutionSemester executionSemester) {
            for (Attends attends : enrolment.getAttendsSet()) {
                if (!attends.getExecutionCourse().getExecutionPeriod().equals(executionSemester)) continue;
                return true;
            }
            return false;
        }

        private void fillCourseLoads(ExecutionCourse execution, CurricularCourse curricular) {
            for (ShiftType shiftType : ShiftType.values()) {
                CourseLoad courseLoad;
                BigDecimal totalHours = curricular.getTotalHoursByShiftType(shiftType, execution.getExecutionPeriod());
                if (totalHours == null || totalHours.compareTo(BigDecimal.ZERO) != 1 || (courseLoad = execution.getCourseLoadByShiftType(shiftType)) != null) continue;
                new CourseLoad(execution, shiftType, null, totalHours);
            }
        }
    }
}

