/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.District;
import org.fenixedu.academic.domain.DistrictSubdivision_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;

public class DistrictSubdivision
extends DistrictSubdivision_Base {
    public static Comparator<DistrictSubdivision> COMPARATOR_BY_NAME = new Comparator<DistrictSubdivision>(){

        @Override
        public int compare(DistrictSubdivision leftDistrictSubdivision, DistrictSubdivision rightDistrictSubdivision) {
            int comparationResult = leftDistrictSubdivision.getName().compareTo(rightDistrictSubdivision.getName());
            return comparationResult == 0 ? leftDistrictSubdivision.getExternalId().compareTo(rightDistrictSubdivision.getExternalId()) : comparationResult;
        }
    };

    private DistrictSubdivision() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    public DistrictSubdivision(String code, String name, District district) {
        this();
        this.init(code, name, district);
    }

    private void init(String code, String name, District district) {
        this.checkParameters(code, name, district);
        super.setCode(code);
        super.setName(name);
        super.setDistrict(district);
    }

    private void checkParameters(String code, String name, District district) {
        if (code == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.DistrictSubdivision.code.cannot.be.null", new String[0]);
        }
        if (name == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.DistrictSubdivision.name.cannot.be.null", new String[0]);
        }
        if (district == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.DistrictSubdivision.district.cannot.be.null", new String[0]);
        }
    }

    public static Collection<DistrictSubdivision> findByName(String name, int size) {
        String normalizedName = StringNormalizer.normalize((String)name);
        TreeSet<DistrictSubdivision> result = new TreeSet<DistrictSubdivision>(COMPARATOR_BY_NAME);
        for (DistrictSubdivision districtSubdivision : Bennu.getInstance().getDistrictSubdivisionsSet()) {
            if (!StringNormalizer.normalize((String)districtSubdivision.getName()).contains(normalizedName)) continue;
            result.add(districtSubdivision);
            if (result.size() < size) continue;
            break;
        }
        return result;
    }

    public static DistrictSubdivision readByCode(String code) {
        DistrictSubdivision result = null;
        if (!StringUtils.isEmpty((String)code)) {
            for (DistrictSubdivision iter : Bennu.getInstance().getDistrictSubdivisionsSet()) {
                if (!iter.getCode().equalsIgnoreCase(code)) continue;
                result = iter;
            }
        }
        return result;
    }
}

