/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;

public class ExecutionDegreesFormat {
    public static List<LabelValueBean> buildLabelValueBeansForExecutionDegree(List<ExecutionDegree> executionDegrees) {
        ArrayList<LabelValueBean> result = new ArrayList<LabelValueBean>();
        for (ExecutionDegree executionDegree : executionDegrees) {
            ExecutionYear executionYear = executionDegree.getExecutionYear();
            String degreeName = executionDegree.getDegree().getNameFor(executionYear).getContent();
            String degreeType = executionDegree.getDegreeCurricularPlan().getDegreeType().getName().getContent();
            String name = degreeType + " em " + degreeName;
            name = name + (ExecutionDegreesFormat.addDegreeCurricularPlanName(executionDegree, executionDegrees) ? " - " + executionDegree.getDegreeCurricularPlan().getName() : "");
            result.add(new LabelValueBean(name, executionDegree.getExternalId().toString()));
        }
        return result;
    }

    private static boolean addDegreeCurricularPlanName(ExecutionDegree selectedExecutionDegree, List<ExecutionDegree> executionDegrees) {
        for (ExecutionDegree executionDegree : executionDegrees) {
            if (executionDegree.getDegree() != selectedExecutionDegree.getDegree() || executionDegree == selectedExecutionDegree) continue;
            return true;
        }
        return false;
    }
}

