/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.coordinator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanRendererConfig;
import org.fenixedu.academic.ui.struts.action.coordinator.CoordinatorApplication;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;

@StrutsFunctionality(app=CoordinatorApplication.CoordinatorPhdApp.class, path="enrolments-management", titleKey="label.externalUnits.externalEnrolments", bundle="AcademicAdminOffice")
@Mapping(path="/phdEnrolmentsManagement", module="coordinator")
@Forwards(value={@Forward(name="showPhdProgram", path="/phd/coordinator/enrolments/showPhdProgram.jsp"), @Forward(name="showEnrolments", path="/phd/coordinator/enrolments/showEnrolments.jsp")})
public class PhdEnrolmentsManagementDA
extends PhdProcessDA {
    private Set<PhdProgram> getManagedPhdPrograms(HttpServletRequest request) {
        HashSet<PhdProgram> result = new HashSet<PhdProgram>();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (Coordinator coordinator : this.getLoggedPerson(request).getCoordinatorsSet()) {
            if (coordinator.getExecutionDegree().getDegree().getPhdProgram() == null || coordinator.getExecutionDegree().getExecutionYear() != currentExecutionYear) continue;
            result.add(coordinator.getExecutionDegree().getDegree().getPhdProgram());
        }
        return result;
    }

    @EntryPoint
    public ActionForward showPhdProgram(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram program = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramOid"));
        if (program != null) {
            this.initPhdProgramConfig(request, program);
            return mapping.findForward("showPhdProgram");
        }
        Set<PhdProgram> phdPrograms = this.getManagedPhdPrograms(request);
        if (phdPrograms.size() == 1) {
            this.initPhdProgramConfig(request, phdPrograms.iterator().next());
            return mapping.findForward("showPhdProgram");
        }
        request.setAttribute("phdPrograms", phdPrograms);
        return mapping.findForward("showPhdProgram");
    }

    private void initPhdProgramConfig(HttpServletRequest request, PhdProgram program) {
        DegreeCurricularPlanRendererConfig config = new DegreeCurricularPlanRendererConfig();
        config.setDegreeCurricularPlan(program.getDegree().getLastActiveDegreeCurricularPlan());
        config.setExecutionInterval(ExecutionYear.readCurrentExecutionYear());
        config.setOrganizeBy(DegreeCurricularPlanRendererConfig.OrganizeType.GROUPS);
        config.setViewCurricularCourseUrl(((Object)((Object)this)).getClass().getAnnotation(Mapping.class).path() + ".do");
        config.addViewCurricularCourseUrlParameter("method", "manageEnrolments");
        request.setAttribute("rendererConfig", (Object)config);
        request.setAttribute("phdProgram", (Object)program);
    }

    public ActionForward changeDegreeCurricularPlanConfig(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlanRendererConfig config = (DegreeCurricularPlanRendererConfig)this.getRenderedObject("rendererConfig");
        request.setAttribute("rendererConfig", (Object)config);
        request.setAttribute("phdProgram", (Object)config.getDegreeCurricularPlan().getDegree().getPhdProgram());
        return mapping.findForward("showPhdProgram");
    }

    public ActionForward exportEnrolmentsToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterOid");
        CurricularCourse curricularCourse = (CurricularCourse)((Object)this.getDomainObject(request, "degreeModuleOid"));
        byte[] content = this.buildSpreadsheet(curricularCourse, semester);
        this.writeFile(response, this.getFileName(curricularCourse, semester), "application/vnd.ms-excel", content);
        return null;
    }

    private byte[] buildSpreadsheet(CurricularCourse curricularCourse, ExecutionSemester semester) throws IOException {
        List<Enrolment> enrolments = curricularCourse.getEnrolmentsByAcademicInterval(semester.getAcademicInterval());
        Collections.sort(enrolments, new Comparator<Enrolment>(){

            @Override
            public int compare(Enrolment o1, Enrolment o2) {
                return o1.getPerson().getName().compareTo(o2.getPerson().getName());
            }
        });
        SpreadsheetBuilder builder = new SpreadsheetBuilder();
        builder.addSheet(semester.getQualifiedName().replace("/", "_"), (SheetData)new SheetData<Enrolment>(enrolments){

            protected void makeLine(Enrolment enrolment) {
                this.addCell(PhdEnrolmentsManagementDA.this.getMessageFromResource("label.phd.number", new String[0]), enrolment.getRegistration().getNumber());
                this.addCell(PhdEnrolmentsManagementDA.this.getMessageFromResource("label.phd.name", new String[0]), enrolment.getPerson().getName());
                this.addCell(PhdEnrolmentsManagementDA.this.getMessageFromResource("label.phd.email", new String[0]), enrolment.getPerson().getInstitutionalOrDefaultEmailAddressValue());
            }
        });
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        builder.build(WorkbookExportFormat.EXCEL, (OutputStream)output);
        return output.toByteArray();
    }

    private String getFileName(CurricularCourse curricularCourse, ExecutionSemester semester) {
        return curricularCourse.getName(semester).replace(" ", "_") + ".xls";
    }

    public ActionForward manageEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        if (bean == null) {
            bean = new ManageEnrolmentsBean();
            bean.setSemester(ExecutionSemester.readActualExecutionSemester());
            bean.setCurricularCourse((CurricularCourse)((Object)this.getDomainObject(request, "degreeModuleOid")));
        }
        this.filterEnrolments(bean);
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        return mapping.findForward("showEnrolments");
    }

    private void filterEnrolments(ManageEnrolmentsBean bean) {
        bean.setRemainingEnrolments(bean.getCurricularCourse().getEnrolmentsByAcademicInterval(bean.getSemester().getAcademicInterval()));
    }
}

