/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.payments;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPR;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPaymentPeriod;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPriceQuirk;
import org.fenixedu.academic.ui.struts.action.manager.payments.PhdPostingRulesManagementDA$callable$makeGratuityPostingRule;
import org.fenixedu.academic.ui.struts.action.manager.payments.PostingRulesManagementDA;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Mapping(path="/phdPostingRules", module="manager", formBeanClass=PostingRulesManagementDA.PostingRulesManagementForm.class, functionality=PostingRulesManagementDA.class)
@Forwards(value={@Forward(name="showPhdProgramPostingRules", path="/manager/payments/postingRules/management/phd/showPhdProgramPostingRules.jsp"), @Forward(name="viewPostingRuleDetails", path="/manager/payments/postingRules/management/phd/viewPostingRuleDetails.jsp"), @Forward(name="editPhdProgramPostingRule", path="/manager/payments/postingRules/management/phd/editPhdProgramPostingRule.jsp"), @Forward(name="addPhdProgramPostingRule", path="/manager/payments/postingRules/management/phd/addPhdProgramPostingRule.jsp")})
public class PhdPostingRulesManagementDA
extends PostingRulesManagementDA {
    public static final Integer STANDARD_GRATUITY;
    public static final Double STANDARD_FINE_RATE;
    public static final Advice advice$makeGratuityPostingRule;

    public ActionForward showPhdProgramPostingRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        request.setAttribute("phdProgram", (Object)phdProgram);
        return mapping.findForward("showPhdProgramPostingRules");
    }

    @Override
    public ActionForward viewPostingRuleDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdProgram", this.getDomainObject(request, "phdProgramId"));
        request.setAttribute("postingRule", (Object)this.getPostingRule(request));
        return mapping.findForward("viewPostingRuleDetails");
    }

    public ActionForward prepareAddGratuityPhdPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        CreateGratuityPhdPRPeriodBean period = (CreateGratuityPhdPRPeriodBean)this.getRenderedObject("period");
        CreateGratuityPhdPRQuickBean quirks = (CreateGratuityPhdPRQuickBean)this.getRenderedObject("quirks");
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("bean", (Object)(bean == null ? new CreateGratuityPhdBean() : bean));
        request.setAttribute("period", (Object)(period == null ? new CreateGratuityPhdPRPeriodBean() : period));
        request.setAttribute("quirks", (Object)(quirks == null ? new CreateGratuityPhdPRQuickBean() : quirks));
        return mapping.findForward("addPhdProgramPostingRule");
    }

    public ActionForward addPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateGratuityPhdPRPeriodBean period = (CreateGratuityPhdPRPeriodBean)this.getRenderedObject("period");
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        CreateGratuityPhdPRQuickBean quirks = (CreateGratuityPhdPRQuickBean)this.getRenderedObject("quirks");
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        if (period.periodEndDate == null || period.periodStartDate == null || period.limitePaymentDay == null) {
            this.addErrorMessage(request, "bean", "error.missing.field.in.period.form", new Object[0]);
            return this.prepareAddGratuityPhdPostingRule(mapping, form, request, response);
        }
        Interval created = period.toInterval();
        if (period.getStartAsDateTime().isAfter((ReadableInstant)period.getEndAsDateTime())) {
            this.addErrorMessage(request, "bean", "error.end.before.start", new Object[0]);
            return this.backToAddPeriod(mapping, request, period, bean, phdProgram, quirks);
        }
        for (CreateGratuityPhdPRPeriodBean previousPeriod : bean.getPeriods()) {
            if (previousPeriod.toInterval().overlap((ReadableInterval)created) == null) continue;
            this.addErrorMessage(request, "bean", "error.intervals.overlap", new Object[0]);
            return this.backToAddPeriod(mapping, request, period, bean, phdProgram, quirks);
        }
        bean.getPeriods().add(period);
        RenderUtils.invalidateViewState((String)"phdProgram");
        request.setAttribute("phdProgram", (Object)phdProgram);
        RenderUtils.invalidateViewState((String)"bean");
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState((String)"period");
        request.setAttribute("period", (Object)new CreateGratuityPhdPRPeriodBean());
        return mapping.findForward("addPhdProgramPostingRule");
    }

    public ActionForward removePeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        int index = Integer.parseInt(request.getParameter("periodToRemove"));
        bean.periods.remove(index);
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("bean", (Object)bean);
        request.setAttribute("period", (Object)new CreateGratuityPhdPRPeriodBean());
        return mapping.findForward("addPhdProgramPostingRule");
    }

    public ActionForward addQuirk(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        CreateGratuityPhdPRPeriodBean period = (CreateGratuityPhdPRPeriodBean)this.getRenderedObject("period");
        CreateGratuityPhdPRQuickBean quirks = (CreateGratuityPhdPRQuickBean)this.getRenderedObject("quirks");
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        bean.getExceptions().add(quirks);
        return this.backToAddPeriod(mapping, request, period, bean, phdProgram, new CreateGratuityPhdPRQuickBean());
    }

    public ActionForward removeQuirk(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        CreateGratuityPhdPRPeriodBean period = (CreateGratuityPhdPRPeriodBean)this.getRenderedObject("period");
        CreateGratuityPhdPRQuickBean quirks = (CreateGratuityPhdPRQuickBean)this.getRenderedObject("quirks");
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        int index = Integer.parseInt(request.getParameter("quirkToRemove"));
        bean.getExceptions().remove(index);
        return this.backToAddPeriod(mapping, request, period, bean, phdProgram, quirks);
    }

    private ActionForward backToAddPeriod(ActionMapping mapping, HttpServletRequest request, CreateGratuityPhdPRPeriodBean period, CreateGratuityPhdBean bean, PhdProgram phdProgram, Object quirks) {
        RenderUtils.invalidateViewState((String)"phdProgram");
        request.setAttribute("phdProgram", (Object)phdProgram);
        RenderUtils.invalidateViewState((String)"bean");
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState((String)"period");
        request.setAttribute("period", (Object)period);
        RenderUtils.invalidateViewState((String)"quirks");
        request.setAttribute("quirks", quirks);
        return mapping.findForward("addPhdProgramPostingRule");
    }

    private void makeGratuityPostingRule(CreateGratuityPhdBean createGratuityPhdBean, PhdProgram phdProgram) {
        Object object = advice$makeGratuityPostingRule.perform((Callable)new PhdPostingRulesManagementDA$callable$makeGratuityPostingRule(this, createGratuityPhdBean, phdProgram));
    }

    static /* synthetic */ void advised$makeGratuityPostingRule(PhdPostingRulesManagementDA this_, CreateGratuityPhdBean bean, PhdProgram phdProgram) {
        if (bean.getPeriods().size() == 0) {
            throw new RuntimeException("error.empty.periods");
        }
        PhdGratuityPR postingRule = new PhdGratuityPR(bean.getStartDate(), bean.getEndDate(), (ServiceAgreementTemplate)((Object)phdProgram.getServiceAgreementTemplate()), new Money(bean.getGratuity().intValue()), bean.getFineRate());
        for (CreateGratuityPhdPRPeriodBean periodBean : bean.getPeriods()) {
            PhdGratuityPaymentPeriod period = new PhdGratuityPaymentPeriod(periodBean.getPeriodStartDate(), periodBean.getPeriodEndDate(), periodBean.getLimitePaymentDay());
            postingRule.addPhdGratuityPaymentPeriods(period);
            period.setRootDomainObject(Bennu.getInstance());
        }
        for (CreateGratuityPhdPRQuickBean quirkBean : bean.getExceptions()) {
            PhdGratuityPriceQuirk quirk = new PhdGratuityPriceQuirk(quirkBean.getYear(), new Money(quirkBean.getGratuity().intValue()));
            postingRule.addPhdGratuityPriceQuirks(quirk);
            quirk.setRootDomainObject(Bennu.getInstance());
        }
        postingRule.setRootDomainObject(Bennu.getInstance());
    }

    public ActionForward addGratuityPhdPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        CreateGratuityPhdBean bean = (CreateGratuityPhdBean)this.getRenderedObject("bean");
        try {
            this.makeGratuityPostingRule(bean, phdProgram);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "bean", e.getMessage(), new Object[0]);
            return this.prepareAddGratuityPhdPostingRule(mapping, form, request, response);
        }
        catch (RuntimeException e) {
            this.addErrorMessage(request, "bean", e.getMessage(), new Object[0]);
            return this.prepareAddGratuityPhdPostingRule(mapping, form, request, response);
        }
        return this.showPhdProgramPostingRules(mapping, form, request, response);
    }

    @Override
    protected PostingRule getPostingRule(HttpServletRequest request) {
        return (PostingRule)((Object)this.getDomainObject(request, "postingRuleId"));
    }

    public ActionForward prepareEditPhdProgramPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PostingRule postingRule = this.getPostingRule(request);
        request.setAttribute("phdProgram", this.getDomainObject(request, "phdProgramId"));
        request.setAttribute("postingRule", (Object)postingRule);
        return mapping.findForward("editPhdProgramPostingRule");
    }

    public ActionForward editPhdProgramPostingRuleInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdProgram", this.getDomainObject(request, "phdProgramId"));
        request.setAttribute("postingRule", this.getRenderedObject("postingRule"));
        return mapping.findForward("editPhdProgramPostingRule");
    }

    static {
        advice$makeGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        STANDARD_GRATUITY = 3000;
        STANDARD_FINE_RATE = 0.01;
    }

    public static class CreateGratuityPhdBean
    implements Serializable {
        DateTime startDate = new DateTime();
        DateTime endDate;
        Integer gratuity = STANDARD_GRATUITY;
        Double fineRate = STANDARD_FINE_RATE;
        private List<CreateGratuityPhdPRPeriodBean> periods = new ArrayList<CreateGratuityPhdPRPeriodBean>();
        private List<CreateGratuityPhdPRQuickBean> exceptions = new ArrayList<CreateGratuityPhdPRQuickBean>();

        public DateTime getStartDate() {
            return this.startDate;
        }

        public void setStartDate(DateTime startDate) {
            this.startDate = startDate;
        }

        public DateTime getEndDate() {
            return this.endDate;
        }

        public void setEndDate(DateTime endDate) {
            this.endDate = endDate;
        }

        public Integer getGratuity() {
            return this.gratuity;
        }

        public void setGratuity(Integer gratuity) {
            this.gratuity = gratuity;
        }

        public Double getFineRate() {
            return this.fineRate;
        }

        public void setFineRate(Double fineRate) {
            this.fineRate = fineRate;
        }

        public List<CreateGratuityPhdPRPeriodBean> getPeriods() {
            return this.periods;
        }

        public void setPeriods(List<CreateGratuityPhdPRPeriodBean> periods) {
            this.periods = periods;
        }

        public List<CreateGratuityPhdPRQuickBean> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(List<CreateGratuityPhdPRQuickBean> exceptions) {
            this.exceptions = exceptions;
        }
    }

    public static class CreateGratuityPhdPRPeriodBean
    implements Serializable {
        Partial periodStartDate;
        Partial periodEndDate;
        Partial limitePaymentDay;

        public Partial getPeriodStartDate() {
            return this.periodStartDate;
        }

        public void setPeriodStartDate(Partial periodStartDate) {
            this.periodStartDate = periodStartDate;
        }

        public Partial getPeriodEndDate() {
            return this.periodEndDate;
        }

        public void setPeriodEndDate(Partial periodEndDate) {
            this.periodEndDate = periodEndDate;
        }

        public Partial getLimitePaymentDay() {
            return this.limitePaymentDay;
        }

        public void setLimitePaymentDay(Partial limitePaymentDay) {
            this.limitePaymentDay = limitePaymentDay;
        }

        public String getPeriodStartString() {
            return this.periodStartDate.toString("d/M");
        }

        public String getPeriodEndString() {
            return this.periodEndDate.toString("d/M");
        }

        public String getLimitePaymentDayString() {
            return this.limitePaymentDay.toString("d/M");
        }

        public DateTime getStartAsDateTime() {
            return new DateTime(new DateTime().getYear(), this.getPeriodStartDate().get(DateTimeFieldType.monthOfYear()), this.getPeriodStartDate().get(DateTimeFieldType.dayOfMonth()), 0, 0, 0, 0);
        }

        public DateTime getEndAsDateTime() {
            return new DateTime(new DateTime().getYear(), this.getPeriodEndDate().get(DateTimeFieldType.monthOfYear()), this.getPeriodEndDate().get(DateTimeFieldType.dayOfMonth()), 0, 0, 0, 0);
        }

        private Interval toInterval() {
            DateTime start = this.getStartAsDateTime();
            DateTime end = this.getEndAsDateTime();
            return new Interval((ReadableInstant)start, (ReadableInstant)end);
        }
    }

    public static class CreateGratuityPhdPRQuickBean
    implements Serializable {
        Integer year;
        Integer gratuity;

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }

        public Integer getGratuity() {
            return this.gratuity;
        }

        public void setGratuity(Integer gratuity) {
            this.gratuity = gratuity;
        }
    }
}

