/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.lists;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.academicAdministration.SearchStudentsByDegreeParametersBean;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.dto.student.RegistrationWithStateForExecutionYearBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminListingsApp.class, path="students-by-degree", titleKey="link.studentsListByDegree", accessGroup="academic(STUDENT_LISTINGS)")
@Mapping(path="/studentsListByDegree", module="academicAdministration")
@Forwards(value={@Forward(name="searchRegistrations", path="/academicAdminOffice/lists/searchRegistrationsByDegree.jsp")})
public class StudentListByDegreeDA
extends FenixDispatchAction {
    private static final String YMD_FORMAT = "yyyy-MM-dd";

    @EntryPoint
    public ActionForward prepareByDegree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchParametersBean", (Object)this.getOrCreateSearchParametersBean());
        return mapping.findForward("searchRegistrations");
    }

    public ActionForward postBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SearchStudentsByDegreeParametersBean searchParametersBean = this.getOrCreateSearchParametersBean();
        RenderUtils.invalidateViewState();
        request.setAttribute("searchParametersBean", (Object)searchParametersBean);
        return mapping.findForward("searchRegistrations");
    }

    private SearchStudentsByDegreeParametersBean getOrCreateSearchParametersBean() {
        SearchStudentsByDegreeParametersBean bean = (SearchStudentsByDegreeParametersBean)this.getRenderedObject("searchParametersBean");
        if (bean == null) {
            Set<DegreeType> degreeTypesForOperation = AcademicAccessRule.getDegreeTypesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet());
            bean = new SearchStudentsByDegreeParametersBean(degreeTypesForOperation, AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet()));
        }
        return bean;
    }

    public ActionForward searchByDegree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SearchStudentsByDegreeParametersBean searchBean = this.getOrCreateSearchParametersBean();
        List<RegistrationWithStateForExecutionYearBean> registrations = StudentListByDegreeDA.search(searchBean);
        request.setAttribute("searchParametersBean", (Object)searchBean);
        request.setAttribute("studentCurricularPlanList", registrations);
        return mapping.findForward("searchRegistrations");
    }

    private static List<RegistrationWithStateForExecutionYearBean> search(SearchStudentsByDegreeParametersBean searchbean) {
        TreeSet<Registration> registrations = new TreeSet<Registration>((Comparator<Registration>)Registration.COMPARATOR_BY_NUMBER_AND_ID);
        Degree chosenDegree = searchbean.getDegree();
        DegreeType chosenDegreeType = searchbean.getDegreeType();
        ExecutionYear executionYear = searchbean.getExecutionYear();
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            if (chosenDegreeType != null && degreeCurricularPlan.getDegreeType() != chosenDegreeType || chosenDegree != null && degreeCurricularPlan.getDegree() != chosenDegree || !degreeCurricularPlan.getDegreeType().isEmpty() && (!searchbean.getAdministratedDegreeTypes().contains(degreeCurricularPlan.getDegreeType()) || !searchbean.getAdministratedDegrees().contains(degreeCurricularPlan.getDegree()))) continue;
            degreeCurricularPlan.getRegistrations(executionYear, registrations);
        }
        DegreeCurricularPlan emptyDegreeCurricularPlan = DegreeCurricularPlan.readEmptyDegreeCurricularPlan();
        if (chosenDegreeType == null || emptyDegreeCurricularPlan.getDegreeType() == chosenDegreeType) {
            emptyDegreeCurricularPlan.getRegistrations(executionYear, registrations);
        }
        return StudentListByDegreeDA.filterResults(searchbean, registrations, executionYear);
    }

    private static List<RegistrationWithStateForExecutionYearBean> filterResults(SearchStudentsByDegreeParametersBean searchBean, Set<Registration> registrations, ExecutionYear executionYear) {
        ArrayList<RegistrationWithStateForExecutionYearBean> result = new ArrayList<RegistrationWithStateForExecutionYearBean>();
        for (Registration registration : registrations) {
            Stream<ProgramConclusion> conclusions;
            RegistrationState lastRegistrationState;
            if (searchBean.hasAnyRegistrationProtocol() && !searchBean.getRegistrationProtocols().contains(registration.getRegistrationProtocol()) || searchBean.hasAnyStudentStatuteType() && !StudentListByDegreeDA.hasStudentStatuteType(searchBean, registration) || (lastRegistrationState = registration.getLastRegistrationState(executionYear)) == null || searchBean.hasAnyRegistrationStateTypes() && !searchBean.getRegistrationStateTypes().contains((Object)lastRegistrationState.getStateType()) || searchBean.isIngressedInChosenYear() && registration.getIngressionYear() != executionYear || searchBean.isConcludedInChosenYear() && (conclusions = ProgramConclusion.conclusionsFor(registration).filter(ProgramConclusion::isTerminal)).allMatch(programConclusion -> {
                RegistrationConclusionBean conclusionBean = new RegistrationConclusionBean(registration, (ProgramConclusion)((Object)programConclusion));
                return conclusionBean.getCurriculumGroup() == null || !conclusionBean.isConcluded() || conclusionBean.getConclusionYear() != executionYear;
            }) || searchBean.getActiveEnrolments() && !registration.hasAnyEnrolmentsIn(executionYear) || searchBean.getStandaloneEnrolments() && !registration.hasAnyStandaloneEnrolmentsIn(executionYear) || searchBean.getRegime() != null && registration.getRegimeType(executionYear) != searchBean.getRegime() || searchBean.getNationality() != null && registration.getPerson().getCountry() != searchBean.getNationality() || searchBean.getIngressionType() != null && registration.getIngressionType() != searchBean.getIngressionType()) continue;
            result.add(new RegistrationWithStateForExecutionYearBean(registration, lastRegistrationState.getStateType(), executionYear));
        }
        return result;
    }

    private static boolean hasStudentStatuteType(SearchStudentsByDegreeParametersBean searchBean, Registration registration) {
        return CollectionUtils.containsAny(searchBean.getStudentStatuteTypes(), registration.getStudent().getStatutesTypesValidOnAnyExecutionSemesterFor(searchBean.getExecutionYear()));
    }

    public ActionForward exportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SearchStudentsByDegreeParametersBean searchBean = this.getOrCreateSearchParametersBean();
        if (searchBean == null) {
            return null;
        }
        List<RegistrationWithStateForExecutionYearBean> registrations = StudentListByDegreeDA.search(searchBean);
        try {
            String filename = StudentListByDegreeDA.getResourceMessage("label.students");
            Degree degree = searchBean.getDegree();
            DegreeType degreeType = searchBean.getDegreeType();
            ExecutionYear executionYear = searchBean.getExecutionYear();
            if (degree != null) {
                filename = filename + "_" + degree.getNameFor(executionYear).getContent().replace(' ', '_');
            } else if (degreeType != null) {
                filename = filename + "_" + degreeType.getName().getContent().replace(' ', '_');
            }
            filename = filename + "_" + executionYear.getYear();
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
            ServletOutputStream writer = response.getOutputStream();
            String param = request.getParameter("extendedInfo");
            boolean extendedInfo = param != null && param.length() > 0 && Boolean.valueOf(param) != false;
            this.exportToXls(registrations, (OutputStream)writer, searchBean, extendedInfo);
            writer.flush();
            response.flushBuffer();
            return null;
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
    }

    private void exportToXls(List<RegistrationWithStateForExecutionYearBean> registrationList, OutputStream outputStream, SearchStudentsByDegreeParametersBean searchBean, boolean extendedInfo) throws IOException {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(StudentListByDegreeDA.getResourceMessage("lists.studentByDegree.unspaced"));
        this.fillSpreadSheetFilters(searchBean, spreadsheet);
        this.fillSpreadSheetResults(registrationList, spreadsheet, searchBean.getExecutionYear(), extendedInfo);
        spreadsheet.getWorkbook().write(outputStream);
    }

    private void fillSpreadSheetFilters(SearchStudentsByDegreeParametersBean searchBean, StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newHeaderRow();
        if (searchBean.isIngressedInChosenYear()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.ingressedInChosenYear"));
        }
        spreadsheet.newHeaderRow();
        if (searchBean.isConcludedInChosenYear()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.concludedInChosenYear"));
        }
        spreadsheet.newHeaderRow();
        if (searchBean.getActiveEnrolments()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.activeEnrolments.capitalized"));
        }
        spreadsheet.newHeaderRow();
        if (searchBean.getStandaloneEnrolments()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.withStandaloneEnrolments"));
        }
        spreadsheet.newHeaderRow();
        if (searchBean.getRegime() != null) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("registration.regime") + ": " + searchBean.getRegime().getLocalizedName());
        }
        spreadsheet.newHeaderRow();
        if (searchBean.getNationality() != null) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.nationality") + ": " + searchBean.getNationality().getName());
        }
        spreadsheet.newHeaderRow();
        if (searchBean.getIngressionType() != null) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.ingression.short") + ": " + searchBean.getIngressionType().getLocalizedName(Locale.getDefault()));
        }
        spreadsheet.newHeaderRow();
        if (searchBean.hasAnyRegistrationProtocol()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registrationAgreement") + ":");
            for (RegistrationProtocol protocol : searchBean.getRegistrationProtocols()) {
                spreadsheet.addHeader(protocol.getDescription().getContent());
            }
        }
        spreadsheet.newHeaderRow();
        if (searchBean.hasAnyRegistrationStateTypes()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registrationState") + ":");
            for (RegistrationStateType state : searchBean.getRegistrationStateTypes()) {
                spreadsheet.addHeader(state.getDescription());
            }
        }
        spreadsheet.newHeaderRow();
        if (searchBean.hasAnyStudentStatuteType()) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.statutes") + ":");
            for (StatuteType statute : searchBean.getStudentStatuteTypes()) {
                spreadsheet.addHeader(statute.getName().getContent());
            }
        }
    }

    private void fillSpreadSheetResults(List<RegistrationWithStateForExecutionYearBean> registrations, StyledExcelSpreadsheet spreadsheet, ExecutionYear executionYear, boolean extendedInfo) {
        spreadsheet.newRow();
        spreadsheet.newRow();
        spreadsheet.addCell((Object)(registrations.size() + " " + StudentListByDegreeDA.getResourceMessage("label.students")));
        this.setHeaders(spreadsheet, extendedInfo);
        for (RegistrationWithStateForExecutionYearBean registrationWithStateForExecutionYearBean : registrations) {
            Registration registration = registrationWithStateForExecutionYearBean.getRegistration();
            spreadsheet.newRow();
            Degree degree = registration.getDegree();
            spreadsheet.addCell((Object)(!StringUtils.isEmpty((String)degree.getSigla()) ? degree.getSigla() : degree.getNameFor(executionYear).toString()));
            spreadsheet.addCell((Object)degree.getFilteredName(executionYear));
            spreadsheet.addCell((Object)registration.getNumber().toString());
            Person person = registration.getPerson();
            spreadsheet.addCell((Object)person.getUsername());
            spreadsheet.addCell((Object)person.getName());
            spreadsheet.addCell((Object)person.getDocumentIdNumber());
            RegistrationState lastRegistrationState = registration.getLastRegistrationState(executionYear);
            spreadsheet.addCell((Object)lastRegistrationState.getStateType().getDescription());
            spreadsheet.addCell((Object)lastRegistrationState.getStateDate().toString(YMD_FORMAT));
            spreadsheet.addCell((Object)registration.getRegistrationProtocol().getCode());
            if (!extendedInfo) continue;
            spreadsheet.addCell((Object)this.getAlmaMater(person, registration));
            spreadsheet.addCell((Object)this.getAlmaMaterCountry(person, registration));
            spreadsheet.addCell((Object)(person.getDefaultEmailAddress() == null ? "" : person.getDefaultEmailAddress().getValue()));
            spreadsheet.addCell((Object)(person.getCountry() == null ? "" : person.getCountry().getName()));
            spreadsheet.addCell((Object)this.getFullAddress(person));
            spreadsheet.addCell((Object)(person.hasDefaultMobilePhone() ? person.getDefaultMobilePhoneNumber() : ""));
            spreadsheet.addCell((Object)person.getGender().toLocalizedString());
            spreadsheet.addCell((Object)(person.getDateOfBirthYearMonthDay() == null ? "" : person.getDateOfBirthYearMonthDay().toString(YMD_FORMAT)));
            spreadsheet.addCell((Object)registration.getEnrolmentsExecutionYears().size());
            spreadsheet.addCell((Object)registration.getCurricularYear(executionYear));
            spreadsheet.addCell((Object)registration.getEnrolments(executionYear).size());
            spreadsheet.addCell((Object)registration.getRegimeType(executionYear).getLocalizedName());
            this.fillSpreadSheetPreBolonhaInfo(spreadsheet, registration);
            spreadsheet.addCell((Object)StudentListByDegreeDA.getResourceMessage(registration.getStudent().isSenior(executionYear) ? "label.yes" : "label.no"));
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.FIRST_CYCLE)) {
                this.fillSpreadSheetBolonhaInfo(spreadsheet, registration, studentCurricularPlan.getCycle(CycleType.FIRST_CYCLE));
            }
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.SECOND_CYCLE)) {
                this.fillSpreadSheetBolonhaInfo(spreadsheet, registration, studentCurricularPlan.getCycle(CycleType.SECOND_CYCLE));
            }
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.THIRD_CYCLE)) {
                this.fillSpreadSheetBolonhaInfo(spreadsheet, registration, studentCurricularPlan.getCycle(CycleType.THIRD_CYCLE));
            }
            spreadsheet.addCell((Object)registrationWithStateForExecutionYearBean.getPersonalDataAuthorization());
            this.addBranchsInformation(spreadsheet, studentCurricularPlan);
            Collection<Enrolment> enrolmentsSem1 = registration.getEnrolments(executionYear.getExecutionSemesterFor(1));
            Collection<Enrolment> enrolmentsSem2 = registration.getEnrolments(executionYear.getExecutionSemesterFor(2));
            spreadsheet.addCell((Object)enrolmentsSem1.size());
            spreadsheet.addCell((Object)enrolmentsSem2.size());
            spreadsheet.addCell((Object)this.countApprovedEnrolments(enrolmentsSem1));
            spreadsheet.addCell((Object)this.countApprovedEnrolments(enrolmentsSem2));
        }
    }

    private int countApprovedEnrolments(Collection<Enrolment> enrolments) {
        int count = 0;
        for (Enrolment enrolment : enrolments) {
            if (!enrolment.isApproved()) continue;
            ++count;
        }
        return count;
    }

    private String getAlmaMater(Person person, Registration registration) {
        for (IndividualCandidacyPersonalDetails shite : person.getIndividualCandidaciesSet()) {
            if (!(shite.getCandidacy().getCandidacyProcess() instanceof MobilityIndividualApplicationProcess)) continue;
            MobilityIndividualApplicationProcess erasmusShite = (MobilityIndividualApplicationProcess)((Object)shite.getCandidacy().getCandidacyProcess());
            return erasmusShite.getCandidacy().getMobilityStudentData().getSelectedOpening().getMobilityAgreement().getUniversityUnit().getNameI18n().toString();
        }
        if (registration.getRegistrationProtocol().attemptAlmaMatterFromPrecedent()) {
            if (registration.getStudentCandidacy() == null) {
                return "";
            }
            StudentCandidacy studentCandidacy = registration.getStudentCandidacy();
            if (studentCandidacy.getPrecedentDegreeInformation() == null) {
                return "";
            }
            PrecedentDegreeInformation precedentDegreeInformation = studentCandidacy.getPrecedentDegreeInformation();
            if (precedentDegreeInformation.getPrecedentInstitution() == null) {
                return "";
            }
            return precedentDegreeInformation.getPrecedentInstitution().getNameI18n().toString();
        }
        return "";
    }

    private String getAlmaMaterCountry(Person person, Registration registration) {
        for (IndividualCandidacyPersonalDetails shite : person.getIndividualCandidaciesSet()) {
            if (!(shite.getCandidacy().getCandidacyProcess() instanceof MobilityIndividualApplicationProcess)) continue;
            MobilityIndividualApplicationProcess erasmusShite = (MobilityIndividualApplicationProcess)((Object)shite.getCandidacy().getCandidacyProcess());
            return erasmusShite.getCandidacy().getMobilityStudentData().getSelectedOpening().getMobilityAgreement().getUniversityUnit().getCountry().getLocalizedName().toString();
        }
        if (registration.getRegistrationProtocol().attemptAlmaMatterFromPrecedent()) {
            if (registration.getStudentCandidacy() == null) {
                return "";
            }
            StudentCandidacy studentCandidacy = registration.getStudentCandidacy();
            if (studentCandidacy.getPrecedentDegreeInformation() == null) {
                return "";
            }
            PrecedentDegreeInformation precedentDegreeInformation = studentCandidacy.getPrecedentDegreeInformation();
            if (precedentDegreeInformation.getPrecedentCountry() == null) {
                return "";
            }
            return precedentDegreeInformation.getPrecedentCountry().getLocalizedName().toString();
        }
        return "";
    }

    private String getFullAddress(Person person) {
        if (person.hasDefaultPhysicalAddress()) {
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isEmpty((String)person.getDefaultPhysicalAddress().getAddress())) {
                sb.append(person.getDefaultPhysicalAddress().getAddress()).append(" ");
            }
            if (!StringUtils.isEmpty((String)person.getDefaultPhysicalAddress().getArea())) {
                sb.append(person.getDefaultPhysicalAddress().getArea()).append(" ");
            }
            if (!StringUtils.isEmpty((String)person.getDefaultPhysicalAddress().getAreaCode())) {
                sb.append(person.getDefaultPhysicalAddress().getAreaCode()).append(" ");
            }
            if (!StringUtils.isEmpty((String)person.getDefaultPhysicalAddress().getAreaOfAreaCode())) {
                sb.append(person.getDefaultPhysicalAddress().getAreaOfAreaCode()).append(" ");
            }
            return StringUtils.isEmpty((String)sb.toString()) ? "" : sb.toString();
        }
        return "";
    }

    private void addBranchsInformation(StyledExcelSpreadsheet spreadsheet, StudentCurricularPlan studentCurricularPlan) {
        StringBuilder majorBranches = new StringBuilder();
        StringBuilder minorBranches = new StringBuilder();
        for (BranchCurriculumGroup group : studentCurricularPlan.getBranchCurriculumGroups()) {
            if (group.isMajor()) {
                majorBranches.append(group.getName().toString()).append(",");
                continue;
            }
            if (!group.isMinor()) continue;
            minorBranches.append(group.getName().toString()).append(",");
        }
        if (majorBranches.length() > 0) {
            spreadsheet.addCell((Object)majorBranches.deleteCharAt(majorBranches.length() - 1).toString());
        } else {
            spreadsheet.addCell((Object)"");
        }
        if (minorBranches.length() > 0) {
            spreadsheet.addCell((Object)minorBranches.deleteCharAt(minorBranches.length() - 1).toString());
        } else {
            spreadsheet.addCell((Object)"");
        }
    }

    private void fillSpreadSheetPreBolonhaInfo(StyledExcelSpreadsheet spreadsheet, Registration registration) {
        this.fillSpreadSheetEmptyCells(spreadsheet);
    }

    private void fillSpreadSheetBolonhaInfo(StyledExcelSpreadsheet spreadsheet, Registration registration, CycleCurriculumGroup cycle) {
        if (cycle != null && !cycle.isExternal()) {
            RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(registration, (CurriculumGroup)((Object)cycle));
            this.fillSpreadSheetRegistrationInfo(spreadsheet, registrationConclusionBean, registrationConclusionBean.isConcluded());
        } else {
            this.fillSpreadSheetEmptyCells(spreadsheet);
        }
    }

    private void fillSpreadSheetRegistrationInfo(StyledExcelSpreadsheet spreadsheet, RegistrationConclusionBean registrationConclusionBean, boolean isConcluded) {
        spreadsheet.addCell((Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)("label." + (isConcluded ? "yes" : "no") + ".capitalized"), (String[])new String[0]));
        spreadsheet.addCell((Object)(isConcluded ? registrationConclusionBean.getConclusionDate().toString(YMD_FORMAT) : ""));
        spreadsheet.addCell((Object)registrationConclusionBean.getRawGrade().getValue());
        spreadsheet.addCell((Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)("label." + (registrationConclusionBean.isConclusionProcessed() ? "yes" : "no") + ".capitalized"), (String[])new String[0]));
        spreadsheet.addCell((Object)registrationConclusionBean.getCalculatedEctsCredits());
    }

    private void fillSpreadSheetEmptyCells(StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.addCell((Object)"");
        spreadsheet.addCell((Object)"");
        spreadsheet.addCell((Object)"");
        spreadsheet.addCell((Object)"");
        spreadsheet.addCell((Object)"");
    }

    private void setHeaders(StyledExcelSpreadsheet spreadsheet, boolean extendedInfo) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.degree.acronym"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.degree.name"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.number"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.username"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.name"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.documentIdNumber"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registration.state"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registration.state.start.date"));
        spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registrationAgreement"));
        if (extendedInfo) {
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.almamater"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.almamater.country"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.email"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.nationality"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.person.title.addressInfo"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.person.title.contactInfo"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.gender"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.dateOfBirth"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.registration.enrolments.number.short"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("curricular.year"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.student.enrolments.number.short"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("registration.regime"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("degree.concluded"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.conclusionDate"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("degree.average"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("degree.hasConclusionProcess"));
            spreadsheet.addHeader("");
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("student.is.senior"));
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.FIRST_CYCLE)) {
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.firstCycle.concluded"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.firstCycle.conclusionDate"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.firstCycle.average"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.firstCycle.hasConclusionProcess"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.firstCycle.ects"));
            }
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.SECOND_CYCLE)) {
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.secondCycle.concluded"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.secondCycle.conclusionDate"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.secondCycle.average"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.secondCycle.hasConclusionProcess"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.secondCycle.ects"));
            }
            if (this.getAdministratedCycleTypes().contains((Object)CycleType.THIRD_CYCLE)) {
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.thirdCycle.concluded"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.thirdCycle.conclusionDate"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.thirdCycle.average"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.thirdCycle.hasConclusionProcess"));
                spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.thirdCycle.ects"));
            }
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.studentData.personalDataAuthorization"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.main.branch"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.minor.branch"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.student.enrolments.number.first.semester"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.student.enrolments.number.second.semester"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.student.enrolments.approved.first.semester"));
            spreadsheet.addHeader(StudentListByDegreeDA.getResourceMessage("label.student.enrolments.approved.second.semester"));
        }
    }

    protected static String getResourceMessage(String key) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])new String[0]);
    }

    protected Set<CycleType> getAdministratedCycleTypes() {
        HashSet<CycleType> cycles = new HashSet<CycleType>();
        for (DegreeType degreeType : AcademicAccessRule.getDegreeTypesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet())) {
            cycles.addAll(degreeType.getCycleTypes());
        }
        return cycles;
    }
}

