/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher.authorization;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.springframework.stereotype.Service;

@Service
public class CsvService {
    public List<Map<String, String>> readCsvFile(File file, String separator, String encoding) throws IOException {
        return this.readCsvFile(new FileInputStream(file), separator, encoding);
    }

    public List<Map<String, String>> readCsvFile(InputStream stream, String separator, String encoding) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream, Charsets.UTF_8);){
            String content = CharStreams.toString((Readable)isr);
            List lines = Splitter.on((String)System.lineSeparator()).splitToList((CharSequence)content);
            ArrayList<String> header = null;
            Vector csvContent = new Vector(lines.size());
            for (String line : lines) {
                String[] parts = line.split(separator);
                if (header == null) {
                    header = new ArrayList<String>();
                    for (String part : parts) {
                        header.add(this.cleanup(part));
                    }
                    continue;
                }
                int index = 0;
                HashMap<String, String> linemap = new HashMap<String, String>(header.size());
                for (String column : header) {
                    linemap.put(column, this.access(parts, index++));
                }
                csvContent.add(linemap);
            }
            Vector vector = csvContent;
            return vector;
        }
    }

    private String access(String[] parts, int index) {
        if (parts.length <= index) {
            return null;
        }
        return this.cleanup(parts[index]);
    }

    private String cleanup(String part) {
        String value = part.trim();
        if (value.startsWith("\"")) {
            value = value.replaceAll("\"", "");
        }
        return value.trim();
    }
}

