/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.CurricularCourseMarksheetManagementBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementBaseBean;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixframework.FenixFramework;

public class CurricularCoursesForDegreeCurricularPlan
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        MarkSheetManagementBaseBean markSheetManagementBean = (MarkSheetManagementBaseBean)source;
        ArrayList<CurricularCourseMarksheetManagementBean> result = new ArrayList<CurricularCourseMarksheetManagementBean>();
        if (markSheetManagementBean.hasDegree() && markSheetManagementBean.hasDegreeCurricularPlan() && markSheetManagementBean.hasExecutionPeriod()) {
            if (markSheetManagementBean.getDegree().getDegreeCurricularPlansSet().contains((Object)markSheetManagementBean.getDegreeCurricularPlan())) {
                if (markSheetManagementBean.getDegree().isBolonhaDegree()) {
                    this.addCurricularCourses(result, markSheetManagementBean.getDegreeCurricularPlan().getDcpDegreeModules(CurricularCourse.class, markSheetManagementBean.getExecutionPeriod().getExecutionYear()), markSheetManagementBean.getExecutionPeriod());
                } else {
                    this.addCurricularCourses(result, markSheetManagementBean.getDegreeCurricularPlan().getCurricularCoursesSet(), markSheetManagementBean.getExecutionPeriod());
                }
            } else {
                markSheetManagementBean.setDegreeCurricularPlan(null);
                markSheetManagementBean.setCurricularCourseBean(null);
            }
        }
        Collections.sort(result, CurricularCourseMarksheetManagementBean.COMPARATOR_BY_NAME);
        return result;
    }

    private void addCurricularCourses(Collection<CurricularCourseMarksheetManagementBean> result, Collection<? extends DegreeModule> dcpDegreeModules, ExecutionSemester executionSemester) {
        for (DegreeModule degreeModule : dcpDegreeModules) {
            result.add(new CurricularCourseMarksheetManagementBean((CurricularCourse)((Object)degreeModule), executionSemester));
        }
    }

    public Converter getConverter() {
        return new BiDirectionalConverter(){

            public Object convert(Class type, Object value) {
                String str = (String)value;
                if (StringUtils.isEmpty((String)str)) {
                    return null;
                }
                String[] values = str.split(":");
                CurricularCourse course = (CurricularCourse)FenixFramework.getDomainObject((String)values[0]);
                ExecutionSemester semester = (ExecutionSemester)FenixFramework.getDomainObject((String)values[1]);
                return new CurricularCourseMarksheetManagementBean(course, semester);
            }

            public String deserialize(Object object) {
                return object == null ? "" : ((CurricularCourseMarksheetManagementBean)object).getKey();
            }
        };
    }
}

