/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator.evaluation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.CreateWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.DeleteWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.EditWrittenEvaluation;
import org.fenixedu.academic.ui.faces.bean.coordinator.evaluation.CoordinatorWrittenTestsInformationBackingBean;

public class CoordinatorWrittenTestsManagementBackingBean
extends CoordinatorWrittenTestsInformationBackingBean {
    private Integer beginHour;
    private Integer beginMinute;
    private Integer endHour;
    private Integer endMinute;
    private String description;

    public String createWrittenTest() {
        try {
            ExecutionCourse executionCourse = this.getExecutionCourse();
            if (executionCourse == null) {
                this.setErrorMessage("error.noExecutionCourse");
                return "";
            }
            ArrayList<String> executionCourseIDs = new ArrayList<String>(1);
            executionCourseIDs.add(this.getExecutionCourseID().toString());
            List<String> degreeModuleScopeIDs = this.getDegreeModuleScopeIDs(executionCourse);
            CreateWrittenEvaluation.runCreateWrittenEvaluation(this.getExecutionCourseID(), this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopeIDs, null, null, null, this.getDescription());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return this.showWrittenTestsForExecutionCourses();
    }

    public String editWrittenTest() {
        try {
            ExecutionCourse executionCourse = this.getExecutionCourse();
            if (executionCourse == null) {
                this.setErrorMessage("error.noExecutionCourse");
                return "";
            }
            ArrayList<String> executionCourseIDs = new ArrayList<String>(1);
            executionCourseIDs.add(this.getExecutionCourseID().toString());
            List<String> degreeModuleScopeIDs = this.getDegreeModuleScopeIDs(executionCourse);
            EditWrittenEvaluation.runEditWrittenEvaluation(executionCourse.getExternalId(), this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopeIDs, null, this.getEvaluationID(), null, this.getDescription(), null);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return this.showWrittenTestsForExecutionCourses();
    }

    public String deleteWrittenTest() {
        try {
            DeleteWrittenEvaluation.runDeleteWrittenEvaluation(this.getExecutionCourseID(), this.getEvaluationID());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return this.showWrittenTestsForExecutionCourses();
    }

    public String showWrittenTestsForExecutionCourses() {
        this.setRequestCommonAttributes();
        return "showWrittenTestsForExecutionCourses";
    }

    private List<String> getDegreeModuleScopeIDs(ExecutionCourse executionCourse) {
        ArrayList<String> degreeModuleScopeIDs = new ArrayList<String>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            List<DegreeModuleScope> degreeModuleScopes = curricularCourse.getDegreeModuleScopes();
            for (DegreeModuleScope degreeModuleScope : degreeModuleScopes) {
                if (!degreeModuleScope.getCurricularSemester().equals(executionCourse.getExecutionPeriod().getSemester())) continue;
                degreeModuleScopeIDs.add(degreeModuleScope.getKey());
            }
        }
        return degreeModuleScopeIDs;
    }

    private Calendar getBegin() {
        Calendar result = Calendar.getInstance();
        result.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getBeginHour(), this.getBeginMinute());
        return result;
    }

    private Calendar getEnd() {
        Calendar result = Calendar.getInstance();
        result.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getEndHour(), this.getEndMinute());
        return result;
    }

    public Integer getBeginHour() {
        if (this.beginHour == null && this.getEvaluation() != null) {
            this.beginHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getBeginning().get(11);
        }
        return this.beginHour;
    }

    public void setBeginHour(Integer beginHour) {
        this.beginHour = beginHour;
    }

    public Integer getBeginMinute() {
        if (this.beginMinute == null && this.getEvaluation() != null) {
            this.beginMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getBeginning().get(12);
        }
        return this.beginMinute;
    }

    public void setBeginMinute(Integer beginMinute) {
        this.beginMinute = beginMinute;
    }

    public String getDescription() {
        WrittenEvaluation writtenEvaluation;
        if (this.description == null && this.getEvaluation() != null && (writtenEvaluation = (WrittenEvaluation)((Object)this.getEvaluation())) instanceof WrittenTest) {
            this.description = ((WrittenTest)((Object)writtenEvaluation)).getDescription();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getEndHour() {
        if (this.endHour == null && this.getEvaluation() != null) {
            this.endHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd().get(11);
        }
        return this.endHour;
    }

    public void setEndHour(Integer endHour) {
        this.endHour = endHour;
    }

    public Integer getEndMinute() {
        if (this.endMinute == null && this.getEvaluation() != null) {
            this.endMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd().get(12);
        }
        return this.endMinute;
    }

    public void setEndMinute(Integer endMinute) {
        this.endMinute = endMinute;
    }
}

