/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager.exams;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.service.filter.ExecutionCourseCoordinatorAuthorizationFilter;
import org.fenixedu.academic.service.filter.ExecutionCourseLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.filter.ResourceAllocationManagerAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.CreateWrittenEvaluation$callable$runCreateWrittenEvaluation;
import org.fenixedu.academic.util.Season;
import org.fenixedu.spaces.domain.Space;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateWrittenEvaluation {
    private static final CreateWrittenEvaluation serviceInstance;
    public static final Advice advice$runCreateWrittenEvaluation;

    protected void run(String executionCourseID, Date writtenEvaluationDate, Date writtenEvaluationStartTime, Date writtenEvaluationEndTime, List<String> executionCourseIDs, List<String> degreeModuleScopeIDs, List<String> roomIDs, GradeScale gradeScale, Season examSeason, String writtenTestDescription) throws FenixServiceException {
        List<ExecutionCourse> executionCoursesToAssociate = this.readExecutionCourses(executionCourseIDs);
        List<DegreeModuleScope> degreeModuleScopesToAssociate = this.readCurricularCourseScopesAndContexts(degreeModuleScopeIDs);
        List<Space> roomsToAssociate = null;
        if (roomIDs != null) {
            roomsToAssociate = this.readRooms(roomIDs);
        }
        Object eval = null;
        if (examSeason != null) {
            eval = new Exam(writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCoursesToAssociate, degreeModuleScopesToAssociate, roomsToAssociate, gradeScale, examSeason);
        } else if (writtenTestDescription != null) {
            eval = new WrittenTest(writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCoursesToAssociate, degreeModuleScopesToAssociate, roomsToAssociate, gradeScale, writtenTestDescription);
        } else {
            throw new InvalidArgumentsServiceException();
        }
    }

    private List<ExecutionCourse> readExecutionCourses(List<String> executionCourseIDs) throws FenixServiceException {
        if (executionCourseIDs.isEmpty()) {
            throw new FenixServiceException("error.invalidExecutionCourse");
        }
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (String executionCourseID : executionCourseIDs) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            if (executionCourse == null) {
                throw new FenixServiceException("error.invalidExecutionCourse");
            }
            result.add(executionCourse);
        }
        return result;
    }

    private List<DegreeModuleScope> readCurricularCourseScopesAndContexts(List<String> degreeModuleScopeIDs) throws FenixServiceException {
        ArrayList<DegreeModuleScope> result = new ArrayList<DegreeModuleScope>();
        for (String key : degreeModuleScopeIDs) {
            DegreeModuleScope degreeModuleScope = DegreeModuleScope.getDegreeModuleScopeByKey(key);
            if (degreeModuleScope == null) continue;
            result.add(degreeModuleScope);
        }
        if (result.isEmpty()) {
            throw new FenixServiceException("error.invalidCurricularCourseScope");
        }
        return result;
    }

    private List<Space> readRooms(List<String> roomIDs) throws FenixServiceException {
        ArrayList<Space> result = new ArrayList<Space>();
        for (String roomID : roomIDs) {
            Space room = (Space)FenixFramework.getDomainObject((String)roomID);
            if (room == null) {
                throw new FenixServiceException("error.noRoom");
            }
            result.add(room);
        }
        return result;
    }

    public static void runCreateWrittenEvaluation(String string, Date date, Date date2, Date date3, List<String> list, List<String> list2, List<String> list3, GradeScale gradeScale, Season season, String string2) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runCreateWrittenEvaluation.perform((Callable)new CreateWrittenEvaluation$callable$runCreateWrittenEvaluation(string, date, date2, date3, list, list2, list3, gradeScale, season, string2));
    }

    static /* synthetic */ void advised$runCreateWrittenEvaluation(String executionCourseID, Date writtenEvaluationDate, Date writtenEvaluationStartTime, Date writtenEvaluationEndTime, List<String> executionCourseIDs, List<String> degreeModuleScopeIDs, List<String> roomIDs, GradeScale gradeScale, Season examSeason, String writtenTestDescription) throws FenixServiceException, NotAuthorizedException {
        try {
            ResourceAllocationManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, gradeScale, examSeason, writtenTestDescription);
        }
        catch (NotAuthorizedException ex1) {
            try {
                ExecutionCourseLecturingTeacherAuthorizationFilter.instance.execute();
                serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, gradeScale, examSeason, writtenTestDescription);
            }
            catch (NotAuthorizedException ex2) {
                ExecutionCourseCoordinatorAuthorizationFilter.instance.execute(executionCourseID);
                serviceInstance.run(executionCourseID, writtenEvaluationDate, writtenEvaluationStartTime, writtenEvaluationEndTime, executionCourseIDs, degreeModuleScopeIDs, roomIDs, gradeScale, examSeason, writtenTestDescription);
            }
        }
    }

    static {
        advice$runCreateWrittenEvaluation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new CreateWrittenEvaluation();
    }
}

