/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.residenceManagement;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.residence.ResidenceYear;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.util.Money;

public class ResidenceEventBean
implements Serializable {
    private String userName;
    private String fiscalNumber;
    private String name;
    private Student student;
    private Money roomValue;
    private String statusMessage;
    private String room;

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public ResidenceEventBean(String userName, String fiscalNumber, String name, Double roomValue, String room) {
        this.userName = userName;
        this.fiscalNumber = fiscalNumber;
        this.name = name;
        this.roomValue = new Money(roomValue);
        this.room = room;
        this.setStudent(null);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFiscalNumber() {
        return this.fiscalNumber;
    }

    public void setFiscalNumber(String fiscalNumber) {
        this.fiscalNumber = fiscalNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Money getRoomValue() {
        return this.roomValue;
    }

    public void setRoomValue(Money roomValue) {
        this.roomValue = roomValue;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public Student getStudent() {
        return this.student;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean getStatus() {
        if (StringUtils.isEmpty((String)this.userName) || !StringUtils.isNumeric((String)this.userName)) {
            this.statusMessage = "label.error.invalid.student.number";
            return false;
        }
        Student student = Student.readStudentByNumber(Integer.valueOf(this.userName));
        if (student == null || student.getPerson() == null) {
            this.statusMessage = "label.error.invalid.student.number";
            return false;
        }
        this.setStudent(student);
        ResidenceYear year = ResidenceYear.getCurrentYear();
        ResidenceManagementUnit unit = year.getUnit();
        String socialSecurityNumber = student.getPerson().getSocialSecurityNumber();
        if (socialSecurityNumber != null && !socialSecurityNumber.equalsIgnoreCase(this.fiscalNumber.trim())) {
            this.statusMessage = "label.error.invalid.fiscalNumber";
            return false;
        }
        return true;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }
}

