/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.degreeAdministrativeOffice.serviceRequest.documentRequest.certificates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.serviceRequest.documentRequest.certificates.ExamDateCertificateExamSelectionEntryBean;

public class ExamDateCertificateExamSelectionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ExamDateCertificateExamSelectionEntryBean> entries = new ArrayList<ExamDateCertificateExamSelectionEntryBean>();

    public List<ExamDateCertificateExamSelectionEntryBean> getEntries() {
        return this.entries;
    }

    public void addEntry(ExamDateCertificateExamSelectionEntryBean entry) {
        this.entries.add(entry);
    }

    public void addEntries(List<ExamDateCertificateExamSelectionEntryBean> entries) {
        this.entries.addAll(entries);
    }

    public static ExamDateCertificateExamSelectionBean buildFor(Collection<Enrolment> enrolments, ExecutionSemester executionSemester) {
        ExamDateCertificateExamSelectionBean result = new ExamDateCertificateExamSelectionBean();
        for (Enrolment enrolment : enrolments) {
            for (Exam exam : enrolment.getAttendsFor(executionSemester).getExecutionCourse().getPublishedExamsFor(enrolment.getCurricularCourse())) {
                result.addEntry(new ExamDateCertificateExamSelectionEntryBean(enrolment, exam));
            }
        }
        return result;
    }

    public Set<Enrolment> getEnrolmentsWithoutExam(Collection<Enrolment> enrolments) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (Enrolment enrolment : enrolments) {
            if (this.containsEnrolment(enrolment)) continue;
            result.add(enrolment);
        }
        return result;
    }

    private boolean containsEnrolment(Enrolment enrolment) {
        for (ExamDateCertificateExamSelectionEntryBean each : this.getEntries()) {
            if (each.getEnrolment() != enrolment) continue;
            return true;
        }
        return false;
    }
}

