/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.candidacy;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.SchoolPeriodDuration;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.joda.time.LocalDate;

public class PrecedentDegreeInformationBean
implements Serializable {
    private static final long serialVersionUID = 574983352972623607L;
    private PrecedentDegreeInformation precedentDegreeInformation;
    private Unit institution;
    private String institutionName;
    private String degreeDesignation;
    private DegreeDesignation raidesDegreeDesignation;
    private String conclusionGrade;
    private Integer conclusionYear;
    private SchoolLevelType schoolLevel;
    private String otherSchoolLevel;
    private Country country;
    private Country countryWhereFinishedHighSchoolLevel;
    private boolean degreeChangeOrTransferOrErasmusStudent = false;
    private SchoolLevelType precedentSchoolLevel;
    private String otherPrecedentSchoolLevel;
    private Unit precedentInstitution;
    private String precedentInstitutionName;
    private String precedentDegreeDesignation;
    private DegreeDesignation precedentDegreeDesignationObject;
    private Integer numberOfPreviousYearEnrolmentsInPrecedentDegree;
    private SchoolPeriodDuration mobilityProgramDuration;
    private Integer numberOfEnroledCurricularCourses;
    private Integer numberOfApprovedCurricularCourses;
    private BigDecimal gradeSum;
    private BigDecimal approvedEcts;
    private BigDecimal enroledEcts;
    private LocalDate conclusionDate;

    public PrecedentDegreeInformationBean() {
    }

    public PrecedentDegreeInformationBean(PrecedentDegreeInformation information) {
        this.setPrecedentDegreeInformation(information);
        this.setDegreeDesignation(information.getDegreeDesignation());
        this.setRaidesDegreeDesignation(DegreeDesignation.readByNameAndSchoolLevel(information.getDegreeDesignation(), information.getSchoolLevel()));
        this.setInstitution(information.getInstitution());
        this.setConclusionGrade(information.getConclusionGrade());
        this.setConclusionYear(information.getConclusionYear());
        this.setCountry(information.getCountry());
        this.setCountryWhereFinishedHighSchoolLevel(information.getCountryHighSchool());
        this.setSchoolLevel(information.getSchoolLevel());
        this.setOtherSchoolLevel(information.getOtherSchoolLevel());
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation() {
        return this.precedentDegreeInformation;
    }

    public void setPrecedentDegreeInformation(PrecedentDegreeInformation precedentDegreeInformation) {
        this.precedentDegreeInformation = precedentDegreeInformation;
    }

    public Unit getInstitution() {
        return this.institution;
    }

    public void setInstitution(Unit institution) {
        this.institution = institution;
    }

    public String getConclusionGrade() {
        return this.conclusionGrade;
    }

    public void setConclusionGrade(String conclusionGrade) {
        this.conclusionGrade = conclusionGrade;
    }

    public Integer getConclusionYear() {
        return this.conclusionYear;
    }

    public void setConclusionYear(Integer conclusionYear) {
        this.conclusionYear = conclusionYear;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        if (this.getSchoolLevel() != null && this.getSchoolLevel().isHighSchoolOrEquivalent()) {
            this.setCountryWhereFinishedHighSchoolLevel(country);
        }
        this.country = country;
    }

    public Country getCountryWhereFinishedHighSchoolLevel() {
        return this.countryWhereFinishedHighSchoolLevel;
    }

    public void setCountryWhereFinishedHighSchoolLevel(Country countryHighSchool) {
        this.countryWhereFinishedHighSchoolLevel = countryHighSchool;
    }

    public boolean isHighSchoolCountryFieldRequired() {
        return this.getSchoolLevel() != null && !this.getSchoolLevel().isHighSchoolOrEquivalent() && !this.getSchoolLevel().isSchoolLevelBasicCycle();
    }

    public String getDegreeDesignation() {
        if (this.isUnitFromRaidesListMandatory()) {
            return this.getRaidesDegreeDesignation() != null ? this.getRaidesDegreeDesignation().getDescription() : null;
        }
        return this.degreeDesignation;
    }

    public boolean isUnitFromRaidesListMandatory() {
        return this.getSchoolLevel() != null && this.getSchoolLevel().isHigherEducation() && this.getCountry() != null && this.getCountry().isDefaultCountry();
    }

    public void setDegreeDesignation(String degreeDesignation) {
        this.degreeDesignation = degreeDesignation;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public UnitName getInstitutionUnitName() {
        return this.institution == null ? null : this.institution.getUnitName();
    }

    public void setInstitutionUnitName(UnitName institutionUnitName) {
        this.institution = institutionUnitName == null ? null : institutionUnitName.getUnit();
    }

    public SchoolLevelType getSchoolLevel() {
        return this.schoolLevel;
    }

    public void setSchoolLevel(SchoolLevelType schoolLevel) {
        this.schoolLevel = schoolLevel;
    }

    public String getOtherSchoolLevel() {
        return this.otherSchoolLevel;
    }

    public void setOtherSchoolLevel(String otherSchoolLevel) {
        this.otherSchoolLevel = otherSchoolLevel;
    }

    public void resetDegree() {
        this.setDegreeDesignation(null);
        this.setRaidesDegreeDesignation(null);
    }

    public void validate() {
        if (this.schoolLevel == SchoolLevelType.OTHER && StringUtils.isEmpty((String)this.otherSchoolLevel)) {
            throw new DomainException("error.registration.PrecedentDegreeInformationBean.otherSchoolLevel.must.be.filled", new String[0]);
        }
        if (this.isDegreeChangeOrTransferOrErasmusStudent() && StringUtils.isEmpty((String)this.getPrecedentDegreeDesignation())) {
            throw new DomainException("error.registration.PrecedentDegreeInformationBean.precedentDegreeDesignation.must.be.filled", new String[0]);
        }
    }

    public void setRaidesDegreeDesignation(DegreeDesignation raidesDegreeDesignation) {
        this.raidesDegreeDesignation = raidesDegreeDesignation;
    }

    public DegreeDesignation getRaidesDegreeDesignation() {
        return this.raidesDegreeDesignation;
    }

    public void setDegreeChangeOrTransferOrErasmusStudent(boolean degreeChangeOrTransferOrErasmusStudent) {
        this.degreeChangeOrTransferOrErasmusStudent = degreeChangeOrTransferOrErasmusStudent;
    }

    public boolean isDegreeChangeOrTransferOrErasmusStudent() {
        return this.degreeChangeOrTransferOrErasmusStudent;
    }

    public SchoolLevelType getPrecedentSchoolLevel() {
        return this.precedentSchoolLevel;
    }

    public void setPrecedentSchoolLevel(SchoolLevelType precedentSchoolLevel) {
        this.precedentSchoolLevel = precedentSchoolLevel;
    }

    public void setOtherPrecedentSchoolLevel(String otherPrecedentSchoolLevel) {
        this.otherPrecedentSchoolLevel = otherPrecedentSchoolLevel;
    }

    public String getOtherPrecedentSchoolLevel() {
        return this.otherPrecedentSchoolLevel;
    }

    public Unit getPrecedentInstitution() {
        return this.precedentInstitution;
    }

    public void setPrecedentInstitution(Unit precedentInstitution) {
        this.precedentInstitution = precedentInstitution;
    }

    public String getPrecedentInstitutionName() {
        return this.precedentInstitutionName;
    }

    public void setPrecedentInstitutionName(String precedentInstitutionName) {
        this.precedentInstitutionName = precedentInstitutionName;
    }

    public UnitName getPrecedentInstitutionUnitName() {
        return this.getPrecedentInstitution() == null ? null : this.getPrecedentInstitution().getUnitName();
    }

    public void setPrecedentInstitutionUnitName(UnitName institutionUnitName) {
        this.setPrecedentInstitution(institutionUnitName == null ? null : institutionUnitName.getUnit());
    }

    public String getPrecedentDegreeDesignation() {
        return this.getPrecedentDegreeDesignationObject() != null ? this.getPrecedentDegreeDesignationObject().getDescription() : this.precedentDegreeDesignation;
    }

    public void setPrecedentDegreeDesignation(String precedentDegreeDesignation) {
        this.precedentDegreeDesignation = precedentDegreeDesignation;
    }

    public void setPrecedentDegreeDesignationObject(DegreeDesignation precedentDegreeDesignationObject) {
        this.precedentDegreeDesignationObject = precedentDegreeDesignationObject;
    }

    public DegreeDesignation getPrecedentDegreeDesignationObject() {
        return this.precedentDegreeDesignationObject;
    }

    public void setNumberOfPreviousYearEnrolmentsInPrecedentDegree(Integer numberOfPreviousYearEnrolmentsInPrecedentDegree) {
        this.numberOfPreviousYearEnrolmentsInPrecedentDegree = numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public Integer getNumberOfPreviousYearEnrolmentsInPrecedentDegree() {
        return this.numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public SchoolPeriodDuration getMobilityProgramDuration() {
        return this.mobilityProgramDuration;
    }

    public void setMobilityProgramDuration(SchoolPeriodDuration mobilityProgramDuration) {
        this.mobilityProgramDuration = mobilityProgramDuration;
    }

    public Integer getNumberOfEnroledCurricularCourses() {
        return this.numberOfEnroledCurricularCourses;
    }

    public void setNumberOfEnroledCurricularCourses(Integer numberOfEnroledCurricularCourses) {
        this.numberOfEnroledCurricularCourses = numberOfEnroledCurricularCourses;
    }

    public Integer getNumberOfApprovedCurricularCourses() {
        return this.numberOfApprovedCurricularCourses;
    }

    public void setNumberOfApprovedCurricularCourses(Integer numberOfApprovedCurricularCourses) {
        this.numberOfApprovedCurricularCourses = numberOfApprovedCurricularCourses;
    }

    public BigDecimal getGradeSum() {
        return this.gradeSum;
    }

    public void setGradeSum(BigDecimal gradeSum) {
        this.gradeSum = gradeSum;
    }

    public BigDecimal getApprovedEcts() {
        return this.approvedEcts;
    }

    public void setApprovedEcts(BigDecimal approvedEcts) {
        this.approvedEcts = approvedEcts;
    }

    public BigDecimal getEnroledEcts() {
        return this.enroledEcts;
    }

    public void setEnroledEcts(BigDecimal enroledEcts) {
        this.enroledEcts = enroledEcts;
    }

    public LocalDate getConclusionDate() {
        return this.conclusionDate;
    }

    public void setConclusionDate(LocalDate conclusionDate) {
        this.conclusionDate = conclusionDate;
    }

    public void updateCountryHighSchoolLevel() {
        if (this.getSchoolLevel() != null && this.getSchoolLevel().isSchoolLevelBasicCycle()) {
            this.setCountryWhereFinishedHighSchoolLevel(null);
        } else if (this.getSchoolLevel() != null && this.getSchoolLevel().isHighSchoolOrEquivalent()) {
            this.setCountryWhereFinishedHighSchoolLevel(this.getCountry());
        }
    }
}

