/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.GratuityValues;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.gratuity.ReimbursementGuideState;
import org.fenixedu.academic.domain.log.CurriculumLineLog;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuideEntry;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PastDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.domain.student.EnrolmentModel;
import org.fenixedu.academic.domain.student.EventGenerator;
import org.fenixedu.academic.domain.student.ExternalRegistrationData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration$callable$createReingression;
import org.fenixedu.academic.domain.student.Registration$callable$deleteReingression;
import org.fenixedu.academic.domain.student.Registration$callable$grantSeniorStatute;
import org.fenixedu.academic.domain.student.Registration$callable$removeAttendFor;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationNumber;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegime;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.Registration_Base;
import org.fenixedu.academic.domain.student.SeniorStatute;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateLog;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurricularPlan.Specialization;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.transactions.InsuranceTransaction;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RegistrationPredicates;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Registration
extends Registration_Base {
    public static final String REGISTRATION_CREATE_SIGNAL = "academic.registration.create";
    private static final Logger logger;
    @Deprecated
    private static final java.util.function.Predicate<DegreeType> DEGREE_TYPES_TO_ENROL_BY_STUDENT;
    public static final Comparator<Registration> NUMBER_COMPARATOR;
    public static final Comparator<Registration> COMPARATOR_BY_START_DATE;
    public static final ComparatorChain COMPARATOR_BY_NUMBER_AND_ID;
    private static final int MAXIMUM_STUDENT_ATTENDS_PER_EXECUTION_PERIOD = 10;
    public static final Advice advice$removeAttendFor;
    public static final Advice advice$grantSeniorStatute;
    public static final Advice advice$createReingression;
    public static final Advice advice$deleteReingression;

    private Registration() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRegistrationProtocol(RegistrationProtocol.getDefault());
    }

    private Registration(Person person, DateTime start, Integer registrationNumber, Degree degree) {
        this();
        this.setStudent(person.getStudent() != null ? person.getStudent() : new Student(person, registrationNumber));
        this.setNumber(registrationNumber == null ? this.getStudent().getNumber() : registrationNumber);
        this.setStartDate(start.toYearMonthDay());
        this.setDegree(degree);
        RegistrationState.createRegistrationState(this, AccessControl.getPerson(), start, RegistrationStateType.REGISTERED);
        Signal.emit((String)REGISTRATION_CREATE_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Registration(Person person, StudentCandidacy studentCandidacy) {
        this(person, null, RegistrationProtocol.getDefault(), null, studentCandidacy);
    }

    public Registration(Person person, Integer studentNumber, Degree degree) {
        this(person, studentNumber, RegistrationProtocol.getDefault(), null, degree);
    }

    public Registration(Person person, DegreeCurricularPlan degreeCurricularPlan) {
        this(person, degreeCurricularPlan, RegistrationProtocol.getDefault(), null, null);
    }

    public Registration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType) {
        this(person, degreeCurricularPlan, RegistrationProtocol.getDefault(), cycleType, null);
    }

    public Registration(Person person, DegreeCurricularPlan degreeCurricularPlan, RegistrationProtocol protocol, CycleType cycleType, ExecutionYear executionYear) {
        this(person, null, protocol, executionYear, degreeCurricularPlan != null ? degreeCurricularPlan.getDegree() : null);
        this.createStudentCurricularPlan(degreeCurricularPlan, executionYear, cycleType);
    }

    public static Registration createRegistrationWithCustomStudentNumber(Person person, DegreeCurricularPlan degreeCurricularPlan, StudentCandidacy studentCandidacy, RegistrationProtocol protocol, CycleType cycleType, ExecutionYear executionYear, Integer studentNumber) {
        Degree degree = degreeCurricularPlan == null ? null : degreeCurricularPlan.getDegree();
        Registration registration = new Registration(person, Registration.calculateStartDate(executionYear), studentNumber, degree);
        registration.setRegistrationYear(executionYear == null ? ExecutionYear.readCurrentExecutionYear() : executionYear);
        registration.setRequestedChangeDegree(false);
        registration.setRequestedChangeBranch(false);
        registration.setRegistrationProtocol(protocol == null ? RegistrationProtocol.getDefault() : protocol);
        registration.createStudentCurricularPlan(degreeCurricularPlan, executionYear, cycleType);
        registration.setStudentCandidacyInformation(studentCandidacy);
        return registration;
    }

    public Registration(Person person, DegreeCurricularPlan degreeCurricularPlan, StudentCandidacy candidacy, RegistrationProtocol protocol, CycleType cycleType) {
        this(person, degreeCurricularPlan, candidacy, protocol, cycleType, null);
    }

    public Registration(Person person, DegreeCurricularPlan degreeCurricularPlan, StudentCandidacy studentCandidacy, RegistrationProtocol protocol, CycleType cycleType, ExecutionYear executionYear) {
        this(person, degreeCurricularPlan, protocol, cycleType, executionYear);
        this.setStudentCandidacyInformation(studentCandidacy);
        EventGenerator.generateNecessaryEvents(this.getLastStudentCurricularPlan(), person, executionYear);
    }

    private Registration(Person person, Integer registrationNumber, RegistrationProtocol protocol, ExecutionYear executionYear, StudentCandidacy studentCandidacy) {
        this(person, registrationNumber, protocol, executionYear, Registration.getDegreeFromCandidacy(studentCandidacy));
        this.setStudentCandidacyInformation(studentCandidacy);
    }

    private static Degree getDegreeFromCandidacy(StudentCandidacy studentCandidacy) {
        return studentCandidacy == null ? null : studentCandidacy.getExecutionDegree().getDegree();
    }

    private Registration(Person person, Integer registrationNumber, RegistrationProtocol protocol, ExecutionYear executionYear, Degree degree) {
        this(person, Registration.calculateStartDate(executionYear), registrationNumber, degree);
        this.setRegistrationYear(executionYear == null ? ExecutionYear.readCurrentExecutionYear() : executionYear);
        this.setRequestedChangeDegree(false);
        this.setRequestedChangeBranch(false);
        this.setRegistrationProtocol(protocol == null ? RegistrationProtocol.getDefault() : protocol);
    }

    private void setStudentCandidacyInformation(StudentCandidacy studentCandidacy) {
        this.setStudentCandidacy(studentCandidacy);
        if (studentCandidacy != null) {
            super.setEntryPhase(studentCandidacy.getEntryPhase());
            super.setIngressionType(studentCandidacy.getIngressionType());
            if (studentCandidacy.getIngressionType().isReIngression()) {
                Degree sourceDegree = studentCandidacy.getDegreeCurricularPlan().getEquivalencePlan().getSourceDegree();
                Registration registration = this.getStudent().readRegistrationByDegree(sourceDegree);
                if (registration == null) {
                    Collection<Registration> registrations = this.getStudent().getRegistrationsMatchingDegreeType(DegreeType::isPreBolonhaDegree);
                    registrations.remove((Object)this);
                    registration = registrations.size() == 1 ? registrations.iterator().next() : null;
                }
                this.setSourceRegistration(registration);
            }
        }
    }

    public StudentCurricularPlan createStudentCurricularPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return this.createStudentCurricularPlan(degreeCurricularPlan, executionYear, null);
    }

    private StudentCurricularPlan createStudentCurricularPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, CycleType cycleType) {
        ExecutionSemester executionSemester;
        YearMonthDay startDay;
        if (executionYear == null || executionYear.isCurrent()) {
            startDay = new YearMonthDay();
            executionSemester = ExecutionSemester.readActualExecutionSemester();
        } else {
            startDay = executionYear.getBeginDateYearMonthDay();
            executionSemester = executionYear.getFirstExecutionPeriod();
        }
        return StudentCurricularPlan.createBolonhaStudentCurricularPlan(this, degreeCurricularPlan, startDay, executionSemester, cycleType);
    }

    private static DateTime calculateStartDate(ExecutionYear executionYear) {
        return executionYear == null || executionYear.isCurrent() ? new DateTime() : executionYear.getBeginDateYearMonthDay().toDateTimeAtMidnight();
    }

    public final void setNumber(Integer number) {
        super.setNumber(number);
        if (number == null && this.getRegistrationNumber() != null) {
            this.getRegistrationNumber().delete();
        } else if (number != null) {
            if (this.getRegistrationNumber() != null) {
                this.getRegistrationNumber().setNumber(number);
            } else {
                new RegistrationNumber(this);
            }
        }
    }

    @Deprecated
    public void delete() {
        this.checkRulesToDelete();
        while (!this.getRegistrationStatesSet().isEmpty()) {
            ((RegistrationState)this.getRegistrationStatesSet().iterator().next()).delete();
        }
        while (!this.getStudentCurricularPlansSet().isEmpty()) {
            ((StudentCurricularPlan)((Object)this.getStudentCurricularPlansSet().iterator().next())).delete();
        }
        while (!this.getAssociatedAttendsSet().isEmpty()) {
            ((Attends)((Object)this.getAssociatedAttendsSet().iterator().next())).delete();
        }
        while (!this.getExternalEnrolmentsSet().isEmpty()) {
            ((ExternalEnrolment)this.getExternalEnrolmentsSet().iterator().next()).delete();
        }
        while (!this.getRegistrationDataByExecutionYearSet().isEmpty()) {
            ((RegistrationDataByExecutionYear)((Object)this.getRegistrationDataByExecutionYearSet().iterator().next())).delete();
        }
        while (!this.getAcademicServiceRequestsSet().isEmpty()) {
            ((RegistrationAcademicServiceRequest)((Object)this.getAcademicServiceRequestsSet().iterator().next())).delete();
        }
        while (!this.getRegistrationRegimesSet().isEmpty()) {
            ((RegistrationRegime)((Object)this.getRegistrationRegimesSet().iterator().next())).delete();
        }
        while (!this.getCurriculumLineLogsSet().isEmpty()) {
            ((CurriculumLineLog)((Object)this.getCurriculumLineLogsSet().iterator().next())).delete();
        }
        while (!this.getRegistrationStateLogsSet().isEmpty()) {
            ((RegistrationStateLog)((Object)this.getRegistrationStateLogsSet().iterator().next())).delete();
        }
        while (!this.getRegistrationStateLogSet().isEmpty()) {
            ((org.fenixedu.academic.domain.student.RegistrationStateLog)((Object)this.getRegistrationStateLogSet().iterator().next())).delete();
        }
        if (this.getRegistrationNumber() != null) {
            this.getRegistrationNumber().delete();
        }
        if (this.getExternalRegistrationData() != null) {
            this.getExternalRegistrationData().delete();
        }
        if (this.getSenior() != null) {
            this.getSenior().delete();
        }
        if (this.getStudentCandidacy() != null) {
            this.getStudentCandidacy().delete();
        }
        this.setIndividualCandidacy(null);
        this.setSourceRegistration(null);
        this.setRegistrationYear(null);
        this.setDegree(null);
        this.setStudent(null);
        super.setRegistrationProtocol(null);
        super.setIngressionType(null);
        this.setRootDomainObject(null);
        this.getDestinyRegistrationsSet().clear();
        this.getShiftsSet().clear();
        super.deleteDomainObject();
    }

    private void checkRulesToDelete() {
        if (this.getDfaRegistrationEventsSet().size() > 0) {
            throw new DomainException("error.student.Registration.cannot.delete.because.is.associated.to.dfa.registration.event", new String[0]);
        }
    }

    public StudentCurricularPlan getActiveStudentCurricularPlan() {
        return this.isActive() ? this.getLastStudentCurricularPlan() : null;
    }

    public StudentCurricularPlan getLastStudentCurricularPlan() {
        Set studentCurricularPlans = this.getStudentCurricularPlansSet();
        if (studentCurricularPlans.isEmpty()) {
            return null;
        }
        return Collections.max(studentCurricularPlans, StudentCurricularPlan.STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_START_DATE);
    }

    public StudentCurricularPlan getFirstStudentCurricularPlan() {
        return !this.getStudentCurricularPlansSet().isEmpty() ? Collections.min(this.getStudentCurricularPlansSet(), StudentCurricularPlan.STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_START_DATE) : null;
    }

    public List<StudentCurricularPlan> getSortedStudentCurricularPlans() {
        ArrayList<StudentCurricularPlan> sortedStudentCurricularPlans = new ArrayList<StudentCurricularPlan>(super.getStudentCurricularPlansSet());
        Collections.sort(sortedStudentCurricularPlans, StudentCurricularPlan.STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_START_DATE);
        return sortedStudentCurricularPlans;
    }

    public final List<StudentCurricularPlan> getStudentCurricularPlansExceptPast() {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : super.getStudentCurricularPlansSet()) {
            if (studentCurricularPlan.isPast()) continue;
            result.add(studentCurricularPlan);
        }
        return result;
    }

    public boolean attends(ExecutionCourse executionCourse) {
        for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.isFor(executionCourse)) continue;
            return true;
        }
        return false;
    }

    public final List<WrittenEvaluation> getWrittenEvaluations(ExecutionSemester executionSemester) {
        ArrayList<WrittenEvaluation> result = new ArrayList<WrittenEvaluation>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.isFor(executionSemester)) continue;
            for (Evaluation evaluation : attend.getExecutionCourse().getAssociatedEvaluationsSet()) {
                if (!(evaluation instanceof WrittenEvaluation) || result.contains((Object)evaluation)) continue;
                result.add((WrittenEvaluation)((Object)evaluation));
            }
        }
        return result;
    }

    public final List<Exam> getEnroledExams(ExecutionSemester executionSemester) {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : this.getWrittenEvaluationEnrolmentsSet()) {
            if (!(writtenEvaluationEnrolment.getWrittenEvaluation() instanceof Exam) || !writtenEvaluationEnrolment.isForExecutionPeriod(executionSemester)) continue;
            result.add((Exam)((Object)writtenEvaluationEnrolment.getWrittenEvaluation()));
        }
        return result;
    }

    public final List<Exam> getUnenroledExams(ExecutionSemester executionSemester) {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.isFor(executionSemester)) continue;
            for (Evaluation evaluation : attend.getExecutionCourse().getAssociatedEvaluationsSet()) {
                if (!(evaluation instanceof Exam) || this.isEnroledIn(evaluation)) continue;
                result.add((Exam)((Object)evaluation));
            }
        }
        return result;
    }

    public final List<WrittenTest> getEnroledWrittenTests(ExecutionSemester executionSemester) {
        ArrayList<WrittenTest> result = new ArrayList<WrittenTest>();
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : this.getWrittenEvaluationEnrolmentsSet()) {
            if (!(writtenEvaluationEnrolment.getWrittenEvaluation() instanceof WrittenTest) || !writtenEvaluationEnrolment.isForExecutionPeriod(executionSemester)) continue;
            result.add((WrittenTest)((Object)writtenEvaluationEnrolment.getWrittenEvaluation()));
        }
        return result;
    }

    public final List<WrittenTest> getUnenroledWrittenTests(ExecutionSemester executionSemester) {
        ArrayList<WrittenTest> result = new ArrayList<WrittenTest>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (attend.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            for (Evaluation evaluation : attend.getExecutionCourse().getAssociatedEvaluationsSet()) {
                if (!(evaluation instanceof WrittenTest) || this.isEnroledIn(evaluation)) continue;
                result.add((WrittenTest)((Object)evaluation));
            }
        }
        return result;
    }

    public List<Project> getProjects(ExecutionSemester executionSemester) {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.isFor(executionSemester)) continue;
            for (Evaluation evaluation : attend.getExecutionCourse().getAssociatedEvaluationsSet()) {
                if (!(evaluation instanceof Project)) continue;
                result.add((Project)((Object)evaluation));
            }
        }
        return result;
    }

    public final boolean isEnroledIn(Evaluation evaluation) {
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : this.getWrittenEvaluationEnrolmentsSet()) {
            if (writtenEvaluationEnrolment.getWrittenEvaluation() != evaluation) continue;
            return true;
        }
        return false;
    }

    public final Space getRoomFor(WrittenEvaluation writtenEvaluation) {
        for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : this.getWrittenEvaluationEnrolmentsSet()) {
            if (writtenEvaluationEnrolment.getWrittenEvaluation() != writtenEvaluation) continue;
            return writtenEvaluationEnrolment.getRoom();
        }
        return null;
    }

    public static Boolean getEnrolmentsAllowStudentToChooseAffinityCycle() {
        return FenixEduAcademicConfiguration.getConfiguration().getEnrolmentsAllowStudentToChooseAffinityCycle();
    }

    public static Boolean getEnrolmentsAllowStudentToEnrolInAffinityCycle() {
        return FenixEduAcademicConfiguration.getConfiguration().getEnrolmentsAllowStudentToEnrolInAffinityCycle();
    }

    public static Boolean getEnrolmentsAllowStudentToCreateRegistrationForAffinityCycle() {
        return FenixEduAcademicConfiguration.getConfiguration().getEnrolmentsAllowStudentToCreateRegistrationForAffinityCycle();
    }

    public final ICurriculum getCurriculum() {
        return this.getCurriculum(new DateTime(), null, null);
    }

    public final ICurriculum getCurriculum(DateTime when) {
        return this.getCurriculum(when, null, null);
    }

    public final ICurriculum getCurriculum(ExecutionYear executionYear) {
        return this.getCurriculum(new DateTime(), executionYear, null);
    }

    public final ICurriculum getCurriculum(CycleType cycleType) {
        return this.getCurriculum(new DateTime(), null, cycleType);
    }

    public final ICurriculum getCurriculum(ExecutionYear executionYear, CycleType cycleType) {
        return this.getCurriculum(new DateTime(), executionYear, cycleType);
    }

    public final ICurriculum getCurriculum(DateTime when, ExecutionYear executionYear, CycleType cycleType) {
        if (this.getStudentCurricularPlansSet().isEmpty()) {
            return Curriculum.createEmpty(executionYear);
        }
        if (this.getDegreeType().isBolonhaType()) {
            StudentCurricularPlan studentCurricularPlan = this.getLastStudentCurricularPlan();
            if (studentCurricularPlan == null) {
                return Curriculum.createEmpty(executionYear);
            }
            if (cycleType == null) {
                return studentCurricularPlan.getCurriculum(when, executionYear);
            }
            CycleCurriculumGroup cycleCurriculumGroup = studentCurricularPlan.getCycle(cycleType);
            if (cycleCurriculumGroup == null) {
                return Curriculum.createEmpty(executionYear);
            }
            return cycleCurriculumGroup.getCurriculum(when, executionYear);
        }
        List<StudentCurricularPlan> sortedSCPs = this.getSortedStudentCurricularPlans();
        ListIterator<StudentCurricularPlan> sortedSCPsIterator = sortedSCPs.listIterator(sortedSCPs.size());
        StudentCurricularPlan lastStudentCurricularPlan = sortedSCPsIterator.previous();
        Curriculum curriculum = lastStudentCurricularPlan.getCurriculum(when, executionYear);
        while (sortedSCPsIterator.hasPrevious()) {
            StudentCurricularPlan studentCurricularPlan = sortedSCPsIterator.previous();
            if (executionYear != null && !studentCurricularPlan.getStartExecutionYear().isBeforeOrEquals(executionYear)) continue;
            curriculum.add(studentCurricularPlan.getCurriculum(when, executionYear));
        }
        return curriculum;
    }

    public int getNumberOfCurriculumEntries() {
        return this.getCurriculum().getCurriculumEntries().size();
    }

    public final Grade getRawGrade() {
        return ProgramConclusion.getConclusionProcess(this.getLastStudentCurricularPlan()).map(ConclusionProcess::getRawGrade).orElseGet(this::calculateRawGrade);
    }

    public final Grade calculateRawGrade() {
        return this.getCurriculum().getRawGrade();
    }

    public final BigDecimal getEctsCredits(ExecutionYear executionYear, CycleType cycleType) {
        return this.getCurriculum(executionYear, cycleType).getSumEctsCredits();
    }

    public final Grade getFinalGrade() {
        return ProgramConclusion.getConclusionProcess(this.getLastStudentCurricularPlan()).map(ConclusionProcess::getFinalGrade).orElse(null);
    }

    public final Grade getFinalGrade(ProgramConclusion programConclusion) {
        return programConclusion.groupFor(this).map(CurriculumGroup::getFinalGrade).orElse(null);
    }

    public final boolean isInFinalDegreeYear() {
        return this.getCurricularYear() == this.getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears();
    }

    public final boolean isQualifiedForSeniority() {
        return this.isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() && (this.isConcluded() || this.isActive() && this.isInFinalDegreeForSeniority());
    }

    public boolean isInFinalDegreeForSeniority() {
        int years = 0;
        StudentCurricularPlan studentCurricularPlan = this.getLastStudentCurricularPlan();
        for (CycleType type : this.getDegreeType().getCycleTypes()) {
            if (!studentCurricularPlan.hasCycleCurriculumGroup(type)) continue;
            years += studentCurricularPlan.getDegreeCurricularPlan().getDurationInYears(type);
        }
        return this.getCurricularYear() == years;
    }

    public final Collection<CurricularCourse> getCurricularCoursesApprovedByEnrolment() {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (Enrolment enrolment : this.getApprovedEnrolments()) {
            result.add(enrolment.getCurricularCourse());
        }
        return result;
    }

    public final Collection<Enrolment> getLatestCurricularCoursesEnrolments(ExecutionYear executionYear) {
        return this.getStudentCurricularPlan(executionYear).getLatestCurricularCoursesEnrolments(executionYear);
    }

    public final boolean hasEnrolments(Enrolment enrolment) {
        if (enrolment == null) {
            return false;
        }
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasEnrolments(enrolment)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyEnrolments() {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyEnrolments()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyCurriculumLines() {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyCurriculumLines()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyCurriculumLines(ExecutionYear executionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyCurriculumLines(executionYear)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyCurriculumLines(ExecutionSemester executionSemester) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyCurriculumLines(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final Collection<Enrolment> getEnrolments(ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(executionYear);
        return studentCurricularPlan != null ? studentCurricularPlan.getEnrolmentsByExecutionYear(executionYear) : Collections.EMPTY_LIST;
    }

    public final Collection<Enrolment> getEnrolments(ExecutionSemester executionSemester) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(executionSemester.getExecutionYear());
        return studentCurricularPlan != null ? studentCurricularPlan.getEnrolmentsByExecutionPeriod(executionSemester) : Collections.EMPTY_LIST;
    }

    public final void addApprovedEnrolments(Collection<Enrolment> enrolments) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            studentCurricularPlan.addApprovedEnrolments(enrolments);
        }
    }

    public final Collection<Enrolment> getApprovedEnrolments() {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            result.addAll(studentCurricularPlan.getAprovedEnrolments());
        }
        return result;
    }

    public final Collection<ExternalEnrolment> getApprovedExternalEnrolments() {
        HashSet<ExternalEnrolment> result = new HashSet<ExternalEnrolment>();
        for (ExternalEnrolment externalEnrolment : this.getExternalEnrolmentsSet()) {
            if (!externalEnrolment.isApproved()) continue;
            result.add(externalEnrolment);
        }
        return result;
    }

    public final Collection<CurriculumLine> getExtraCurricularCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        Set<StudentCurricularPlan> toInspect = this.isBolonha() ? Collections.singleton(this.getLastStudentCurricularPlan()) : this.getStudentCurricularPlansSet();
        for (StudentCurricularPlan studentCurricularPlan : toInspect) {
            result.addAll(studentCurricularPlan.getExtraCurricularCurriculumLines());
        }
        return result;
    }

    public final Collection<CurriculumLine> getStandaloneCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        Set<StudentCurricularPlan> toInspect = this.isBolonha() ? Collections.singleton(this.getLastStudentCurricularPlan()) : this.getStudentCurricularPlansSet();
        for (StudentCurricularPlan studentCurricularPlan : toInspect) {
            result.addAll(studentCurricularPlan.getStandaloneCurriculumLines());
        }
        return result;
    }

    public void assertConclusionDate(Collection<CurriculumModule> result) {
        for (CurriculumLine curriculumLine : this.getApprovedCurriculumLines()) {
            if (curriculumLine.calculateConclusionDate() != null) continue;
            result.add((CurriculumModule)((Object)curriculumLine));
        }
    }

    public final Collection<Enrolment> getPropaedeuticEnrolments() {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        Set<StudentCurricularPlan> toInspect = this.isBolonha() ? Collections.singleton(this.getLastStudentCurricularPlan()) : this.getStudentCurricularPlansSet();
        for (StudentCurricularPlan studentCurricularPlan : toInspect) {
            result.addAll(studentCurricularPlan.getPropaedeuticEnrolments());
        }
        return result;
    }

    public final Collection<CurriculumLine> getPropaedeuticCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        Set<StudentCurricularPlan> toInspect = this.isBolonha() ? Collections.singleton(this.getLastStudentCurricularPlan()) : this.getStudentCurricularPlansSet();
        for (StudentCurricularPlan studentCurricularPlan : toInspect) {
            result.addAll(studentCurricularPlan.getPropaedeuticCurriculumLines());
        }
        return result;
    }

    public YearMonthDay getLastExternalApprovedEnrolmentEvaluationDate() {
        if (this.getExternalEnrolmentsSet().isEmpty()) {
            return null;
        }
        ExternalEnrolment externalEnrolment = Collections.max(this.getExternalEnrolmentsSet(), ExternalEnrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_EVALUATION_DATE);
        return externalEnrolment.getApprovementDate() != null ? externalEnrolment.getApprovementDate() : (externalEnrolment.hasExecutionPeriod() ? externalEnrolment.getExecutionPeriod().getEndDateYearMonthDay() : null);
    }

    public final Collection<CurriculumLine> getApprovedCurriculumLines() {
        if (this.isBolonha()) {
            return this.getLastStudentCurricularPlan().getApprovedCurriculumLines();
        }
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        for (StudentCurricularPlan plan : this.getStudentCurricularPlansSet()) {
            result.addAll(plan.getApprovedCurriculumLines());
        }
        return result;
    }

    public final boolean hasAnyApprovedCurriculumLines() {
        return this.getLastStudentCurricularPlan().hasAnyApprovedCurriculumLines();
    }

    public final Collection<IEnrolment> getApprovedIEnrolments() {
        HashSet<IEnrolment> result = new HashSet<IEnrolment>();
        for (CurriculumLine curriculumLine : this.getApprovedCurriculumLines()) {
            if (curriculumLine.isEnrolment()) {
                result.add((Enrolment)((Object)curriculumLine));
                continue;
            }
            if (!curriculumLine.isDismissal()) continue;
            result.addAll(((Dismissal)((Object)curriculumLine)).getSourceIEnrolments());
        }
        result.addAll(this.getExternalEnrolmentsSet());
        return result;
    }

    public final boolean hasAnyApprovedEnrolment() {
        return this.getLastStudentCurricularPlan().hasAnyApprovedEnrolment() || this.hasAnyExternalApprovedEnrolment();
    }

    public final boolean hasAnyApprovedEnrolments(ExecutionYear executionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (!enrolment.isApproved() || enrolment.getExecutionPeriod().getExecutionYear() != executionYear) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyEnroledEnrolments(ExecutionYear year) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (!enrolment.isEnroled() || !enrolment.isValid(year)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasAnyEnrolmentsIn(ExecutionYear executionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (enrolment.getExecutionPeriod().getExecutionYear() != executionYear) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasAnyEnrolmentsIn(ExecutionSemester executionSemester) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (enrolment.getExecutionPeriod() != executionSemester) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasAnyStandaloneEnrolmentsIn(ExecutionYear executionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            StandaloneCurriculumGroup standaloneCurriculumGroup = studentCurricularPlan.getStandaloneCurriculumGroup();
            if (standaloneCurriculumGroup == null || !standaloneCurriculumGroup.hasEnrolment(executionYear)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnyExternalApprovedEnrolment() {
        for (ExternalEnrolment externalEnrolment : this.getExternalEnrolmentsSet()) {
            if (!externalEnrolment.isApproved()) continue;
            return true;
        }
        return false;
    }

    public final Double getDismissalsEctsCredits() {
        return this.getLastStudentCurricularPlan().getDismissalsEctsCredits();
    }

    public final boolean getHasExternalEnrolments() {
        return !this.getExternalEnrolmentsSet().isEmpty();
    }

    public final Collection<ExecutionYear> getEnrolmentsExecutionYears() {
        HashSet<ExecutionYear> result = new HashSet<ExecutionYear>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                result.add(enrolment.getExecutionPeriod().getExecutionYear());
            }
        }
        return result;
    }

    public final int getNumberOfYearsEnrolledUntil(ExecutionYear executionYear) {
        int count = 0;
        for (ExecutionYear year : this.getEnrolmentsExecutionYears()) {
            if (!year.isBeforeOrEquals(executionYear)) continue;
            ++count;
        }
        return count;
    }

    public final SortedSet<ExecutionYear> getSortedEnrolmentsExecutionYears() {
        TreeSet<ExecutionYear> result = new TreeSet<ExecutionYear>(ExecutionYear.COMPARATOR_BY_YEAR);
        result.addAll(this.getEnrolmentsExecutionYears());
        return result;
    }

    public Set<ExecutionYear> getAllRelatedRegistrationsEnrolmentsExecutionYears(Set<ExecutionYear> result) {
        if (result == null) {
            result = new HashSet<ExecutionYear>();
        }
        result.addAll(this.getEnrolmentsExecutionYears());
        if (this.isBolonha()) {
            Registration source;
            Registration registration = source = this.getSourceRegistration() != null ? this.getSourceRegistration() : this.getSourceRegistrationForTransition();
            if (source != null) {
                source.getAllRelatedRegistrationsEnrolmentsExecutionYears(result);
            }
        } else {
            Set<Registration> registrations = this.getStudent().getRegistrationsSet();
            for (Registration registration : registrations) {
                if (registration == this || registration.isBolonha() || registration.isConcluded()) continue;
                result.addAll(registration.getEnrolmentsExecutionYears());
            }
        }
        return result;
    }

    public Collection<ExecutionYear> getCurriculumLinesExecutionYears() {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (CurriculumLine curriculumLine : studentCurricularPlan.getAllCurriculumLines()) {
                if (!curriculumLine.hasExecutionPeriod()) continue;
                result.add(curriculumLine.getExecutionYear());
            }
        }
        return result;
    }

    public SortedSet<ExecutionYear> getSortedCurriculumLinesExecutionYears() {
        TreeSet<ExecutionYear> result = new TreeSet<ExecutionYear>(ExecutionYear.COMPARATOR_BY_YEAR);
        result.addAll(this.getCurriculumLinesExecutionYears());
        return result;
    }

    public final ExecutionYear getFirstEnrolmentExecutionYear() {
        SortedSet<ExecutionYear> sortedEnrolmentsExecutionYears = this.getSortedEnrolmentsExecutionYears();
        return sortedEnrolmentsExecutionYears.isEmpty() ? null : sortedEnrolmentsExecutionYears.first();
    }

    public ExecutionYear getFirstCurriculumLineExecutionYear() {
        SortedSet<ExecutionYear> executionYears = this.getSortedCurriculumLinesExecutionYears();
        return executionYears.isEmpty() ? null : executionYears.first();
    }

    public final ExecutionYear getLastEnrolmentExecutionYear() {
        SortedSet<ExecutionYear> sorted = this.getSortedEnrolmentsExecutionYears();
        if (!sorted.isEmpty()) {
            return sorted.last();
        }
        return null;
    }

    public ExecutionYear getLastApprovementExecutionYear() {
        if (this.isBolonha()) {
            return this.getLastStudentCurricularPlan().getLastApprovementExecutionYear();
        }
        ExecutionYear result = null;
        for (StudentCurricularPlan plan : this.getStudentCurricularPlansSet()) {
            ExecutionYear year = plan.getLastApprovementExecutionYear();
            if (year == null || result != null && !result.isBefore(year)) continue;
            result = year;
        }
        return result;
    }

    public final Collection<ExecutionSemester> getEnrolmentsExecutionPeriods() {
        HashSet<ExecutionSemester> result = new HashSet<ExecutionSemester>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                result.add(enrolment.getExecutionPeriod());
            }
        }
        return result;
    }

    public final SortedSet<ExecutionSemester> getSortedEnrolmentsExecutionPeriods() {
        TreeSet<ExecutionSemester> result = new TreeSet<ExecutionSemester>(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
        result.addAll(this.getEnrolmentsExecutionPeriods());
        return result;
    }

    public final Set<Attends> getOrderedAttends() {
        TreeSet<Attends> result = new TreeSet<Attends>(Attends.ATTENDS_COMPARATOR);
        result.addAll(this.getAssociatedAttendsSet());
        return result;
    }

    public final int countCompletedCoursesForActiveUndergraduateCurricularPlan() {
        return this.getActiveStudentCurricularPlan().getAprovedEnrolments().size();
    }

    public List<StudentCurricularPlan> getStudentCurricularPlansBySpecialization(Specialization specialization) {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (studentCurricularPlan.getSpecialization() == null || !studentCurricularPlan.getSpecialization().equals((Object)specialization)) continue;
            result.add(studentCurricularPlan);
        }
        return result;
    }

    public final List<StudentCurricularPlan> getStudentCurricularPlansByDegree(Degree degree) {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (studentCurricularPlan.getDegree() != degree) continue;
            result.add(studentCurricularPlan);
        }
        return result;
    }

    public final StudentCurricularPlan getPastStudentCurricularPlanByDegree(Degree degree) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (studentCurricularPlan.getDegree() != degree || !studentCurricularPlan.isPast()) continue;
            return studentCurricularPlan;
        }
        return null;
    }

    public List<Attends> readAttendsInCurrentExecutionPeriod() {
        ArrayList<Attends> attends = new ArrayList<Attends>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.getExecutionCourse().getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            attends.add(attend);
        }
        return attends;
    }

    public List<Attends> readAttendsByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Attends> attends = new ArrayList<Attends>();
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.isFor(executionSemester)) continue;
            attends.add(attend);
        }
        return attends;
    }

    @Deprecated
    public static final Registration readByUsername(String username) {
        Iterator<Registration> iterator;
        Person person = Person.readPersonByUsername(username);
        if (person != null && (iterator = person.getStudentsSet().iterator()).hasNext()) {
            Registration registration = iterator.next();
            return registration;
        }
        return null;
    }

    @Deprecated
    public static final Registration readStudentByNumberAndDegreeType(Integer number, DegreeType degreeType) {
        Registration nonActiveRegistration = null;
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            if (registration.getNumber().intValue() != number.intValue() || !registration.getDegreeType().equals(degreeType)) continue;
            if (registration.isActive()) {
                return registration;
            }
            nonActiveRegistration = registration;
        }
        return nonActiveRegistration;
    }

    public static final Registration readByNumberAndDegreeCurricularPlan(Integer number, DegreeCurricularPlan degreeCurricularPlan) {
        Registration nonActiveRegistration = null;
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            if (registration.getNumber().intValue() != number.intValue() || !registration.getDegreeCurricularPlans().contains((Object)degreeCurricularPlan)) continue;
            if (registration.isActive()) {
                return registration;
            }
            nonActiveRegistration = registration;
        }
        return nonActiveRegistration;
    }

    public static final Registration readRegisteredRegistrationByNumberAndDegreeType(Integer number, DegreeType degreeType) {
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            if (registration.getNumber().intValue() != number.intValue() || !registration.getDegreeType().equals(degreeType) || !registration.isInRegisteredState()) continue;
            return registration;
        }
        return null;
    }

    public static final Collection<Registration> readRegistrationsByNumberAndDegreeTypes(Integer number, DegreeType ... degreeTypes) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        List<DegreeType> degreeTypesList = Arrays.asList(degreeTypes);
        for (RegistrationNumber registrationNumber : Bennu.getInstance().getRegistrationNumbersSet()) {
            Registration registration;
            if (registrationNumber.getNumber().intValue() != number.intValue() || !degreeTypesList.contains((registration = registrationNumber.getRegistration()).getDegreeType())) continue;
            result.add(registration);
        }
        return result;
    }

    public static final List<Registration> readByNumber(Integer number) {
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        for (RegistrationNumber registrationNumber : Bennu.getInstance().getRegistrationNumbersSet()) {
            if (registrationNumber.getNumber().intValue() != number.intValue()) continue;
            registrations.add(registrationNumber.getRegistration());
        }
        return registrations;
    }

    public static final List<Registration> readByNumberAndDegreeType(Integer number, DegreeType degreeType) {
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        for (RegistrationNumber registrationNumber : Bennu.getInstance().getRegistrationNumbersSet()) {
            if (registrationNumber.getNumber().intValue() != number.intValue() || registrationNumber.getRegistration().getDegreeType() != degreeType) continue;
            registrations.add(registrationNumber.getRegistration());
        }
        return registrations;
    }

    public static final List<Registration> readByNumberAndDegreeTypeAndAgreement(Integer number, DegreeType degreeType, boolean normalAgreement) {
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        for (RegistrationNumber registrationNumber : Bennu.getInstance().getRegistrationNumbersSet()) {
            if (registrationNumber.getNumber().intValue() != number.intValue() || registrationNumber.getRegistration().getDegreeType() != degreeType || registrationNumber.getRegistration().getRegistrationProtocol() == RegistrationProtocol.getDefault() != normalAgreement) continue;
            registrations.add(registrationNumber.getRegistration());
        }
        return registrations;
    }

    public static final List<Registration> readAllStudentsBetweenNumbers(Integer fromNumber, Integer toNumber) {
        int fromNumberInt = fromNumber;
        int toNumberInt = toNumber;
        ArrayList<Registration> students = new ArrayList<Registration>();
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            int studentNumberInt = registration.getNumber();
            if (studentNumberInt < fromNumberInt || studentNumberInt > toNumberInt) continue;
            students.add(registration);
        }
        return students;
    }

    public static final List<Registration> readRegistrationsByDegreeType(DegreeType degreeType) {
        ArrayList<Registration> students = new ArrayList<Registration>();
        for (Registration registration : Bennu.getInstance().getRegistrationsSet()) {
            if (!registration.getDegreeType().equals(degreeType)) continue;
            students.add(registration);
        }
        return students;
    }

    public final GratuitySituation readGratuitySituationByExecutionDegree(ExecutionDegree executionDegree) {
        GratuityValues gratuityValues = executionDegree.getGratuityValues();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            GratuitySituation gratuitySituation = studentCurricularPlan.getGratuitySituationByGratuityValues(gratuityValues);
            if (gratuitySituation == null) continue;
            return gratuitySituation;
        }
        return null;
    }

    public final List<InsuranceTransaction> readAllInsuranceTransactionByExecutionYear(ExecutionYear executionYear) {
        ArrayList<InsuranceTransaction> insuranceTransactions = new ArrayList<InsuranceTransaction>();
        for (InsuranceTransaction insuranceTransaction : this.getInsuranceTransactionsSet()) {
            if (!insuranceTransaction.getExecutionYear().equals(executionYear)) continue;
            insuranceTransactions.add(insuranceTransaction);
        }
        return insuranceTransactions;
    }

    public final List<InsuranceTransaction> readAllNonReimbursedInsuranceTransactionsByExecutionYear(ExecutionYear executionYear) {
        ArrayList<InsuranceTransaction> nonReimbursedInsuranceTransactions = new ArrayList<InsuranceTransaction>();
        for (InsuranceTransaction insuranceTransaction : this.getInsuranceTransactionsSet()) {
            if (!insuranceTransaction.getExecutionYear().equals(executionYear)) continue;
            GuideEntry guideEntry = insuranceTransaction.getGuideEntry();
            if (guideEntry == null || guideEntry.getReimbursementGuideEntriesSet().isEmpty()) {
                nonReimbursedInsuranceTransactions.add(insuranceTransaction);
                continue;
            }
            boolean isReimbursed = false;
            for (ReimbursementGuideEntry reimbursementGuideEntry : guideEntry.getReimbursementGuideEntriesSet()) {
                if (!reimbursementGuideEntry.getReimbursementGuide().getActiveReimbursementGuideSituation().getReimbursementGuideState().equals((Object)ReimbursementGuideState.PAYED)) continue;
                isReimbursed = true;
                break;
            }
            if (isReimbursed) continue;
            nonReimbursedInsuranceTransactions.add(insuranceTransaction);
        }
        return nonReimbursedInsuranceTransactions;
    }

    public final Enrolment findEnrolmentByEnrolmentID(String enrolmentID) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            Enrolment enrolment = studentCurricularPlan.findEnrolmentByEnrolmentID(enrolmentID);
            if (enrolment == null) continue;
            return enrolment;
        }
        return null;
    }

    public final Set<ExecutionCourse> getAttendingExecutionCoursesForCurrentExecutionPeriod() {
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.getExecutionCourse().getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            result.add(attends.getExecutionCourse());
        }
        return result;
    }

    public final Set<ExecutionCourse> getAttendingExecutionCoursesFor() {
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            result.add(attends.getExecutionCourse());
        }
        return result;
    }

    public final List<ExecutionCourse> getAttendingExecutionCoursesFor(ExecutionSemester executionSemester) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.isFor(executionSemester)) continue;
            result.add(attends.getExecutionCourse());
        }
        return result;
    }

    public final List<ExecutionCourse> getAttendingExecutionCoursesFor(ExecutionYear executionYear) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.isFor(executionYear)) continue;
            result.add(attends.getExecutionCourse());
        }
        return result;
    }

    public final List<Attends> getAttendsForExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<Attends> result = new ArrayList<Attends>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.isFor(executionSemester)) continue;
            result.add(attends);
        }
        return result;
    }

    public final List<Shift> getShiftsForCurrentExecutionPeriod() {
        ArrayList<Shift> result = new ArrayList<Shift>();
        for (Shift shift : this.getShiftsSet()) {
            if (!shift.getExecutionCourse().getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            result.add(shift);
        }
        return result;
    }

    public final List<Shift> getShiftsFor(ExecutionSemester executionSemester) {
        ArrayList<Shift> result = new ArrayList<Shift>();
        for (Shift shift : this.getShiftsSet()) {
            if (shift.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            result.add(shift);
        }
        return result;
    }

    public final List<Shift> getShiftsFor(ExecutionCourse executionCourse) {
        ArrayList<Shift> result = new ArrayList<Shift>();
        for (Shift shift : this.getShiftsSet()) {
            if (shift.getExecutionCourse() != executionCourse) continue;
            result.add(shift);
        }
        return result;
    }

    public final Shift getShiftFor(ExecutionCourse executionCourse, ShiftType shiftType) {
        for (Shift shift : this.getShiftsSet()) {
            if (shift.getExecutionCourse() != executionCourse || !shift.hasShiftType(shiftType)) continue;
            return shift;
        }
        return null;
    }

    private int countNumberOfDistinctExecutionCoursesOfShiftsFor(ExecutionSemester executionSemester) {
        HashSet<ExecutionCourse> result = new HashSet<ExecutionCourse>();
        for (Shift shift : this.getShiftsSet()) {
            if (shift.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            result.add(shift.getExecutionCourse());
        }
        return result.size();
    }

    public final Integer getNumberOfExecutionCoursesWithEnroledShiftsFor(ExecutionSemester executionSemester) {
        return this.getAttendingExecutionCoursesFor(executionSemester).size() - this.countNumberOfDistinctExecutionCoursesOfShiftsFor(executionSemester);
    }

    public final Integer getNumberOfExecutionCoursesHavingNotEnroledShiftsFor(ExecutionSemester executionSemester) {
        int result = 0;
        List<Shift> enroledShifts = this.getShiftsFor(executionSemester);
        block0: for (ExecutionCourse executionCourse : this.getAttendingExecutionCoursesFor(executionSemester)) {
            for (ShiftType shiftType : executionCourse.getOldShiftTypesToEnrol()) {
                if (this.enroledShiftsContainsShiftWithSameExecutionCourseAndShiftType(enroledShifts, executionCourse, shiftType)) continue;
                ++result;
                continue block0;
            }
        }
        return result;
    }

    private boolean enroledShiftsContainsShiftWithSameExecutionCourseAndShiftType(List<Shift> enroledShifts, ExecutionCourse executionCourse, ShiftType shiftType) {
        return enroledShifts.stream().anyMatch(enroledShift -> enroledShift.getExecutionCourse() == executionCourse && enroledShift.containsType(shiftType));
    }

    public final Set<SchoolClass> getSchoolClassesToEnrol() {
        HashSet<SchoolClass> result = new HashSet<SchoolClass>();
        for (Attends attends : this.getAssociatedAttendsSet()) {
            ExecutionCourse executionCourse = attends.getExecutionCourse();
            if (!executionCourse.getExecutionPeriod().getState().equals(PeriodState.CURRENT)) continue;
            result.addAll(this.getSchoolClassesToEnrolBy(executionCourse));
        }
        return result;
    }

    public final Set<SchoolClass> getSchoolClassesToEnrolBy(ExecutionCourse executionCourse) {
        Set<SchoolClass> schoolClasses = executionCourse.getSchoolClassesBy(this.getActiveStudentCurricularPlan().getDegreeCurricularPlan());
        return schoolClasses.isEmpty() ? executionCourse.getSchoolClasses() : schoolClasses;
    }

    public void addAttendsTo(ExecutionCourse executionCourse) {
        this.checkIfReachedAttendsLimit();
        if (this.getStudent().readAttendByExecutionCourse(executionCourse) == null) {
            Enrolment enrolment = this.findEnrolment(this.getActiveStudentCurricularPlan(), executionCourse, executionCourse.getExecutionPeriod());
            if (enrolment != null) {
                enrolment.createAttends(this, executionCourse);
            } else {
                Attends attends = this.getAttendsForExecutionCourse(executionCourse);
                if (attends != null) {
                    attends.delete();
                }
                new Attends(this, executionCourse);
            }
        }
    }

    private Attends getAttendsForExecutionCourse(ExecutionCourse executionCourse) {
        List<Attends> attendsInExecutionPeriod = this.getAttendsForExecutionPeriod(executionCourse.getExecutionPeriod());
        for (Attends attends : attendsInExecutionPeriod) {
            for (CurricularCourse curricularCourse : attends.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
                if (!executionCourse.getAssociatedCurricularCoursesSet().contains((Object)curricularCourse)) continue;
                return attends;
            }
        }
        return null;
    }

    private Enrolment findEnrolment(StudentCurricularPlan studentCurricularPlan, ExecutionCourse executionCourse, ExecutionSemester executionSemester) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            Enrolment enrolment = studentCurricularPlan.getEnrolmentByCurricularCourseAndExecutionPeriod(curricularCourse, executionSemester);
            if (enrolment == null) continue;
            return enrolment;
        }
        return null;
    }

    private void checkIfReachedAttendsLimit() {
        User userView = Authenticate.getUser();
        if (!(userView != null && AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)this.getDegree()), userView.getPerson().getUser()) || this.readAttendsInCurrentExecutionPeriod().size() < 10)) {
            throw new DomainException("error.student.reached.attends.limit", String.valueOf(10));
        }
    }

    public final void removeAttendFor(ExecutionCourse executionCourse) {
        Object object = advice$removeAttendFor.perform((Callable)new Registration$callable$removeAttendFor(this, executionCourse));
    }

    static final /* synthetic */ void advised$removeAttendFor(Registration this_, ExecutionCourse executionCourse) {
        Attends attend = this_.readRegistrationAttendByExecutionCourse(executionCourse);
        if (attend != null) {
            this_.checkIfHasEnrolmentFor(attend);
            this_.checkIfHasShiftsFor(executionCourse);
            attend.delete();
        }
    }

    public void checkIfHasEnrolmentFor(Attends attend) {
        if (attend.getEnrolment() != null) {
            throw new DomainException("errors.student.already.enroled", new String[0]);
        }
    }

    public void checkIfHasShiftsFor(ExecutionCourse executionCourse) {
        if (!this.getShiftsFor(executionCourse).isEmpty()) {
            throw new DomainException("errors.student.already.enroled.in.shift", new String[0]);
        }
    }

    public final Integer getNumber() {
        return super.getNumber() != null ? super.getNumber() : this.getStudent().getNumber();
    }

    public final Person getPerson() {
        return this.getStudent().getPerson();
    }

    public final String getName() {
        return this.getPerson().getName();
    }

    public final String getEmail() {
        return this.getPerson().getEmail();
    }

    public final Double getEntryGrade() {
        return this.getStudentCandidacy() != null ? this.getStudentCandidacy().getEntryGrade() : null;
    }

    public final void setEntryGrade(Double entryGrade) {
        if (this.getStudentCandidacy() == null) {
            throw new DomainException("error.registration.withou.student.candidacy", new String[0]);
        }
        this.getStudentCandidacy().setEntryGrade(entryGrade);
    }

    public final String getPrecedentDegreeConclusionGrade(SchoolLevelType levelType) {
        return this.hasPrecedentDegreeInformation(levelType) ? this.getPrecedentDegreeInformation(levelType).getConclusionGrade() : null;
    }

    public boolean hasPrecedentDegreeInformation(SchoolLevelType levelType) {
        return this.getPrecedentDegreeInformation(levelType) != null;
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation(SchoolLevelType levelType) {
        return super.getPrecedentDegreeInformation() != null && super.getPrecedentDegreeInformation().getSchoolLevel() == levelType ? super.getPrecedentDegreeInformation() : null;
    }

    public boolean isFirstCycleAtributionIngression() {
        return this.getIngressionType().isFirstCycleAttribution();
    }

    public boolean isSecondCycleInternalCandidacyIngression() {
        return this.getIngressionType().isInternal2ndCycleAccess();
    }

    public void setIngressionType(IngressionType ingressionType) {
        this.checkIngressionType(ingressionType);
        super.setIngressionType(ingressionType);
    }

    private void checkIngressionType(IngressionType ingressionType) {
        Registration.checkIngression(ingressionType, this.getPerson(), this.getFirstStudentCurricularPlan().getDegreeCurricularPlan());
    }

    public static void checkIngression(IngressionType ingressionType, Person person, DegreeCurricularPlan degreeCurricularPlan) {
        if (ingressionType.isReIngression()) {
            if (person == null || person.getStudent() == null) {
                throw new DomainException("error.registration.preBolonhaSourceDegreeNotFound", new String[0]);
            }
            if (degreeCurricularPlan.getEquivalencePlan() != null) {
                Student student = person.getStudent();
                Degree sourceDegree = degreeCurricularPlan.getEquivalencePlan().getSourceDegreeCurricularPlan().getDegree();
                Registration sourceRegistration = person.getStudent().readRegistrationByDegree(sourceDegree);
                if (sourceRegistration == null) {
                    Collection<Registration> registrations = student.getRegistrationsMatchingDegreeType(DegreeType::isPreBolonhaDegree);
                    registrations.removeAll(student.getRegistrationsFor(degreeCurricularPlan));
                    Registration registration = sourceRegistration = registrations.size() == 1 ? registrations.iterator().next() : null;
                }
                if (sourceRegistration == null) {
                    throw new DomainException("error.registration.preBolonhaSourceDegreeNotFound", new String[0]);
                }
                if (!sourceRegistration.getActiveStateType().canReingress()) {
                    throw new DomainException("error.registration.preBolonhaSourceRegistrationCannotReingress", new String[0]);
                }
            }
        }
    }

    public final ExecutionYear getIngressionYear() {
        return this.calculateIngressionYear();
    }

    public ExecutionYear calculateIngressionYear() {
        return this.inspectIngressionYear(this);
    }

    private ExecutionYear inspectIngressionYear(Registration registration) {
        if (registration.getSourceRegistration() == null) {
            return registration.getStartExecutionYear();
        }
        return this.inspectIngressionYear(registration.getSourceRegistration());
    }

    public final String getContigent() {
        return this.getStudentCandidacy() != null ? this.getStudentCandidacy().getContigent() : null;
    }

    public String getDegreeNameWithDegreeCurricularPlanName() {
        StudentCurricularPlan toAsk;
        StudentCurricularPlan studentCurricularPlan = toAsk = this.getStudentCurricularPlan(this.getStartExecutionYear()) == null ? this.getFirstStudentCurricularPlan() : this.getStudentCurricularPlan(this.getStartExecutionYear());
        if (toAsk == null) {
            return "";
        }
        return toAsk.getPresentationName(this.getStartExecutionYear());
    }

    public String getDegreeNameWithDescription() {
        return this.getDegree().getPresentationName(this.getStartExecutionYear());
    }

    public String getDegreeName() {
        return this.getDegree().getNameFor(this.getStartExecutionYear()).getContent();
    }

    public final String getDegreeDescription() {
        DegreeType degreeType = this.getDegreeType();
        return this.getDegreeDescription(degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : this.getLastConcludedCycleType());
    }

    @Deprecated
    public final String getDegreeDescription(CycleType cycleType) {
        return this.getDegreeDescription(cycleType, I18N.getLocale());
    }

    @Deprecated
    public final String getDegreeDescription(ExecutionYear executionYear, CycleType cycleType) {
        return this.getDegreeDescription(executionYear, cycleType, I18N.getLocale());
    }

    @Deprecated
    public final String getDegreeDescription(CycleType cycleType, Locale locale) {
        return this.getDegreeDescription(this.getStartExecutionYear(), cycleType, locale);
    }

    public final String getDegreeDescription(ExecutionYear executionYear, ProgramConclusion programConclusion, Locale locale) {
        StringBuilder res = new StringBuilder();
        Degree degree = this.getDegree();
        DegreeType degreeType = degree.getDegreeType();
        if (programConclusion != null && !programConclusion.isTerminal() && !Strings.isNullOrEmpty((String)programConclusion.getName().getContent(locale))) {
            res.append(programConclusion.getName().getContent(locale));
            res.append(", ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"label.of.the.male", (String[])new String[0])).append(" ");
        }
        if (programConclusion == null) {
            programConclusion = degreeType.getCycleTypes().stream().map(cycleType -> this.getLastStudentCurricularPlan().getCycleCourseGroup((CycleType)((Object)cycleType))).filter(Objects::nonNull).map(CourseGroup_Base::getProgramConclusion).filter(Objects::nonNull).findAny().orElseGet(() -> ProgramConclusion.conclusionsFor(this).findAny().orElse(null));
        }
        if (!this.isEmptyDegree() && !degreeType.isEmpty()) {
            res.append(degreeType.getPrefix(locale));
            if (programConclusion != null && !Strings.isNullOrEmpty((String)programConclusion.getDescription().getContent(locale))) {
                res.append(programConclusion.getDescription().getContent(locale).toUpperCase());
                res.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"label.in", (String[])new String[0])).append(" ");
            }
        }
        res.append(degree.getFilteredName(executionYear, locale).toUpperCase());
        return res.toString();
    }

    @Deprecated
    public final String getDegreeDescription(ExecutionYear executionYear, CycleType cycleType, Locale locale) {
        CycleCourseGroup cycleCourseGroup = this.getLastStudentCurricularPlan().getCycleCourseGroup(cycleType);
        ProgramConclusion programConclusion = cycleCourseGroup != null ? cycleCourseGroup.getProgramConclusion() : null;
        return this.getDegreeDescription(executionYear, programConclusion, locale);
    }

    public String getDegreeCurricularPlanName() {
        return this.getLastDegreeCurricularPlan().getName();
    }

    public final Degree getDegree() {
        return super.getDegree() != null ? super.getDegree() : (!this.getStudentCurricularPlansSet().isEmpty() ? this.getLastStudentCurricularPlan().getDegree() : null);
    }

    public final DegreeType getDegreeType() {
        return this.getDegree() == null ? null : this.getDegree().getDegreeType();
    }

    public final boolean isBolonha() {
        DegreeType degreeType = this.getDegreeType();
        return degreeType != null && degreeType.isBolonhaType();
    }

    public final boolean isActiveForOffice(Unit office) {
        return this.isActive() && this.isForOffice(office.getAdministrativeOffice());
    }

    @Deprecated
    public boolean isDegreeAdministrativeOffice() {
        return this.getDegree().getAdministrativeOffice().getAdministrativeOfficeType() == AdministrativeOfficeType.DEGREE;
    }

    public final boolean isForOffice(AdministrativeOffice administrativeOffice) {
        return this.getDegree().getAdministrativeOffice().equals((Object)administrativeOffice);
    }

    public final boolean isAllowedToManageRegistration() {
        return AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_REGISTRATIONS, Authenticate.getUser()).collect(Collectors.toSet()).contains(this.getDegree()) || AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.VIEW_FULL_STUDENT_CURRICULUM, Authenticate.getUser()).collect(Collectors.toSet()).contains(this.getDegree());
    }

    public boolean isCurricularCourseApproved(CurricularCourse curricularCourse) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.isCurricularCourseApproved(curricularCourse)) continue;
            return true;
        }
        return false;
    }

    public final Set<RegistrationStateType> getRegistrationStatesTypes(ExecutionYear executionYear) {
        HashSet<RegistrationStateType> result = new HashSet<RegistrationStateType>();
        for (RegistrationState registrationState : this.getRegistrationStates(executionYear)) {
            result.add(registrationState.getStateType());
        }
        return result;
    }

    public final Set<RegistrationStateType> getRegistrationStatesTypes(ExecutionSemester executionSemester) {
        HashSet<RegistrationStateType> result = new HashSet<RegistrationStateType>();
        for (RegistrationState registrationState : this.getRegistrationStates(executionSemester)) {
            result.add(registrationState.getStateType());
        }
        return result;
    }

    public boolean isRegistered(DateTime when) {
        RegistrationState stateInDate = this.getStateInDate(when);
        return stateInDate != null && stateInDate.isActive() || this.hasAnyEnrolmentsIn(ExecutionSemester.readByDateTime(when));
    }

    public boolean isRegistered(ExecutionSemester executionSemester) {
        return this.hasAnyActiveState(executionSemester) || this.hasAnyEnrolmentsIn(executionSemester);
    }

    public final boolean isRegistered(ExecutionYear executionYear) {
        return this.hasAnyActiveState(executionYear) || this.hasAnyEnrolmentsIn(executionYear);
    }

    public final RegistrationState getActiveState() {
        if (!this.getRegistrationStatesSet().isEmpty()) {
            RegistrationState activeState = null;
            for (RegistrationState state : this.getRegistrationStatesSet()) {
                if (state.getStateDate().isAfterNow() || activeState != null && RegistrationState.DATE_COMPARATOR.compare(activeState, state) >= 0) continue;
                activeState = state;
            }
            return activeState;
        }
        return null;
    }

    public RegistrationState getLastState() {
        RegistrationState result = null;
        for (RegistrationState state : this.getRegistrationStatesSet()) {
            if (result != null && !state.getStateDate().isAfter((ReadableInstant)result.getStateDate())) continue;
            result = state;
        }
        return result;
    }

    public RegistrationStateType getLastStateType() {
        RegistrationState registrationState = this.getLastState();
        return registrationState == null ? null : registrationState.getStateType();
    }

    public final RegistrationState getFirstState() {
        return this.getFirstRegistrationState();
    }

    public final RegistrationStateType getActiveStateType() {
        RegistrationState activeState = this.getActiveState();
        return activeState != null ? activeState.getStateType() : RegistrationStateType.REGISTERED;
    }

    public final boolean isActive() {
        return this.getActiveStateType().isActive();
    }

    public boolean hasAnyActiveState(ExecutionSemester executionSemester) {
        for (RegistrationState registrationState : this.getRegistrationStates(executionSemester)) {
            if (!registrationState.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveState(ExecutionYear executionYear) {
        for (RegistrationState registrationState : this.getRegistrationStates(executionYear)) {
            if (!registrationState.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveFirstState(ExecutionYear period) {
        Set<RegistrationState> states = this.getRegistrationStates(period);
        return states.isEmpty() ? false : Collections.min(states, RegistrationState.DATE_COMPARATOR).isActive();
    }

    public boolean hasActiveLastState(ExecutionSemester executionSemester) {
        Set<RegistrationState> states = this.getRegistrationStates(executionSemester);
        return states.isEmpty() ? false : Collections.max(states, RegistrationState.DATE_COMPARATOR).isActive();
    }

    public boolean hasRegistrationState(RegistrationStateType stateType) {
        for (RegistrationState state : this.getRegistrationStatesSet()) {
            if (state.getStateType() != stateType) continue;
            return true;
        }
        return false;
    }

    public final boolean isInRegisteredState() {
        return this.getActiveStateType() == RegistrationStateType.REGISTERED;
    }

    public final boolean isInternalAbandon() {
        return this.getActiveStateType() == RegistrationStateType.INTERNAL_ABANDON;
    }

    public final boolean getInterruptedStudies() {
        return this.isInterrupted();
    }

    public boolean isInterrupted() {
        return this.getActiveStateType() == RegistrationStateType.INTERRUPTED;
    }

    public final boolean getFlunked() {
        return this.isFlunked();
    }

    public boolean isFlunked() {
        return this.getActiveStateType() == RegistrationStateType.FLUNKED;
    }

    public final boolean isInMobilityState() {
        return this.getActiveStateType() == RegistrationStateType.MOBILITY;
    }

    public boolean isSchoolPartConcluded() {
        return this.getActiveStateType() == RegistrationStateType.SCHOOLPARTCONCLUDED;
    }

    public boolean isConcluded() {
        return this.getActiveStateType() == RegistrationStateType.CONCLUDED;
    }

    public boolean isTransited() {
        return this.getActiveStateType() == RegistrationStateType.TRANSITED;
    }

    public boolean isCanceled() {
        return this.getActiveStateType() == RegistrationStateType.CANCELED;
    }

    public final boolean isTransited(DateTime when) {
        RegistrationState stateInDate = this.getStateInDate(when);
        return stateInDate != null && stateInDate.getStateType() == RegistrationStateType.TRANSITED;
    }

    public final boolean isTransited(ExecutionYear executionYear) {
        return this.hasStateType(executionYear, RegistrationStateType.TRANSITED);
    }

    public final boolean isTransition() {
        return this.getActiveStateType() == RegistrationStateType.TRANSITION;
    }

    public final boolean isTransition(ExecutionYear executionYear) {
        return this.hasStateType(executionYear, RegistrationStateType.TRANSITION);
    }

    public final boolean getWasTransition() {
        return this.hasState(RegistrationStateType.TRANSITION);
    }

    public final RegistrationState getStateInDate(DateTime dateTime) {
        ArrayList sortedRegistrationStates = new ArrayList(this.getRegistrationStatesSet());
        Collections.sort(sortedRegistrationStates, RegistrationState.DATE_COMPARATOR);
        ListIterator iterator = sortedRegistrationStates.listIterator(sortedRegistrationStates.size());
        while (iterator.hasPrevious()) {
            RegistrationState registrationState = (RegistrationState)iterator.previous();
            if (dateTime.isBefore((ReadableInstant)registrationState.getStateDate())) continue;
            return registrationState;
        }
        return null;
    }

    public final RegistrationState getStateInDate(LocalDate localDate) {
        ArrayList sortedRegistrationStates = new ArrayList(this.getRegistrationStatesSet());
        Collections.sort(sortedRegistrationStates, RegistrationState.DATE_COMPARATOR);
        ListIterator iterator = sortedRegistrationStates.listIterator(sortedRegistrationStates.size());
        while (iterator.hasPrevious()) {
            RegistrationState registrationState = (RegistrationState)iterator.previous();
            if (localDate.isBefore((ReadablePartial)registrationState.getStateDate().toLocalDate())) continue;
            return registrationState;
        }
        return null;
    }

    public Set<RegistrationState> getRegistrationStates(ExecutionYear executionYear) {
        return this.getRegistrationStates((ReadableInstant)executionYear.getBeginDateYearMonthDay().toDateTimeAtMidnight(), (ReadableInstant)executionYear.getEndDateYearMonthDay().toDateTimeAtMidnight());
    }

    public Set<RegistrationState> getRegistrationStates(ExecutionSemester executionSemester) {
        return this.getRegistrationStates((ReadableInstant)executionSemester.getBeginDateYearMonthDay().toDateTimeAtMidnight(), (ReadableInstant)executionSemester.getEndDateYearMonthDay().toDateTimeAtMidnight());
    }

    public Set<RegistrationState> getRegistrationStates(ReadableInstant beginDateTime, ReadableInstant endDateTime) {
        HashSet<RegistrationState> result = new HashSet<RegistrationState>();
        this.populateRegistrationStates(beginDateTime, endDateTime, result);
        return result;
    }

    public List<RegistrationState> getRegistrationStatesList(ExecutionYear executionYear) {
        return this.getRegistrationStatesList((ReadableInstant)executionYear.getBeginDateYearMonthDay().toDateTimeAtMidnight(), (ReadableInstant)executionYear.getEndDateYearMonthDay().toDateTimeAtMidnight());
    }

    public List<RegistrationState> getRegistrationStatesList(ExecutionSemester executionSemester) {
        return this.getRegistrationStatesList((ReadableInstant)executionSemester.getBeginDateYearMonthDay().toDateTimeAtMidnight(), (ReadableInstant)executionSemester.getEndDateYearMonthDay().toDateTimeAtMidnight());
    }

    public List<RegistrationState> getRegistrationStatesList(ReadableInstant beginDateTime, ReadableInstant endDateTime) {
        ArrayList<RegistrationState> result = new ArrayList<RegistrationState>();
        this.populateRegistrationStates(beginDateTime, endDateTime, result);
        return result;
    }

    private void populateRegistrationStates(ReadableInstant beginDateTime, ReadableInstant endDateTime, Collection<RegistrationState> result) {
        ArrayList sortedRegistrationsStates = new ArrayList(this.getRegistrationStatesSet());
        Collections.sort(sortedRegistrationsStates, RegistrationState.DATE_COMPARATOR);
        ListIterator iter = sortedRegistrationsStates.listIterator(sortedRegistrationsStates.size());
        while (iter.hasPrevious()) {
            RegistrationState state = (RegistrationState)iter.previous();
            if (state.getStateDate().isAfter(endDateTime)) continue;
            result.add(state);
            if (state.getStateDate().isAfter(beginDateTime)) continue;
            break;
        }
    }

    public RegistrationState getFirstRegistrationState() {
        return !this.getRegistrationStatesSet().isEmpty() ? Collections.min(this.getRegistrationStatesSet(), RegistrationState.DATE_COMPARATOR) : null;
    }

    public final RegistrationState getLastRegistrationState(ExecutionYear executionYear) {
        ArrayList sortedRegistrationsStates = new ArrayList(this.getRegistrationStatesSet());
        Collections.sort(sortedRegistrationsStates, RegistrationState.DATE_COMPARATOR);
        ListIterator iter = sortedRegistrationsStates.listIterator(sortedRegistrationsStates.size());
        while (iter.hasPrevious()) {
            RegistrationState state = (RegistrationState)iter.previous();
            if (state.getStateDate().isAfter((ReadableInstant)executionYear.getEndDateYearMonthDay().toDateTimeAtMidnight())) continue;
            return state;
        }
        return null;
    }

    public boolean hasState(RegistrationStateType stateType) {
        return this.hasAnyState(Collections.singletonList(stateType));
    }

    public boolean hasAnyState(Collection<RegistrationStateType> stateTypes) {
        for (RegistrationState registrationState : this.getRegistrationStatesSet()) {
            if (!stateTypes.contains((Object)registrationState.getStateType())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasStateType(ExecutionSemester executionSemester, RegistrationStateType registrationStateType) {
        return this.getRegistrationStatesTypes(executionSemester).contains((Object)registrationStateType);
    }

    public final boolean hasStateType(ExecutionYear executionYear, RegistrationStateType registrationStateType) {
        return this.getRegistrationStatesTypes(executionYear).contains((Object)registrationStateType);
    }

    public boolean hasFlunkedState(ExecutionYear executionYear) {
        return this.hasStateType(executionYear, RegistrationStateType.FLUNKED);
    }

    public boolean hasRegisteredActiveState() {
        return this.getActiveStateType() == RegistrationStateType.REGISTERED;
    }

    public Collection<RegistrationState> getRegistrationStates(RegistrationStateType registrationStateType) {
        return this.getRegistrationStates(Collections.singletonList(registrationStateType));
    }

    public Collection<RegistrationState> getRegistrationStates(Collection<RegistrationStateType> registrationStateTypes) {
        HashSet<RegistrationState> result = new HashSet<RegistrationState>();
        for (RegistrationState registrationState : this.getRegistrationStatesSet()) {
            if (!registrationStateTypes.contains((Object)registrationState.getStateType())) continue;
            result.add(registrationState);
        }
        return result;
    }

    public final double getEctsCredits() {
        return this.calculateCredits();
    }

    public double calculateCredits() {
        return this.getTotalEctsCredits(null).doubleValue();
    }

    public final BigDecimal getTotalEctsCredits(ExecutionYear executionYear) {
        return this.getCurriculum(executionYear).getSumEctsCredits();
    }

    public double getEnrolmentsEcts(ExecutionYear executionYear) {
        return this.getLastStudentCurricularPlan().getEnrolmentsEctsCredits(executionYear);
    }

    public final int getCurricularYear() {
        return this.getCurricularYear(ExecutionYear.readCurrentExecutionYear());
    }

    public final int getCurricularYear(ExecutionYear executionYear) {
        return this.getCurriculum(executionYear).getCurricularYear();
    }

    public final int getCurricularYear(DateTime when, ExecutionYear executionYear) {
        return this.getCurriculum(when, executionYear, null).getCurricularYear();
    }

    public final Person getConclusionProcessResponsible() {
        return this.isRegistrationConclusionProcessed() ? this.getConclusionProcess().getResponsible() : null;
    }

    public final Person getConclusionProcessLastResponsible() {
        return this.isRegistrationConclusionProcessed() ? this.getConclusionProcess().getLastResponsible() : null;
    }

    public boolean isRegistrationConclusionProcessed() {
        return this.getLastStudentCurricularPlan().isConclusionProcessed();
    }

    public boolean isQualifiedToRegistrationConclusionProcess() {
        return this.isActive() || this.isConcluded();
    }

    public ExecutionYear calculateConclusionYear() {
        ExecutionYear result = this.getLastApprovementExecutionYear();
        if (result == null) {
            if (this.hasState(RegistrationStateType.CONCLUDED)) {
                return this.getFirstRegistrationState(RegistrationStateType.CONCLUDED).getExecutionYear();
            }
            if (this.isOldMasterDegree() && this.hasState(RegistrationStateType.SCHOOLPARTCONCLUDED)) {
                return this.getFirstRegistrationState(RegistrationStateType.SCHOOLPARTCONCLUDED).getExecutionYear();
            }
        }
        return result;
    }

    private RegistrationState getFirstRegistrationState(RegistrationStateType stateType) {
        TreeSet<RegistrationState> states = new TreeSet<RegistrationState>(RegistrationState.DATE_COMPARATOR);
        states.addAll(this.getRegistrationStates(stateType));
        return (RegistrationState)states.first();
    }

    private boolean isOldMasterDegree() {
        return this.getDegreeType().isPreBolonhaMasterDegree();
    }

    public YearMonthDay getConclusionDate() {
        return ProgramConclusion.getConclusionProcess(this.getLastStudentCurricularPlan()).map(ConclusionProcess::getConclusionYearMonthDay).orElse(null);
    }

    @Deprecated
    public YearMonthDay getConclusionDateForBolonha() {
        return this.getConclusionDate();
    }

    public final YearMonthDay getConclusionDate(CycleType cycleType) {
        if (!this.getDegreeType().hasAnyCycleTypes()) {
            return this.getConclusionDate();
        }
        if (!this.hasConcludedCycle(cycleType)) {
            throw new DomainException("Registration.hasnt.finished.given.cycle", new String[0]);
        }
        StudentCurricularPlan lastStudentCurricularPlan = this.getLastStudentCurricularPlan();
        if (lastStudentCurricularPlan == null) {
            throw new DomainException("Registration.has.no.student.curricular.plan", new String[0]);
        }
        return lastStudentCurricularPlan.getConclusionDate(cycleType);
    }

    public YearMonthDay calculateConclusionDate() {
        return this.getLastStudentCurricularPlan().getLastApprovementDate();
    }

    public YearMonthDay calculateConclusionDate(CycleType cycleType) {
        if (!this.getDegreeType().hasAnyCycleTypes()) {
            return this.calculateConclusionDate();
        }
        if (!this.hasConcludedCycle(cycleType)) {
            throw new DomainException("Registration.hasnt.finished.given.cycle", new String[0]);
        }
        StudentCurricularPlan lastStudentCurricularPlan = this.getLastStudentCurricularPlan();
        if (lastStudentCurricularPlan == null) {
            throw new DomainException("Registration.has.no.student.curricular.plan", new String[0]);
        }
        return lastStudentCurricularPlan.calculateConclusionDate(cycleType);
    }

    public final String getConclusionProcessNotes() {
        return this.isRegistrationConclusionProcessed() ? this.getConclusionProcess().getNotes() : null;
    }

    public final DateTime getConclusionProcessCreationDateTime() {
        return this.isRegistrationConclusionProcessed() ? this.getConclusionProcess().getCreationDateTime() : null;
    }

    public final DateTime getConclusionProcessLastModificationDateTime() {
        return this.isRegistrationConclusionProcessed() ? this.getConclusionProcess().getLastModificationDateTime() : null;
    }

    public final String getGraduateTitle(ProgramConclusion programConclusion, Locale locale) {
        if (programConclusion.isConclusionProcessed(this)) {
            ExecutionYear conclusionYear = programConclusion.groupFor(this).map(CurriculumGroup::getConclusionYear).orElse(null);
            return this.getLastDegreeCurricularPlan().getGraduateTitle(conclusionYear, programConclusion, locale);
        }
        throw new DomainException("Registration.hasnt.concluded.requested.cycle", new String[0]);
    }

    public final boolean hasConcludedFirstCycle() {
        return this.hasConcludedCycle(CycleType.FIRST_CYCLE);
    }

    public final boolean hasConcludedSecondCycle() {
        return this.hasConcludedCycle(CycleType.SECOND_CYCLE);
    }

    public final boolean hasConcludedCycle(CycleType cycleType) {
        return this.getLastStudentCurricularPlan().hasConcludedCycle(cycleType);
    }

    public final boolean hasConcludedCycle(CycleType cycleType, ExecutionYear executionYear) {
        return this.getLastStudentCurricularPlan().hasConcludedCycle(cycleType, executionYear);
    }

    public boolean hasConcluded() {
        StudentCurricularPlan lastStudentCurricularPlan = this.getLastStudentCurricularPlan();
        return lastStudentCurricularPlan.isConcluded();
    }

    public boolean getHasConcluded() {
        return this.hasConcluded();
    }

    public final Collection<CycleType> getConcludedCycles() {
        if (!this.getDegreeType().hasAnyCycleTypes()) {
            return Collections.EMPTY_SET;
        }
        TreeSet<CycleType> result = new TreeSet<CycleType>(CycleType.COMPARATOR_BY_LESS_WEIGHT);
        for (CycleType cycleType : this.getDegreeType().getCycleTypes()) {
            if (!this.hasConcludedCycle(cycleType)) continue;
            result.add(cycleType);
        }
        return result;
    }

    public final Collection<CycleCurriculumGroup> getConclusionProcessedCycles(ExecutionYear executionYear) {
        HashSet<CycleCurriculumGroup> result = new HashSet<CycleCurriculumGroup>();
        for (CycleCurriculumGroup group : this.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops()) {
            if (!group.isConclusionProcessed() || group.getConclusionYear() != executionYear) continue;
            result.add(group);
        }
        return result;
    }

    public final Collection<CycleType> getConcludedCycles(ExecutionYear executionYear) {
        if (!this.getDegreeType().hasAnyCycleTypes()) {
            return Collections.emptySet();
        }
        TreeSet<CycleType> result = new TreeSet<CycleType>(CycleType.COMPARATOR_BY_LESS_WEIGHT);
        for (CycleType cycleType : this.getDegreeType().getCycleTypes()) {
            if (!this.hasConcludedCycle(cycleType, executionYear)) continue;
            result.add(cycleType);
        }
        return result;
    }

    public final CycleType getCurrentCycleType() {
        return this.getCycleType(ExecutionYear.readCurrentExecutionYear());
    }

    public final CycleType getCycleType(ExecutionYear executionYear) {
        if (!this.isBolonha() || this.isEmptyDegree() || this.getDegreeType().isEmpty()) {
            return null;
        }
        TreeSet<CycleType> concludedCycles = new TreeSet<CycleType>(this.getConcludedCycles(executionYear));
        if (concludedCycles.isEmpty()) {
            return this.getLastStudentCurricularPlan().getFirstOrderedCycleCurriculumGroup().getCycleType();
        }
        CycleType result = null;
        for (CycleType cycleType : concludedCycles) {
            CycleCurriculumGroup group = this.getLastStudentCurricularPlan().getCycle(cycleType);
            if (!group.hasEnrolment(executionYear)) continue;
            result = cycleType;
        }
        if (result != null) {
            return result;
        }
        CycleType last = (CycleType)((Object)concludedCycles.last());
        return last.hasNext() && this.getDegreeType().hasCycleTypes(last.getNext()) ? last.getNext() : last;
    }

    private boolean isEmptyDegree() {
        return this.getLastStudentCurricularPlan() != null ? this.getLastStudentCurricularPlan().isEmpty() : true;
    }

    public final CycleType getLastConcludedCycleType() {
        TreeSet<CycleType> concludedCycles = new TreeSet<CycleType>(this.getConcludedCycles());
        return concludedCycles.isEmpty() ? null : (CycleType)((Object)concludedCycles.last());
    }

    public boolean canRepeatConclusionProcess(Person person) {
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.REPEAT_CONCLUSION_PROCESS, (AcademicProgram)((Object)this.getDegree()), person.getUser());
    }

    public void conclude(CurriculumGroup curriculumGroup) {
        AccessControl.check(this, RegistrationPredicates.MANAGE_CONCLUSION_PROCESS);
        if (curriculumGroup == null || !this.getLastStudentCurricularPlan().hasCurriculumModule((CurriculumModule)((Object)curriculumGroup))) {
            throw new DomainException("error.Registration.invalid.cycleCurriculumGroup", new String[0]);
        }
        curriculumGroup.conclude();
        ProgramConclusion conclusion = curriculumGroup.getDegreeModule().getProgramConclusion();
        if (conclusion != null && conclusion.getTargetState() != null && !conclusion.getTargetState().equals((Object)this.getActiveStateType())) {
            RegistrationState.createRegistrationState(this, AccessControl.getPerson(), new DateTime(), conclusion.getTargetState());
        }
    }

    public final boolean hasApprovement(ExecutionYear executionYear) {
        int curricularYearAtTheEnd;
        int curricularYearInTheBegin = this.getCurricularYear(executionYear);
        if (curricularYearInTheBegin > (curricularYearAtTheEnd = this.getCurricularYear(executionYear.getNextExecutionYear()))) {
            throw new DomainException("Registration.curricular.year.has.decreased", new String[0]);
        }
        return curricularYearAtTheEnd > curricularYearInTheBegin;
    }

    public final boolean isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() {
        return this.getDegreeType().isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree();
    }

    public final boolean isMasterDegreeOrBolonhaMasterDegree() {
        DegreeType degreeType = this.getDegreeType();
        return degreeType.isPreBolonhaMasterDegree() || degreeType.isBolonhaMasterDegree();
    }

    public final boolean isDEA() {
        return this.getDegreeType().isAdvancedSpecializationDiploma();
    }

    public final EnrolmentModel getEnrolmentModelForCurrentExecutionYear() {
        return this.getEnrolmentModelForExecutionYear(ExecutionYear.readCurrentExecutionYear());
    }

    public final EnrolmentModel getEnrolmentModelForExecutionYear(ExecutionYear year) {
        RegistrationDataByExecutionYear registrationData = this.getRegistrationDataByExecutionYear(year);
        return registrationData != null ? registrationData.getEnrolmentModel() : null;
    }

    public final void setEnrolmentModelForCurrentExecutionYear(EnrolmentModel model) {
        this.setEnrolmentModelForExecutionYear(ExecutionYear.readCurrentExecutionYear(), model);
    }

    public final void setEnrolmentModelForExecutionYear(ExecutionYear year, EnrolmentModel model) {
        RegistrationDataByExecutionYear registrationData = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear(this, year);
        registrationData.setEnrolmentModel(model);
    }

    private RegistrationDataByExecutionYear getRegistrationDataByExecutionYear(ExecutionYear year) {
        for (RegistrationDataByExecutionYear registrationData : this.getRegistrationDataByExecutionYearSet()) {
            if (!registrationData.getExecutionYear().equals(year)) continue;
            return registrationData;
        }
        return null;
    }

    public final ExecutionYear getRegistrationYear() {
        return super.getRegistrationYear() == null ? this.getFirstEnrolmentExecutionYear() : super.getRegistrationYear();
    }

    public final boolean isFirstTime(ExecutionYear executionYear) {
        return this.getRegistrationYear() == executionYear;
    }

    public final boolean isFirstTime() {
        return this.isFirstTime(ExecutionYear.readCurrentExecutionYear());
    }

    public final StudentCurricularPlan getStudentCurricularPlan(ExecutionYear executionYear) {
        return executionYear == null ? this.getStudentCurricularPlan(new YearMonthDay()) : this.getStudentCurricularPlan(executionYear.getEndDateYearMonthDay());
    }

    public final StudentCurricularPlan getStudentCurricularPlanForCurrentExecutionYear() {
        return this.getStudentCurricularPlan(ExecutionYear.readCurrentExecutionYear());
    }

    public final StudentCurricularPlan getStudentCurricularPlan(ExecutionSemester executionSemester) {
        return executionSemester == null ? this.getStudentCurricularPlan(new YearMonthDay()) : this.getStudentCurricularPlan(executionSemester.getEndDateYearMonthDay());
    }

    public final StudentCurricularPlan getStudentCurricularPlan(YearMonthDay date) {
        StudentCurricularPlan result = null;
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            YearMonthDay startDate = studentCurricularPlan.getStartDateYearMonthDay();
            if (startDate.isAfter((ReadablePartial)date) || result != null && !startDate.isAfter((ReadablePartial)result.getStartDateYearMonthDay())) continue;
            result = studentCurricularPlan;
        }
        return result;
    }

    public final StudentCurricularPlan getStudentCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.getDegreeCurricularPlan().equals((Object)degreeCurricularPlan)) continue;
            return studentCurricularPlan;
        }
        return null;
    }

    public final Set<DegreeCurricularPlan> getDegreeCurricularPlans() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            result.add(studentCurricularPlan.getDegreeCurricularPlan());
        }
        return result;
    }

    public final YearMonthDay getStartDate() {
        if (super.getStartDate() != null) {
            return super.getStartDate();
        }
        if (this.getStudentCandidacy() != null) {
            return this.getStudentCandidacy().getActiveCandidacySituation().getSituationDate().toYearMonthDay();
        }
        if (this.getRegistrationYear() != null) {
            return this.getRegistrationYear().getBeginDateYearMonthDay();
        }
        return null;
    }

    public final ExecutionYear getStartExecutionYear() {
        ExecutionYear registrationYear = this.getRegistrationYear();
        return registrationYear != null ? registrationYear : ExecutionYear.readByDateTime(this.getStartDate().toDateTimeAtMidnight());
    }

    public final boolean hasStartedBeforeFirstBolonhaExecutionYear() {
        return this.getStartExecutionYear().isBefore(ExecutionYear.readFirstBolonhaExecutionYear());
    }

    public final boolean hasStudentCurricularPlanInExecutionPeriod(ExecutionSemester executionSemester) {
        return this.getStudentCurricularPlan(executionSemester) != null;
    }

    public final boolean isCustomEnrolmentModel(ExecutionYear executionYear) {
        return this.getEnrolmentModelForExecutionYear(executionYear) == EnrolmentModel.CUSTOM;
    }

    public final boolean isCustomEnrolmentModel() {
        return this.isCustomEnrolmentModel(ExecutionYear.readCurrentExecutionYear());
    }

    public final boolean isCompleteEnrolmentModel(ExecutionYear executionYear) {
        return this.getEnrolmentModelForExecutionYear(executionYear) == EnrolmentModel.COMPLETE;
    }

    public final boolean isCompleteEnrolmentModel() {
        return this.isCompleteEnrolmentModel(ExecutionYear.readCurrentExecutionYear());
    }

    public final DegreeCurricularPlan getActiveDegreeCurricularPlan() {
        return this.getActiveStudentCurricularPlan() != null ? this.getActiveStudentCurricularPlan().getDegreeCurricularPlan() : null;
    }

    public final DegreeCurricularPlan getLastDegreeCurricularPlan() {
        return this.getLastStudentCurricularPlan() != null ? this.getLastStudentCurricularPlan().getDegreeCurricularPlan() : null;
    }

    public Degree getLastDegree() {
        return this.getLastDegreeCurricularPlan().getDegree();
    }

    private boolean hasAnyNotPayedGratuityEvents() {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyNotPayedGratuityEvents()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedInsuranceEvents() {
        for (InsuranceEvent event : this.getPerson().getNotCancelledInsuranceEvents()) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEvents(AdministrativeOffice office) {
        for (AdministrativeOfficeFeeAndInsuranceEvent event : this.getPerson().getNotCancelledAdministrativeOfficeFeeAndInsuranceEvents(office)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedGratuityEventUntil(ExecutionYear executionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyNotPayedGratuityEventsUntil(executionYear)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedInsuranceEventUntil(ExecutionYear executionYear) {
        for (InsuranceEvent event : this.getPerson().getNotCancelledInsuranceEventsUntil(executionYear)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEventUntil(AdministrativeOffice office, ExecutionYear executionYear) {
        for (AdministrativeOfficeFeeAndInsuranceEvent event : this.getPerson().getNotCancelledAdministrativeOfficeFeeAndInsuranceEventsUntil(office, executionYear)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyNotPayedGratuityEventsForPreviousYears(ExecutionYear limitExecutionYear) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasAnyNotPayedGratuityEventsForPreviousYears(limitExecutionYear)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasToPayGratuityOrInsurance() {
        return this.getInterruptedStudies() ? false : this.getRegistrationProtocol().isToPayGratuity();
    }

    public final DiplomaRequest getDiplomaRequest(CycleType cycleType) {
        return this.getDiplomaRequest(this.getLastStudentCurricularPlan().getCycleCourseGroup(cycleType).getProgramConclusion());
    }

    public final DiplomaRequest getDiplomaRequest(ProgramConclusion programConclusion) {
        for (DocumentRequest documentRequest : this.getDocumentRequests()) {
            if (!documentRequest.isDiploma() || documentRequest.finishedUnsuccessfully()) continue;
            DiplomaRequest diplomaRequest = (DiplomaRequest)((Object)documentRequest);
            if (programConclusion != null && !programConclusion.equals((Object)diplomaRequest.getProgramConclusion())) continue;
            return diplomaRequest;
        }
        return null;
    }

    public final PastDiplomaRequest getPastDiplomaRequest() {
        for (DocumentRequest documentRequest : this.getDocumentRequests()) {
            if (!documentRequest.isPastDiploma() || documentRequest.finishedUnsuccessfully()) continue;
            return (PastDiplomaRequest)((Object)documentRequest);
        }
        return null;
    }

    public final RegistryDiplomaRequest getRegistryDiplomaRequest(CycleType cycleType) {
        return this.getRegistryDiplomaRequest(this.getLastStudentCurricularPlan().getCycleCourseGroup(cycleType).getProgramConclusion());
    }

    public final RegistryDiplomaRequest getRegistryDiplomaRequest(ProgramConclusion programConclusion) {
        for (DocumentRequest documentRequest : this.getDocumentRequests()) {
            if (!documentRequest.isRegistryDiploma() || documentRequest.finishedUnsuccessfully()) continue;
            RegistryDiplomaRequest registryDiplomaRequest = (RegistryDiplomaRequest)((Object)documentRequest);
            if (programConclusion != null && !programConclusion.equals((Object)registryDiplomaRequest.getProgramConclusion())) continue;
            return registryDiplomaRequest;
        }
        return null;
    }

    public final DiplomaSupplementRequest getDiplomaSupplementRequest(ProgramConclusion programConclusion) {
        for (DocumentRequest documentRequest : this.getDocumentRequests()) {
            if (!documentRequest.isDiplomaSupplement() || documentRequest.finishedUnsuccessfully()) continue;
            DiplomaSupplementRequest diplomaSupplementRequest = (DiplomaSupplementRequest)((Object)documentRequest);
            if (programConclusion != null && !programConclusion.equals((Object)diplomaSupplementRequest.getProgramConclusion())) continue;
            return diplomaSupplementRequest;
        }
        return null;
    }

    public final Collection<DocumentRequest> getDocumentRequests() {
        HashSet<DocumentRequest> result = new HashSet<DocumentRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isDocumentRequest()) continue;
            result.add((DocumentRequest)((Object)academicServiceRequest));
        }
        return result;
    }

    public final Set<DocumentRequest> getDocumentRequests(DocumentRequestType documentRequestType, AcademicServiceRequestSituationType academicServiceRequestSituationType, ExecutionYear executionYear, boolean collectDocumentsMarkedAsFreeProcessed) {
        HashSet<DocumentRequest> result = new HashSet<DocumentRequest>();
        for (DocumentRequest documentRequest : this.getDocumentRequests()) {
            if (documentRequest.getDocumentRequestType() != documentRequestType || documentRequest.getAcademicServiceRequestSituationType() != academicServiceRequestSituationType || !executionYear.containsDate(documentRequest.getCreationDate()) || collectDocumentsMarkedAsFreeProcessed && !documentRequest.isFreeProcessed()) continue;
            result.add(documentRequest);
        }
        return result;
    }

    public final Set<DocumentRequest> getSucessfullyFinishedDocumentRequestsBy(ExecutionYear executionYear, DocumentRequestType documentRequestType, boolean collectDocumentsMarkedAsFreeProcessed) {
        HashSet<DocumentRequest> result = new HashSet<DocumentRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            DocumentRequest documentRequest;
            if (!(academicServiceRequest instanceof DocumentRequest) || (documentRequest = (DocumentRequest)((Object)academicServiceRequest)).getDocumentRequestType() != documentRequestType || !documentRequest.finishedSuccessfully() || !executionYear.containsDate(documentRequest.getCreationDate()) || collectDocumentsMarkedAsFreeProcessed && !documentRequest.isFreeProcessed()) continue;
            result.add((DocumentRequest)((Object)academicServiceRequest));
        }
        return result;
    }

    public final Collection<DocumentRequest> getSucessfullyFinishedDocumentRequests(DocumentRequestType documentRequestType) {
        HashSet<DocumentRequest> result = new HashSet<DocumentRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            DocumentRequest documentRequest;
            if (!(academicServiceRequest instanceof DocumentRequest) || (documentRequest = (DocumentRequest)((Object)academicServiceRequest)).getDocumentRequestType() != documentRequestType || !documentRequest.finishedSuccessfully()) continue;
            result.add((DocumentRequest)((Object)academicServiceRequest));
        }
        return result;
    }

    public final Collection<? extends AcademicServiceRequest> getAcademicServiceRequests(Class<? extends AcademicServiceRequest> clazz) {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (clazz == null || !academicServiceRequest.getClass().equals(clazz)) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public Collection<? extends AcademicServiceRequest> getAcademicServiceRequests(Class<? extends AcademicServiceRequest> clazz, ExecutionYear executionYear) {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (clazz == null || !academicServiceRequest.getClass().equals(clazz) || !academicServiceRequest.isFor(executionYear)) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public final Collection<? extends AcademicServiceRequest> getAcademicServiceRequests(AcademicServiceRequestSituationType academicServiceRequestSituationType) {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if ((academicServiceRequestSituationType != null || !academicServiceRequest.isNewRequest()) && academicServiceRequest.getAcademicServiceRequestSituationType() != academicServiceRequestSituationType) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public final Collection<AcademicServiceRequest> getNewAcademicServiceRequests() {
        return this.getAcademicServiceRequests(AcademicServiceRequestSituationType.NEW);
    }

    public final Collection<AcademicServiceRequest> getProcessingAcademicServiceRequests() {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.hasProcessed() || academicServiceRequest.isConcluded() || academicServiceRequest.isDelivered() || academicServiceRequest.finishedUnsuccessfully()) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public Collection<AcademicServiceRequest> getToDeliverAcademicServiceRequests() {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isDeliveredSituationAccepted()) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public final Collection<AcademicServiceRequest> getConcludedAcademicServiceRequests() {
        return this.getAcademicServiceRequests(AcademicServiceRequestSituationType.CONCLUDED);
    }

    public final Collection<AcademicServiceRequest> getHistoricalAcademicServiceRequests() {
        HashSet<AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest academicServiceRequest : this.getAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isHistorical()) continue;
            result.add(academicServiceRequest);
        }
        return result;
    }

    public final boolean isInactive() {
        return this.getActiveStateType().isInactive();
    }

    public Space getCampus() {
        return this.getLastStudentCurricularPlan().getLastCampus();
    }

    public Space getCampus(ExecutionYear executionYear) {
        StudentCurricularPlan scp = this.getStudentCurricularPlan(executionYear);
        return scp == null ? this.getLastStudentCurricularPlan().getCampus(executionYear) : scp.getCampus(executionYear);
    }

    public final String getIstUniversity() {
        return this.getCampus().getName();
    }

    public final void setStudentCandidacy(StudentCandidacy studentCandidacy) {
        if (this.getStudentCandidacy() != null) {
            throw new DomainException("error.org.fenixedu.academic.domain.student.Registration.studentCandidacy.cannot.be.modified", new String[0]);
        }
        super.setStudentCandidacy(studentCandidacy);
    }

    public final void removeStudentCandidacy() {
        super.setStudentCandidacy(null);
    }

    public final Boolean getPayedTuition() {
        return !this.hasAnyNotPayedGratuityEventsForPreviousYears(ExecutionYear.readCurrentExecutionYear());
    }

    public final boolean getHasGratuityDebtsCurrently() {
        return this.hasGratuityDebtsCurrently();
    }

    public final boolean hasGratuityDebtsCurrently() {
        return this.hasAnyNotPayedGratuityEvents();
    }

    public final boolean hasInsuranceDebtsCurrently() {
        return this.hasAnyNotPayedInsuranceEvents();
    }

    public final boolean hasAdministrativeOfficeFeeAndInsuranceDebtsCurrently(AdministrativeOffice administrativeOffice) {
        return this.hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEvents(administrativeOffice);
    }

    public final boolean hasGratuityDebts(ExecutionYear executionYear) {
        return this.hasAnyNotPayedGratuityEventUntil(executionYear);
    }

    public final boolean hasInsuranceDebts(ExecutionYear executionYear) {
        return this.hasAnyNotPayedInsuranceEventUntil(executionYear);
    }

    public final boolean hasAdministrativeOfficeFeeAndInsuranceDebts(AdministrativeOffice office, ExecutionYear executionYear) {
        return this.hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEventUntil(office, executionYear);
    }

    public final Attends readAttendByExecutionCourse(ExecutionCourse executionCourse) {
        return this.getStudent().readAttendByExecutionCourse(executionCourse);
    }

    public final Attends readRegistrationAttendByExecutionCourse(ExecutionCourse executionCourse) {
        for (Attends attend : this.getAssociatedAttendsSet()) {
            if (!attend.isFor(executionCourse)) continue;
            return attend;
        }
        return null;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        if (registrationProtocol == null) {
            registrationProtocol = RegistrationProtocol.getDefault();
        }
        super.setRegistrationProtocol(registrationProtocol);
        if (registrationProtocol != null && registrationProtocol.isEnrolmentByStudentAllowed() && !registrationProtocol.isAlien() && this.getExternalRegistrationData() == null) {
            new ExternalRegistrationData(this);
        }
    }

    public final boolean hasGratuityEvent(ExecutionYear executionYear, Class<? extends GratuityEvent> type) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.hasGratuityEvent(executionYear, type)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasDissertationThesis() {
        return this.getDissertationEnrolment() != null && this.getDissertationEnrolment().getThesis() != null;
    }

    public final String getDissertationThesisTitle() {
        String result = null;
        if (this.hasDissertationThesis()) {
            result = this.getDissertationEnrolment().getThesis().getFinalFullTitle().getContent().trim();
        }
        return result;
    }

    public final LocalDate getDissertationThesisDiscussedDate() {
        if (this.hasDissertationThesis()) {
            Thesis thesis = this.getDissertationEnrolment().getThesis();
            return thesis.hasCurrentDiscussedDate() ? thesis.getCurrentDiscussedDate().toLocalDate() : null;
        }
        return null;
    }

    public final Enrolment getDissertationEnrolment() {
        return this.getDissertationEnrolment(null);
    }

    public final Enrolment getDissertationEnrolment(DegreeCurricularPlan degreeCurricularPlan) {
        for (StudentCurricularPlan scp : this.getStudentCurricularPlansSet()) {
            Enrolment enrolment;
            if (degreeCurricularPlan != null && scp.getDegreeCurricularPlan() != degreeCurricularPlan || (enrolment = scp.getLatestDissertationEnrolment()) == null) continue;
            return enrolment;
        }
        return null;
    }

    public Set<Enrolment> getDissertationEnrolments(DegreeCurricularPlan degreeCurricularPlan) {
        HashSet<Enrolment> enrolments = new HashSet<Enrolment>();
        for (StudentCurricularPlan scp : this.getStudentCurricularPlansSet()) {
            if (degreeCurricularPlan != null && scp.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            enrolments.addAll(scp.getDissertationEnrolments());
        }
        return enrolments;
    }

    public final StudentCurricularPlan getLastStudentDegreeCurricularPlansByDegree(Degree degree) {
        TreeSet<StudentCurricularPlan> result = new TreeSet<StudentCurricularPlan>(StudentCurricularPlan.DATE_COMPARATOR);
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlans()) {
            if (degreeCurricularPlan.getDegree() != degree) continue;
            result.add(this.getStudentCurricularPlan(degreeCurricularPlan));
        }
        return (StudentCurricularPlan)((Object)result.last());
    }

    public final ExternalEnrolment findExternalEnrolment(Unit university, ExecutionSemester period, String code) {
        for (ExternalEnrolment externalEnrolment : this.getExternalEnrolmentsSet()) {
            if (externalEnrolment.getExecutionPeriod() != period || !externalEnrolment.getExternalCurricularCourse().getCode().equals(code) || externalEnrolment.getExternalCurricularCourse().getUnit() != university) continue;
            return externalEnrolment;
        }
        return null;
    }

    public final SortedSet<ExternalEnrolment> getSortedExternalEnrolments() {
        TreeSet<ExternalEnrolment> result = new TreeSet<ExternalEnrolment>(ExternalEnrolment.COMPARATOR_BY_NAME);
        result.addAll(this.getExternalEnrolmentsSet());
        return result;
    }

    public Registration getSourceRegistrationForTransition() {
        if (this.getLastDegreeCurricularPlan().getEquivalencePlan() == null) {
            return null;
        }
        DegreeCurricularPlanEquivalencePlan equivalencePlan = this.getLastDegreeCurricularPlan().getEquivalencePlan();
        List<Registration> registrations = this.getStudent().getRegistrationsFor(equivalencePlan.getSourceDegreeCurricularPlan());
        return registrations.isEmpty() ? null : registrations.iterator().next();
    }

    public List<Registration> getTargetTransitionRegistrations() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (DegreeCurricularPlanEquivalencePlan equivalencePlan : this.getLastDegreeCurricularPlan().getTargetEquivalencePlans()) {
            Registration transitionRegistration = this.getStudent().getTransitionRegistrationFor(equivalencePlan.getDegreeCurricularPlan());
            if (transitionRegistration == null) continue;
            result.add(transitionRegistration);
        }
        return result;
    }

    public void transitToBolonha(Person person, DateTime when) {
        if (!this.isActive()) {
            throw new DomainException("error.student.Registration.cannot.transit.non.active.registrations", new String[0]);
        }
        RegistrationState.createRegistrationState(this, person, when, RegistrationStateType.TRANSITED);
        for (Registration registration : this.getTargetTransitionRegistrations()) {
            if (registration.getDegreeType().isBolonhaDegree()) {
                RegistrationState.createRegistrationState(registration, person, when, registration.hasConcluded() ? RegistrationStateType.CONCLUDED : RegistrationStateType.REGISTERED);
            } else {
                RegistrationState.createRegistrationState(registration, person, when, RegistrationStateType.REGISTERED);
            }
            registration.setRegistrationProtocol(this.getRegistrationProtocol());
            registration.setSourceRegistration(this);
            this.changeAttends(registration, when);
        }
        if (!this.getTargetTransitionRegistrations().isEmpty()) {
            this.changeAttends(this.getTargetTransitionRegistrations().iterator().next(), when);
        }
    }

    private void changeAttends(Registration newRegistration, DateTime when) {
        ExecutionSemester executionSemester = ExecutionSemester.readByDateTime(when);
        if (executionSemester == null) {
            throw new DomainException("error.Registration.invalid.when.date", new String[0]);
        }
        block0: for (Attends attends : this.getAssociatedAttendsSet()) {
            if (!attends.getExecutionPeriod().isAfterOrEquals(executionSemester)) continue;
            for (CurricularCourse curricularCourse : attends.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
                if (curricularCourse.getDegreeCurricularPlan() != newRegistration.getLastDegreeCurricularPlan()) continue;
                attends.setRegistration(newRegistration);
                continue block0;
            }
        }
    }

    public boolean isEnrolmentByStudentAllowed() {
        return this.isActive() && this.getRegistrationProtocol().isEnrolmentByStudentAllowed();
    }

    @Deprecated
    public boolean isEnrolmentByStudentAllowed(DegreeType type) {
        return DEGREE_TYPES_TO_ENROL_BY_STUDENT.test(type);
    }

    public boolean isEnrolmentByStudentInShiftsAllowed() {
        return this.isActive();
    }

    public void editStartDates(LocalDate startDate, LocalDate homologationDate, LocalDate studiesStartDate) {
        this.editStartDates(new YearMonthDay((Object)startDate), new YearMonthDay((Object)homologationDate), new YearMonthDay((Object)studiesStartDate));
    }

    public void editStartDates(YearMonthDay startDate, YearMonthDay homologationDate, YearMonthDay studiesStartDate) {
        this.editStartDates(null, startDate, homologationDate, studiesStartDate);
    }

    public void editStartDates(ExecutionYear registrationYear, YearMonthDay startDate, YearMonthDay homologationDate, YearMonthDay studiesStartDate) {
        this.setStartDate(startDate);
        if (registrationYear != null) {
            if (this.getStartDate().isAfter((ReadablePartial)registrationYear.getEndLocalDate())) {
                throw new DomainException("error.Registration.startDate.after.registrationYear", new String[0]);
            }
            this.setRegistrationYear(registrationYear);
        }
        RegistrationState firstRegistrationState = this.getFirstRegistrationState();
        firstRegistrationState.setStateDate(startDate);
        if (firstRegistrationState != this.getFirstRegistrationState()) {
            throw new DomainException("error.Registration.startDate.changes.first.registration.state", new String[0]);
        }
        StudentCurricularPlan first = this.getFirstStudentCurricularPlan();
        first.setStartDate(startDate);
        if (first != this.getFirstStudentCurricularPlan()) {
            throw new DomainException("error.Registration.startDate.changes.first.scp", new String[0]);
        }
        this.setHomologationDate(homologationDate);
        this.setStudiesStartDate(studiesStartDate);
    }

    public void setStartDate(YearMonthDay startDate) {
        if (startDate == null) {
            throw new DomainException("error.Registration.null.startDate", new String[0]);
        }
        super.setStartDate(startDate);
        ExecutionYear year = ExecutionYear.readByDateTime(startDate.toLocalDate());
        if (year == null) {
            throw new DomainException("error.Registration.invalid.execution.year", new String[0]);
        }
        this.setRegistrationYear(year);
    }

    public StudentStatute grantSeniorStatute(ExecutionYear executionYear) {
        return (StudentStatute)((Object)advice$grantSeniorStatute.perform((Callable)new Registration$callable$grantSeniorStatute(this, executionYear)));
    }

    static /* synthetic */ StudentStatute advised$grantSeniorStatute(Registration this_, ExecutionYear executionYear) {
        return new SeniorStatute(this_.getStudent(), this_, StatuteType.findSeniorStatuteType().orElse(null), executionYear.getFirstExecutionPeriod(), executionYear.getLastExecutionPeriod());
    }

    public void setHomologationDate(LocalDate homologationDate) {
        this.setHomologationDate(new YearMonthDay((Object)homologationDate));
    }

    public void setStudiesStartDate(LocalDate studiesStartDate) {
        this.setStudiesStartDate(new YearMonthDay((Object)studiesStartDate));
    }

    public Collection<CurriculumLineLog> getCurriculumLineLogs(ExecutionSemester executionSemester) {
        HashSet<CurriculumLineLog> res = new HashSet<CurriculumLineLog>();
        for (CurriculumLineLog curriculumLineLog : this.getCurriculumLineLogsSet()) {
            if (!curriculumLineLog.isFor(executionSemester)) continue;
            res.add(curriculumLineLog);
        }
        return res;
    }

    public boolean containsEnrolmentOutOfPeriodEventFor(ExecutionSemester executionSemester) {
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansSet()) {
            for (EnrolmentOutOfPeriodEvent event : studentCurricularPlan.getEnrolmentOutOfPeriodEventsSet()) {
                if (event.getExecutionPeriod() != executionSemester) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStartedBetween(ExecutionYear firstExecutionYear, ExecutionYear finalExecutionYear) {
        return this.getStartExecutionYear().isAfterOrEquals(firstExecutionYear) && this.getStartExecutionYear().isBeforeOrEquals(finalExecutionYear);
    }

    public boolean hasRegistrationRegime(ExecutionYear executionYear, RegistrationRegimeType type) {
        for (RegistrationRegime regime : this.getRegistrationRegimesSet()) {
            if (!regime.isFor(executionYear) || !regime.hasRegime(type)) continue;
            return true;
        }
        return false;
    }

    public RegistrationRegimeType getRegimeType(ExecutionYear executionYear) {
        for (RegistrationRegime regime : this.getRegistrationRegimesSet()) {
            if (!regime.isFor(executionYear)) continue;
            return regime.getRegimeType();
        }
        return RegistrationRegimeType.defaultType();
    }

    public boolean isPartialRegime(ExecutionYear executionYear) {
        return this.getRegimeType(executionYear) == RegistrationRegimeType.PARTIAL_TIME;
    }

    public boolean isFullRegime(ExecutionYear executionYear) {
        return this.getRegimeType(executionYear) == RegistrationRegimeType.FULL_TIME;
    }

    public void changeShifts(Attends attend, Registration newRegistration) {
        for (Shift shift : this.getShiftsSet()) {
            if (!attend.isFor(shift)) continue;
            shift.removeStudents(this);
            shift.addStudents(newRegistration);
        }
    }

    public boolean hasMissingPersonalInformation(ExecutionYear executionYear) {
        if (this.getPhdIndividualProgramProcess() != null) {
            return false;
        }
        return this.getPrecedentDegreeInformation(executionYear) == null || !this.getPersonalInformationBean(executionYear).isValid();
    }

    public boolean hasMissingPersonalInformationForAcademicService(ExecutionYear executionYear) {
        if (this.getPhdIndividualProgramProcess() != null) {
            return false;
        }
        return this.getPrecedentDegreeInformation(executionYear) == null || this.getPersonalInformationBean(executionYear).isEditableByAcademicService();
    }

    public void createReingression(ExecutionYear executionYear, LocalDate localDate) {
        Object object = advice$createReingression.perform((Callable)new Registration$callable$createReingression(this, executionYear, localDate));
    }

    static /* synthetic */ void advised$createReingression(Registration this_, ExecutionYear executionYear, LocalDate reingressionDate) {
        RegistrationDataByExecutionYear dataByYear = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear(this_, executionYear);
        dataByYear.createReingression(reingressionDate);
    }

    public boolean hasReingression(ExecutionYear executionYear) {
        RegistrationDataByExecutionYear data = this.getRegistrationDataByExecutionYear(executionYear);
        if (data != null) {
            return data.isReingression();
        }
        return false;
    }

    public Set<RegistrationDataByExecutionYear> getReingressions() {
        HashSet<RegistrationDataByExecutionYear> reingressions = new HashSet<RegistrationDataByExecutionYear>();
        for (RegistrationDataByExecutionYear year : this.getRegistrationDataByExecutionYearSet()) {
            if (!year.isReingression()) continue;
            reingressions.add(year);
        }
        return reingressions;
    }

    public void deleteReingression(ExecutionYear executionYear) {
        Object object = advice$deleteReingression.perform((Callable)new Registration$callable$deleteReingression(this, executionYear));
    }

    static /* synthetic */ void advised$deleteReingression(Registration this_, ExecutionYear executionYear) {
        RegistrationDataByExecutionYear dataByExecutionYear = this_.getRegistrationDataByExecutionYear(executionYear);
        if (dataByExecutionYear == null || dataByExecutionYear.getExecutionYear() != executionYear) {
            throw new DomainException("error.Registration.reingression.not.marked.in.execution.year", new String[0]);
        }
        dataByExecutionYear.deleteReingression();
    }

    public PersonalInformationBean getPersonalInformationBean(ExecutionYear executionYear) {
        PrecedentDegreeInformation precedentInformation = this.getPrecedentDegreeInformation(executionYear);
        if (precedentInformation == null) {
            precedentInformation = this.getLatestPrecedentDegreeInformation();
        }
        if (precedentInformation == null) {
            return new PersonalInformationBean(this);
        }
        return new PersonalInformationBean(precedentInformation);
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation(ExecutionYear executionYear) {
        for (PrecedentDegreeInformation precedentDegreeInfo : this.getPrecedentDegreesInformationsSet()) {
            if (!precedentDegreeInfo.getPersonalIngressionData().getExecutionYear().equals(executionYear)) continue;
            return precedentDegreeInfo;
        }
        return null;
    }

    public PrecedentDegreeInformation getLatestPrecedentDegreeInformation() {
        TreeSet<PrecedentDegreeInformation> degreeInformations = new TreeSet<PrecedentDegreeInformation>(Collections.reverseOrder(PrecedentDegreeInformation.COMPARATOR_BY_EXECUTION_YEAR));
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (PrecedentDegreeInformation pdi : this.getPrecedentDegreesInformationsSet()) {
            if (pdi.getExecutionYear().isAfter(currentExecutionYear)) continue;
            degreeInformations.add(pdi);
        }
        if (degreeInformations.isEmpty()) {
            return null;
        }
        return degreeInformations.iterator().next();
    }

    public int getNumberEnroledCurricularCoursesInCurrentYear() {
        return this.getLastStudentCurricularPlan() == null ? 0 : this.getLastStudentCurricularPlan().countEnrolments(ExecutionYear.readCurrentExecutionYear());
    }

    public List<CycleCurriculumGroup> getInternalCycleCurriculumGrops() {
        return this.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops();
    }

    public Collection<CurriculumGroup> getAllCurriculumGroups() {
        TreeSet<CurriculumGroup> result = new TreeSet<CurriculumGroup>(CurriculumGroup.COMPARATOR_BY_NAME_AND_ID);
        for (StudentCurricularPlan plan : this.getStudentCurricularPlansSet()) {
            result.addAll(plan.getAllCurriculumGroups());
        }
        return result;
    }

    public Collection<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        TreeSet<CurriculumGroup> result = new TreeSet<CurriculumGroup>(CurriculumGroup.COMPARATOR_BY_NAME_AND_ID);
        for (StudentCurricularPlan plan : this.getStudentCurricularPlansSet()) {
            result.addAll(plan.getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups());
        }
        return result;
    }

    public Boolean hasIndividualCandidacyFor(ExecutionYear executionYear) {
        return this.getIndividualCandidacy() != null && this.getIndividualCandidacy().getCandidacyProcess().getCandidacyExecutionInterval().equals(executionYear);
    }

    public void updateEnrolmentDate(ExecutionYear executionYear) {
        RegistrationDataByExecutionYear registrationData = RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear(this, executionYear);
        Collection<Enrolment> executionYearEnrolments = this.getEnrolments(executionYear);
        if (executionYearEnrolments.isEmpty()) {
            registrationData.setEnrolmentDate(null);
        } else if (registrationData.getEnrolmentDate() == null) {
            Enrolment firstEnrolment = Collections.min(executionYearEnrolments, new Comparator<Enrolment>(){

                @Override
                public int compare(Enrolment left, Enrolment right) {
                    return left.getCreationDateDateTime().compareTo((ReadableInstant)right.getCreationDateDateTime());
                }
            });
            registrationData.edit(firstEnrolment.getCreationDateDateTime().toLocalDate());
        }
    }

    public void exportValues(StringBuilder result) {
        Formatter formatter = new Formatter(result);
        Student student = this.getStudent();
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.ingression", (String[])new String[0]), this.getIngressionType() == null ? " - " : this.getIngressionType().getDescription().getContent());
        formatter.format("%s: %d\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.studentNumber", (String[])new String[0]), student.getNumber());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.Student.Person.name", (String[])new String[0]), student.getPerson().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.degree", (String[])new String[0]), this.getDegree().getPresentationName());
        formatter.close();
    }

    public RegistrationState getLastActiveState() {
        ArrayList activeStateList = new ArrayList();
        CollectionUtils.select((Collection)this.getRegistrationStatesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((RegistrationState)arg0).getStateType().isActive();
            }
        }, activeStateList);
        return !activeStateList.isEmpty() ? Collections.max(activeStateList, RegistrationState.DATE_COMPARATOR) : null;
    }

    public boolean hasDissertationEnrolment(ExecutionDegree executionDegree) {
        ExecutionYear previousExecutionYear = executionDegree.getExecutionYear();
        if (previousExecutionYear.hasNextExecutionYear()) {
            ExecutionYear executionYear = previousExecutionYear.getNextExecutionYear();
            for (Attends attends : this.getAssociatedAttendsSet()) {
                Enrolment enrolment;
                if (attends.getExecutionYear() != executionYear || attends.getEnrolment() == null || !(enrolment = attends.getEnrolment()).isDissertation() || enrolment.getDegreeCurricularPlanOfDegreeModule() != executionDegree.getDegreeCurricularPlan()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidForRAIDES() {
        return FenixEduAcademicConfiguration.getConfiguration().getRaidesRequestInfo() != false && this.isActive() && this.isBolonha() && !this.getDegreeType().isEmpty() && this.getRegistrationProtocol().isForOfficialMobilityReporting();
    }

    static {
        advice$removeAttendFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$grantSeniorStatute = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createReingression = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deleteReingression = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(Registration.class);
        DEGREE_TYPES_TO_ENROL_BY_STUDENT = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isAdvancedSpecializationDiploma);
        NUMBER_COMPARATOR = new Comparator<Registration>(){

            @Override
            public int compare(Registration o1, Registration o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        };
        COMPARATOR_BY_START_DATE = new Comparator<Registration>(){

            @Override
            public int compare(Registration o1, Registration o2) {
                int comparationResult = o1.getStartDate().compareTo((ReadablePartial)o2.getStartDate());
                return comparationResult == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : comparationResult;
            }
        };
        COMPARATOR_BY_NUMBER_AND_ID = new ComparatorChain();
        COMPARATOR_BY_NUMBER_AND_ID.addComparator(NUMBER_COMPARATOR);
        COMPARATOR_BY_NUMBER_AND_ID.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
    }
}

