/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting.activities;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.log.PhdLog;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.util.phd.PhdProperties;
import org.fenixedu.bennu.core.domain.User;

public abstract class PhdMeetingSchedulingActivity
extends Activity<PhdMeetingSchedulingProcess> {
    @Override
    public final void checkPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
        this.processPreConditions(process2, userView);
        this.activityPreConditions(process2, userView);
    }

    protected void processPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
    }

    protected abstract void activityPreConditions(PhdMeetingSchedulingProcess var1, User var2);

    public static String getAccessInformation(PhdIndividualProgramProcess process2, PhdParticipant participant, String coordinatorMessage, String teacherMessage) {
        if (!participant.isInternal()) {
            return AlertService.AlertMessage.get("message.phd.external.access", PhdProperties.getPhdExternalAccessLink(), participant.getAccessHashCode(), participant.getPassword());
        }
        Person person = ((InternalPhdParticipant)((Object)participant)).getPerson();
        if (process2.isCoordinatorForPhdProgram(person)) {
            return AlertService.AlertMessage.get(coordinatorMessage, new Object[0]);
        }
        if (process2.isGuiderOrAssistentGuider(person) || person.getTeacher() != null) {
            return AlertService.AlertMessage.get(teacherMessage, new Object[0]);
        }
        throw new DomainException("error.PhdThesisProcess.unexpected.participant.type", new String[0]);
    }

    @Override
    protected void log(PhdMeetingSchedulingProcess process2, User userView, Object object) {
        PhdThesisProcess thesisProcess = process2.getThesisProcess();
        PhdLog.logActivity(this, (PhdProgramProcess)((Object)thesisProcess), userView, object);
    }
}

