/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting;

import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingMinutesDocument_Base;

public class PhdMeetingMinutesDocument
extends PhdMeetingMinutesDocument_Base {
    public PhdMeetingMinutesDocument() {
    }

    public PhdMeetingMinutesDocument(PhdMeeting meeting, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        this();
        this.init(meeting, documentType, remarks, content, filename, uploader);
    }

    protected void init(PhdMeeting meeting, PhdIndividualProgramDocumentType documentType, String remarks, byte[] content, String filename, Person uploader) {
        this.checkParameters((PhdProgramProcess)((Object)meeting.getMeetingProcess()), documentType, content, filename, uploader);
        this.setDocumentVersion(meeting, documentType);
        this.setPhdMeeting(meeting);
        super.setDocumentType(documentType);
        super.setRemarks(remarks);
        super.setUploader(uploader);
        super.setDocumentAccepted(Boolean.valueOf(true));
        super.init(filename, filename, content);
    }

    protected void setDocumentVersion(PhdMeeting meeting, PhdIndividualProgramDocumentType documentType) {
        if (documentType.isVersioned()) {
            Set documents = meeting.getDocumentsSet();
            super.setDocumentVersion(Integer.valueOf(documents.isEmpty() ? 1 : documents.size() + 1));
        } else {
            super.setDocumentVersion(Integer.valueOf(1));
        }
    }

    public PhdProgramProcess getPhdProgramProcess() {
        return this.getPhdMeeting().getMeetingProcess().getThesisProcess().getIndividualProgramProcess();
    }

    public boolean isLast() {
        return this.getPhdMeeting().getLatestDocumentVersion() == this;
    }

    public PhdProgramProcessDocument getLastVersion() {
        return this.getPhdMeeting().getLatestDocumentVersion();
    }
}

