/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;

public class ScheduleThesisMeetingRequest
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.getActiveState().equals(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        if (bean.isToNotify()) {
            AlertService.alertParticipants(process2.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.president.notification.subject", new Object[0]), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.president.notification.body", new Object[0]), process2.getPresidentJuryElement().getParticipant());
            AlertService.alertResponsibleCoordinators(process2.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.coordinator.notification.subject", new Object[0]), AlertService.AlertMessage.create("message.phd.request.schedule.meeting.coordinator.notification.body", process2.getPresidentJuryElement().getNameWithTitle()));
        }
        process2.createState(PhdThesisProcessStateType.WAITING_FOR_THESIS_MEETING_SCHEDULING, userView.getPerson(), bean.getRemarks());
        return process2;
    }
}

