/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdIndividualProgramDocumentType {
    CANDIDACY_FORM,
    REGISTRATION_FORM,
    CANDIDACY_REVIEW(true, false),
    STUDY_PLAN(true, false),
    CV,
    DEGREE_FINALIZATION_CERTIFICATE(false),
    HABILITATION_CERTIFICATE_DOCUMENT(false),
    DISSERTATION_OR_FINAL_WORK_DOCUMENT(false),
    ID_DOCUMENT,
    SOCIAL_SECURITY,
    RECOMMENDATION_LETTER(false, false),
    HEALTH_BULLETIN,
    GUIDER_ACCEPTANCE_LETTER(true, false),
    ASSISTENT_GUIDER_ACCEPTANCE_LETTER(true, false),
    MOTIVATION_LETTER,
    RESEARCH_PLAN,
    CANDIDACY_RATIFICATION(true, false),
    PUBLIC_PRESENTATION_SEMINAR_COMISSION(true, false),
    PUBLIC_PRESENTATION_SEMINAR_REPORT(true, false),
    PROVISIONAL_THESIS(true, false),
    FINAL_THESIS(true, false),
    FINAL_THESIS_RATIFICATION_DOCUMENT(true, false),
    THESIS_REQUIREMENT,
    THESIS_ABSTRACT(true, false),
    JURY_ELEMENTS(true, false),
    JURY_PRESIDENT_ELEMENT(true, false),
    JURY_REPORT_FEEDBACK(true, false),
    CANDIDACY_FEEDBACK_DOCUMENT(true, false),
    JURY_MEETING_MINUTES(true, false),
    CONCLUSION_DOCUMENT(true, false),
    OTHER(false, false),
    FEEDBACK_REPORT(false, false, true),
    GUIDANCE_OTHER(false, false, true),
    PAYMENT_DOCUMENT(true, false, false),
    TOEFL_LINGUISTICS_CERTIFICATE(true, false, true),
    GRE_LINGUISTICS_CERTIFICATE(true, false, true),
    JURY_PRESIDENT_DECLARATION(true, false, false),
    MAXIMUM_GRADE_GUIDER_PROPOSAL(true, false, false);

    private boolean isVersioned;
    private boolean isAutomaticallyVisibleToStudent;
    private boolean isForGuidance;

    private PhdIndividualProgramDocumentType() {
        this(true, true, false);
    }

    private PhdIndividualProgramDocumentType(boolean isVersioned) {
        this(isVersioned, true, false);
    }

    private PhdIndividualProgramDocumentType(boolean isVersioned, boolean isAutomaticallyVisibleToStudent) {
        this(isVersioned, isAutomaticallyVisibleToStudent, false);
    }

    private PhdIndividualProgramDocumentType(boolean isVersioned, boolean isAutomaticallyVisibleToStudent, boolean isForGuidance) {
        this.isVersioned = isVersioned;
        this.isAutomaticallyVisibleToStudent = isAutomaticallyVisibleToStudent;
        this.isForGuidance = isForGuidance;
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getQualifiedName() {
        return PhdIndividualProgramDocumentType.class.getSimpleName() + "." + this.name();
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public static Collection<PhdIndividualProgramDocumentType> getDocumentTypesVisibleToStudent() {
        HashSet<PhdIndividualProgramDocumentType> result = new HashSet<PhdIndividualProgramDocumentType>();
        for (PhdIndividualProgramDocumentType document : PhdIndividualProgramDocumentType.values()) {
            if (!document.isAutomaticallyVisibleToStudent) continue;
            result.add(document);
        }
        return result;
    }

    public boolean isForGuidance() {
        return this.isForGuidance;
    }
}

