/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.period;

import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.SecondCycleCandidacyPeriod_Base;
import org.joda.time.DateTime;

public class SecondCycleCandidacyPeriod
extends SecondCycleCandidacyPeriod_Base {
    private SecondCycleCandidacyPeriod() {
    }

    public SecondCycleCandidacyPeriod(SecondCycleCandidacyProcess candidacyProcess, ExecutionYear executionInterval, DateTime start, DateTime end) {
        this();
        this.init(candidacyProcess, (ExecutionInterval)((Object)executionInterval), start, end);
    }

    private void init(SecondCycleCandidacyProcess candidacyProcess, ExecutionInterval executionInterval, DateTime start, DateTime end) {
        this.checkParameters(candidacyProcess);
        super.init(executionInterval, start, end);
        this.addCandidacyProcesses((CandidacyProcess)((Object)candidacyProcess));
    }

    private void checkParameters(SecondCycleCandidacyProcess candidacyProcess) {
        if (candidacyProcess == null) {
            throw new DomainException("error.SecondCycleCandidacyPeriod.invalid.candidacy.process", new String[0]);
        }
    }

    public SecondCycleCandidacyProcess getSecondCycleCandidacyProcess() {
        return (SecondCycleCandidacyProcess)((Object)(!this.getCandidacyProcessesSet().isEmpty() ? (CandidacyProcess)((Object)this.getCandidacyProcessesSet().iterator().next()) : null));
    }

    public ExecutionYear getExecutionInterval() {
        return (ExecutionYear)((Object)super.getExecutionInterval());
    }

    public void edit(DateTime start, DateTime end) {
        this.checkDates(start, end);
        this.checkIfCandEdit(start, end);
        super.setStart(start);
        super.setEnd(end);
    }

    private void checkIfCandEdit(DateTime start, DateTime end) {
        for (SecondCycleCandidacyPeriod secondCycleCandidacyPeriod : this.getExecutionInterval().getSecondCycleCandidacyPeriods()) {
            if (secondCycleCandidacyPeriod == this || !secondCycleCandidacyPeriod.intercept(start, end)) continue;
            throw new DomainException("error.SecondCycleCandidacyPeriod.interception", this.getExecutionInterval().getName(), start.toString("dd/MM/yyyy HH:mm"), end.toString("dd/MM/yyyy HH:mm"));
        }
    }

    public SecondCycleCandidacyPeriod getNextPeriod() {
        return null;
    }
}

