/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.period;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class CandidacyPeriod
extends CandidacyPeriod_Base {
    public static final Comparator<CandidacyPeriod> LAST_CANDIDACY_PERIOD = new Comparator<CandidacyPeriod>(){

        @Override
        public int compare(CandidacyPeriod o1, CandidacyPeriod o2) {
            int result = o1.getStart().compareTo((ReadableInstant)o2.getStart());
            return -1 * (result == 0 ? o1.getEnd().compareTo((ReadableInstant)o2.getEnd()) : result);
        }
    };

    protected CandidacyPeriod() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        this.checkParameters(executionInterval, start, end);
        this.setExecutionInterval(executionInterval);
        this.setStart(start);
        this.setEnd(end);
    }

    protected void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        String[] args = new String[]{};
        if (executionInterval == null) {
            throw new DomainException("error.CandidacyPeriod.invalid.academic.period", args);
        }
        this.checkDates(start, end);
    }

    protected void checkDates(DateTime start, DateTime end) {
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.CandidacyPeriod.invalid.dates", new String[0]);
        }
    }

    public void edit(DateTime start, DateTime end) {
        this.checkDates(start, end);
        super.setStart(start);
        super.setEnd(end);
    }

    public boolean isOpen() {
        return this.contains(new DateTime());
    }

    public boolean isOpen(DateTime date) {
        return this.contains(date);
    }

    public boolean contains(DateTime date) {
        return !this.getStart().isAfter((ReadableInstant)date) && !this.getEnd().isBefore((ReadableInstant)date);
    }

    public boolean intercept(DateTime start, DateTime end) {
        this.checkDates(start, end);
        return this.contains(start) || this.contains(end);
    }

    public boolean isPhdCandidacyPeriod() {
        return false;
    }

    public boolean isEpflCandidacyPeriod() {
        return false;
    }

    public boolean isInstitutionCandidacyPeriod() {
        return false;
    }

    public boolean isOutboundMobilityCandidacyPeriod() {
        return false;
    }

    public String getPresentationName() {
        return this.getStart().toString("dd/MM/yyyy") + " - " + this.getEnd().toString("dd/MM/yyyy");
    }

    public static List<CandidacyPeriod> readAllByType(Class<? extends CandidacyPeriod> clazz) {
        ArrayList<CandidacyPeriod> result = new ArrayList<CandidacyPeriod>();
        Set candidacyPeriods = Bennu.getInstance().getCandidacyPeriodsSet();
        for (CandidacyPeriod candidacyPeriod : candidacyPeriods) {
            if (!clazz.equals(((Object)((Object)candidacyPeriod)).getClass())) continue;
            result.add(candidacyPeriod);
        }
        Collections.sort(result, LAST_CANDIDACY_PERIOD);
        return result;
    }
}

